/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import water.webserver.iface.H2OWebsocketServlet;
import water.webserver.iface.WebsocketConnection;
import water.webserver.iface.WebsocketHandler;

public class Jetty9WebsocketServlet
extends WebSocketServlet {
    private final H2OWebsocketServlet impl;

    public Jetty9WebsocketServlet(H2OWebsocketServlet impl) {
        this.impl = impl;
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)new H2OWebSocketCreator());
    }

    public class H2OWebSocketCreator
    implements WebSocketCreator {
        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            return new Jetty9WebsocketHandler();
        }
    }

    class Jetty9WebsocketHandler
    implements WebSocketListener {
        private WebsocketHandler handler;
        private Jetty9WebsocketConnection conn;

        Jetty9WebsocketHandler() {
        }

        public void onWebSocketConnect(Session sess) {
            this.conn = new Jetty9WebsocketConnection(sess);
            this.handler = Jetty9WebsocketServlet.this.impl.onConnect((WebsocketConnection)this.conn);
        }

        public void onWebSocketBinary(byte[] payload, int offset, int len) {
        }

        public void onWebSocketText(String message) {
            this.handler.onMessage(message);
        }

        public void onWebSocketClose(int statusCode, String reason) {
            this.handler.onClose((WebsocketConnection)this.conn);
            this.conn = null;
            this.handler = null;
        }

        public void onWebSocketError(Throwable cause) {
            cause.printStackTrace();
        }
    }

    static class Jetty9WebsocketConnection
    implements WebsocketConnection {
        private final Session sess;

        Jetty9WebsocketConnection(Session sess) {
            this.sess = sess;
        }

        public void sendMessage(String message) throws IOException {
            this.sess.getRemote().sendString(message);
        }
    }
}

