/*
 * Decompiled with CFR 0.152.
 */
package water.webserver.jetty9;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.FormAuthenticator;
import org.eclipse.jetty.server.Authentication;

class Jetty9DelegatingAuthenticator
implements Authenticator {
    private Authenticator _primaryAuth;
    private FormAuthenticator _formAuth;

    Jetty9DelegatingAuthenticator(Authenticator primaryAuth, FormAuthenticator formAuth) {
        this._primaryAuth = primaryAuth;
        this._formAuth = formAuth;
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._primaryAuth.setConfiguration(configuration);
        this._formAuth.setConfiguration(configuration);
    }

    public String getAuthMethod() {
        return "FORM_PREFERRED";
    }

    public void prepareRequest(ServletRequest request) {
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        if (Jetty9DelegatingAuthenticator.isBrowserAgent((HttpServletRequest)request)) {
            return this._formAuth.validateRequest(request, response, mandatory);
        }
        return this._primaryAuth.validateRequest(request, response, mandatory);
    }

    private static boolean isBrowserAgent(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && (userAgent.startsWith("Mozilla/") || userAgent.startsWith("Opera/"));
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }
}

