/*
 * Decompiled with CFR 0.152.
 */
package water.k8s;

import java.net.InetAddress;
import java.util.Collection;
import water.H2O;
import water.init.AbstractEmbeddedH2OConfig;
import water.k8s.H2OCluster;
import water.util.Log;

public class KubernetesEmbeddedConfig
extends AbstractEmbeddedH2OConfig {
    private final String flatfile;
    private final int cloudSize;

    public KubernetesEmbeddedConfig(Collection<String> nodeIPs) {
        this.flatfile = this.writeFlatFile(nodeIPs);
        this.cloudSize = nodeIPs.size();
    }

    private String writeFlatFile(Collection<String> nodeIPs) {
        StringBuilder flatFileBuilder = new StringBuilder();
        nodeIPs.forEach(nodeIP -> {
            flatFileBuilder.append((String)nodeIP);
            flatFileBuilder.append(":");
            flatFileBuilder.append(54321);
            flatFileBuilder.append("\n");
        });
        return flatFileBuilder.toString();
    }

    public void notifyAboutEmbeddedWebServerIpPort(InetAddress ip, int port) {
        if (H2O.SELF == null) {
            throw new IllegalStateException("H2O.SELF is expected to be defined at this point!");
        }
        H2OCluster.setCurrentNodeInfo((H2OCluster.H2ONodeInfo)new NodeInfo());
    }

    public void notifyAboutCloudSize(InetAddress ip, int port, InetAddress leaderIp, int leaderPort, int size) {
        Log.info((Object[])new Object[]{String.format("Created cluster of size %d, leader node IP is '%s'", size, leaderIp.toString())});
        if (size == this.cloudSize) {
            this.cloudingFinished();
        }
    }

    public boolean providesFlatfile() {
        return true;
    }

    public String fetchFlatfile() {
        return this.flatfile;
    }

    public void exit(int status) {
        System.exit(status);
    }

    public void print() {
    }

    public boolean disableNonLeaderNodeAccess() {
        return H2OCluster.isRunningOnKubernetes();
    }

    private static class NodeInfo
    implements H2OCluster.H2ONodeInfo {
        private NodeInfo() {
        }

        public boolean isLeader() {
            return H2O.SELF.isLeaderNode();
        }
    }
}

