/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;

public class LoggerBackend {
    public static final org.apache.log4j.Level[] L4J_LVLS = new org.apache.log4j.Level[]{org.apache.log4j.Level.FATAL, org.apache.log4j.Level.ERROR, org.apache.log4j.Level.WARN, org.apache.log4j.Level.INFO, org.apache.log4j.Level.DEBUG, org.apache.log4j.Level.TRACE};
    public static final Level[] L4J_LOGGING_LVLS = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
    public int _level;
    public String _prefix;
    public String _maxLogFileSize;
    public boolean _launchedWithHadoopJar;
    public boolean _haveInheritedLog4jConfiguration;
    public Function<String, String> _getLogFilePath;

    public Logger createLog4j() {
        String h2oLog4jConfiguration = System.getProperty("h2o.log4j.configuration");
        if (h2oLog4jConfiguration != null) {
            File file = new File(h2oLog4jConfiguration);
            if (file.exists()) {
                Configurator.reconfigure((URI)file.toURI());
            } else {
                URL confUrl = LoggerBackend.class.getClassLoader().getResource(h2oLog4jConfiguration);
                if (confUrl != null) {
                    try {
                        Configurator.reconfigure((URI)confUrl.toURI());
                    }
                    catch (URISyntaxException e) {
                        System.err.println("ERROR: failed in createLog4j, exiting now.");
                        e.printStackTrace();
                        return null;
                    }
                }
            }
        } else {
            try {
                this.reconfigureLog4J();
            }
            catch (Exception e) {
                System.err.println("ERROR: failed in createLog4j, exiting now.");
                e.printStackTrace();
                return null;
            }
        }
        return Logger.getLogger((String)"water.default");
    }

    public void reconfigureLog4J() {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setStatusLevel(L4J_LOGGING_LVLS[this._level]);
        builder.setConfigurationName("H2OLogConfiguration");
        String patternTail = this._prefix + " %10.10t %5.5p %c: %m%n";
        String pattern = "%d{MM-dd HH:mm:ss.SSS} " + patternTail;
        LayoutComponentBuilder layoutComponentBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", pattern);
        builder.add(((AppenderComponentBuilder)builder.newAppender("Console", "Console").addAttribute("target", "SYSTEM_OUT")).add(layoutComponentBuilder));
        builder.add(this.newRollingFileAppenderComponent(builder, "R1", "1MB", this._getLogFilePath.apply("trace"), pattern, org.apache.log4j.Level.TRACE));
        builder.add(this.newRollingFileAppenderComponent(builder, "R2", this._maxLogFileSize, this._getLogFilePath.apply("debug"), pattern, org.apache.log4j.Level.DEBUG));
        builder.add(this.newRollingFileAppenderComponent(builder, "R3", this._maxLogFileSize, this._getLogFilePath.apply("info"), pattern, org.apache.log4j.Level.INFO));
        builder.add(this.newRollingFileAppenderComponent(builder, "R4", "256KB", this._getLogFilePath.apply("warn"), pattern, org.apache.log4j.Level.WARN));
        builder.add(this.newRollingFileAppenderComponent(builder, "R5", "256KB", this._getLogFilePath.apply("error"), pattern, org.apache.log4j.Level.ERROR));
        builder.add(this.newRollingFileAppenderComponent(builder, "R6", "256KB", this._getLogFilePath.apply("fatal"), pattern, org.apache.log4j.Level.FATAL));
        builder.add(this.newRollingFileAppenderComponent(builder, "HTTPD", "1MB", this._getLogFilePath.apply("httpd"), "%d{ISO8601} " + patternTail, org.apache.log4j.Level.TRACE));
        AppenderRefComponentBuilder consoleAppenderRef = builder.newAppenderRef("Console");
        ArrayList<Object> appenderReferences = new ArrayList<AppenderRefComponentBuilder>();
        appenderReferences.add(builder.newAppenderRef("R1"));
        appenderReferences.add(builder.newAppenderRef("R2"));
        appenderReferences.add(builder.newAppenderRef("R3"));
        appenderReferences.add(builder.newAppenderRef("R4"));
        appenderReferences.add(builder.newAppenderRef("R5"));
        appenderReferences.add(builder.newAppenderRef("R6"));
        appenderReferences.add(consoleAppenderRef);
        builder.add(this.newLoggerComponent(builder, "hex", appenderReferences));
        builder.add(this.newLoggerComponent(builder, "water", appenderReferences));
        builder.add(this.newLoggerComponent(builder, "ai.h2o", appenderReferences));
        builder.add((RootLoggerComponentBuilder)builder.newRootLogger(String.valueOf(L4J_LVLS[this._level])).add(consoleAppenderRef));
        builder.add(this.newLoggerComponent(builder, "org.apache.http", appenderReferences, "WARN"));
        builder.add(this.newLoggerComponent(builder, "com.amazonaws", appenderReferences, "WARN"));
        builder.add(this.newLoggerComponent(builder, "org.apache.hadoop", appenderReferences, "WARN"));
        builder.add(this.newLoggerComponent(builder, "org.jets3t.service", appenderReferences, "WARN"));
        builder.add(this.newLoggerComponent(builder, "org.reflections.Reflections", appenderReferences, "ERROR"));
        builder.add(this.newLoggerComponent(builder, "com.brsanthu.googleanalytics", appenderReferences, "ERROR"));
        builder.add(this.newLoggerComponent(builder, "org.apache.hadoop.util.NativeCodeLoader", appenderReferences, "ERROR"));
        appenderReferences = new ArrayList();
        appenderReferences.add(builder.newAppenderRef("HTTPD"));
        builder.add(this.newLoggerComponent(builder, "water.api.RequestServer", appenderReferences));
        Configurator.reconfigure((Configuration)((Configuration)builder.build()));
    }

    AppenderComponentBuilder newRollingFileAppenderComponent(ConfigurationBuilder builder, String name, String sizeBasedTriggeringPolicyValue, String fileNameValue, String filePatternValue, org.apache.log4j.Level thresholdFilterLevel) {
        ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", sizeBasedTriggeringPolicyValue));
        LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", filePatternValue);
        FilterComponentBuilder thresholdFilter = (FilterComponentBuilder)builder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.DENY).addAttribute("level", thresholdFilterLevel.toString());
        ComponentBuilder rolloverStrategy = builder.newComponent("DefaultRolloverStrategy").addAttribute("max", 3);
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender(name, "RollingFile").addAttribute("fileName", fileNameValue)).addAttribute("filePattern", fileNameValue.concat(".%i"))).add(thresholdFilter)).addComponent(triggeringPolicy)).addComponent((ComponentBuilder)layoutBuilder)).addComponent(rolloverStrategy);
        return appenderBuilder;
    }

    LoggerComponentBuilder newLoggerComponent(ConfigurationBuilder builder, String name, List<AppenderRefComponentBuilder> appenderReferences) {
        LoggerComponentBuilder loggerComponentBuilder = builder.newLogger(name);
        for (AppenderRefComponentBuilder reference : appenderReferences) {
            loggerComponentBuilder.add(reference);
        }
        loggerComponentBuilder.addAttribute("additivity", false);
        return loggerComponentBuilder;
    }

    LoggerComponentBuilder newLoggerComponent(ConfigurationBuilder builder, String name, List<AppenderRefComponentBuilder> appenderReferences, String level) {
        LoggerComponentBuilder loggerComponentBuilder = builder.newLogger(name);
        for (AppenderRefComponentBuilder reference : appenderReferences) {
            loggerComponentBuilder.add(reference);
        }
        loggerComponentBuilder.addAttribute("additivity", false);
        loggerComponentBuilder.addAttribute("level", level);
        return loggerComponentBuilder;
    }
}

