/*
 * Decompiled with CFR 0.152.
 */
package water.parser.orc;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.HDFSFileVec;
import water.fvec.Vec;
import water.parser.ParseSetup;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.ParserProvider;
import water.parser.orc.OrcParser;
import water.persist.PersistHdfs;

public class OrcParserProvider
extends ParserProvider {
    static ParserInfo ORC_INFO = new ParserInfo("ORC", 10020, true);

    public ParserInfo info() {
        return ORC_INFO;
    }

    public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
        return new OrcParser(setup, jobKey);
    }

    public ParseSetup guessSetup(ByteVec bv, byte[] bits, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] domains, String[][] naStrings) {
        if (bv instanceof FileVec) {
            return this.readSetup((FileVec)bv, columnNames, columnTypes);
        }
        throw new UnsupportedOperationException("ORC only works on Files");
    }

    public ParseSetup createParserSetup(Key[] inputs, ParseSetup requiredSetup) {
        Iced frameOrVec = DKV.getGet((Key)inputs[0]);
        FileVec f = frameOrVec instanceof Frame ? (FileVec)((Frame)frameOrVec).vec(0) : (FileVec)frameOrVec;
        return this.readSetup(f, requiredSetup.getColumnNames(), requiredSetup.getColumnTypes());
    }

    private Reader getReader(FileVec f) throws IOException {
        String strPath = FileVec.getPathForKey((Key)f._key);
        Path path = new Path(strPath);
        if (f instanceof HDFSFileVec) {
            return OrcFile.createReader((FileSystem)PersistHdfs.getFS((String)strPath), (Path)path);
        }
        return OrcFile.createReader((Path)path, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)new Configuration()));
    }

    public ParseSetup readSetup(FileVec f, String[] columnNames, byte[] columnTypes) {
        try {
            List stripesInfo;
            Reader orcFileReader = this.getReader(f);
            StructObjectInspector insp = (StructObjectInspector)orcFileReader.getObjectInspector();
            OrcParser.OrcParseSetup stp = OrcParser.deriveParseSetup(orcFileReader, insp);
            if (columnNames != null && stp.getAllColNames().length == columnNames.length) {
                stp.setColumnNames(columnNames);
                stp.setAllColNames(columnNames);
            }
            if (columnTypes != null && columnTypes.length == stp.getColumnTypes().length) {
                byte[] old_columnTypes = stp.getColumnTypes();
                String[] old_columnTypeNames = stp.getColumnTypesString();
                for (int index = 0; index < columnTypes.length; ++index) {
                    if (columnTypes[index] != 4) continue;
                    old_columnTypes[index] = columnTypes[index];
                }
                stp.setColumnTypes(old_columnTypes);
                stp.setColumnTypeStrings(old_columnTypeNames);
            }
            if ((stripesInfo = orcFileReader.getStripes()).size() == 0) {
                stp._chunk_size = (int)f.length();
                f.setChunkSize(stp._chunk_size);
                return stp;
            }
            f.setNChunks(stripesInfo.size());
            stp._chunk_size = f._chunkSize;
            assert (f.nChunks() == stripesInfo.size());
            return stp;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public ParseSetup setupLocal(Vec v, ParseSetup setup) {
        if (!(v instanceof FileVec)) {
            throw H2O.unimpl((String)"ORC only implemented for HDFS / NFS files");
        }
        try {
            ((OrcParser.OrcParseSetup)setup).setOrcFileReader(this.getReader((FileVec)v));
            return setup;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

