/*
 * Decompiled with CFR 0.152.
 */
package water.parser.orc;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.joda.time.DateTime;
import org.joda.time.MutableDateTime;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.parser.BufferedString;
import water.parser.ParseReader;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.StreamParseWriter;
import water.parser.orc.OrcParserProvider;
import water.parser.orc.OrcUtil;
import water.util.ArrayUtils;
import water.util.StringUtils;

public class OrcParser
extends Parser {
    private final Reader orcFileReader;
    public static final int DAY_TO_MS = 86400000;
    public static final int ADD_OFFSET = 28800000;
    public static final int HOUR_OFFSET = 3600000;
    private MutableDateTime epoch = new MutableDateTime();
    private ArrayList<String> storeWarnings = new ArrayList();
    private transient int _cidx;
    private transient HashMap<Integer, HashMap<Number, byte[]>> _toStringMaps = new HashMap();

    OrcParser(ParseSetup setup, Key<Job> jobKey) {
        super(setup, jobKey);
        this.epoch.setDate(0L);
        this.orcFileReader = ((OrcParseSetup)setup).orcFileReader;
    }

    protected ParseWriter streamParse(InputStream is, StreamParseWriter dout) throws IOException {
        List<StripeInformation> stripesInfo = ((OrcParseSetup)this._setup).getStripes();
        StreamParseWriter nextChunk = dout;
        Futures fs = new Futures();
        for (int i = 0; i < stripesInfo.size(); ++i) {
            this.parseChunk(i, null, (ParseWriter)nextChunk);
            nextChunk.close(fs);
            if (dout != nextChunk) {
                dout.reduce(nextChunk);
            }
            if (i >= stripesInfo.size() - 1) continue;
            nextChunk = nextChunk.nextChunk();
        }
        return dout;
    }

    protected ParseWriter streamParseZip(InputStream is, StreamParseWriter dout, InputStream bvs) throws IOException {
        throw new UnsupportedOperationException("H2O Orc Parser does not support parsing of zipped orc files");
    }

    protected final ParseWriter parseChunk(int chunkId, ParseReader din, ParseWriter dout) {
        this._cidx = chunkId;
        List<StripeInformation> stripesInfo = ((OrcParseSetup)this._setup).getStripes();
        if (stripesInfo.size() == 0) {
            dout.addError(new ParseWriter.ParseErr("Orc Parser: Empty file.", chunkId, 0L, -2L));
            return dout;
        }
        OrcParseSetup setup = (OrcParseSetup)this._setup;
        StripeInformation thisStripe = stripesInfo.get(chunkId);
        String[] orcTypes = setup.getColumnTypesString();
        boolean[] toInclude = setup.getToInclude();
        try {
            long currentBatchRow;
            RecordReader perStripe = this.orcFileReader.rows(thisStripe.getOffset(), thisStripe.getDataLength(), setup.getToInclude(), null, setup.getColumnNames());
            VectorizedRowBatch batch = null;
            long rowCount = thisStripe.getNumberOfRows();
            for (long rows = 0L; rows != rowCount; rows += currentBatchRow) {
                int nrows;
                currentBatchRow = (batch = perStripe.nextBatch(batch)).count();
                if (currentBatchRow != (long)(nrows = (int)currentBatchRow)) {
                    throw new IllegalArgumentException("got batch with too many records, does not fit in int");
                }
                ColumnVector[] dataVectors = batch.cols;
                int colIndex = 0;
                for (int col = 0; col < batch.numCols; ++col) {
                    if (!toInclude[col + 1]) continue;
                    if (this._setup.getColumnTypes()[colIndex] != 0) {
                        this.write1column(dataVectors[col], orcTypes[colIndex], colIndex, nrows, dout);
                    } else {
                        dout.addNAs(col, nrows);
                    }
                    ++colIndex;
                }
            }
            byte[] col_types = this._setup.getColumnTypes();
            for (int i = 0; i < col_types.length; ++i) {
                if (col_types[i] != 0) continue;
                dout.addNAs(i, (int)rowCount);
            }
            perStripe.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return dout;
    }

    private void write1column(ColumnVector oneColumn, String columnType, int cIdx, int rowNumber, ParseWriter dout) {
        if (oneColumn.isRepeating && !oneColumn.noNulls) {
            for (int i = 0; i < rowNumber; ++i) {
                dout.addInvalidCol(cIdx);
            }
        } else {
            switch (columnType.toLowerCase()) {
                case "bigint": 
                case "boolean": 
                case "int": 
                case "smallint": 
                case "tinyint": {
                    this.writeLongcolumn((LongColumnVector)oneColumn, cIdx, rowNumber, dout);
                    break;
                }
                case "float": 
                case "double": {
                    this.writeDoublecolumn((DoubleColumnVector)oneColumn, cIdx, rowNumber, dout);
                    break;
                }
                case "numeric": 
                case "real": {
                    if (oneColumn instanceof LongColumnVector) {
                        this.writeLongcolumn((LongColumnVector)oneColumn, cIdx, rowNumber, dout);
                        break;
                    }
                    this.writeDoublecolumn((DoubleColumnVector)oneColumn, cIdx, rowNumber, dout);
                    break;
                }
                case "string": 
                case "varchar": 
                case "char": {
                    this.writeStringcolumn((BytesColumnVector)oneColumn, cIdx, rowNumber, dout);
                    break;
                }
                case "date": 
                case "timestamp": {
                    this.writeTimecolumn((LongColumnVector)oneColumn, columnType, cIdx, rowNumber, dout);
                    break;
                }
                case "decimal": {
                    this.writeDecimalcolumn((DecimalColumnVector)oneColumn, cIdx, rowNumber, dout);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Orc schema type: " + columnType);
                }
            }
        }
    }

    private long correctTimeStamp(long daysSinceEpoch) {
        long timestamp = daysSinceEpoch * 86400000L + 28800000L;
        DateTime date = new DateTime(timestamp);
        int hour = date.hourOfDay().get();
        if (hour == 0) {
            return timestamp;
        }
        return timestamp - (long)(hour * 3600000);
    }

    private void writeTimecolumn(LongColumnVector col, String columnType, int cIdx, int rowNumber, ParseWriter dout) {
        boolean timestamp = columnType.equals("timestamp");
        long[] oneColumn = col.vector;
        if (col.isRepeating) {
            long val = timestamp ? oneColumn[0] / 1000000L : this.correctTimeStamp(oneColumn[0]);
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                dout.addNumCol(cIdx, val, 0);
            }
        } else if (col.noNulls) {
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                dout.addNumCol(cIdx, timestamp ? oneColumn[rowIndex] / 1000000L : this.correctTimeStamp(oneColumn[rowIndex]), 0);
            }
        } else {
            boolean[] isNull = col.isNull;
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                if (isNull[rowIndex]) {
                    dout.addInvalidCol(cIdx);
                    continue;
                }
                dout.addNumCol(cIdx, timestamp ? oneColumn[rowIndex] / 1000000L : this.correctTimeStamp(oneColumn[rowIndex]), 0);
            }
        }
    }

    private void writeDecimalcolumn(DecimalColumnVector col, int cIdx, int rowNumber, ParseWriter dout) {
        HiveDecimalWritable[] oneColumn = col.vector;
        if (col.isRepeating) {
            HiveDecimal hd = oneColumn[0].getHiveDecimal();
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                dout.addNumCol(cIdx, hd.unscaledValue().longValue(), -hd.scale());
            }
        } else if (col.noNulls) {
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                HiveDecimal hd = oneColumn[rowIndex].getHiveDecimal();
                dout.addNumCol(cIdx, hd.unscaledValue().longValue(), -hd.scale());
            }
        } else {
            boolean[] isNull = col.isNull;
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                if (isNull[rowIndex]) {
                    dout.addInvalidCol(cIdx);
                    continue;
                }
                HiveDecimal hd = oneColumn[rowIndex].getHiveDecimal();
                dout.addNumCol(cIdx, hd.unscaledValue().longValue(), -hd.scale());
            }
        }
    }

    private void writeStringcolumn(BytesColumnVector col, int cIdx, int rowNumber, ParseWriter dout) {
        BufferedString bs = new BufferedString();
        if (col.isRepeating) {
            assert (col.length[0] >= 0) : ((Object)((Object)this)).getClass().getSimpleName() + ".writeStringcolumn/1: col.length[0]=" + col.length[0] + ", col.start[0]=" + col.start[0];
            dout.addStrCol(cIdx, bs.set(col.vector[0], col.start[0], col.length[0]));
            for (int rowIndex = 1; rowIndex < rowNumber; ++rowIndex) {
                dout.addStrCol(cIdx, bs);
            }
        } else if (col.noNulls) {
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                int l = col.length[rowIndex];
                assert (l >= 0) : ((Object)((Object)this)).getClass().getSimpleName() + ".writeStringcolumn/2: col.col.length[rowIndex]=" + l + ", rowIndex=" + rowIndex;
                dout.addStrCol(cIdx, bs.set(col.vector[rowIndex], col.start[rowIndex], l));
            }
        } else {
            boolean[] isNull = col.isNull;
            for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                if (isNull[rowIndex]) {
                    dout.addInvalidCol(cIdx);
                    continue;
                }
                int l = col.length[rowIndex];
                assert (l >= 0) : ((Object)((Object)this)).getClass().getSimpleName() + ".writeStringcolumn/3: col.col.length[rowIndex]=" + l + ", rowIndex=" + rowIndex;
                dout.addStrCol(cIdx, bs.set(col.vector[rowIndex], col.start[rowIndex], col.length[rowIndex]));
            }
        }
    }

    private void writeDoublecolumn(DoubleColumnVector vec, int colId, int rowNumber, ParseWriter dout) {
        double[] oneColumn = vec.vector;
        byte t = this._setup.getColumnTypes()[colId];
        switch (t) {
            case 4: {
                if (this._toStringMaps.get(colId) == null) {
                    this._toStringMaps.put(colId, new HashMap());
                }
                HashMap<Number, byte[]> map = this._toStringMaps.get(colId);
                BufferedString bs = new BufferedString();
                if (vec.isRepeating) {
                    bs.set(StringUtils.toBytes((Object)oneColumn[0]));
                    for (int i = 0; i < rowNumber; ++i) {
                        dout.addStrCol(colId, bs);
                    }
                } else if (vec.noNulls) {
                    for (int i = 0; i < rowNumber; ++i) {
                        double d = oneColumn[i];
                        if (map.get(d) == null) {
                            map.put(d, StringUtils.toBytes((Object)d));
                        }
                        dout.addStrCol(colId, bs.set(map.get(d)));
                    }
                } else {
                    for (int i = 0; i < rowNumber; ++i) {
                        boolean[] isNull = vec.isNull;
                        if (isNull[i]) {
                            dout.addInvalidCol(colId);
                            continue;
                        }
                        double d = oneColumn[i];
                        if (map.get(d) == null) {
                            map.put(d, StringUtils.toBytes((Object)d));
                        }
                        dout.addStrCol(colId, bs.set(map.get(d)));
                    }
                }
                break;
            }
            default: {
                if (vec.isRepeating) {
                    for (int i = 0; i < rowNumber; ++i) {
                        dout.addNumCol(colId, oneColumn[0]);
                    }
                } else if (vec.noNulls) {
                    for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                        dout.addNumCol(colId, oneColumn[rowIndex]);
                    }
                } else {
                    boolean[] isNull = vec.isNull;
                    for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                        if (isNull[rowIndex]) {
                            dout.addInvalidCol(colId);
                            continue;
                        }
                        dout.addNumCol(colId, oneColumn[rowIndex]);
                    }
                }
                break;
            }
        }
    }

    private void writeLongcolumn(LongColumnVector vec, int colId, int rowNumber, ParseWriter dout) {
        long[] oneColumn = vec.vector;
        byte t = this._setup.getColumnTypes()[colId];
        switch (t) {
            case 4: {
                if (this._toStringMaps.get(colId) == null) {
                    this._toStringMaps.put(colId, new HashMap());
                }
                HashMap<Number, byte[]> map = this._toStringMaps.get(colId);
                BufferedString bs = new BufferedString();
                if (vec.isRepeating) {
                    bs.set(StringUtils.toBytes((Object)oneColumn[0]));
                    for (int i = 0; i < rowNumber; ++i) {
                        dout.addStrCol(colId, bs);
                    }
                } else if (vec.noNulls) {
                    for (int i = 0; i < rowNumber; ++i) {
                        long l = oneColumn[i];
                        if (map.get(l) == null) {
                            map.put(l, StringUtils.toBytes((Object)l));
                        }
                        dout.addStrCol(colId, bs.set(map.get(l)));
                    }
                } else {
                    for (int i = 0; i < rowNumber; ++i) {
                        boolean[] isNull = vec.isNull;
                        if (isNull[i]) {
                            dout.addInvalidCol(colId);
                            continue;
                        }
                        long l = oneColumn[i];
                        if (map.get(l) == null) {
                            map.put(l, StringUtils.toBytes((Object)l));
                        }
                        dout.addStrCol(colId, bs.set(map.get(l)));
                    }
                }
                break;
            }
            default: {
                if (vec.isRepeating) {
                    for (int i = 0; i < rowNumber; ++i) {
                        dout.addNumCol(colId, oneColumn[0], 0);
                    }
                } else if (vec.noNulls) {
                    for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                        this.check_Min_Value(oneColumn[rowIndex], colId, rowNumber, dout);
                        dout.addNumCol(colId, oneColumn[rowIndex], 0);
                    }
                } else {
                    for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
                        boolean[] isNull = vec.isNull;
                        if (isNull[rowIndex]) {
                            dout.addInvalidCol(colId);
                            continue;
                        }
                        this.check_Min_Value(oneColumn[rowIndex], colId, rowNumber, dout);
                        dout.addNumCol(colId, oneColumn[rowIndex], 0);
                    }
                }
                break;
            }
        }
    }

    private void check_Min_Value(long l, int cIdx, int rowNumber, ParseWriter dout) {
        if (l <= Long.MIN_VALUE) {
            String warning = "Orc Parser: Long.MIN_VALUE: " + l + " is found in column " + cIdx + " row " + rowNumber + " of stripe " + this._cidx + ".  This value is used for sentinel and will not be parsed correctly.";
            dout.addError(new ParseWriter.ParseErr(warning, this._cidx, (long)rowNumber, -2L));
        }
    }

    private static int countStructFields(ObjectInspector x, ArrayList<String> allColumnNames) {
        int res = 1;
        switch (x.getCategory()) {
            case STRUCT: {
                StructObjectInspector structObjectInspector = (StructObjectInspector)x;
                List allColumns = structObjectInspector.getAllStructFieldRefs();
                for (StructField oneField : allColumns) {
                    allColumnNames.add(oneField.getFieldName());
                    res += OrcParser.countStructFields(oneField.getFieldObjectInspector(), allColumnNames);
                }
                break;
            }
            case LIST: {
                ListObjectInspector listObjectInspector = (ListObjectInspector)x;
                allColumnNames.add("list");
                res += OrcParser.countStructFields(listObjectInspector.getListElementObjectInspector(), allColumnNames);
                break;
            }
            case MAP: {
                MapObjectInspector mapObjectInspector = (MapObjectInspector)x;
                allColumnNames.add("mapKey");
                res += OrcParser.countStructFields(mapObjectInspector.getMapKeyObjectInspector(), allColumnNames);
                allColumnNames.add("mapValue");
                res += OrcParser.countStructFields(mapObjectInspector.getMapValueObjectInspector(), allColumnNames);
                break;
            }
            case UNION: {
                UnionObjectInspector unionObjectInspector = (UnionObjectInspector)x;
                allColumnNames.add("union");
                for (ObjectInspector xx : unionObjectInspector.getObjectInspectors()) {
                    res += OrcParser.countStructFields(xx, allColumnNames);
                }
                break;
            }
            case PRIMITIVE: {
                break;
            }
            default: {
                throw H2O.unimpl();
            }
        }
        return res;
    }

    static OrcParseSetup deriveParseSetup(Reader orcFileReader, StructObjectInspector insp) {
        List allColumns = insp.getAllStructFieldRefs();
        List allStripes = orcFileReader.getStripes();
        ArrayList<String> allColNames = new ArrayList<String>();
        boolean[] toInclude = new boolean[allColumns.size() + 1];
        int supportedFieldCnt = 0;
        int colIdx = 0;
        for (StructField oneField : allColumns) {
            int cnt;
            allColNames.add(oneField.getFieldName());
            String columnType = oneField.getFieldObjectInspector().getTypeName();
            if (columnType.toLowerCase().contains("decimal")) {
                columnType = "decimal";
            }
            if (OrcUtil.isSupportedSchema(columnType)) {
                toInclude[colIdx + 1] = true;
                ++supportedFieldCnt;
            }
            if ((cnt = OrcParser.countStructFields(oneField.getFieldObjectInspector(), allColNames)) > 1) {
                toInclude = Arrays.copyOf(toInclude, toInclude.length + cnt - 1);
            }
            colIdx += cnt;
        }
        String[] allNames = allColNames.toArray(new String[allColNames.size()]);
        String[] names = new String[supportedFieldCnt];
        byte[] types = new byte[supportedFieldCnt];
        String[][] domains = new String[supportedFieldCnt][];
        String[] dataPreview = new String[supportedFieldCnt];
        String[] dataTypes = new String[supportedFieldCnt];
        Object[] errs = new ParseWriter.ParseErr[]{};
        int columnIndex = 0;
        for (StructField oneField : allColumns) {
            String columnType = oneField.getFieldObjectInspector().getTypeName();
            if (columnType.toLowerCase().contains("decimal")) {
                columnType = "decimal";
            }
            if (OrcUtil.isSupportedSchema(columnType)) {
                names[columnIndex] = oneField.getFieldName();
                types[columnIndex] = OrcUtil.schemaToColumnType(columnType);
                dataTypes[columnIndex] = columnType;
                ++columnIndex;
                continue;
            }
            errs = (ParseWriter.ParseErr[])ArrayUtils.append((Object[])errs, (Object[])new ParseWriter.ParseErr[]{new ParseWriter.ParseErr("Orc Parser: Skipping field: " + oneField.getFieldName() + " because of unsupported type: " + columnType, -1, -1L, -2L)});
        }
        long[] stripeSizes = new long[allStripes.size()];
        long fileSize = 0L;
        long maxStripeSize = 0L;
        for (int index = 0; index < allStripes.size(); ++index) {
            long stripeSize = ((StripeInformation)allStripes.get(index)).getDataLength();
            if (stripeSize > maxStripeSize) {
                maxStripeSize = stripeSize;
            }
            stripeSizes[index] = fileSize += stripeSize;
        }
        OrcParseSetup ps = new OrcParseSetup(supportedFieldCnt, names, types, domains, null, new String[][]{dataPreview}, orcFileReader, dataTypes, toInclude, allNames, (ParseWriter.ParseErr[])errs);
        return ps;
    }

    public static class OrcParseSetup
    extends ParseSetup {
        transient Reader orcFileReader;
        String[] columnTypesString;
        boolean[] toInclude;
        String[] allColumnNames;
        private transient List<StripeInformation> stripesInfo;

        public OrcParseSetup(int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, Reader orcReader, String[] columntypes, boolean[] toInclude, String[] allColNames, ParseWriter.ParseErr[] errs) {
            super(OrcParserProvider.ORC_INFO, (byte)124, true, 1, ncols, columnNames, ctypes, domains, naStrings, data, errs);
            this.orcFileReader = orcReader;
            this.columnTypesString = columntypes;
            this.toInclude = toInclude;
            this.allColumnNames = allColNames;
        }

        protected boolean isCompatible(ParseSetup setupB) {
            return super.isCompatible(setupB) && Arrays.equals(this.getColumnTypes(), setupB.getColumnTypes());
        }

        protected Parser parser(Key jobKey) {
            return new OrcParser(this, (Key<Job>)jobKey);
        }

        public Reader getOrcFileReader() {
            return this.orcFileReader;
        }

        public String[] getColumnTypesString() {
            return this.columnTypesString;
        }

        public void setColumnTypeStrings(String[] columnTypeStrings) {
            this.columnTypesString = columnTypeStrings;
        }

        public boolean[] getToInclude() {
            return this.toInclude;
        }

        public String[] getAllColNames() {
            return this.allColumnNames;
        }

        public void setAllColNames(String[] columnNames) {
            this.allColumnNames = this.allColumnNames;
        }

        public void setOrcFileReader(Reader orcFileReader) {
            this.orcFileReader = orcFileReader;
            this.stripesInfo = orcFileReader.getStripes();
        }

        public List<StripeInformation> getStripes() {
            return this.stripesInfo;
        }
    }
}

