/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import water.fvec.Chunk;
import water.fvec.Vec;

public class VecDataInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private final Vec _v;
    private byte[] _buffer;
    private long _offset;
    private int _pos;

    public VecDataInputStream(Vec v) {
        this._v = v;
        this.flushBuffer(0L);
    }

    private int buffAvailable() {
        return this._buffer.length - this._pos;
    }

    private long globAvailable() {
        return this._v.length() - (this._offset + (long)this._pos);
    }

    private void fetchData(long position) {
        Chunk chk = this._v.chunkForRow(position);
        this._buffer = chk.asBytes();
        this._offset = chk.start();
        this._pos = (int)(position - this._offset);
        assert (this._buffer.length > 0);
    }

    private void flushBuffer(long position) {
        this._buffer = EMPTY_BUFFER;
        this._pos = 0;
        this._offset = position;
    }

    @Override
    public int read() throws IOException {
        if (this.buffAvailable() <= 0) {
            if (this.globAvailable() <= 0L) {
                return -1;
            }
            this.fetchData(this._offset + (long)this._pos);
        }
        return this._buffer[this._pos++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read = this.read(this._offset + (long)this._pos, buffer, offset, length);
        int skipped = (int)this.skip(read);
        assert (skipped == read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        long target = this._offset + (long)this._pos + n;
        if (this.inBuffer(target)) {
            this.seekInBuffer(target);
        } else {
            if (target > this._v.length()) {
                n -= target - this._v.length();
                target = this._v.length();
            }
            this.flushBuffer(target);
        }
        return n;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        int avail;
        int loaded = 0;
        for (long currentPosition = position; loaded < length && currentPosition < this._v.length(); loaded += avail, currentPosition += (long)avail) {
            int pos;
            byte[] buff;
            if (this.inBuffer(currentPosition)) {
                buff = this._buffer;
                pos = (int)(currentPosition - this._offset);
            } else {
                Chunk chunk = this._v.chunkForRow(currentPosition);
                buff = chunk.asBytes();
                pos = (int)(currentPosition - chunk.start());
            }
            avail = Math.min(buff.length - pos, length - loaded);
            System.arraycopy(buff, pos, buffer, offset + loaded, avail);
        }
        return loaded;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int loaded = this.read(position, buffer, offset, length);
        if (loaded != length) {
            throw new EOFException("Reached the end of the Vec while reading into buffer.");
        }
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void seek(long position) throws IOException {
        if (this.inBuffer(position)) {
            this.seekInBuffer(position);
        } else {
            this.flushBuffer(position);
        }
    }

    private void seekInBuffer(long position) {
        this._pos = (int)(position - this._offset);
    }

    private boolean inBuffer(long position) {
        return position >= this._offset && position < this._offset + (long)this._buffer.length;
    }

    public long getPos() throws IOException {
        return this._offset + (long)this._pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new UnsupportedOperationException("Intentionally not implemented");
    }
}

