/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import org.apache.parquet.hadoop.VecParquetReader;
import water.Job;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Vec;
import water.parser.ParseSetup;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.ParserProvider;
import water.parser.parquet.ParquetParser;

public class ParquetParserProvider
extends ParserProvider {
    static ParserInfo PARQUET_INFO = new ParserInfo("PARQUET", 10030, true, false, false);

    public ParserInfo info() {
        return PARQUET_INFO;
    }

    public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
        return new ParquetParser(setup, jobKey);
    }

    public ParseSetup guessSetup(ByteVec vec, byte[] bits, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] domains, String[][] naStrings) {
        return ParquetParser.guessSetup(vec, bits);
    }

    public ParseSetup createParserSetup(Key[] inputs, ParseSetup requestedSetup) {
        return requestedSetup instanceof ParquetParser.ParquetParseSetup ? requestedSetup : requestedSetup.copyTo((ParseSetup)new ParquetParser.ParquetParseSetup());
    }

    public ParseSetup setupLocal(Vec v, ParseSetup setup) {
        ((ParquetParser.ParquetParseSetup)setup).parquetMetadata = VecParquetReader.readFooterAsBytes(v);
        return setup;
    }
}

