/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.InternalParquetRecordReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import water.fvec.Vec;
import water.parser.ParseWriter;
import water.parser.parquet.ChunkReadSupport;
import water.persist.VecDataInputStream;
import water.persist.VecFileSystem;
import water.util.Log;

public class VecParquetReader
implements Closeable {
    private static ParquetMetadataConverter converter = new ParquetMetadataConverter();
    private final Vec vec;
    private final ParquetMetadata metadata;
    private final ParseWriter writer;
    private final byte[] chunkSchema;
    private InternalParquetRecordReader<Integer> reader;

    public VecParquetReader(Vec vec, ParquetMetadata metadata, ParseWriter writer, byte[] chunkSchema) {
        this.vec = vec;
        this.metadata = metadata;
        this.writer = writer;
        this.chunkSchema = chunkSchema;
    }

    public Integer read() throws IOException {
        try {
            if (this.reader == null) {
                this.initReader();
            }
            assert (this.reader != null);
            if (this.reader.nextKeyValue()) {
                return (Integer)this.reader.getCurrentValue();
            }
            return null;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void initReader() throws IOException {
        assert (this.reader == null);
        List blocks = this.metadata.getBlocks();
        MessageType fileSchema = this.metadata.getFileMetaData().getSchema();
        this.reader = new InternalParquetRecordReader((ReadSupport)new ChunkReadSupport(this.writer, this.chunkSchema));
        Configuration conf = VecFileSystem.makeConfiguration((Vec)this.vec);
        this.reader.initialize(fileSchema, this.metadata.getFileMetaData().getKeyValueMetaData(), VecFileSystem.VEC_PATH, blocks, conf);
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readFooterAsBytes(Vec vec) {
        byte[] byArray;
        FSDataInputStream f = null;
        try {
            f = new FSDataInputStream((InputStream)new VecDataInputStream(vec));
            int FOOTER_LENGTH_SIZE = 4;
            if (vec.length() < (long)(ParquetFileWriter.MAGIC.length + 4 + ParquetFileWriter.MAGIC.length)) {
                throw new RuntimeException("Vec doesn't represent a Parquet data (too short)");
            }
            long footerLengthIndex = vec.length() - 4L - (long)ParquetFileWriter.MAGIC.length;
            f.seek(footerLengthIndex);
            int footerLength = BytesUtils.readIntLittleEndian((InputStream)f);
            byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
            f.readFully(magic);
            if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
                throw new RuntimeException("Vec is not a Parquet file. expected magic number at tail " + Arrays.toString(ParquetFileWriter.MAGIC) + " but found " + Arrays.toString(magic));
            }
            long footerIndex = footerLengthIndex - (long)footerLength;
            if (footerIndex < (long)ParquetFileWriter.MAGIC.length) throw new RuntimeException("corrupted file: the footer index is not within the Vec");
            if (footerIndex >= footerLengthIndex) {
                throw new RuntimeException("corrupted file: the footer index is not within the Vec");
            }
            f.seek(footerIndex);
            byte[] metadataBytes = new byte[footerLength];
            f.readFully(metadataBytes);
            byArray = metadataBytes;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to read Parquet metadata", e);
            }
            catch (Throwable throwable) {
                try {
                    if (f == null) throw throwable;
                    f.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    Log.warn((Object[])new Object[]{"Failed to close Vec data input stream", e2});
                }
                throw throwable;
            }
        }
        try {
            if (f == null) return byArray;
            f.close();
            return byArray;
        }
        catch (Exception e) {
            Log.warn((Object[])new Object[]{"Failed to close Vec data input stream", e});
        }
        return byArray;
    }

    public static ParquetMetadata readFooter(byte[] metadataBytes) {
        return VecParquetReader.readFooter(metadataBytes, ParquetMetadataConverter.NO_FILTER);
    }

    public static ParquetMetadata readFooter(byte[] metadataBytes, ParquetMetadataConverter.MetadataFilter filter) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(metadataBytes);
            return converter.readParquetMetadata((InputStream)bis, filter);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read Parquet metadata", e);
        }
    }
}

