/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import water.util.Log;

class H2OInternalParquetRecordReader<T> {
    private ColumnIOFactory columnIOFactory = null;
    private final FilterCompat.Filter filter;
    private MessageType requestedSchema;
    private MessageType fileSchema;
    private int columnCount;
    private final ReadSupport<T> readSupport;
    private RecordMaterializer<T> recordConverter;
    private T currentValue;
    private long total;
    private long current = 0L;
    private int currentBlock = -1;
    private ParquetFileReader reader;
    private RecordReader<T> recordReader;
    private boolean strictTypeChecking;
    private long totalTimeSpentReadingBytes;
    private long totalTimeSpentProcessingRecords;
    private long startedAssemblingCurrentBlockAt;
    private long totalCountLoadedSoFar = 0L;
    private Path file;
    private long unmaterializableRecordCounter = 0L;

    public H2OInternalParquetRecordReader(ReadSupport<T> readSupport, FilterCompat.Filter filter) {
        this.readSupport = readSupport;
        this.filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)filter, (String)"filter");
    }

    public H2OInternalParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, FilterCompat.NOOP);
    }

    private void checkRead() throws IOException {
        if (this.current == this.totalCountLoadedSoFar) {
            if (this.current != 0L) {
                this.totalTimeSpentProcessingRecords += System.currentTimeMillis() - this.startedAssemblingCurrentBlockAt;
                if (Log.isLoggingFor((String)"info")) {
                    Log.info((Object[])new Object[]{"Assembled and processed " + this.totalCountLoadedSoFar + " records from " + this.columnCount + " columns in " + this.totalTimeSpentProcessingRecords + " ms: " + (float)this.totalCountLoadedSoFar / (float)this.totalTimeSpentProcessingRecords + " rec/ms, " + (float)this.totalCountLoadedSoFar * (float)this.columnCount / (float)this.totalTimeSpentProcessingRecords + " cell/ms"});
                    long totalTime = this.totalTimeSpentProcessingRecords + this.totalTimeSpentReadingBytes;
                    if (totalTime != 0L) {
                        long percentReading = 100L * this.totalTimeSpentReadingBytes / totalTime;
                        long percentProcessing = 100L * this.totalTimeSpentProcessingRecords / totalTime;
                        Log.info((Object[])new Object[]{"time spent so far " + percentReading + "% reading (" + this.totalTimeSpentReadingBytes + " ms) and " + percentProcessing + "% processing (" + this.totalTimeSpentProcessingRecords + " ms)"});
                    }
                }
            }
            Log.info((Object[])new Object[]{"at row " + this.current + ". reading next block"});
            long t0 = System.currentTimeMillis();
            PageReadStore pages = this.reader.readNextRowGroup();
            if (pages == null) {
                throw new IOException("expecting more rows but reached last block. Read " + this.current + " out of " + this.total);
            }
            long timeSpentReading = System.currentTimeMillis() - t0;
            this.totalTimeSpentReadingBytes += timeSpentReading;
            if (Log.isLoggingFor((String)"info")) {
                Log.info((Object[])new Object[]{"block read in memory in " + timeSpentReading + " ms. row count = " + pages.getRowCount()});
            }
            if (Log.isLoggingFor((String)"debug")) {
                Log.debug((Object[])new Object[]{"initializing Record assembly with requested schema " + this.requestedSchema});
            }
            MessageColumnIO columnIO = this.columnIOFactory.getColumnIO(this.requestedSchema, this.fileSchema, this.strictTypeChecking);
            this.recordReader = columnIO.getRecordReader(pages, this.recordConverter, this.filter);
            this.startedAssemblingCurrentBlockAt = System.currentTimeMillis();
            this.totalCountLoadedSoFar += pages.getRowCount();
            ++this.currentBlock;
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public void initialize(MessageType fileSchema, FileMetaData parquetFileMetadata, Path file, List<BlockMetaData> blocks, Configuration configuration) throws IOException {
        Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
        ReadSupport.ReadContext readContext = this.readSupport.init(new InitContext(configuration, H2OInternalParquetRecordReader.toSetMultiMap(fileMetadata), fileSchema));
        this.columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
        this.requestedSchema = readContext.getRequestedSchema();
        this.fileSchema = fileSchema;
        this.file = file;
        this.columnCount = this.requestedSchema.getPaths().size();
        this.recordConverter = this.readSupport.prepareForRead(configuration, fileMetadata, fileSchema, readContext);
        this.strictTypeChecking = true;
        List columns = this.requestedSchema.getColumns();
        this.reader = new ParquetFileReader(configuration, parquetFileMetadata, file, blocks, columns);
        for (BlockMetaData block : blocks) {
            this.total += block.getRowCount();
        }
        Log.info((Object[])new Object[]{"RecordReader initialized will read a total of " + this.total + " records."});
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean recordFound = false;
        while (!recordFound) {
            if (this.current >= this.total) {
                return false;
            }
            try {
                this.checkRead();
                ++this.current;
                try {
                    this.currentValue = this.recordReader.read();
                }
                catch (RecordMaterializer.RecordMaterializationException e) {
                    ++this.unmaterializableRecordCounter;
                    Log.debug((Object[])new Object[]{"skipping a corrupt record"});
                    continue;
                }
                if (this.recordReader.shouldSkipCurrentRecord()) {
                    Log.debug((Object[])new Object[]{"skipping record"});
                    continue;
                }
                if (this.currentValue == null) {
                    this.current = this.totalCountLoadedSoFar;
                    Log.debug((Object[])new Object[]{"filtered record reader reached end of block"});
                    continue;
                }
                recordFound = true;
                Log.debug((Object[])new Object[]{"read value: " + this.currentValue});
            }
            catch (RuntimeException e) {
                throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in file %s", this.current, this.currentBlock, this.file), (Throwable)e);
            }
        }
        return true;
    }

    public long getUnmaterializableRecordCount() {
        return this.unmaterializableRecordCounter;
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map) {
        HashMap setMultiMap = new HashMap();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            HashSet<V> set = new HashSet<V>();
            set.add(entry.getValue());
            setMultiMap.put(entry.getKey(), Collections.unmodifiableSet(set));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }
}

