/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import water.parser.BufferedString;
import water.parser.ParseWriter;
import water.util.StringUtils;

class ChunkConverter
extends GroupConverter {
    private final WriterDelegate _writer;
    private final Converter[] _converters;
    private int _currentRecordIdx = -1;

    ChunkConverter(MessageType parquetSchema, byte[] chunkSchema, ParseWriter writer) {
        this._writer = new WriterDelegate(writer, chunkSchema.length);
        int colIdx = 0;
        this._converters = new Converter[chunkSchema.length];
        for (Type parquetField : parquetSchema.getFields()) {
            assert (parquetField.isPrimitive());
            this._converters[colIdx] = this.newConverter(colIdx, chunkSchema[colIdx], parquetField.asPrimitiveType());
            ++colIdx;
        }
    }

    public Converter getConverter(int fieldIndex) {
        return this._converters[fieldIndex];
    }

    public void start() {
        ++this._currentRecordIdx;
        this._writer.startLine();
    }

    public void end() {
        this._writer.endLine();
        assert (this._writer.lineNum() - 1L == (long)this._currentRecordIdx);
    }

    int getCurrentRecordIdx() {
        return this._currentRecordIdx;
    }

    private PrimitiveConverter newConverter(int colIdx, byte vecType, PrimitiveType parquetType) {
        switch (vecType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (parquetType.getOriginalType() == OriginalType.TIMESTAMP_MILLIS) {
                    return new TimestampConverter(colIdx, this._writer);
                }
                boolean dictSupport = parquetType.getOriginalType() == OriginalType.UTF8 || parquetType.getOriginalType() == OriginalType.ENUM;
                return new StringConverter(this._writer, colIdx, dictSupport);
            }
            case 3: {
                return new NumberConverter(colIdx, this._writer);
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + vecType);
    }

    private static class WriterDelegate {
        private final ParseWriter _writer;
        private final int _numCols;
        private int _col;

        WriterDelegate(ParseWriter writer, int numCols) {
            this._writer = writer;
            this._numCols = numCols;
            this._col = Integer.MIN_VALUE;
        }

        void startLine() {
            this._col = -1;
        }

        void endLine() {
            this.moveToCol(this._numCols);
            this._writer.newLine();
        }

        int moveToCol(int colIdx) {
            for (int c = this._col + 1; c < colIdx; ++c) {
                this._writer.addInvalidCol(c);
            }
            this._col = colIdx;
            return this._col;
        }

        void addNumCol(int colIdx, long number, int exp) {
            this._writer.addNumCol(this.moveToCol(colIdx), number, exp);
        }

        void addNumCol(int colIdx, double d) {
            this._writer.addNumCol(this.moveToCol(colIdx), d);
        }

        void addStrCol(int colIdx, BufferedString str) {
            this._writer.addStrCol(this.moveToCol(colIdx), str);
        }

        long lineNum() {
            return this._writer.lineNum();
        }
    }

    private static class TimestampConverter
    extends PrimitiveConverter {
        private final int _colIdx;
        private final WriterDelegate _writer;

        TimestampConverter(int _colIdx, WriterDelegate _writer) {
            this._colIdx = _colIdx;
            this._writer = _writer;
        }

        public void addLong(long value) {
            this._writer.addNumCol(this._colIdx, value, 0);
        }
    }

    private static class NumberConverter
    extends PrimitiveConverter {
        private final int _colIdx;
        private final WriterDelegate _writer;
        private final BufferedString _bs = new BufferedString();

        NumberConverter(int _colIdx, WriterDelegate _writer) {
            this._colIdx = _colIdx;
            this._writer = _writer;
        }

        public void addBoolean(boolean value) {
            this._writer.addNumCol(this._colIdx, value ? 1.0 : 0.0);
        }

        public void addDouble(double value) {
            this._writer.addNumCol(this._colIdx, value);
        }

        public void addFloat(float value) {
            this._writer.addNumCol(this._colIdx, value);
        }

        public void addInt(int value) {
            this._writer.addNumCol(this._colIdx, value, 0);
        }

        public void addLong(long value) {
            this._writer.addNumCol(this._colIdx, value, 0);
        }

        public void addBinary(Binary value) {
            this._bs.set(StringUtils.bytesOf((CharSequence)value.toStringUsingUTF8()));
            this._writer.addStrCol(this._colIdx, this._bs);
        }
    }

    private static class StringConverter
    extends PrimitiveConverter {
        private final BufferedString _bs = new BufferedString();
        private final int _colIdx;
        private final WriterDelegate _writer;
        private final boolean _dictionarySupport;
        private String[] _dict;

        StringConverter(WriterDelegate writer, int colIdx, boolean dictionarySupport) {
            this._colIdx = colIdx;
            this._writer = writer;
            this._dictionarySupport = dictionarySupport;
        }

        public void addBinary(Binary value) {
            this._bs.set(StringUtils.bytesOf((CharSequence)value.toStringUsingUTF8()));
            this._writer.addStrCol(this._colIdx, this._bs);
        }

        public boolean hasDictionarySupport() {
            return this._dictionarySupport;
        }

        public void setDictionary(Dictionary dictionary) {
            this._dict = new String[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this._dict[i] = dictionary.decodeToBinary(i).toStringUsingUTF8();
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this._bs.set(StringUtils.bytesOf((CharSequence)this._dict[dictionaryId]));
            this._writer.addStrCol(this._colIdx, this._bs);
        }
    }
}

