/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.io.api.Binary;

final class ParquetInt96TimestampConverter {
    private static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final byte BYTES_IN_INT96_TIMESTAMP = 12;

    private ParquetInt96TimestampConverter() {
    }

    public static long getTimestampMillis(Binary timestampBinary) {
        if (timestampBinary.length() != 12) {
            throw new IllegalArgumentException("Parquet timestamp must be 12 bytes long, actual " + timestampBinary.length());
        }
        byte[] bytes = timestampBinary.getBytes();
        long timeOfDayNanos = Longs.fromBytes((byte)bytes[7], (byte)bytes[6], (byte)bytes[5], (byte)bytes[4], (byte)bytes[3], (byte)bytes[2], (byte)bytes[1], (byte)bytes[0]);
        int julianDay = Ints.fromBytes((byte)bytes[11], (byte)bytes[10], (byte)bytes[9], (byte)bytes[8]);
        return ParquetInt96TimestampConverter.julianDayToMillis(julianDay) + timeOfDayNanos / NANOS_PER_MILLISECOND;
    }

    private static long julianDayToMillis(int julianDay) {
        return (long)(julianDay - 2440588) * MILLIS_IN_DAY;
    }
}

