/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import water.parser.BufferedString;
import water.parser.parquet.ParquetInt96TimestampConverter;
import water.parser.parquet.WriterDelegate;
import water.util.StringUtils;

class ChunkConverter
extends GroupConverter {
    private final WriterDelegate _writer;
    private final Converter[] _converters;
    private long _currentRecordIdx = -1L;

    ChunkConverter(MessageType parquetSchema, byte[] chunkSchema, WriterDelegate writer) {
        this._writer = writer;
        int colIdx = 0;
        this._converters = new Converter[chunkSchema.length];
        for (Type parquetField : parquetSchema.getFields()) {
            assert (parquetField.isPrimitive());
            this._converters[colIdx] = this.newConverter(colIdx, chunkSchema[colIdx], parquetField.asPrimitiveType());
            ++colIdx;
        }
    }

    public Converter getConverter(int fieldIndex) {
        return this._converters[fieldIndex];
    }

    public void start() {
        ++this._currentRecordIdx;
        this._writer.startLine();
    }

    public void end() {
        this._writer.endLine();
    }

    long getCurrentRecordIdx() {
        return this._currentRecordIdx;
    }

    private PrimitiveConverter newConverter(int colIdx, byte vecType, PrimitiveType parquetType) {
        switch (vecType) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                if (OriginalType.TIMESTAMP_MILLIS.equals((Object)parquetType.getOriginalType()) || parquetType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
                    return new TimestampConverter(colIdx, this._writer);
                }
                boolean dictSupport = parquetType.getOriginalType() == OriginalType.UTF8 || parquetType.getOriginalType() == OriginalType.ENUM;
                return new StringConverter(this._writer, colIdx, dictSupport);
            }
            case 3: {
                if (OriginalType.DECIMAL.equals((Object)parquetType.getOriginalType())) {
                    return new DecimalConverter(colIdx, parquetType.getDecimalMetadata().getScale(), this._writer);
                }
                return new NumberConverter(colIdx, this._writer);
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + vecType);
    }

    private static class TimestampConverter
    extends PrimitiveConverter {
        private final int _colIdx;
        private final WriterDelegate _writer;

        TimestampConverter(int _colIdx, WriterDelegate _writer) {
            this._colIdx = _colIdx;
            this._writer = _writer;
        }

        public void addLong(long value) {
            this._writer.addNumCol(this._colIdx, value, 0);
        }

        public void addBinary(Binary value) {
            long timestampMillis = ParquetInt96TimestampConverter.getTimestampMillis(value);
            this._writer.addNumCol(this._colIdx, timestampMillis);
        }
    }

    private static class DecimalConverter
    extends PrimitiveConverter {
        private final int _colIdx;
        private final WriterDelegate _writer;
        private final BufferedString _bs = new BufferedString();
        private final int _exp;

        DecimalConverter(int colIdx, int scale, WriterDelegate writer) {
            this._colIdx = colIdx;
            this._writer = writer;
            this._exp = -scale;
        }

        public void addBoolean(boolean value) {
            throw new UnsupportedOperationException("Boolean type is not supported by DecimalConverter");
        }

        public void addDouble(double value) {
            throw new UnsupportedOperationException("Double type is not supported by DecimalConverter");
        }

        public void addFloat(float value) {
            throw new UnsupportedOperationException("Float type is not supported by DecimalConverter");
        }

        public void addInt(int value) {
            this._writer.addNumCol(this._colIdx, value, this._exp);
        }

        public void addLong(long value) {
            this._writer.addNumCol(this._colIdx, value, this._exp);
        }

        public void addBinary(Binary value) {
            throw new UnsupportedOperationException("Arbitrary precision Decimal type is currently not supported by H2O.Please use 64-bit decimal type instead (precision <= 18).");
        }
    }

    private static class NumberConverter
    extends PrimitiveConverter {
        private final int _colIdx;
        private final WriterDelegate _writer;
        private final BufferedString _bs = new BufferedString();

        NumberConverter(int _colIdx, WriterDelegate _writer) {
            this._colIdx = _colIdx;
            this._writer = _writer;
        }

        public void addBoolean(boolean value) {
            this._writer.addNumCol(this._colIdx, value ? 1.0 : 0.0);
        }

        public void addDouble(double value) {
            this._writer.addNumCol(this._colIdx, value);
        }

        public void addFloat(float value) {
            this._writer.addNumCol(this._colIdx, value);
        }

        public void addInt(int value) {
            this._writer.addNumCol(this._colIdx, value, 0);
        }

        public void addLong(long value) {
            this._writer.addNumCol(this._colIdx, value, 0);
        }

        public void addBinary(Binary value) {
            this._bs.set(StringUtils.bytesOf((CharSequence)value.toStringUsingUTF8()));
            this._writer.addStrCol(this._colIdx, this._bs);
        }
    }

    private static class StringConverter
    extends PrimitiveConverter {
        private final BufferedString _bs = new BufferedString();
        private final int _colIdx;
        private final WriterDelegate _writer;
        private final boolean _dictionarySupport;
        private String[] _dict;

        StringConverter(WriterDelegate writer, int colIdx, boolean dictionarySupport) {
            this._colIdx = colIdx;
            this._writer = writer;
            this._dictionarySupport = dictionarySupport;
        }

        public void addBinary(Binary value) {
            this.writeStrCol(StringUtils.bytesOf((CharSequence)value.toStringUsingUTF8()));
        }

        public boolean hasDictionarySupport() {
            return this._dictionarySupport;
        }

        public void setDictionary(Dictionary dictionary) {
            this._dict = new String[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this._dict[i] = dictionary.decodeToBinary(i).toStringUsingUTF8();
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.writeStrCol(StringUtils.bytesOf((CharSequence)this._dict[dictionaryId]));
        }

        private void writeStrCol(byte[] data) {
            this._bs.set(data);
            this._writer.addStrCol(this._colIdx, this._bs);
        }
    }
}

