/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import java.util.concurrent.TimeUnit;
import org.apache.parquet.io.api.Binary;
import water.parser.parquet.TypeUtils;

final class ParquetInt96TimestampConverter {
    private static final int JULIAN_EPOCH_OFFSET_DAYS = 2440588;
    private static final long MILLIS_IN_DAY = TimeUnit.DAYS.toMillis(1L);
    private static final long NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final byte BYTES_IN_INT96_TIMESTAMP = 12;

    private ParquetInt96TimestampConverter() {
    }

    public static long getTimestampMillis(Binary timestampBinary) {
        if (timestampBinary.length() != 12) {
            throw new IllegalArgumentException("Parquet timestamp must be 12 bytes long, actual " + timestampBinary.length());
        }
        byte[] bytes = timestampBinary.getBytes();
        long timeOfDayNanos = TypeUtils.longFromBytes(bytes[7], bytes[6], bytes[5], bytes[4], bytes[3], bytes[2], bytes[1], bytes[0]);
        int julianDay = TypeUtils.intFromBytes(bytes[11], bytes[10], bytes[9], bytes[8]);
        return ParquetInt96TimestampConverter.julianDayToMillis(julianDay) + timeOfDayNanos / NANOS_PER_MILLISECOND;
    }

    private static long julianDayToMillis(int julianDay) {
        return (long)(julianDay - 2440588) * MILLIS_IN_DAY;
    }
}

