/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.parser.BufferedString;
import water.persist.PersistHdfs;

public class FrameParquetExporter {
    public void export(H2O.H2OCountedCompleter<?> completer, String path, Frame frame, boolean force, String compression) {
        File f = new File(path);
        new PartExportParquetTask(completer, f.getPath(), FrameParquetExporter.generateMessageTypeString(frame), frame.names(), frame.types(), frame.domains(), force, compression).dfork(frame);
    }

    private static String generateMessageTypeString(Frame frame) {
        String message_txt = "message test { ";
        block6: for (int i = 0; i < frame.numCols(); ++i) {
            String currName = frame._names[i];
            switch (frame.types()[i]) {
                case 5: {
                    message_txt = message_txt.concat("optional int64 ").concat(currName).concat(" (TIMESTAMP_MILLIS);");
                    continue block6;
                }
                case 0: 
                case 3: {
                    message_txt = message_txt.concat("optional double ").concat(currName).concat("; ");
                    continue block6;
                }
                case 2: 
                case 4: {
                    message_txt = message_txt.concat("optional BINARY ").concat(currName).concat(" (UTF8); ");
                    continue block6;
                }
                case 1: {
                    message_txt = message_txt.concat("optional fixed_len_byte_array(16) ").concat(currName).concat(" (UUID); ");
                }
            }
        }
        message_txt = message_txt.concat("} ");
        return message_txt;
    }

    private static ParquetWriter<Group> buildWriter(Path file, CompressionCodecName compressionCodecName, Configuration configuration, MessageType _schema, ParquetFileWriter.Mode mode) throws IOException {
        GroupWriteSupport.setSchema((MessageType)_schema, (Configuration)configuration);
        return new ParquetWriter.Builder(file){

            protected ParquetWriter.Builder self() {
                return this;
            }

            protected WriteSupport<Group> getWriteSupport(Configuration conf) {
                return new GroupWriteSupport();
            }
        }.self().withCompressionCodec(compressionCodecName).withConf(configuration).withWriteMode(mode).build();
    }

    private static class PartExportParquetTask
    extends MRTask<PartExportParquetTask> {
        final String _path;
        final CompressionCodecName _compressionCodecName;
        final String _messageTypeString;
        final String[] _colNames;
        final byte[] _colTypes;
        final String[][] _domains;
        final boolean _force;

        PartExportParquetTask(H2O.H2OCountedCompleter<?> completer, String path, String messageTypeString, String[] colNames, byte[] colTypes, String[][] domains, boolean force, String compression) {
            super(completer);
            this._path = path;
            this._compressionCodecName = this.getCompressionCodecName(compression);
            this._messageTypeString = messageTypeString;
            this._colNames = colNames;
            this._colTypes = colTypes;
            this._domains = domains;
            this._force = force;
        }

        CompressionCodecName getCompressionCodecName(String compression) {
            if (compression == null) {
                return CompressionCodecName.UNCOMPRESSED;
            }
            switch (compression.toLowerCase()) {
                case "gzip": {
                    return CompressionCodecName.GZIP;
                }
                case "lzo": {
                    return CompressionCodecName.LZO;
                }
                case "snappy": {
                    return CompressionCodecName.SNAPPY;
                }
            }
            throw new RuntimeException("Compression " + compression + "is not supported for parquet export.");
        }

        ParquetFileWriter.Mode getMode(boolean force) {
            return force ? ParquetFileWriter.Mode.OVERWRITE : ParquetFileWriter.Mode.CREATE;
        }

        public void map(Chunk[] cs) {
            Chunk anyChunk = cs[0];
            int partIdx = anyChunk.cidx();
            String partPath = this._path + "/part-m-" + String.valueOf(100000 + partIdx).substring(1);
            SimpleGroupFactory fact = new SimpleGroupFactory(MessageTypeParser.parseMessageType((String)this._messageTypeString));
            try (ParquetWriter writer = FrameParquetExporter.buildWriter(new Path(partPath), this._compressionCodecName, PersistHdfs.CONF, MessageTypeParser.parseMessageType((String)this._messageTypeString), this.getMode(this._force));){
                for (int i = 0; i < anyChunk._len; ++i) {
                    Group group = fact.newGroup();
                    block17: for (int j = 0; j < cs.length; ++j) {
                        String currColName = this._colNames[j];
                        byte currColType = this._colTypes[j];
                        switch (currColType) {
                            case 1: 
                            case 5: {
                                group = group.append(currColName, cs[j].at8(i));
                                continue block17;
                            }
                            case 2: {
                                group = group.append(currColName, cs[j].atStr(new BufferedString(), i).toString());
                                continue block17;
                            }
                            case 4: {
                                if (cs[j].isNA(i)) {
                                    group = group.append(currColName, "");
                                    continue block17;
                                }
                                group = group.append(currColName, this._domains[j][(int)cs[j].at8(i)]);
                                continue block17;
                            }
                            default: {
                                group = group.append(currColName, cs[j].atd(i));
                            }
                        }
                    }
                    writer.write((Object)group);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

