/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileReader;
import water.fvec.HDFSFileVec;
import water.fvec.Vec;
import water.persist.PersistHdfs;
import water.persist.VecFileSystem;

class VecReaderEnv {
    private final Configuration _conf;
    private final Path _path;

    private VecReaderEnv(Configuration conf, Path path) {
        this._conf = conf;
        this._path = path;
        this._conf.setInt(ParquetFileReader.PARQUET_READ_PARALLELISM, 1);
    }

    Configuration getConf() {
        return this._conf;
    }

    Path getPath() {
        return this._path;
    }

    static VecReaderEnv make(Vec vec) {
        if (vec instanceof HDFSFileVec) {
            Path path = new Path(((HDFSFileVec)vec).getPath());
            return new VecReaderEnv(PersistHdfs.CONF, path);
        }
        return new VecReaderEnv(VecFileSystem.makeConfiguration((Vec)vec), VecFileSystem.VEC_PATH);
    }
}

