/*
 * Decompiled with CFR 0.152.
 */
package water.parser.parquet;

import org.apache.parquet.format.converter.ParquetMetadataConverter;
import water.DKV;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BinaryParserProvider;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.parquet.ParquetParser;
import water.parser.parquet.VecParquetReader;

public class ParquetParserProvider
extends BinaryParserProvider {
    static ParserInfo PARQUET_INFO = new ParserInfo("PARQUET", 10020, true, false, true, false);

    public ParserInfo info() {
        return PARQUET_INFO;
    }

    public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
        return new ParquetParser(setup, jobKey);
    }

    public ParseSetup guessInitSetup(ByteVec v, byte[] bits, ParseSetup userSetup) {
        return ParquetParser.guessFormatSetup(v, bits, userSetup.gettzAdjustToLocal());
    }

    public ParseSetup guessFinalSetup(ByteVec v, byte[] bits, ParseSetup ps) {
        boolean[] keepColumns = null;
        int[] parseColumnIndices = ps.get_parse_columns_indices();
        if (parseColumnIndices != null) {
            int numCols = ps.getNumberColumns();
            keepColumns = new boolean[numCols];
            for (int cindex : parseColumnIndices) {
                keepColumns[cindex] = true;
            }
        }
        return ParquetParser.guessDataSetup(v, (ParquetParser.ParquetParseSetup)ps, keepColumns);
    }

    public ParseSetup createParserSetup(Key[] inputs, ParseSetup requestedSetup) {
        ParseSetup setup = requestedSetup instanceof ParquetParser.ParquetParseSetup ? requestedSetup : requestedSetup.copyTo((ParseSetup)new ParquetParser.ParquetParseSetup());
        Iced frameOrVec = DKV.getGet((Key)inputs[0]);
        ByteVec vec = (ByteVec)(frameOrVec instanceof Frame ? ((Frame)frameOrVec).vec(0) : frameOrVec);
        if (setup.getForceColTypes() && vec != null) {
            setup.setParquetColumnTypes(ParquetParser.extractColumnTypes(VecParquetReader.readFooter(VecParquetReader.readFooterAsBytes((Vec)vec), ParquetMetadataConverter.NO_FILTER)));
        }
        byte[] requestedTypes = setup.getColumnTypes();
        byte[] types = ParquetParser.correctTypeConversions(vec, requestedTypes);
        setup.setColumnTypes(types);
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == requestedTypes[i]) continue;
            setup.addErrs(new ParseWriter.ParseErr[]{new ParseWriter.UnsupportedTypeOverride(inputs[0].toString(), Vec.TYPE_STR[types[i]], Vec.TYPE_STR[requestedTypes[i]], setup.getColumnNames()[i])});
        }
        return setup;
    }

    public ParseSetup setupLocal(Vec v, ParseSetup setup) {
        ((ParquetParser.ParquetParseSetup)setup).parquetMetadata = VecParquetReader.readFooterAsBytes(v);
        return setup;
    }
}

