/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.api.FSIOException;
import water.fvec.FileVec;
import water.fvec.GcsFileVec;
import water.persist.GcsBlob;
import water.persist.GcsStorageProvider;
import water.persist.Persist;
import water.util.Log;

public final class PersistGcs
extends Persist {
    private GcsStorageProvider storageProvider = new GcsStorageProvider();
    private final LoadingCache<String, List<String>> keyCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(String key) {
            ArrayList<String> blobs = new ArrayList<String>();
            for (Blob b : PersistGcs.this.storageProvider.getStorage().get(key, new Storage.BucketGetOption[0]).list(new Storage.BlobListOption[0]).iterateAll()) {
                blobs.add(b.getName());
            }
            return blobs;
        }
    });
    private final LoadingCache<Object, List<String>> bucketCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Object, List<String>>(){

        public List<String> load(Object key) {
            ArrayList<String> fileNames = new ArrayList<String>();
            for (Bucket b : PersistGcs.this.storageProvider.getStorage().list(new Storage.BucketListOption[0]).iterateAll()) {
                fileNames.add(b.getName());
            }
            return fileNames;
        }
    });

    public byte[] load(Value v) throws IOException {
        BlobId blobId = GcsBlob.of(v._key).getBlobId();
        byte[] contentBytes = MemoryManager.malloc1((int)v._max);
        ByteBuffer wrappingBuffer = ByteBuffer.wrap(contentBytes);
        Key k = v._key;
        long offset = 0L;
        if (k._kb[0] == 5) {
            offset = FileVec.chunkOffset((Key)k);
        }
        ReadChannel reader = this.storageProvider.getStorage().reader(blobId, new Storage.BlobSourceOption[0]);
        reader.seek(offset);
        reader.read(wrappingBuffer);
        return contentBytes;
    }

    public Key uriToKey(URI uri) throws IOException {
        GcsBlob blob = GcsBlob.of(uri);
        Long contentSize = this.storageProvider.getStorage().get(blob.getBlobId()).getSize();
        return GcsFileVec.make((String)blob.getCanonical(), (long)contentSize);
    }

    public void store(Value v) throws IOException {
        if (!v._key.home()) {
            return;
        }
        byte[] payload = v.memOrLoad();
        GcsBlob blob = GcsBlob.of(v._key);
        Log.debug((Object[])new Object[]{"Storing: " + blob.toString()});
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        this.storageProvider.getStorage().create(blob.getBlobInfo(), new Storage.BlobTargetOption[0]).writer(new Storage.BlobWriteOption[0]).write(buffer);
    }

    public void delete(Value v) {
        BlobId blobId = GcsBlob.of(v._key).getBlobId();
        Log.debug((Object[])new Object[]{"Deleting: " + blobId.toString()});
        this.storageProvider.getStorage().get(blobId).delete(new Blob.BlobSourceOption[0]);
    }

    public void cleanUp() {
        throw H2O.unimpl();
    }

    public List<String> calcTypeaheadMatches(String filter, int limit) {
        ArrayList<String> results;
        block6: {
            String input = GcsBlob.removePrefix(filter);
            String[] bk = input.split("/", 2);
            results = limit > 0 ? new ArrayList<String>(limit) : new ArrayList();
            try {
                if (bk.length == 1) {
                    List buckets = (List)this.bucketCache.get((Object)"all");
                    for (String s : buckets) {
                        results.add("gs://" + s);
                        if (--limit != 0) continue;
                        break block6;
                    }
                    break block6;
                }
                if (bk.length != 2) break block6;
                List objects = (List)this.keyCache.get((Object)bk[0]);
                for (String s : objects) {
                    if (s.startsWith(bk[1])) {
                        results.add("gs://" + bk[0] + "/" + s);
                    }
                    if (--limit != 0) continue;
                    break;
                }
            }
            catch (ExecutionException e) {
                Log.err((Throwable)e);
            }
        }
        return results;
    }

    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        String[] bk = GcsBlob.removePrefix(path).split("/", 2);
        if (bk.length < 2) {
            this.parseBucket(bk[0], files, keys, fails);
        } else {
            try {
                Iterable values = this.storageProvider.getStorage().list(bk[0], new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)bk[1])}).getValues();
                values.forEach(blob -> {
                    String blobPath = "gs://" + blob.getBucket() + "/" + blob.getName();
                    Key k = GcsFileVec.make((String)blobPath, (long)blob.getSize());
                    keys.add(k.toString());
                    files.add(blobPath);
                });
            }
            catch (Throwable t) {
                Log.err((Throwable)t);
                fails.add(path);
            }
        }
    }

    private void parseBucket(String bucketId, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails) {
        Bucket bucket = this.storageProvider.getStorage().get(bucketId, new Storage.BucketGetOption[0]);
        for (Blob blob : bucket.list(new Storage.BlobListOption[0]).iterateAll()) {
            GcsBlob gcsBlob = GcsBlob.of(blob.getBlobId());
            Log.debug((Object[])new Object[]{"Importing: " + gcsBlob.toString()});
            try {
                Key k = GcsFileVec.make((String)gcsBlob.getCanonical(), (long)blob.getSize());
                keys.add(k.toString());
                files.add(gcsBlob.getCanonical());
            }
            catch (Throwable t) {
                Log.err((Throwable)t);
                fails.add(gcsBlob.getCanonical());
            }
        }
    }

    public InputStream open(final String path) {
        GcsBlob gcsBlob = GcsBlob.of(path);
        Log.debug((Object[])new Object[]{"Opening: " + gcsBlob.toString()});
        final Blob blob = this.storageProvider.getStorage().get(gcsBlob.getBlobId());
        return new InputStream(){
            final ReadChannel reader;
            {
                this.reader = blob.reader(new Blob.BlobSourceOption[0]);
            }

            @Override
            public int read() throws IOException {
                try {
                    ByteBuffer bytes = ByteBuffer.wrap(MemoryManager.malloc1((int)1));
                    int numRed = this.reader.read(bytes);
                    if (numRed == 0) {
                        return -1;
                    }
                    return bytes.get(0);
                }
                catch (IOException e) {
                    throw new FSIOException(path, (Throwable)e);
                }
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                Objects.requireNonNull(bytes);
                if (off < 0 || len < 0 || len > bytes.length - off) {
                    throw new IndexOutOfBoundsException("Length of byte array is " + bytes.length + ". Offset is " + off + " and length is " + len);
                }
                if (len == 0) {
                    return 0;
                }
                ByteBuffer buffer = ByteBuffer.wrap(bytes, off, len);
                return this.reader.read(buffer);
            }

            @Override
            public int available() throws IOException {
                return 1;
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }
        };
    }

    public OutputStream create(String path, boolean overwrite) {
        GcsBlob gcsBlob = GcsBlob.of(path);
        Log.debug((Object[])new Object[]{"Creating: " + gcsBlob.getCanonical()});
        final WriteChannel writer = this.storageProvider.getStorage().create(gcsBlob.getBlobInfo(), new Storage.BlobTargetOption[0]).writer(new Storage.BlobWriteOption[0]);
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(new byte[]{(byte)b});
                writer.write(buffer);
            }

            @Override
            public void write(byte[] b) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(b);
                writer.write(buffer);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
                writer.write(buffer);
            }

            @Override
            public void close() throws IOException {
                writer.close();
            }
        };
    }

    public boolean rename(String fromPath, String toPath) {
        BlobId fromBlob = GcsBlob.of(fromPath).getBlobId();
        BlobId toBlob = GcsBlob.of(toPath).getBlobId();
        this.storageProvider.getStorage().get(fromBlob).copyTo(toBlob, new Blob.BlobSourceOption[0]);
        this.keyCache.invalidate((Object)fromBlob.getBucket());
        this.keyCache.invalidate((Object)toBlob.getBucket());
        return this.storageProvider.getStorage().delete(fromBlob);
    }

    private String[] split(String path) {
        return GcsBlob.removePrefix(path).split("/", 2);
    }

    public boolean exists(String path) {
        String[] bk = this.split(path);
        if (bk.length == 1) {
            return this.storageProvider.getStorage().get(bk[0], new Storage.BucketGetOption[0]).exists(new Bucket.BucketSourceOption[0]);
        }
        if (bk.length == 2) {
            Blob blob = this.storageProvider.getStorage().get(bk[0], bk[1], new Storage.BlobGetOption[0]);
            return blob != null && blob.exists(new Blob.BlobSourceOption[0]);
        }
        return false;
    }

    public boolean isDirectory(String path) {
        String[] bk = this.split(path);
        return bk.length == 1;
    }

    public String getParent(String path) {
        String[] bk = this.split(path);
        if (bk.length > 0) {
            return bk[0];
        }
        return null;
    }

    public boolean delete(String path) {
        BlobId blob = GcsBlob.of(path).getBlobId();
        this.keyCache.invalidate((Object)blob.getBucket());
        return this.storageProvider.getStorage().get(blob).delete(new Blob.BlobSourceOption[0]);
    }

    public long length(String path) {
        BlobId blob = GcsBlob.of(path).getBlobId();
        return this.storageProvider.getStorage().get(blob).getSize();
    }

    public Persist.PersistEntry[] list(String path) {
        String[] bk = this.split(path);
        int substrLen = bk.length == 2 ? bk[1].length() : 0;
        ArrayList<Persist.PersistEntry> results = new ArrayList<Persist.PersistEntry>();
        try {
            for (Blob b : this.storageProvider.getStorage().list(bk[0], new Storage.BlobListOption[0]).iterateAll()) {
                if (bk.length != 1 && (bk.length != 2 || !b.getName().startsWith(bk[1]))) continue;
                String relativeName = b.getName().substring(substrLen);
                if (relativeName.startsWith("/")) {
                    relativeName = relativeName.substring(1);
                }
                results.add(new Persist.PersistEntry(relativeName, b.getSize().longValue(), b.getUpdateTime().longValue()));
            }
        }
        catch (StorageException e) {
            Log.err((Throwable)e);
        }
        return results.toArray(new Persist.PersistEntry[results.size()]);
    }

    public boolean mkdirs(String path) {
        try {
            String[] bk = this.split(path);
            if (bk.length > 0) {
                Bucket b = this.storageProvider.getStorage().get(bk[0], new Storage.BucketGetOption[0]);
                if (b == null || !b.exists(new Bucket.BucketSourceOption[0])) {
                    this.storageProvider.getStorage().create(BucketInfo.of((String)bk[0]), new Storage.BucketTargetOption[0]);
                }
                return true;
            }
            return false;
        }
        catch (StorageException e) {
            Log.err((Throwable)e);
            return false;
        }
    }
}

