/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import water.Futures;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.api.HDFSIOException;
import water.fvec.FileVec;
import water.fvec.HDFSFileVec;
import water.fvec.NFSFileVec;
import water.persist.Persist;
import water.util.FileUtils;
import water.util.Log;

public final class PersistHdfs
extends Persist {
    public static final Configuration CONF;
    private final Path _iceRoot;

    public PersistHdfs() {
        this._iceRoot = null;
    }

    public void cleanUp() {
        throw H2O.unimpl();
    }

    public PersistHdfs(URI uri) {
        try {
            this._iceRoot = new Path(uri + "/ice" + H2O.SELF_ADDRESS.getHostAddress() + "-" + H2O.API_PORT);
            FileSystem fs = FileSystem.get((URI)this._iceRoot.toUri(), (Configuration)CONF);
            fs.mkdirs(this._iceRoot);
        }
        catch (Exception e) {
            throw Log.throwErr((Throwable)e);
        }
    }

    public byte[] load(final Value v) {
        long start = System.currentTimeMillis();
        final byte[] b = MemoryManager.malloc1((int)v._max);
        Key k = v._key;
        long skip = k.isChunkKey() ? NFSFileVec.chunkOffset((Key)k) : 0L;
        final Path p = this._iceRoot == null ? new Path(FileVec.getPathForKey((Key)k)) : new Path(this._iceRoot, PersistHdfs.getIceName((Value)v));
        final long skip_ = skip;
        PersistHdfs.run(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)CONF);
                FSDataInputStream s = null;
                try {
                    s = fs.open(p);
                    if (p.toString().toLowerCase().startsWith("maprfs:")) {
                        s.seek(skip_);
                        s.readFully(b);
                    } else {
                        s.seek(skip_);
                        s.readFully(b);
                    }
                    assert (v.isPersisted());
                }
                catch (Throwable throwable) {
                    s.getWrappedStream().close();
                    FileUtils.close((Closeable[])new Closeable[]{s});
                    throw throwable;
                }
                s.getWrappedStream().close();
                FileUtils.close((Closeable[])new Closeable[]{s});
                return null;
            }
        }, true, v._max);
        long end = System.currentTimeMillis();
        if (end - start > 1000L) {
            Log.debug((Object[])new Object[]{"Slow Read: " + (end - start) + " millis to get bytes " + skip_ + "-" + (skip_ + (long)b.length) + " in HDFS read."});
        }
        return b;
    }

    public void store(Value v) {
        assert (this == H2O.getPM().getIce());
        assert (!v.isPersisted());
        byte[] m = v.memOrLoad();
        assert (m == null || m.length == v._max);
        PersistHdfs.store(new Path(this._iceRoot, PersistHdfs.getIceName((Value)v)), m);
    }

    public static void store(final Path path, final byte[] data) {
        PersistHdfs.run(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)CONF);
                fs.mkdirs(path.getParent());
                FSDataOutputStream s = fs.create(path);
                try {
                    s.write(data);
                }
                finally {
                    s.close();
                }
                return null;
            }
        }, false, data.length);
    }

    public void delete(final Value v) {
        assert (this == H2O.getPM().getIce());
        assert (!v.isPersisted());
        PersistHdfs.run(new Callable(){

            public Object call() throws Exception {
                Path p = new Path(PersistHdfs.this._iceRoot, Persist.getIceName((Value)v));
                FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)CONF);
                fs.delete(p, true);
                return null;
            }
        }, false, 0);
    }

    private static void run(Callable c, boolean read, int size) {
        long start_io_ms = System.currentTimeMillis();
        while (true) {
            try {
                long start_ns = System.nanoTime();
                c.call();
            }
            catch (EOFException e) {
                e.printStackTrace();
                System.out.println(e.getMessage());
                PersistHdfs.ignoreAndWait(e, true);
                continue;
            }
            catch (SocketTimeoutException e) {
                PersistHdfs.ignoreAndWait(e, false);
                continue;
            }
            catch (IOException e) {
                if (e.getClass().getName().contains("S3Exception")) {
                    PersistHdfs.ignoreAndWait(e, true);
                    continue;
                }
                PersistHdfs.ignoreAndWait(e, true);
                continue;
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().contains("S3Exception")) {
                    PersistHdfs.ignoreAndWait(e, false);
                    continue;
                }
                throw Log.throwErr((Throwable)e);
            }
            catch (Exception e) {
                throw Log.throwErr((Throwable)e);
            }
            break;
        }
    }

    private static void ignoreAndWait(Exception e, boolean printException) {
        Log.ignore((Throwable)e, (String)"Hit HDFS reset problem, retrying...", (boolean)printException);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void addFolder(Path p, ArrayList<String> keys, ArrayList<String> failed) throws IOException {
        FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)CONF);
        if (!fs.exists(p)) {
            failed.add("Path does not exist: '" + p.toString() + "'");
            return;
        }
        PersistHdfs.addFolder(fs, p, keys, failed);
    }

    private static void addFolder(FileSystem fs, Path p, ArrayList<String> keys, ArrayList<String> failed) {
        try {
            if (fs == null) {
                return;
            }
            Futures futures = new Futures();
            for (FileStatus file : fs.listStatus(p)) {
                Path pfs = file.getPath();
                if (file.isDir()) {
                    PersistHdfs.addFolder(fs, pfs, keys, failed);
                    continue;
                }
                if (file.getLen() <= 0L) continue;
                Key k = null;
                k = HDFSFileVec.make((String)file.getPath().toString(), (long)file.getLen(), (Futures)futures);
                keys.add(k.toString());
                Log.debug((Object[])new Object[]{"PersistHdfs: DKV.put(" + k + ")"});
            }
        }
        catch (Exception e) {
            Log.err((Throwable)e);
            failed.add(p.toString());
        }
    }

    public Key uriToKey(URI uri) throws IOException {
        assert ("hdfs".equals(uri.getScheme()) || "s3".equals(uri.getScheme()) || "s3n".equals(uri.getScheme()) || "s3a".equals(uri.getScheme())) : "Expected hdfs, s3 s3n, or s3a scheme, but uri is " + uri;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
        FileStatus[] fstatus = fs.listStatus(new Path(uri));
        assert (fstatus.length == 1) : "Expected uri to single file, but uri is " + uri;
        return HDFSFileVec.make((String)fstatus[0].getPath().toString(), (long)fstatus[0].getLen());
    }

    public static FileSystem getFS(String path) throws IOException {
        try {
            return PersistHdfs.getFS(new URI(path));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static FileSystem getFS(URI uri) throws IOException {
        return FileSystem.get((URI)uri, (Configuration)CONF);
    }

    private boolean isBareS3NBucketWithoutTrailingSlash(String s) {
        String s2 = s.toLowerCase();
        Matcher m = Pattern.compile("s3n://[^/]*").matcher(s2);
        return m.matches();
    }

    public ArrayList<String> calcTypeaheadMatches(String filter, int limit) {
        Configuration conf = CONF;
        if (this.isBareS3NBucketWithoutTrailingSlash(filter)) {
            filter = filter + "/";
        }
        ArrayList<String> array = new ArrayList<String>();
        String s = filter.toLowerCase();
        if ("hdfs:".equals(s)) {
            return array;
        }
        if ("maprfs:".equals(s)) {
            return array;
        }
        try {
            Path p;
            Path expand = p = new Path(filter);
            if (!filter.endsWith("/")) {
                expand = p.getParent();
            }
            FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)conf);
            for (FileStatus file : fs.listStatus(expand)) {
                Path fp = file.getPath();
                if (fp.toString().startsWith(p.toString())) {
                    array.add(fp.toString());
                }
                if (array.size() != limit) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Log.trace((Object[])new Object[]{e});
        }
        catch (Throwable t) {
            t.printStackTrace();
            Log.warn((Object[])new Object[]{t});
        }
        return array;
    }

    public void importFiles(String path, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        if (this.isBareS3NBucketWithoutTrailingSlash(path)) {
            path = path + "/";
        }
        Log.info((Object[])new Object[]{"ImportHDFS processing (" + path + ")"});
        try {
            PersistHdfs.addFolder(new Path(path), keys, fails);
            files.addAll(keys);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public String getHomeDirectory() {
        try {
            FileSystem fs = FileSystem.get((Configuration)CONF);
            return fs.getHomeDirectory().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Persist.PersistEntry[] list(String path) {
        try {
            Path p = new Path(path);
            URI uri = p.toUri();
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            FileStatus[] arr1 = fs.listStatus(p);
            Persist.PersistEntry[] arr2 = new Persist.PersistEntry[arr1.length];
            for (int i = 0; i < arr1.length; ++i) {
                arr2[i] = new Persist.PersistEntry(arr1[i].getPath().getName(), arr1[i].getLen(), arr1[i].getModificationTime());
            }
            return arr2;
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean exists(String path) {
        Path p = new Path(path);
        URI uri = p.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean isDirectory(String path) {
        Path p = new Path(path);
        URI uri = p.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            return fs.isDirectory(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public long length(String path) {
        Path p = new Path(path);
        URI uri = p.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            return fs.getFileStatus(p).getLen();
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public InputStream open(String path) {
        Path p = new Path(path);
        URI uri = p.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            return fs.open(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean mkdirs(String path) {
        Path p = new Path(path);
        URI uri = p.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            if (fs.exists(p)) {
                return false;
            }
            return fs.mkdirs(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean rename(String fromPath, String toPath) {
        Path f = new Path(fromPath);
        Path t = new Path(toPath);
        URI uri = f.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            return fs.rename(f, t);
        }
        catch (IOException e) {
            throw new HDFSIOException(toPath, CONF.toString(), (Exception)e);
        }
    }

    public OutputStream create(String path, boolean overwrite) {
        Path p = new Path(path);
        URI uri = p.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            return fs.create(p, overwrite);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean delete(String path) {
        Path p = new Path(path);
        URI uri = p.toUri();
        try {
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)CONF);
            return fs.delete(p, true);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    static {
        Configuration conf = null;
        if (H2O.ARGS.hdfs_config != null) {
            conf = new Configuration();
            File p = new File(H2O.ARGS.hdfs_config);
            if (!p.exists()) {
                H2O.die((String)("Unable to open hdfs configuration file " + p.getAbsolutePath()));
            }
            conf.addResource(new Path(p.getAbsolutePath()));
            Log.debug((Object[])new Object[]{"resource ", p.getAbsolutePath(), " added to the hadoop configuration"});
        } else {
            conf = new Configuration();
            Path confDir = null;
            if (System.getenv().containsKey("HADOOP_CONF_DIR")) {
                confDir = new Path(System.getenv("HADOOP_CONF_DIR"));
            } else if (System.getenv().containsKey("YARN_CONF_DIR")) {
                confDir = new Path(System.getenv("YARN_CONF_DIR"));
            } else if (System.getenv().containsKey("HADOOP_HOME")) {
                confDir = new Path(System.getenv("HADOOP_HOME"), "conf");
            }
            if (confDir != null) {
                Log.info((Object[])new Object[]{"Using HDFS configuration from " + confDir});
                conf.addResource(new Path(confDir, "core-site.xml"));
            } else {
                Log.debug((Object[])new Object[]{"Cannot find HADOOP_CONF_DIR or YARN_CONF_DIR - default HDFS properties are NOT loaded!"});
            }
        }
        CONF = conf;
    }

    private static class Size {
        int _value;

        private Size() {
        }
    }
}

