/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import water.Futures;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.api.HDFSIOException;
import water.fvec.FileVec;
import water.fvec.HDFSFileVec;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.persist.Persist;
import water.persist.S3ATokenRefresherFactory;
import water.persist.VecDataInputStream;
import water.util.FileUtils;
import water.util.Log;

public final class PersistHdfs
extends Persist {
    private static final String[] _customS3ASecurityProviders = new String[]{"hex://water.persist.H2OCredentialProviderFactory"};
    public static final Configuration CONF;
    private final Path _iceRoot = null;
    private static final List<S3ATokenRefresherFactory> _refreshers;
    private static final PathFilter HIDDEN_FILE_FILTER;

    static void configureFromProperties(Configuration conf, Properties props) {
        for (Object propertyKey : Collections.list(props.keys())) {
            String propertyValue = props.getProperty((String)propertyKey);
            conf.set((String)propertyKey, propertyValue);
        }
    }

    static void injectS3ASecurityCredentialProviders(Configuration conf) {
        Collection providers = conf.getStringCollection("fs.s3a.security.credential.provider.path");
        String[] merged = new String[providers.size() + _customS3ASecurityProviders.length];
        int i = 0;
        for (String provider : providers) {
            merged[i++] = provider;
        }
        for (String provider : _customS3ASecurityProviders) {
            merged[i++] = provider;
        }
        assert (i == merged.length);
        conf.setStrings("fs.s3a.security.credential.provider.path", merged);
    }

    public void cleanUp() {
        throw H2O.unimpl();
    }

    public byte[] load(Value v) {
        assert (v.isPersisted());
        Key k = v._key;
        long skip = k.isChunkKey() ? NFSFileVec.chunkOffset((Key)k) : 0L;
        return this.load(k, skip, v._max);
    }

    public byte[] load(Key k, long skip, int max) {
        Path p = this._iceRoot == null ? new Path(FileVec.getPathForKey((Key)k)) : new Path(this._iceRoot, PersistHdfs.getIceName((Key)k));
        return this.load(p, skip, max);
    }

    private byte[] load(Path p, long skip, int max) {
        long start = System.currentTimeMillis();
        byte[] b = MemoryManager.malloc1((int)max);
        PersistHdfs.run(() -> {
            FileSystem fs = FileSystem.get((URI)p.toUri(), (Configuration)CONF);
            FSDataInputStream s = null;
            try {
                s = fs.open(p);
                s.seek(skip);
                s.readFully(b);
                if (s == null) return null;
            }
            catch (Throwable throwable) {
                if (s == null) throw throwable;
                FileUtils.close((Closeable[])new Closeable[]{s.getWrappedStream()});
                FileUtils.closeSilently((Closeable[])new Closeable[]{s});
                throw throwable;
            }
            FileUtils.close((Closeable[])new Closeable[]{s.getWrappedStream()});
            FileUtils.closeSilently((Closeable[])new Closeable[]{s});
            return null;
        });
        long end = System.currentTimeMillis();
        if (end - start > 1000L) {
            Log.debug((Object[])new Object[]{"Slow Read: " + (end - start) + " millis to get bytes " + skip + "-" + (skip + (long)b.length) + " in HDFS read."});
        }
        return b;
    }

    public void store(Value v) {
        assert (this == H2O.getPM().getIce());
        assert (!v.isPersisted());
        byte[] m = v.memOrLoad();
        assert (m == null || m.length == v._max);
        PersistHdfs.store(new Path(this._iceRoot, PersistHdfs.getIceName((Value)v)), m);
    }

    private static void store(Path path, byte[] data) {
        PersistHdfs.run(() -> {
            FileSystem fs = PersistHdfs.getFileSystem(path, true);
            fs.mkdirs(path.getParent());
            try (FSDataOutputStream s = fs.create(path);){
                s.write(data);
            }
            return null;
        });
    }

    public void delete(Value v) {
        assert (this == H2O.getPM().getIce());
        assert (!v.isPersisted());
        PersistHdfs.run(() -> {
            Path p = new Path(this._iceRoot, PersistHdfs.getIceName((Value)v));
            FileSystem fs = PersistHdfs.getFileSystem(p, true);
            fs.delete(p, true);
            return null;
        });
    }

    private static void run(Callable<?> c) {
        while (true) {
            try {
                c.call();
            }
            catch (EOFException e) {
                PersistHdfs.ignoreAndWait(e, true);
                continue;
            }
            catch (SocketTimeoutException e) {
                PersistHdfs.ignoreAndWait(e, false);
                continue;
            }
            catch (IOException e) {
                PersistHdfs.ignoreAndWait(e, e.getClass().getName().contains("S3Exception"));
                continue;
            }
            catch (RuntimeException e) {
                if (e.getClass().getName().contains("S3Exception")) {
                    PersistHdfs.ignoreAndWait(e, false);
                    continue;
                }
                throw Log.throwErr((Throwable)e);
            }
            catch (Exception e) {
                throw Log.throwErr((Throwable)e);
            }
            break;
        }
    }

    private static void ignoreAndWait(Exception e, boolean printException) {
        Log.ignore((Throwable)e, (String)"Hit HDFS reset problem, retrying...", (boolean)printException);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void addFolder(Path p, ArrayList<String> keys, ArrayList<String> failed) throws IOException, RuntimeException {
        FileSystem fs = PersistHdfs.getFileSystem(p, false);
        if (!fs.exists(p)) {
            failed.add("Path does not exist: '" + p.toString() + "'");
            return;
        }
        PersistHdfs.addFolder(fs, p, keys, failed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFolder(FileSystem fs, Path p, ArrayList<String> keys, ArrayList<String> failed) {
        if (fs == null) {
            return;
        }
        Futures futures = new Futures();
        try {
            for (FileStatus file : fs.listStatus(p, HIDDEN_FILE_FILTER)) {
                Path pfs = file.getPath();
                if (file.isDirectory()) {
                    PersistHdfs.addFolder(fs, pfs, keys, failed);
                    continue;
                }
                if (file.getLen() <= 0L) continue;
                Key k = HDFSFileVec.make((String)pfs.toString(), (long)file.getLen(), (Futures)futures);
                keys.add(k.toString());
                Log.debug((Object[])new Object[]{"PersistHdfs: DKV.put(" + k + ")"});
            }
        }
        catch (Exception e) {
            Log.err((Object[])new Object[]{e});
            failed.add(p.toString());
        }
        finally {
            futures.blockForPending();
        }
    }

    public Key uriToKey(URI uri) throws IOException {
        assert ("hdfs".equals(uri.getScheme()) || "s3".equals(uri.getScheme()) || "s3n".equals(uri.getScheme()) || "s3a".equals(uri.getScheme())) : "Expected hdfs, s3 s3n, or s3a scheme, but uri is " + uri;
        Path path = new Path(uri);
        FileSystem fs = PersistHdfs.getFileSystem(path, false);
        FileStatus[] fstatus = fs.listStatus(path);
        assert (fstatus.length == 1) : "Expected uri to single file, but uri is " + uri;
        return HDFSFileVec.make((String)fstatus[0].getPath().toString(), (long)fstatus[0].getLen());
    }

    private boolean isBareS3NBucketWithoutTrailingSlash(String s) {
        String s2 = s.toLowerCase();
        Matcher m = Pattern.compile("s3n://[^/]*").matcher(s2);
        return m.matches();
    }

    public ArrayList<String> calcTypeaheadMatches(String filter, int limit) {
        if (this.isBareS3NBucketWithoutTrailingSlash(filter)) {
            filter = filter + "/";
        }
        ArrayList<String> array = new ArrayList<String>();
        String s = filter.toLowerCase();
        if ("hdfs:".equals(s)) {
            return array;
        }
        if ("maprfs:".equals(s)) {
            return array;
        }
        try {
            Path p;
            Path expand = p = new Path(filter);
            if (!filter.endsWith("/")) {
                expand = p.getParent();
            }
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            for (FileStatus file : fs.listStatus(expand)) {
                Path fp = file.getPath();
                if (fp.toString().startsWith(p.toString())) {
                    array.add(fp.toString());
                }
                if (array.size() != limit) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Log.trace((Object[])new Object[]{e});
        }
        catch (Throwable t) {
            Log.warn((Object[])new Object[]{t});
        }
        return array;
    }

    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        if (this.isBareS3NBucketWithoutTrailingSlash(path)) {
            path = path + "/";
        }
        Log.info((Object[])new Object[]{"ImportHDFS processing (" + path + ")"});
        try {
            PersistHdfs.addFolder(new Path(path), keys, fails);
            files.addAll(keys);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public String getHomeDirectory() {
        try {
            FileSystem fs = FileSystem.get((Configuration)CONF);
            return fs.getHomeDirectory().toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Persist.PersistEntry[] list(String path) {
        try {
            Path p = new Path(path);
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            FileStatus[] arr1 = fs.listStatus(p);
            Persist.PersistEntry[] arr2 = new Persist.PersistEntry[arr1.length];
            for (int i = 0; i < arr1.length; ++i) {
                arr2[i] = new Persist.PersistEntry(arr1[i].getPath().getName(), arr1[i].getLen(), arr1[i].getModificationTime());
            }
            return arr2;
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean exists(String path) {
        Path p = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public String getParent(String path) {
        Path p = new Path(path);
        return p.getParent().toUri().toString();
    }

    public boolean isDirectory(String path) {
        Path p = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            return fs.isDirectory(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public long length(String path) {
        Path p = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            return fs.getFileStatus(p).getLen();
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public InputStream open(String path) {
        return this.openSeekable(path);
    }

    public InputStream openSeekable(String path) {
        Path p = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            return fs.open(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public InputStream wrapSeekable(Vec vec) {
        return new FSDataInputStream((InputStream)new VecDataInputStream(vec, true));
    }

    public boolean isSeekableOpenSupported() {
        return true;
    }

    public boolean mkdirs(String path) {
        Path p = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            if (fs.exists(p)) {
                return false;
            }
            return fs.mkdirs(p);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean rename(String fromPath, String toPath) {
        Path f = new Path(fromPath);
        Path t = new Path(toPath);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(f, false);
            return fs.rename(f, t);
        }
        catch (IOException e) {
            throw new HDFSIOException(toPath, CONF.toString(), (Exception)e);
        }
    }

    public OutputStream create(String path, boolean overwrite) {
        Path p = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            return fs.create(p, overwrite);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean delete(String path) {
        Path p = new Path(path);
        try {
            FileSystem fs = PersistHdfs.getFileSystem(p, false);
            return fs.delete(p, true);
        }
        catch (IOException e) {
            throw new HDFSIOException(path, CONF.toString(), (Exception)e);
        }
    }

    public boolean canHandle(String path) {
        URI uri = new Path(path).toUri();
        try {
            return uri.getScheme() != null && FileSystem.getFileSystemClass((String)uri.getScheme(), (Configuration)CONF) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static FileSystem getFileSystem(Path path, boolean assumeTokensAcquired) throws IOException {
        block1: {
            S3ATokenRefresherFactory refresherFactory;
            boolean handled;
            if (assumeTokensAcquired || _refreshers.size() <= 0) break block1;
            Iterator<S3ATokenRefresherFactory> iterator = _refreshers.iterator();
            while (iterator.hasNext() && !(handled = (refresherFactory = iterator.next()).startDelegationTokenRefresher(path))) {
            }
        }
        return FileSystem.get((URI)path.toUri(), (Configuration)CONF);
    }

    public static void registerRefresherFactory(S3ATokenRefresherFactory refresherFactory) {
        _refreshers.add(refresherFactory);
    }

    static {
        _refreshers = new LinkedList<S3ATokenRefresherFactory>();
        HIDDEN_FILE_FILTER = p -> !p.getName().startsWith(".");
        Configuration conf = new Configuration();
        if (H2O.ARGS.hdfs_config != null && H2O.ARGS.hdfs_config.length > 0) {
            for (String config : H2O.ARGS.hdfs_config) {
                File p2 = new File(config);
                if (!p2.exists()) {
                    H2O.die((String)("Unable to open hdfs configuration file " + p2.getAbsolutePath()));
                }
                conf.addResource(new Path(p2.getAbsolutePath()));
                Log.debug((Object[])new Object[]{"resource ", p2.getAbsolutePath(), " added to the hadoop configuration"});
            }
        } else {
            Path confDir = null;
            if (System.getenv().containsKey("HADOOP_CONF_DIR")) {
                confDir = new Path(System.getenv("HADOOP_CONF_DIR"));
            } else if (System.getenv().containsKey("YARN_CONF_DIR")) {
                confDir = new Path(System.getenv("YARN_CONF_DIR"));
            } else if (System.getenv().containsKey("HADOOP_HOME")) {
                confDir = new Path(System.getenv("HADOOP_HOME"), "conf");
            }
            if (confDir != null) {
                Log.info((Object[])new Object[]{"Using HDFS configuration from " + confDir});
                conf.addResource(new Path(confDir, "core-site.xml"));
            } else {
                Log.debug((Object[])new Object[]{"Cannot find HADOOP_CONF_DIR or YARN_CONF_DIR - default HDFS properties are NOT loaded!"});
            }
        }
        PersistHdfs.injectS3ASecurityCredentialProviders(conf);
        PersistHdfs.configureFromProperties(conf, H2O.ARGS.hadoop_properties);
        CONF = conf;
    }
}

