/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.fvec.FileVec;
import water.fvec.HTTPFileVec;
import water.persist.PersistEagerHTTP;
import water.util.ByteStreams;
import water.util.HttpResponseStatus;
import water.util.Log;

public class PersistHTTP
extends PersistEagerHTTP {
    private static final Logger LOG = Logger.getLogger(PersistHTTP.class);
    private static final String ENABLE_LAZY_LOAD_KEY = "sys.ai.h2o.persist.http.enableLazyLoad";
    private static final Set<String> COMPRESSED_CONTENT_TYPES = new HashSet<String>(Arrays.asList("application/zip", "application/gzip"));

    public final byte[] load(Value v) throws IOException {
        byte[] b = MemoryManager.malloc1((int)v._max);
        Key k = v._key;
        long offset = k._kb[0] == 5 ? FileVec.chunkOffset((Key)k) : 0L;
        URI source = PersistHTTP.decodeKey(k);
        HttpRequestBase req = this.createReq(source, false);
        String rangeHeader = "bytes=" + offset + "-" + (offset + (long)v._max - 1L);
        req.setHeader("Range", rangeHeader);
        LOG.debug((Object)("Loading " + rangeHeader + " from " + source));
        try (CloseableHttpClient client = HttpClientBuilder.create().build();
             CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
            if (response.getStatusLine().getStatusCode() != HttpResponseStatus.PARTIAL_CONTENT.getCode()) {
                throw new IllegalStateException("Expected to retrieve a partial content response (status: " + response.getStatusLine() + ").");
            }
            if (PersistHTTP.readContentLength((HttpResponse)response) != (long)v._max) {
                throw new IllegalStateException("Received incorrect amount of data (expected: " + v._max + "B, received: " + response.getEntity().getContentLength() + "B).");
            }
            try (InputStream s = response.getEntity().getContent();){
                ByteStreams.readFully((InputStream)s, (byte[])b);
            }
        }
        return b;
    }

    static long readContentLength(HttpResponse response) {
        long len = response.getEntity().getContentLength();
        if (len >= 0L) {
            return len;
        }
        Header contentRange = response.getFirstHeader("Content-Range");
        try {
            return PersistHTTP.parseContentRangeLength(contentRange);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to determine response length: " + contentRange, e);
        }
    }

    private static long parseContentRangeLength(Header contentRange) {
        if (contentRange == null || contentRange.getValue() == null) {
            throw new IllegalStateException("Range not available");
        }
        if (!contentRange.getValue().startsWith("bytes")) {
            throw new IllegalStateException("Only 'bytes' range is supported: " + contentRange);
        }
        String value = contentRange.getValue().substring("bytes".length()).trim();
        String[] crParts = value.split("/");
        if (crParts.length != 2) {
            throw new IllegalStateException("Invalid HTTP response. Cannot parse header Content-Range: " + contentRange.getValue());
        }
        String[] range = crParts[0].split("-");
        if (range.length != 2) {
            throw new IllegalStateException("Invalid HTTP response. Cannot interpret range value in response header Content-Range: " + contentRange.getValue());
        }
        return 1L + Long.parseLong(range[1]) - Long.parseLong(range[0]);
    }

    private static URI decodeKey(Key k) {
        return URI.create(new String(k._kb[0] == 5 ? Arrays.copyOfRange(k._kb, 10, k._kb.length) : k._kb));
    }

    /*
     * Exception decompiling
     */
    long useLazyLoad(URI uri) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean isCompressed(HttpResponse response) {
        Header contentTypeHeader = response.getFirstHeader("Content-Type");
        if (contentTypeHeader == null) {
            return false;
        }
        String contentType = contentTypeHeader.getValue();
        if (contentType == null) {
            return false;
        }
        return COMPRESSED_CONTENT_TYPES.contains(contentType.toLowerCase());
    }

    long checkRangeSupport(URI uri, HttpResponse response) {
        boolean acceptByteRange;
        Header acceptRangesHeader = response.getFirstHeader("Accept-Ranges");
        Header contentLengthHeader = response.getFirstHeader("Content-Length");
        boolean bl = acceptByteRange = acceptRangesHeader != null && "bytes".equalsIgnoreCase(acceptRangesHeader.getValue());
        if (!acceptByteRange || contentLengthHeader == null) {
            LOG.debug((Object)(uri + " does not support range header"));
            return -1L;
        }
        LOG.debug((Object)("Range support confirmed for " + uri + " with length " + contentLengthHeader.getValue()));
        return Long.parseLong(contentLengthHeader.getValue());
    }

    private HttpRequestBase createReq(URI uri, boolean isHead) {
        HttpHead req = isHead ? new HttpHead(uri) : new HttpGet(uri);
        req.setHeader("Accept-Encoding", "identity");
        return req;
    }

    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        boolean lazyLoadEnabled = Boolean.parseBoolean(System.getProperty(ENABLE_LAZY_LOAD_KEY, "true"));
        if (lazyLoadEnabled) {
            try {
                URI source = URI.create(path);
                long length = this.useLazyLoad(source);
                if (length >= 0L) {
                    Key destination_key = HTTPFileVec.make((String)path, (long)length);
                    files.add(path);
                    keys.add(destination_key.toString());
                    return;
                }
            }
            catch (Exception e) {
                Log.debug((Object[])new Object[]{"Failed to detect range support for " + path, e});
            }
        } else {
            Log.debug((Object[])new Object[]{"HTTP lazy load disabled by user."});
        }
        super.importFiles(path, pattern, files, keys, fails, dels);
    }
}

