/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import water.DKV;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.Value;
import water.fvec.FileVec;
import water.fvec.S3FileVec;
import water.persist.Persist;
import water.util.Log;
import water.util.RIStream;

public final class PersistS3
extends Persist {
    private static final String HELP = "You can specify a credentials properties file with the -aws_credentials command line switch.";
    private static final String KEY_PREFIX = "s3://";
    private static final int KEY_PREFIX_LEN = "s3://".length();
    private static final Object _lock = new Object();
    private static volatile AmazonS3 _s3;
    public static final String S3_SOCKET_TIMEOUT_PROP = "water.s3.socketTimeout";
    public static final String S3_CONNECTION_TIMEOUT_PROP = "water.s3.connectionTimeout";
    public static final String S3_MAX_ERROR_RETRY_PROP = "water.s3.maxErrorRetry";
    public static final String S3_MAX_HTTP_CONNECTIONS_PROP = "water.s3.maxHttpConnections";
    Cache _bucketCache = new Cache();
    HashMap<String, KeyCache> _keyCaches = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmazonS3 getClient() {
        if (_s3 == null) {
            Object object = _lock;
            synchronized (object) {
                if (_s3 == null) {
                    try {
                        H2OAWSCredentialsProviderChain c = new H2OAWSCredentialsProviderChain();
                        ClientConfiguration cc = PersistS3.s3ClientCfg();
                        _s3 = new AmazonS3Client((AWSCredentialsProvider)c, cc);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        StringBuilder msg = new StringBuilder();
                        msg.append(e.getMessage() + "\n");
                        msg.append("Unable to load S3 credentials.");
                        throw new RuntimeException(msg.toString());
                    }
                }
            }
        }
        return _s3;
    }

    public static InputStream openStream(Key k, RIStream.ProgressMonitor pmon) throws IOException {
        return new H2SO3InputStream(k, pmon);
    }

    public static Key loadKey(S3ObjectSummary obj) throws IOException {
        return S3FileVec.make((String)PersistS3.encodePath(obj.getBucketName(), obj.getKey()), (long)obj.getSize());
    }

    private static void processListing(ObjectListing listing, ArrayList<String> succ, ArrayList<String> fail, boolean doImport) {
        for (S3ObjectSummary obj : listing.getObjectSummaries()) {
            try {
                if (doImport) {
                    Key k = PersistS3.loadKey(obj);
                    succ.add(k.toString());
                    continue;
                }
                succ.add(obj.getKey());
            }
            catch (IOException e) {
                fail.add(obj.getKey());
            }
        }
    }

    public void importFiles(String path, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        Log.info((Object[])new Object[]{"ImportS3 processing (" + path + ")"});
        AmazonS3 s3 = PersistS3.getClient();
        String[] parts = PersistS3.decodePath(path);
        ObjectListing currentList = s3.listObjects(parts[0], parts[1]);
        PersistS3.processListing(currentList, files, fails, true);
        while (currentList.isTruncated()) {
            currentList = s3.listNextBatchOfObjects(currentList);
            PersistS3.processListing(currentList, files, fails, true);
        }
        keys.addAll(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] load(Value v) {
        long start_io_ms = System.currentTimeMillis();
        byte[] b = MemoryManager.malloc1((int)v._max);
        Key k = v._key;
        long skip = 0L;
        if (k._kb[0] == 5) {
            skip = FileVec.chunkOffset((Key)k);
        }
        S3ObjectInputStream s = null;
        while (true) {
            try {
                long start_ns = System.nanoTime();
                s = PersistS3.getObjectForKey(k, skip, v._max).getObjectContent();
                ByteStreams.readFully((InputStream)s, (byte[])b);
                assert (v.isPersisted());
                byte[] byArray = b;
                return byArray;
            }
            catch (EOFException e) {
                PersistS3.ignoreAndWait(e, false);
                continue;
            }
            catch (SocketTimeoutException e) {
                PersistS3.ignoreAndWait(e, false);
                continue;
            }
            catch (IOException e) {
                PersistS3.ignoreAndWait(e, true);
                continue;
            }
            finally {
                try {
                    if (s == null) continue;
                    s.close();
                }
                catch (IOException e) {}
                continue;
            }
            break;
        }
    }

    private static void ignoreAndWait(Exception e, boolean printException) {
        Log.ignore((Throwable)e, (String)"Hit the S3 reset problem, waiting and retrying...", (boolean)printException);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void store(Value v) {
        if (!v._key.home()) {
            return;
        }
        throw H2O.unimpl();
    }

    public static Key encodeKey(String bucket, String key) {
        Key res = PersistS3.encodeKeyImpl(bucket, key);
        return res;
    }

    public static String[] decodeKey(Key k) {
        return PersistS3.decodeKeyImpl(k);
    }

    private static String encodePath(String bucket, String key) {
        return KEY_PREFIX + bucket + '/' + key;
    }

    private static Key encodeKeyImpl(String bucket, String key) {
        return Key.make((String)(KEY_PREFIX + bucket + '/' + key));
    }

    private static String[] decodePath(String s) {
        assert (s.startsWith(KEY_PREFIX) && s.indexOf(47) >= 0) : "Attempting to decode non s3 key: " + s;
        int dlm = (s = s.substring(KEY_PREFIX_LEN)).indexOf(47);
        if (dlm < 0) {
            return new String[]{s, null};
        }
        String bucket = s.substring(0, dlm);
        String key = s.substring(dlm + 1);
        return new String[]{bucket, key};
    }

    private static String[] decodeKeyImpl(Key k) {
        String s = new String(k._kb[0] == 5 ? Arrays.copyOfRange(k._kb, 10, k._kb.length) : k._kb);
        return PersistS3.decodePath(s);
    }

    private static S3Object getObjectForKey(Key k, long offset, long length) throws IOException {
        String[] bk = PersistS3.decodeKey(k);
        GetObjectRequest r = new GetObjectRequest(bk[0], bk[1]);
        r.setRange(offset, offset + length - 1L);
        return PersistS3.getClient().getObject(r);
    }

    private static ObjectMetadata getObjectMetadataForKey(Key k) {
        String[] bk = PersistS3.decodeKey(k);
        assert (bk.length == 2);
        return PersistS3.getClient().getObjectMetadata(bk[0], bk[1]);
    }

    static ClientConfiguration s3ClientCfg() {
        ClientConfiguration cfg = new ClientConfiguration();
        Properties prop = System.getProperties();
        if (prop.containsKey(S3_SOCKET_TIMEOUT_PROP)) {
            cfg.setSocketTimeout(Integer.getInteger(S3_SOCKET_TIMEOUT_PROP).intValue());
        }
        if (prop.containsKey(S3_CONNECTION_TIMEOUT_PROP)) {
            cfg.setConnectionTimeout(Integer.getInteger(S3_CONNECTION_TIMEOUT_PROP).intValue());
        }
        if (prop.containsKey(S3_MAX_ERROR_RETRY_PROP)) {
            cfg.setMaxErrorRetry(Integer.getInteger(S3_MAX_ERROR_RETRY_PROP).intValue());
        }
        if (prop.containsKey(S3_MAX_HTTP_CONNECTIONS_PROP)) {
            cfg.setMaxConnections(Integer.getInteger(S3_MAX_HTTP_CONNECTIONS_PROP).intValue());
        }
        cfg.setProtocol(Protocol.HTTP);
        return cfg;
    }

    public void delete(Value v) {
        throw new UnsupportedOperationException();
    }

    public Key uriToKey(URI uri) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<String> fails = new ArrayList<String>();
        ArrayList<String> dels = new ArrayList<String>();
        this.importFiles(uri.toString(), files, keys, fails, dels);
        if (!fails.isEmpty()) {
            throw new RuntimeException("Failed to import " + Arrays.toString(fails.toArray(new String[0])));
        }
        if (keys.size() != 1) {
            throw new RuntimeException("Expected exactly one file, got " + Arrays.toString(keys.toArray(new String[0])));
        }
        Key k = Key.make((String)keys.get(0));
        Keyed x = (Keyed)DKV.getGet((Key)k);
        assert (x._key.toString().equals(keys.get(0)));
        return k;
    }

    public void cleanUp() {
        throw H2O.unimpl();
    }

    public List<String> calcTypeaheadMatches(String filter, int limit) {
        String[] parts = PersistS3.decodePath(filter);
        if (parts[1] != null) {
            if (this._keyCaches.get(parts[0]) == null) {
                if (!PersistS3.getClient().doesBucketExist(parts[0])) {
                    return new ArrayList<String>();
                }
                this._keyCaches.put(parts[0], new KeyCache(parts[0]));
            }
            return this._keyCaches.get(parts[0]).fetch(parts[1], limit);
        }
        return this._bucketCache.fetch(parts[0], limit);
    }

    private static class KeyCache
    extends Cache {
        private final String _keyPrefix;
        private final String _bucket;

        public KeyCache(String bucket) {
            this._bucket = bucket;
            this._keyPrefix = super.wrapKey(bucket) + "/";
        }

        @Override
        protected String[] update() {
            AmazonS3 s3 = PersistS3.getClient();
            ObjectListing currentList = s3.listObjects(this._bucket, "");
            ArrayList res = new ArrayList();
            PersistS3.processListing(currentList, res, null, false);
            while (currentList.isTruncated()) {
                currentList = s3.listNextBatchOfObjects(currentList);
                PersistS3.processListing(currentList, res, null, false);
            }
            Collections.sort(res);
            this._cache = res.toArray(new String[res.size()]);
            return this._cache;
        }

        @Override
        protected String wrapKey(String s) {
            String x = this._keyPrefix + s;
            return this._keyPrefix + s;
        }
    }

    private static class Cache {
        long _lastUpdated = 0L;
        long _timeoutMillis = 300000L;
        String[] _cache = new String[0];

        private Cache() {
        }

        public boolean containsKey(String k) {
            return Arrays.binarySearch(this._cache, k) >= 0;
        }

        protected String[] update() {
            List l = PersistS3.getClient().listBuckets();
            Object[] cache = new String[l.size()];
            int i = 0;
            for (Bucket b : l) {
                cache[i++] = b.getName();
            }
            Arrays.sort(cache);
            this._cache = cache;
            return cache;
        }

        protected String wrapKey(String s) {
            return PersistS3.KEY_PREFIX + s;
        }

        public ArrayList<String> fetch(String filter, int limit) {
            Object[] cache = this._cache;
            if (System.currentTimeMillis() > this._lastUpdated + this._timeoutMillis) {
                cache = this.update();
                this._lastUpdated = System.currentTimeMillis();
            }
            ArrayList<String> res = new ArrayList<String>();
            int i = Arrays.binarySearch(cache, filter);
            if (i < 0) {
                i = -i - 1;
            }
            while (i < cache.length && ((String)cache[i]).startsWith(filter) && (limit < 0 || res.size() < limit)) {
                res.add(this.wrapKey((String)cache[i++]));
            }
            return res;
        }
    }

    public static final class H2SO3InputStream
    extends RIStream {
        Key _k;
        long _to;
        String[] _bk;

        protected InputStream open(long offset) {
            return PersistS3.getClient().getObject(new GetObjectRequest(this._bk[0], this._bk[1]).withRange(offset, this._to)).getObjectContent();
        }

        public H2SO3InputStream(Key k, RIStream.ProgressMonitor pmon) {
            this(k, pmon, 0L, Long.MAX_VALUE);
        }

        public H2SO3InputStream(Key k, RIStream.ProgressMonitor pmon, long from, long to) {
            super(from, pmon);
            this._k = k;
            this._to = Math.min((long)(DKV.get((Key)k)._max - 1), to);
            this._bk = PersistS3.decodeKey(k);
            this.open();
        }
    }

    static class H2OArgCredentialsProvider
    implements AWSCredentialsProvider {
        public static final String DEFAULT_CREDENTIALS_LOCATION = "AwsCredentials.properties";

        H2OArgCredentialsProvider() {
        }

        public AWSCredentials getCredentials() {
            File credentials = new File(DEFAULT_CREDENTIALS_LOCATION);
            try {
                return new PropertiesCredentials(credentials);
            }
            catch (IOException e) {
                throw new AmazonClientException("Unable to load AWS credentials from file " + credentials);
            }
        }

        public void refresh() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class H2OAWSCredentialsProviderChain
    extends AWSCredentialsProviderChain {
        public H2OAWSCredentialsProviderChain() {
            super(new AWSCredentialsProvider[]{new H2OArgCredentialsProvider(), new InstanceProfileCredentialsProvider(), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new ProfileCredentialsProvider()});
        }
    }
}

