/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.util.Objects;
import water.DKV;
import water.Iced;
import water.Key;
import water.api.Handler;
import water.persist.IcedS3Credentials;
import water.persist.PersistS3CredentialsV3;

public class PersistS3Handler
extends Handler {
    public PersistS3CredentialsV3 setS3Credentials(int version, PersistS3CredentialsV3 s3Credentials) {
        this.validateS3Credentials(s3Credentials);
        IcedS3Credentials icedS3Credentials = new IcedS3Credentials(s3Credentials.secret_key_id, s3Credentials.secret_access_key, s3Credentials.session_token);
        DKV.put((Key)Key.make((String)"S3_CREDENTIALS_KEY"), (Iced)icedS3Credentials);
        return s3Credentials;
    }

    private void validateS3Credentials(PersistS3CredentialsV3 s3Credentials) {
        Objects.requireNonNull(s3Credentials);
        if (s3Credentials.secret_key_id == null) {
            throw new IllegalArgumentException("The field 'S3_SECRET_KEY_ID' may not be null.");
        }
        if (s3Credentials.secret_access_key == null) {
            throw new IllegalArgumentException("The field 'S3_SECRET_ACCESS_KEY' may not be null.");
        }
        s3Credentials.secret_key_id = s3Credentials.secret_key_id.trim();
        s3Credentials.secret_access_key = s3Credentials.secret_access_key.trim();
        if (s3Credentials.session_token != null) {
            s3Credentials.session_token = s3Credentials.session_token.trim();
        }
        if (s3Credentials.secret_key_id.isEmpty()) {
            throw new IllegalArgumentException("The field 'S3_SECRET_KEY_ID' may not be empty.");
        }
        if (s3Credentials.secret_access_key.isEmpty()) {
            throw new IllegalArgumentException("The field 'S3_SECRET_ACCESS_KEY' may not be empty.");
        }
        if (s3Credentials.session_token != null && s3Credentials.session_token.isEmpty()) {
            throw new IllegalArgumentException("The field 'S3_SESSION_TOKEN' may not be empty");
        }
    }
}

