/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import water.H2O;
import water.persist.Persist;
import water.persist.PersistS3;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.ast.prims.misc.AstSetProperty;
import water.rapids.vals.ValStr;

public class AstS3GeneratePresignedURL
extends AstBuiltin<AstSetProperty> {
    public String[] args() {
        return new String[]{"path", "duration_millis"};
    }

    public int nargs() {
        return 3;
    }

    public String str() {
        return "s3.generate.presigned.URL";
    }

    protected ValStr exec(Val[] args) {
        String path = args[1].getStr();
        long durationMillis = (long)args[2].getNum();
        Persist persist = H2O.getPM().getPersistForURI(URI.create(path));
        if (!(persist instanceof PersistS3)) {
            throw new IllegalArgumentException("Path '" + path + "' cannot be handled by PersistS3.");
        }
        Date expiration = new Date(Instant.now().toEpochMilli() + durationMillis);
        URL presignedURL = ((PersistS3)persist).generatePresignedUrl(path, expiration);
        return new ValStr(presignedURL.toString());
    }
}

