/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import water.persist.PersistS3;
import water.util.Log;

public class H2OCredentialProviderFactory
extends CredentialProviderFactory {
    public CredentialProvider createProvider(URI uri, Configuration configuration) {
        if ("hex".equals(uri.getScheme()) && ((Object)((Object)this)).getClass().getName().equals(uri.getHost())) {
            return new H2OCredentialProvider((AWSCredentialsProvider)new PersistS3.H2OAWSCredentialsProviderChain());
        }
        return null;
    }

    static class H2OCredentialEntry
    extends CredentialProvider.CredentialEntry {
        protected H2OCredentialEntry(String alias, char[] credential) {
            super(alias, credential);
        }
    }

    static class H2OCredentialProvider
    extends CredentialProvider {
        private final AWSCredentialsProvider _awsCredentialsProvider;

        public H2OCredentialProvider(AWSCredentialsProvider awsCredentialsProvider) {
            this._awsCredentialsProvider = awsCredentialsProvider;
        }

        public void flush() {
        }

        public CredentialProvider.CredentialEntry getCredentialEntry(String s) {
            try {
                if ("fs.s3a.access.key".equals(s)) {
                    AWSCredentials credentials = this._awsCredentialsProvider.getCredentials();
                    return new H2OCredentialEntry("fs.s3a.access.key", credentials.getAWSAccessKeyId().toCharArray());
                }
                if ("fs.s3a.secret.key".equals(s)) {
                    AWSCredentials credentials = this._awsCredentialsProvider.getCredentials();
                    return new H2OCredentialEntry("fs.s3a.secret.key", credentials.getAWSSecretKey().toCharArray());
                }
            }
            catch (Exception e) {
                Log.warn((Object[])new Object[]{"Failed to retrieve '" + s + "' using the H2O built-in credentials chain."});
            }
            return null;
        }

        public List<String> getAliases() {
            return Collections.emptyList();
        }

        public CredentialProvider.CredentialEntry createCredentialEntry(String s, char[] chars) {
            throw new UnsupportedOperationException("AWS Credentials are read-only: unable to create new entry");
        }

        public void deleteCredentialEntry(String s) {
            throw new UnsupportedOperationException("AWS Credentials are read-only: unable to delete an entry");
        }
    }
}

