/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import hex.CreateFrame;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import water.DKV;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.Log;

@Ignore(value="Support for tests, but no actual tests here")
public class FrameTestUtil {
    public static Frame createFrame(String fname, long[] chunkLayout, String[][] data) {
        Frame f = new Frame(Key.make((String)fname));
        f.preparePartialFrame(new String[]{"C0"});
        f.update();
        byte[] types = new byte[]{2};
        for (int i = 0; i < chunkLayout.length; ++i) {
            FrameTestUtil.createNC(fname, data[i], i, (int)chunkLayout[i], types);
        }
        f = (Frame)DKV.get((String)fname).get();
        f.finalizePartialFrame(chunkLayout, (String[][])new String[][]{null}, types);
        return f;
    }

    public static NewChunk createNC(String fname, String[] data, int cidx, int len, byte[] types) {
        NewChunk[] nchunks = Frame.createNewChunks((String)fname, (byte[])types, (int)cidx);
        for (int i = 0; i < len; ++i) {
            nchunks[0].addStr(data[i] != null ? data[i] : null);
        }
        Frame.closeNewChunks((NewChunk[])nchunks);
        return nchunks[0];
    }

    public static Frame createFrame(String fname, long[] chunkLayout) {
        Frame f = new Frame(Key.make((String)fname));
        f.preparePartialFrame(new String[]{"C0"});
        f.update();
        byte[] types = new byte[]{3};
        for (int i = 0; i < chunkLayout.length; ++i) {
            FrameTestUtil.createNC(fname, i, (int)chunkLayout[i], types);
        }
        f = (Frame)DKV.get((String)fname).get();
        f.finalizePartialFrame(chunkLayout, (String[][])new String[][]{null}, types);
        return f;
    }

    public static NewChunk createNC(String fname, int cidx, int len, byte[] types) {
        NewChunk[] nchunks = Frame.createNewChunks((String)fname, (byte[])types, (int)cidx);
        int starVal = cidx * 1000;
        for (int i = 0; i < len; ++i) {
            nchunks[0].addNum((double)(starVal + i));
        }
        Frame.closeNewChunks((NewChunk[])nchunks);
        return nchunks[0];
    }

    public static void assertValues(Frame f, String[] expValues) {
        FrameTestUtil.assertValues(f.vec(0), expValues);
    }

    public static void assertValues(Vec v, String[] expValues) {
        Assert.assertEquals((String)"Number of rows", (long)expValues.length, (long)v.length());
        BufferedString tmpStr = new BufferedString();
        int i = 0;
        while ((long)i < v.length()) {
            if (v.isNA((long)i)) {
                Assert.assertEquals((String)"NAs should match", null, (Object)expValues[i]);
            } else {
                Assert.assertEquals((String)"Values should match", (Object)expValues[i], (Object)v.atStr(tmpStr, (long)i).toString());
            }
            ++i;
        }
    }

    public static String[] collectS(Vec v) {
        String[] res = new String[(int)v.length()];
        BufferedString tmpStr = new BufferedString();
        int i = 0;
        while ((long)i < v.length()) {
            res[i] = v.isNA((long)i) ? null : v.atStr(tmpStr, (long)i).toString();
            ++i;
        }
        return res;
    }

    public static class CountAllRowsPresented
    extends MRTask<CountAllRowsPresented> {
        int[] _counters;
        int _columnIndex;
        ArrayList<Integer> _badRows;

        public CountAllRowsPresented(int columnInd, Frame fr) {
            if (!fr.vec(columnInd).isCategorical() && !fr.vec(columnInd).isInt()) {
                throw new IllegalArgumentException("The column data type must be categorical or integer.");
            }
            this._columnIndex = columnInd;
            long numRows = fr.numRows();
            this._counters = new int[(int)numRows];
            Arrays.fill(this._counters, 1);
            this._badRows = new ArrayList();
        }

        public void map(Chunk[] chks) {
            int numRows = chks[0].len();
            for (int index = 0; index < numRows; ++index) {
                long temp = chks[this._columnIndex].at8(index);
                int n = (int)temp;
                this._counters[n] = this._counters[n] - 1;
            }
        }

        public ArrayList<Integer> findMissingRows() {
            int numBad = 0;
            for (int index = 0; index < this._counters.length; ++index) {
                if (this._counters[index] == 0) continue;
                ++numBad;
                this._badRows.add(index);
                Log.info((Object[])new Object[]{"Missing row " + index + " in final result with counter value " + this._counters[index]});
            }
            Log.info((Object[])new Object[]{"Total number of problem rows: " + numBad});
            return this._badRows;
        }
    }

    public static class Create1IDColumn
    extends MRTask<Create1IDColumn> {
        Frame _oneColumnFrame;

        public Create1IDColumn(int numRows) {
            CreateFrame cf = new CreateFrame();
            cf.rows = numRows;
            cf.cols = 1;
            cf.categorical_fraction = 0.0;
            cf.integer_fraction = 1.0;
            cf.binary_fraction = 0.0;
            cf.time_fraction = 0.0;
            cf.string_fraction = 0.0;
            cf.binary_ones_fraction = 0.0;
            cf.has_response = false;
            this._oneColumnFrame = (Frame)cf.execImpl().get();
        }

        public void map(Chunk chks) {
            int numRows = chks.len();
            int rowOffset = (int)chks.start();
            for (int index = 0; index < numRows; ++index) {
                chks.set(index, (long)(rowOffset + index));
            }
        }

        public Frame returnFrame() {
            return this._oneColumnFrame;
        }
    }

    public static class CountIntValueRows
    extends MRTask<CountIntValueRows> {
        public long _numberAppear;
        public long _value;
        public int _columnIndex;
        public int _columnIndRowValue;
        public ArrayList<Long> _specialRows;

        public CountIntValueRows(long value, int columnInd, int columnIndRowValue, Frame fr) {
            if (!fr.vec(columnInd).isCategorical() && !fr.vec(columnInd).isInt()) {
                throw new IllegalArgumentException("The column data type must be categorical or integer.");
            }
            this._value = value;
            this._columnIndex = columnInd;
            this._numberAppear = 0L;
            this._specialRows = new ArrayList();
            this._columnIndRowValue = columnIndRowValue;
        }

        public void map(Chunk[] chks) {
            int numRows = chks[0].len();
            for (int index = 0; index < numRows; ++index) {
                if (chks[this._columnIndex].at8(index) != this._value) continue;
                this._specialRows.add(chks[this._columnIndRowValue].at8(index));
                ++this._numberAppear;
            }
        }

        public void reduce(CountIntValueRows that) {
            this._numberAppear += that._numberAppear;
        }

        public long getNumberAppear() {
            return this._numberAppear;
        }
    }
}

