/*
 * Decompiled with CFR 0.152.
 */
package water.runner;

import java.util.HashSet;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import water.Key;
import water.TestUtil;
import water.Value;
import water.fvec.Frame;
import water.fvec.Vec;
import water.runner.CheckKeysTask;
import water.runner.CloudSize;
import water.runner.H2ORunnerAfters;
import water.runner.H2ORunnerBefores;
import water.util.Log;

@Ignore
public class H2ORunner
extends BlockJUnit4ClassRunner {
    private final TestClass testClass = this.getTestClass();
    private final HashSet<String> doOnlyTestNames = new HashSet();
    private final HashSet<String> ignoreTestsNames = new HashSet();

    public H2ORunner(Class<?> klass) throws InitializationError {
        super(klass);
        this.createTestFilters();
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        List befores = this.getTestClass().getAnnotatedMethods(Before.class);
        return new H2ORunnerBefores(statement, befores, target);
    }

    protected Statement withAfterClasses(Statement statement) {
        List afters = this.testClass.getAnnotatedMethods(AfterClass.class);
        return new H2ORunnerAfters(statement, afters, null);
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (this.isIgnored(method)) {
            notifier.fireTestIgnored(description);
        } else {
            this.leaf(this.methodBlock(method), description, notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaf(Statement statement, Description description, RunNotifier notifier) {
        TestUtil.stall_till_cloudsize(this.fetchCloudSize());
        EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
        eachNotifier.fireTestStarted();
        try {
            statement.evaluate();
        }
        catch (AssumptionViolatedException e) {
            eachNotifier.addFailedAssumption(e);
        }
        catch (Throwable e) {
            eachNotifier.addFailure(e);
        }
        finally {
            try {
                this.checkLeakedKeys(description);
            }
            catch (Throwable t) {
                eachNotifier.addFailure(t);
            }
            eachNotifier.fireTestFinished();
        }
    }

    private void checkLeakedKeys(Description description) {
        CheckKeysTask checkKeysTask = (CheckKeysTask)new CheckKeysTask().doAllNodes();
        if (checkKeysTask.leakedKeys.length == 0) {
            return;
        }
        this.printLeakedKeys(checkKeysTask.leakedKeys);
        throw new IllegalStateException(String.format("Test method '%s.%s' leaked %d keys.", description.getTestClass().getName(), description.getMethodName(), checkKeysTask.leakedKeys.length));
    }

    private void printLeakedKeys(Key[] leakedKeys) {
        HashSet<Key> leakedKeysSet = new HashSet<Key>(leakedKeys.length);
        for (Key k : leakedKeys) {
            leakedKeysSet.add(k);
        }
        for (Key key : leakedKeys) {
            Value keyValue = Value.STORE_get((Key)key);
            if (keyValue == null || !keyValue.isFrame()) continue;
            Frame frame = (Frame)key.get();
            Log.err((Object[])new Object[]{String.format("Leaked frame with key '%s'. This frame contains the following vectors:", frame._key.toString())});
            for (Key vecKey : frame.keys()) {
                if (!leakedKeysSet.contains(vecKey)) continue;
                Log.err((Object[])new Object[]{String.format("   Vector '%s'. This vector contains the following chunks:", vecKey.toString())});
                Vec vec = (Vec)vecKey.get();
                for (int i = 0; i < vec.nChunks(); ++i) {
                    Key chunkKey = vec.chunkKey(i);
                    if (!leakedKeysSet.contains(chunkKey)) continue;
                    Log.err((Object[])new Object[]{String.format("       Chunk id %d, key '%s'", i, chunkKey)});
                    leakedKeysSet.remove(chunkKey);
                }
                if (leakedKeysSet.contains(vec.rollupStatsKey())) {
                    Log.err((Object[])new Object[]{String.format("       Rollup stats '%s'", vec.rollupStatsKey().toString())});
                    leakedKeysSet.remove(vec.rollupStatsKey());
                }
                leakedKeysSet.remove(vecKey);
            }
            leakedKeysSet.remove(key);
        }
        if (!leakedKeysSet.isEmpty()) {
            Log.err((Object[])new Object[]{String.format("%nThere are %d uncategorized leaked keys detected:", leakedKeysSet.size())});
        }
        for (Key key : leakedKeysSet) {
            Log.err((Object[])new Object[]{String.format("Key '%s' of type %s.", key.toString(), key.valueClass())});
        }
    }

    private int fetchCloudSize() {
        CloudSize annotation = (CloudSize)this.testClass.getAnnotation(CloudSize.class);
        if (annotation == null) {
            throw new IllegalStateException("@CloudSize annotation is missing for test class: " + this.testClass.getName());
        }
        int cloudSize = annotation.value();
        if (cloudSize < 1) {
            throw new IllegalStateException("@CloudSize annotation must specify sizes greater than zero. Given value: " + cloudSize);
        }
        return cloudSize;
    }

    protected boolean isIgnored(FrameworkMethod child) {
        boolean isAnnotatedAsIgnored = super.isIgnored(child);
        String testName = child.getDeclaringClass().getName() + "#" + child.getMethod().getName();
        boolean isConfiguredAsIgnored = this.ignoreTestsNames.contains(testName);
        boolean isConfiguredAsDoOnly = this.doOnlyTestNames.contains(testName);
        return isAnnotatedAsIgnored || isConfiguredAsIgnored && !isConfiguredAsDoOnly || !this.doOnlyTestNames.isEmpty() && !isConfiguredAsDoOnly;
    }

    private void createTestFilters() {
        String[] split;
        String doOnlytestsInput;
        String[] split2;
        String ignoreTests = System.getProperty("ignore.tests");
        if (ignoreTests != null && (split2 = ignoreTests.split(",")).length != 1 && !split2[0].equals("")) {
            for (String ignoredTestName : split2) {
                this.ignoreTestsNames.add(ignoredTestName);
            }
        }
        if ((doOnlytestsInput = System.getProperty("doonly.tests")) != null && (split = doOnlytestsInput.split(",")).length != 1 && !split[0].equals("")) {
            for (String doOnlyTestName : split) {
                this.doOnlyTestNames.add(doOnlyTestName);
            }
        }
    }
}

