/*
 * Decompiled with CFR 0.152.
 */
package water.test.util;

import hex.ConfusionMatrix;
import org.junit.Assert;
import water.Key;
import water.MRTask;
import water.Scope;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class ConfusionMatrixUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfusionMatrix buildCM(Vec actuals, Vec predictions) {
        if (!actuals.isCategorical()) {
            throw new IllegalArgumentException("actuals must be categorical.");
        }
        if (!predictions.isCategorical()) {
            throw new IllegalArgumentException("predictions must be categorical.");
        }
        Scope.enter();
        try {
            Vec adapted = predictions.adaptTo(actuals.domain());
            int len = actuals.domain().length;
            Frame fr = new Frame(new Vec[]{actuals});
            fr.add("C2", adapted);
            CMBuilder cm = (CMBuilder)new CMBuilder(len).doAll(fr);
            ConfusionMatrix confusionMatrix = new ConfusionMatrix(cm._arr, actuals.domain());
            return confusionMatrix;
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    public static void assertCMEqual(String[] expectedDomain, double[][] expectedCM, ConfusionMatrix actualCM) {
        Assert.assertArrayEquals((String)"Expected domain differs", (Object[])expectedDomain, (Object[])actualCM._domain);
        double[][] acm = actualCM._cm;
        Assert.assertEquals((String)"CM dimension differs", (long)expectedCM.length, (long)acm.length);
        for (int i = 0; i < acm.length; ++i) {
            Assert.assertArrayEquals((String)("CM row " + i + " differs!"), (double[])expectedCM[i], (double[])acm[i], (double)1.0E-10);
        }
    }

    private static class CMBuilder
    extends MRTask<CMBuilder> {
        final int _len;
        double[][] _arr;

        CMBuilder(int len) {
            this._len = len;
        }

        public void map(Chunk ca, Chunk cp) {
            this._arr = new double[this._len][this._len];
            for (int i = 0; i < ca._len; ++i) {
                if (ca.isNA(i)) continue;
                double[] dArray = this._arr[(int)ca.at8(i)];
                int n = (int)cp.at8(i);
                dArray[n] = dArray[n] + 1.0;
            }
        }

        public void reduce(CMBuilder cm) {
            ArrayUtils.add((double[][])this._arr, (double[][])cm._arr);
        }
    }
}

