/*
 * Decompiled with CFR 0.152.
 */
package water.test;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;
import org.junit.Assert;
import water.H2O;

public class WebsocketClient
extends Endpoint {
    private Map<String, String> receivedMessage;
    private Session sess;
    private final Gson gson = new Gson();

    public WebsocketClient() throws URISyntaxException, IOException, DeploymentException {
        String destUri = "ws://" + H2O.getIpPortString() + "/3/Steam.websocket";
        ClientManager client = ClientManager.createClient();
        ClientEndpointConfig cec = ClientEndpointConfig.Builder.create().build();
        this.sess = client.connectToServer((Endpoint)this, cec, new URI(destUri));
    }

    public void close() throws IOException {
        this.sess.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Test Done"));
    }

    @OnOpen
    public void onOpen(Session session, EndpointConfig config) {
        session.addMessageHandler(String.class, message -> {
            System.out.println("Received message: " + message);
            WebsocketClient websocketClient = this;
            synchronized (websocketClient) {
                this.receivedMessage = (Map)this.gson.fromJson(message, new TypeToken<Map<String, String>>(){}.getType());
                ((Object)((Object)this)).notifyAll();
            }
        });
    }

    public void sendMessage(Object msg) throws IOException {
        this.sess.getBasicRemote().sendText(this.gson.toJson(msg));
    }

    public Map<String, String> waitToReceiveMessage(String message) {
        return this.waitToReceiveMessage(message, 10000);
    }

    public Map<String, String> waitToReceiveMessage(String message, int timeoutMillis) {
        return this.waitToReceiveMessage(message, timeoutMillis, true).get();
    }

    public synchronized Optional<Map<String, String>> waitToReceiveMessage(String message, int timeoutMillis, boolean failOnNone) {
        try {
            ((Object)((Object)this)).wait(timeoutMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.receivedMessage != null) {
            Map<String, String> res = this.receivedMessage;
            this.receivedMessage = null;
            return Optional.of(res);
        }
        if (failOnNone) {
            Assert.fail((String)("Expected " + message + ", but no message received from H2O."));
        }
        return Optional.empty();
    }
}

