/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.junit.Ignore;
import water.DKV;
import water.Key;
import water.Scope;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Env;
import water.rapids.Session;

@Ignore
public class TestFrameBuilder {
    private static final long NOT_SET = -1L;
    private Map<Integer, String[]> stringData = new HashMap<Integer, String[]>();
    private Map<Integer, double[]> numericData = new HashMap<Integer, double[]>();
    private Map<Integer, String[]> givenDomains = new HashMap<Integer, String[]>();
    private String frameName;
    private byte[] vecTypes;
    private String[] colNames;
    private long[] chunkLayout;
    private int numCols;
    private Key<Frame> key;
    private long numRows = -1L;
    private String[][] domains = null;
    private Map<Integer, Integer[]> categoriesPerCol = new HashMap<Integer, Integer[]>();

    public TestFrameBuilder withName(String frameName) {
        this.throwIf(frameName.startsWith("$"), "Frame name " + frameName + " may only be used with a Session object.");
        this.frameName = frameName;
        return this;
    }

    public TestFrameBuilder withName(String frameName, Session session) {
        return this.withName(new Env(session).expand(frameName));
    }

    public TestFrameBuilder withColNames(String ... colNames) {
        this.colNames = colNames;
        return this;
    }

    public TestFrameBuilder withVecTypes(byte ... vecTypes) {
        this.vecTypes = vecTypes;
        return this;
    }

    public TestFrameBuilder withUniformVecTypes(int nvecs, byte vecType) {
        byte[] vecTypes = new byte[nvecs];
        for (int i = 0; i < nvecs; ++i) {
            vecTypes[i] = vecType;
        }
        this.vecTypes = vecTypes;
        return this;
    }

    public TestFrameBuilder withSequenceIntDataForCol(int column, int from, int to) {
        assert (to > from);
        int size = to - from;
        double[] arr = new double[size];
        for (int i = from; i < to; ++i) {
            arr[i] = i;
        }
        this.numericData.put(column, arr);
        return this;
    }

    public TestFrameBuilder withRandomIntDataForCol(int column, int size, int min, int max, long seed) {
        assert (max > min);
        assert (seed + (long)(size * size) <= Long.MAX_VALUE);
        double[] arr = new double[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = min + new Random(seed + (long)(i * size)).nextInt(max - min);
        }
        this.numericData.put(column, arr);
        return this;
    }

    public TestFrameBuilder withRandomDoubleDataForCol(int column, int size, int min, int max, long seed) {
        assert (max >= min);
        double[] arr = new double[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = (double)min + (double)(max - min) * new Random(seed + (long)(i * size)).nextDouble();
        }
        this.numericData.put(column, arr);
        return this;
    }

    public TestFrameBuilder withRandomBinaryDataForCol(int column, int size, long seed) {
        String[] arr = new String[size];
        Random generator = new Random();
        long multiplierFromRandomClass = 25214903917L;
        assert (seed + (long)size * multiplierFromRandomClass < Long.MAX_VALUE);
        for (int i = 0; i < size; ++i) {
            generator.setSeed(seed + (long)i * multiplierFromRandomClass);
            arr[i] = Boolean.toString(generator.nextBoolean());
        }
        this.stringData.put(column, arr);
        return this;
    }

    public TestFrameBuilder withDataForCol(int column, String[] data) {
        this.stringData.put(column, data);
        return this;
    }

    public TestFrameBuilder withDataForCol(int column, double[] data) {
        this.numericData.put(column, data);
        return this;
    }

    public TestFrameBuilder withDataForCol(int column, long[] data) {
        if (data == null) {
            this.numericData.put(column, null);
        } else {
            double[] doubles = new double[data.length];
            for (int i = 0; i < data.length; ++i) {
                doubles[i] = data[i];
            }
            this.numericData.put(column, doubles);
        }
        return this;
    }

    public TestFrameBuilder withDomain(int column, String[] domain) {
        this.givenDomains.put(column, domain);
        return this;
    }

    public TestFrameBuilder withChunkLayout(long ... chunkLayout) {
        this.chunkLayout = chunkLayout;
        return this;
    }

    public Frame build() {
        this.prepareAndCheck();
        Frame f = new Frame(this.key);
        f.preparePartialFrame(this.colNames);
        f.update();
        int cidx = 0;
        long start = 0L;
        for (long chnkSize : this.chunkLayout) {
            this.createChunks(start, chnkSize, cidx);
            ++cidx;
            start += chnkSize;
        }
        f = (Frame)DKV.get(this.key).get();
        f.finalizePartialFrame(this.chunkLayout, this.domains, this.vecTypes);
        Scope.track((Frame[])new Frame[]{f});
        return f;
    }

    private void prepareAndCheck() {
        this.checkVecTypes();
        this.checkNames();
        this.checkColumnData();
        this.checkFrameName();
        this.checkChunkLayout();
        this.prepareCategoricals();
    }

    private String[] getUniqueValues(Map<String, Integer> mapping) {
        String[] values = new String[mapping.size()];
        Iterator<String> iterator = mapping.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            values[mapping.get((Object)key).intValue()] = key = iterator.next();
        }
        return values;
    }

    private Integer[] applyDomainMapping(Map<String, Integer> mapping, String[] original) {
        Integer[] categoricals = new Integer[original.length];
        for (int i = 0; i < original.length; ++i) {
            categoricals[i] = original[i] == null ? null : mapping.get(original[i]);
        }
        return categoricals;
    }

    private Map<String, Integer> getMapping(String[] array) {
        return this.getMapping(array, false);
    }

    private Map<String, Integer> getMapping(String[] array, boolean useOrderInArray) {
        TreeMap<String, Integer> mapping = new TreeMap<String, Integer>();
        int level = 0;
        for (String item : array) {
            if (item == null || mapping.containsKey(item)) continue;
            mapping.put(item, useOrderInArray ? level++ : 0);
        }
        if (!useOrderInArray) {
            for (Map.Entry entry : mapping.entrySet()) {
                entry.setValue(level++);
            }
        }
        return mapping;
    }

    private void prepareCategoricals() {
        for (int colIdx = 0; colIdx < this.vecTypes.length; ++colIdx) {
            if (this.givenDomains.containsKey(colIdx)) {
                String[] doms = this.givenDomains.get(colIdx);
                this.domains[colIdx] = doms;
                Map<String, Integer> mapping = this.getMapping(doms, true);
                Integer[] categories = this.applyDomainMapping(mapping, this.stringData.get(colIdx));
                this.categoriesPerCol.put(colIdx, categories);
                continue;
            }
            if (this.vecTypes[colIdx] == 4) {
                Map<String, Integer> mapping = this.getMapping(this.stringData.get(colIdx));
                Integer[] categories = this.applyDomainMapping(mapping, this.stringData.get(colIdx));
                this.domains[colIdx] = this.getUniqueValues(mapping);
                this.categoriesPerCol.put(colIdx, categories);
                continue;
            }
            if (this.domains == null) continue;
            this.domains[colIdx] = null;
        }
    }

    private void createChunks(long start, long length, int cidx) {
        NewChunk[] nchunks = Frame.createNewChunks((String)this.key.toString(), (byte[])this.vecTypes, (int)cidx);
        int i = (int)start;
        while ((long)i < start + length) {
            block8: for (int colIdx = 0; colIdx < this.vecTypes.length; ++colIdx) {
                switch (this.vecTypes[colIdx]) {
                    case 3: {
                        nchunks[colIdx].addNum(this.numericData.get(colIdx)[i]);
                        continue block8;
                    }
                    case 2: {
                        nchunks[colIdx].addStr((Object)this.stringData.get(colIdx)[i]);
                        continue block8;
                    }
                    case 5: {
                        nchunks[colIdx].addNum(this.numericData.get(colIdx)[i]);
                        continue block8;
                    }
                    case 4: {
                        Integer cat = this.categoriesPerCol.get(colIdx)[i];
                        if (cat != null) {
                            nchunks[colIdx].addCategorical(cat.intValue());
                            continue block8;
                        }
                        nchunks[colIdx].addNA();
                        continue block8;
                    }
                    case 0: {
                        nchunks[colIdx].addNum(this.numericData.get(colIdx)[i]);
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported Vector type for the builder");
                    }
                }
            }
            ++i;
        }
        Frame.closeNewChunks((NewChunk[])nchunks);
    }

    private void checkVecTypes() {
        int i;
        if (this.vecTypes == null) {
            if (this.colNames == null) {
                this.vecTypes = new byte[0];
            } else {
                this.vecTypes = new byte[this.colNames.length];
                for (i = 0; i < this.colNames.length; ++i) {
                    this.vecTypes[i] = 3;
                }
            }
        }
        this.numCols = this.vecTypes.length;
        block6: for (i = 0; i < this.vecTypes.length; ++i) {
            switch (this.vecTypes[i]) {
                case 0: 
                case 3: 
                case 5: {
                    if (this.numericData.get(i) != null) continue block6;
                    this.numericData.put(i, new double[0]);
                    continue block6;
                }
                case 4: {
                    this.domains = new String[this.vecTypes.length][];
                }
                case 2: {
                    if (this.stringData.get(i) != null) continue block6;
                    this.stringData.put(i, new String[0]);
                }
            }
        }
    }

    private void checkNames() {
        if (this.colNames == null) {
            this.colNames = new String[this.vecTypes.length];
            for (int i = 0; i < this.vecTypes.length; ++i) {
                this.colNames[i] = "col_" + i;
            }
        } else {
            this.throwIf(this.colNames.length != this.vecTypes.length, "Number of vector types and number of column names differ.");
        }
    }

    private void checkFrameName() {
        this.key = this.frameName == null ? Key.make() : Key.make((String)this.frameName);
    }

    private void checkChunkLayout() {
        if (this.chunkLayout != null) {
            int sum = 0;
            for (long numPerChunk : this.chunkLayout) {
                sum = (int)((long)sum + numPerChunk);
            }
            this.throwIf((long)sum > this.numRows, "Chunk layout contains bad elements. Total sum is higher then available number of elements.");
        } else {
            this.chunkLayout = new long[]{this.numRows};
        }
    }

    private void checkColumnData() {
        block5: for (int colIdx = 0; colIdx < this.numCols; ++colIdx) {
            switch (this.vecTypes[colIdx]) {
                case 3: 
                case 5: {
                    if (this.numRows == -1L) {
                        this.numRows = this.numericData.get(colIdx).length;
                        continue block5;
                    }
                    this.throwIf(this.numRows != (long)this.numericData.get(colIdx).length, "Columns have different number of elements");
                    continue block5;
                }
                case 2: 
                case 4: {
                    if (this.numRows == -1L) {
                        this.numRows = this.stringData.get(colIdx).length;
                        continue block5;
                    }
                    this.throwIf(this.numRows != (long)this.stringData.get(colIdx).length, "Columns have different number of elements");
                    continue block5;
                }
                case 0: {
                    double[] data = this.numericData.get(colIdx);
                    this.numRows = data.length;
                    for (int i = 0; i < data.length; ++i) {
                        this.throwIf(!Double.isNaN(data[i]), "All elements in a bad column must be NAs.");
                    }
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported Vector type for the builder");
                }
            }
        }
    }

    private void throwIf(boolean condition, String msg) {
        if (condition) {
            throw new IllegalArgumentException(msg);
        }
    }
}

