/*
 * Decompiled with CFR 0.152.
 */
package water.junit;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringEscapeUtils;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import water.junit.TeeOutputStream;

@Ignore(value="Support for tests, but no actual tests here")
public class XMLTestReporter
extends RunListener {
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    DocumentBuilderFactory docBuilderFactory;
    DocumentBuilder docBuilder;
    Document document;
    TransformerFactory transFactory;
    Transformer trans;
    String reportsDir;
    Element testSuiteElement;
    long testSuiteStartTime;
    Element testCaseElement;
    long testCaseStartTime;
    String currentTestSuiteName;
    long testCount;
    long successCount;
    long failureCount;
    PrintStream stdOut;
    PrintStream stdErr;
    ByteArrayOutputStream out;
    ByteArrayOutputStream err;

    public XMLTestReporter() throws Exception {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
        this.document = this.docBuilder.newDocument();
        this.testCaseElement = this.document.createElement("testcase");
        this.transFactory = TransformerFactory.newInstance();
        this.trans = this.transFactory.newTransformer();
        this.trans.setOutputProperty("indent", "yes");
        this.reportsDir = System.getProperty("junit.reports.dir", "build/test-results");
        File rdir = new File(this.reportsDir);
        if (rdir.isFile()) {
            throw new IllegalArgumentException(this.reportsDir + " is not a directory!");
        }
        if (!rdir.exists()) {
            rdir.mkdirs();
        }
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.currentTestSuiteName != null) {
            this.finishTestSuite();
        }
    }

    public void testStarted(Description description) throws Exception {
        String testSuiteName = description.getClassName();
        if (this.currentTestSuiteName == null) {
            this.startTestSuite(testSuiteName);
        } else if (!this.currentTestSuiteName.equals(testSuiteName)) {
            this.finishTestSuite();
            this.startTestSuite(testSuiteName);
        }
        this.currentTestSuiteName = testSuiteName;
        this.startTestCase(description);
    }

    public void testFinished(Description description) throws Exception {
        this.finishTestCase();
        this.recordTestCaseSuccess();
    }

    public void testFailure(Failure failure) throws Exception {
        this.finishTestCase();
        this.recordTestCaseFailure(failure);
    }

    public void startTestSuite(String testSuiteName) throws Exception {
        this.testSuiteStartTime = System.currentTimeMillis();
        this.document = this.docBuilder.newDocument();
        this.testSuiteElement = this.document.createElement("testsuite");
        this.document.appendChild(this.testSuiteElement);
        this.testSuiteElement.setAttribute("name", StringEscapeUtils.escapeXml((String)testSuiteName));
        this.testSuiteElement.setAttribute("timestamp", StringEscapeUtils.escapeXml((String)this.dateFormat.format(new Date(this.testSuiteStartTime))));
        this.testSuiteElement.setAttribute("hostname", StringEscapeUtils.escapeXml((String)InetAddress.getLocalHost().getHostName()));
        this.testSuiteElement.setAttribute("ncpu", StringEscapeUtils.escapeXml((String)Integer.toString(Runtime.getRuntime().availableProcessors())));
        Element propertiesElement = this.document.createElement("properties");
        this.testSuiteElement.appendChild(propertiesElement);
        for (String name : System.getProperties().stringPropertyNames()) {
            Element propertyElement = this.document.createElement("property");
            propertyElement.setAttribute("name", StringEscapeUtils.escapeXml((String)name));
            propertyElement.setAttribute("value", StringEscapeUtils.escapeXml((String)System.getProperty(name)));
            propertiesElement.appendChild(propertyElement);
        }
        this.testCount = 0L;
        this.successCount = 0L;
        this.failureCount = 0L;
        this.stdOut = System.out;
        this.out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(new TeeOutputStream(this.out, this.stdOut), true));
        this.stdErr = System.err;
        this.err = new ByteArrayOutputStream();
        System.setErr(new PrintStream(new TeeOutputStream(this.err, this.stdErr), true));
    }

    public void finishTestSuite() throws Exception {
        double time = (double)(System.currentTimeMillis() - this.testSuiteStartTime) / 1000.0;
        this.testSuiteElement.setAttribute("time", "" + time);
        long errorCount = this.testCount - this.successCount - this.failureCount;
        this.testSuiteElement.setAttribute("tests", "" + this.testCount);
        this.testSuiteElement.setAttribute("failures", "" + this.failureCount);
        this.testSuiteElement.setAttribute("errors", "" + errorCount);
        System.setOut(this.stdOut);
        System.setErr(this.stdErr);
        Element systemOutElement = this.document.createElement("system-out");
        this.testSuiteElement.appendChild(systemOutElement);
        systemOutElement.appendChild(this.document.createCDATASection(this.out.toString()));
        Element systemErrElement = this.document.createElement("system-err");
        this.testSuiteElement.appendChild(systemErrElement);
        systemErrElement.appendChild(this.document.createCDATASection(this.err.toString()));
        FileWriter fw = new FileWriter(this.reportsDir + File.separator + "TEST-" + this.currentTestSuiteName + ".xml");
        StreamResult sr = new StreamResult(fw);
        DOMSource source = new DOMSource(this.document);
        this.trans.transform(source, sr);
        fw.close();
    }

    public void startTestCase(Description description) throws Exception {
        this.testCaseStartTime = System.currentTimeMillis();
        this.testCaseElement = this.document.createElement("testcase");
        this.testSuiteElement.appendChild(this.testCaseElement);
        this.testCaseElement.setAttribute("classname", description.getClassName());
        this.testCaseElement.setAttribute("name", description.getMethodName());
        ++this.testCount;
    }

    public void finishTestCase() throws Exception {
        double time = (double)(System.currentTimeMillis() - this.testCaseStartTime) / 1000.0;
        this.testCaseElement.setAttribute("time", "" + time);
    }

    public void recordTestCaseSuccess() throws Exception {
        ++this.successCount;
    }

    public void recordTestCaseFailure(Failure failure) throws Exception {
        Element failureElement = this.document.createElement("failure");
        this.testCaseElement.appendChild(failureElement);
        Description description = failure.getDescription();
        String exceptionName = failure.getException().getClass().getName();
        failureElement.setAttribute("message", failure.getMessage());
        failureElement.setAttribute("type", exceptionName);
        Text messageElement = this.document.createTextNode(exceptionName + ": " + failure.getMessage() + "\n\tat " + description.getClassName() + "." + description.getMethodName() + "()");
        failureElement.appendChild(messageElement);
        ++this.failureCount;
    }
}

