/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import water.H2O;
import water.Key;
import water.Scope;
import water.TestFrameCatalog;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;

public class TestUtilTest
extends TestUtil {
    @Rule
    public transient TemporaryFolder tmp = new TemporaryFolder();

    @BeforeClass
    public static void setup() {
        TestUtilTest.stall_till_cloudsize(1);
    }

    @Test
    public void asFactor() {
        Scope.enter();
        try {
            Frame fr = new TestFrameBuilder().withName("testFrame").withColNames("ColA").withVecTypes(2).withDataForCol(0, TestUtilTest.ar("yes", "no")).build();
            Scope.track((Frame[])new Frame[]{fr});
            Assert.assertTrue((boolean)fr.vec(0).isString());
            Frame res = TestUtilTest.asFactor(fr, "ColA");
            Assert.assertTrue((boolean)res.vec(0).isCategorical());
            Scope.track((Frame[])new Frame[]{res});
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeFrameToCSV() throws IOException {
        Assume.assumeTrue((H2O.getCloudSize() == 1 ? 1 : 0) != 0);
        try {
            Scope.enter();
            Frame f = TestFrameCatalog.oneChunkFewRows();
            f.remove("col_3");
            File exportedFile = new File(this.tmp.getRoot(), "export.csv");
            TestUtilTest.writeFrameToCSV(exportedFile.getAbsolutePath(), f, true, false);
            Frame imported = Scope.track((Frame[])new Frame[]{TestUtilTest.parseTestFile(exportedFile.getAbsolutePath())});
            TestUtilTest.assertFrameEquals(f, imported, 0.0);
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

