/*
 * Decompiled with CFR 0.152.
 */
package water.runner;

import java.util.Arrays;
import java.util.Set;
import org.junit.Ignore;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.Value;
import water.fvec.Vec;
import water.runner.LocalTestRuntime;
import water.util.ArrayUtils;

@Ignore
public class CheckKeysTask
extends MRTask<CheckKeysTask> {
    Key[] leakedKeys;
    LeakInfo[] leakInfos;

    protected static boolean isIgnorableKeyLeak(Key key, Value value) {
        return value == null || value.isVecGroup() || value.isESPCGroup() || key.equals((Object)Job.LIST) || value.isJob() && ((Job)value.get()).isStopped();
    }

    public void reduce(CheckKeysTask mrt) {
        this.leakedKeys = (Key[])ArrayUtils.append((Object[])this.leakedKeys, (Object[])mrt.leakedKeys);
        this.leakInfos = (LeakInfo[])ArrayUtils.append((Object[])this.leakInfos, (Object[])mrt.leakInfos);
    }

    protected void setupLocal() {
        Set<Key> initKeys = LocalTestRuntime.beforeTestKeys;
        Set keysAfterTest = H2O.localKeySet();
        int numLeakedKeys = keysAfterTest.size() - initKeys.size();
        this.leakedKeys = numLeakedKeys > 0 ? new Key[numLeakedKeys] : new Key[]{};
        this.leakInfos = new LeakInfo[0];
        if (numLeakedKeys > 0) {
            int leakedKeysPointer = 0;
            for (Key key : keysAfterTest) {
                Value keyValue;
                if (initKeys.contains(key) || CheckKeysTask.isIgnorableKeyLeak(key, keyValue = Value.STORE_get((Key)key))) continue;
                this.leakedKeys[leakedKeysPointer] = key;
                LeakInfo leakInfo = this.makeLeakInfo(leakedKeysPointer, keyValue);
                if (leakInfo != null) {
                    this.leakInfos = (LeakInfo[])ArrayUtils.append((Object[])this.leakInfos, (Object[])new LeakInfo[]{leakInfo});
                }
                ++leakedKeysPointer;
            }
            if (leakedKeysPointer < numLeakedKeys) {
                this.leakedKeys = Arrays.copyOfRange(this.leakedKeys, 0, leakedKeysPointer);
            }
        }
    }

    private LeakInfo makeLeakInfo(int keyIdx, Value value) {
        String vClass;
        if (value == null) {
            return null;
        }
        switch (vClass = value.className()) {
            case "water.fvec.RollupStats": {
                Key vecKey = Vec.getVecKey((Key)this.leakedKeys[keyIdx]);
                return new LeakInfo(keyIdx, vecKey, String.valueOf(value.get()));
            }
        }
        return null;
    }

    public static class LeakInfo
    extends Iced<LeakInfo> {
        final int _keyIdx;
        final Key<Vec> _vecKey;
        final int _nodeId;
        final String _info;

        private LeakInfo(int keyIdx, Key<Vec> vecKey, String info) {
            this._keyIdx = keyIdx;
            this._vecKey = vecKey;
            this._nodeId = H2O.SELF.index();
            this._info = info;
        }

        public String toString() {
            return "nodeId=" + this._nodeId + ", vecKey=" + String.valueOf(this._vecKey) + ", _info='" + this._info;
        }
    }
}

