/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import org.junit.Assert;
import org.junit.Ignore;
import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;

@Ignore(value="Support for tests, but no actual tests here")
public class FrameTestUtil {
    public static Frame createFrame(String fname, long[] chunkLayout, String[][] data) {
        Frame f = new Frame(Key.make((String)fname));
        f.preparePartialFrame(new String[]{"C0"});
        f.update();
        byte[] types = new byte[]{2};
        for (int i = 0; i < chunkLayout.length; ++i) {
            FrameTestUtil.createNC(fname, data[i], i, (int)chunkLayout[i], types);
        }
        f = (Frame)DKV.get((String)fname).get();
        f.finalizePartialFrame(chunkLayout, (String[][])new String[][]{null}, types);
        return f;
    }

    public static NewChunk createNC(String fname, String[] data, int cidx, int len, byte[] types) {
        NewChunk[] nchunks = Frame.createNewChunks((String)fname, (byte[])types, (int)cidx);
        for (int i = 0; i < len; ++i) {
            nchunks[0].addStr(data[i] != null ? data[i] : null);
        }
        Frame.closeNewChunks((NewChunk[])nchunks);
        return nchunks[0];
    }

    public static Frame createFrame(String fname, long[] chunkLayout) {
        Frame f = new Frame(Key.make((String)fname));
        f.preparePartialFrame(new String[]{"C0"});
        f.update();
        byte[] types = new byte[]{3};
        for (int i = 0; i < chunkLayout.length; ++i) {
            FrameTestUtil.createNC(fname, i, (int)chunkLayout[i], types);
        }
        f = (Frame)DKV.get((String)fname).get();
        f.finalizePartialFrame(chunkLayout, (String[][])new String[][]{null}, types);
        return f;
    }

    public static NewChunk createNC(String fname, int cidx, int len, byte[] types) {
        NewChunk[] nchunks = Frame.createNewChunks((String)fname, (byte[])types, (int)cidx);
        int starVal = cidx * 1000;
        for (int i = 0; i < len; ++i) {
            nchunks[0].addNum((double)(starVal + i));
        }
        Frame.closeNewChunks((NewChunk[])nchunks);
        return nchunks[0];
    }

    public static void assertValues(Frame f, String[] expValues) {
        FrameTestUtil.assertValues(f.vec(0), expValues);
    }

    public static void assertValues(Vec v, String[] expValues) {
        Assert.assertEquals((String)"Number of rows", (long)expValues.length, (long)v.length());
        BufferedString tmpStr = new BufferedString();
        int i = 0;
        while ((long)i < v.length()) {
            if (v.isNA((long)i)) {
                Assert.assertEquals((String)"NAs should match", null, (Object)expValues[i]);
            } else {
                Assert.assertEquals((String)"Values should match", (Object)expValues[i], (Object)v.atStr(tmpStr, (long)i).toString());
            }
            ++i;
        }
    }

    public static String[] collectS(Vec v) {
        String[] res = new String[(int)v.length()];
        BufferedString tmpStr = new BufferedString();
        int i = 0;
        while ((long)i < v.length()) {
            res[i] = v.isNA((long)i) ? null : v.atStr(tmpStr, (long)i).toString();
            ++i;
        }
        return res;
    }
}

