/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.CreateFrame;
import hex.Model;
import hex.SplitFrame;
import hex.genmodel.GenModel;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.easy.RowData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import water.DKV;
import water.ExtensionManager;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.IcedWrapper;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.TypeMap;
import water.UDPRebooted;
import water.Value;
import water.api.StreamWriteOption;
import water.api.StreamWriter;
import water.api.StreamingSchema;
import water.fvec.AppendableVec;
import water.fvec.C16Chunk;
import water.fvec.C8Chunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.init.NetworkInit;
import water.parser.BufferedString;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.util.FileUtils;
import water.util.Log;
import water.util.RandomBase;
import water.util.RandomUtils;
import water.util.Timer;
import water.util.TwoDimTable;
import water.util.fp.Function;

@Ignore(value="Support for tests, but no actual tests here")
public class TestUtil
extends Iced {
    public static final boolean JACOCO_ENABLED = Boolean.parseBoolean(System.getProperty("test.jacocoEnabled", "false"));
    private static boolean _stall_called_before = false;
    private static String[] ignoreTestsNames;
    private static String[] doonlyTestsNames;
    protected static int _initial_keycnt;
    public static int MINCLOUDSIZE;
    protected static int DEFAULT_TIME_FOR_CLOUDING;
    public static Description CURRENT_TEST_DESCRIPTION;
    @Rule
    public transient TestRule logRule;
    @Rule
    public transient TestRule runRule;
    @Rule
    public transient TestRule timerRule;

    public TestUtil() {
        this(1);
    }

    public TestUtil(int minCloudSize) {
        String doonlyTests;
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        loader.setDefaultAssertionStatus(true);
        this.logRule = new TestRule(){

            public Statement apply(Statement base, Description description) {
                Log.info((Object[])new Object[]{"###########################################################"});
                Log.info((Object[])new Object[]{"  * Test class name:  " + description.getClassName()});
                Log.info((Object[])new Object[]{"  * Test method name: " + description.getMethodName()});
                Log.info((Object[])new Object[]{"###########################################################"});
                CURRENT_TEST_DESCRIPTION = description;
                return base;
            }
        };
        this.runRule = new TestRule(){

            public Statement apply(Statement base, Description description) {
                String testName = description.getClassName() + "#" + description.getMethodName();
                boolean ignored = false;
                if (ignoreTestsNames != null && ignoreTestsNames.length > 0) {
                    for (String tn : ignoreTestsNames) {
                        if (!testName.startsWith(tn)) continue;
                        ignored = true;
                        break;
                    }
                }
                if (doonlyTestsNames != null && doonlyTestsNames.length > 0) {
                    ignored = true;
                    for (String tn : doonlyTestsNames) {
                        if (!testName.startsWith(tn)) continue;
                        ignored = false;
                        break;
                    }
                }
                if (ignored) {
                    Log.info((Object[])new Object[]{"#### TEST " + testName + " IGNORED"});
                    return new Statement(){

                        public void evaluate() throws Throwable {
                        }
                    };
                }
                return base;
            }
        };
        this.timerRule = new TestRule(){

            public Statement apply(Statement base, Description description) {
                return new TimerStatement(base, description.getClassName() + "#" + description.getMethodName());
            }

            class TimerStatement
            extends Statement {
                private final Statement _base;
                private final String _tname;
                Throwable _ex;

                public TimerStatement(Statement base, String tname) {
                    this._base = base;
                    this._tname = tname;
                }

                public void evaluate() throws Throwable {
                    Timer t = new Timer();
                    try {
                        this._base.evaluate();
                    }
                    catch (Throwable ex) {
                        try {
                            this._ex = ex;
                            throw this._ex;
                        }
                        catch (Throwable throwable) {
                            Log.info((Object[])new Object[]{"#### TEST " + this._tname + " EXECUTION TIME: " + t.toString()});
                            throw throwable;
                        }
                    }
                    Log.info((Object[])new Object[]{"#### TEST " + this._tname + " EXECUTION TIME: " + t.toString()});
                }
            }
        };
        MINCLOUDSIZE = Math.max(MINCLOUDSIZE, minCloudSize);
        String ignoreTests = System.getProperty("ignore.tests");
        if (ignoreTests != null && (ignoreTestsNames = ignoreTests.split(",")).length == 1 && ignoreTestsNames[0].equals("")) {
            ignoreTestsNames = null;
        }
        if ((doonlyTests = System.getProperty("doonly.tests")) != null && (doonlyTestsNames = doonlyTests.split(",")).length == 1 && doonlyTestsNames[0].equals("")) {
            doonlyTestsNames = null;
        }
    }

    protected static int getDefaultTimeForClouding() {
        return JACOCO_ENABLED ? DEFAULT_TIME_FOR_CLOUDING * 10 : DEFAULT_TIME_FOR_CLOUDING;
    }

    public static void stall_till_cloudsize(int x) {
        TestUtil.stall_till_cloudsize(x, TestUtil.getDefaultTimeForClouding());
    }

    public static double[] changeDouble2SingleArray(double[][] arr) {
        double[] result = new double[arr.length * arr[0].length];
        int numRows = arr.length;
        int offset = 0;
        for (int rind = 0; rind < numRows; ++rind) {
            int rowLength = arr[rind].length;
            System.arraycopy(arr[rind], 0, result, offset, rowLength);
            offset += rowLength;
        }
        return result;
    }

    public static void stall_till_cloudsize(int x, int timeout) {
        TestUtil.stall_till_cloudsize(new String[0], x, timeout);
    }

    public static void stall_till_cloudsize(String[] args, int x) {
        TestUtil.stall_till_cloudsize(args, x, TestUtil.getDefaultTimeForClouding());
    }

    public static void stall_till_cloudsize(String[] args, int x, int timeout) {
        x = Math.max(MINCLOUDSIZE, x);
        if (!_stall_called_before) {
            H2O.main((String[])args);
            H2O.registerResourceRoot((File)new File(System.getProperty("user.dir") + File.separator + "h2o-web/src/main/resources/www"));
            H2O.registerResourceRoot((File)new File(System.getProperty("user.dir") + File.separator + "h2o-core/src/main/resources/www"));
            ExtensionManager.getInstance().registerRestApiExtensions();
            _stall_called_before = true;
        }
        H2O.waitForCloudSize((int)x, (long)timeout);
        _initial_keycnt = H2O.store_size();
        H2O.startServingRestApi();
    }

    @AfterClass
    public static void checkLeakedKeys() {
        int leaked_keys = H2O.store_size() - _initial_keycnt;
        int cnt = 0;
        if (leaked_keys > 0) {
            int print_max = 10;
            for (Key k : H2O.localKeySet()) {
                Value value = Value.STORE_get((Key)k);
                if (value == null || value.isVecGroup() || value.isESPCGroup() || k == Job.LIST || value.isJob() && ((Job)value.get()).isStopped()) {
                    --leaked_keys;
                    continue;
                }
                System.out.println(k + " -> " + (value.type() != TypeMap.PRIM_B ? value.get() : "byte[]"));
                if (cnt++ >= print_max) continue;
                System.err.println("Leaked key: " + k + " = " + TypeMap.className((int)value.type()));
            }
            if (print_max < leaked_keys) {
                System.err.println("... and " + (leaked_keys - print_max) + " more leaked keys");
            }
        }
        Assert.assertTrue((String)("Keys leaked: " + leaked_keys + ", cnt = " + cnt), (leaked_keys <= 0 || cnt == 0 ? 1 : 0) != 0);
        new DKVCleaner().doAllNodes();
        _initial_keycnt = H2O.store_size();
    }

    public static void cleanupKeys(Class ... objectType) {
        new KeyCleaner(objectType).doAllNodes();
    }

    public static void checkArrays(double[] expected, double[] actual, double threshold) {
        for (int i = 0; i < actual.length; ++i) {
            if (Double.isNaN(expected[i]) || Double.isNaN(actual[i])) continue;
            Assert.assertEquals((double)expected[i], (double)actual[i], (double)(threshold * Math.min(Math.abs(expected[i]), Math.abs(actual[i]))));
        }
    }

    public static void checkDoubleArrays(double[][] expected, double[][] actual, double threshold) {
        int len1 = expected.length;
        Assert.assertEquals((long)len1, (long)actual.length);
        for (int ind = 0; ind < len1; ++ind) {
            Assert.assertEquals((long)expected[ind].length, (long)actual[ind].length);
            TestUtil.checkArrays(expected[ind], actual[ind], threshold);
        }
    }

    @Deprecated
    protected static Frame generate_enum_only(int numCols, int numRows, int num_factor, double missingfrac) {
        return TestUtil.generateEnumOnly(numCols, numRows, num_factor, missingfrac);
    }

    protected static Frame generateEnumOnly(int numCols, int numRows, int num_factor, double missingfrac) {
        long seed = System.currentTimeMillis();
        System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + seed);
        return TestUtil.generateEnumOnly(numCols, numRows, num_factor, missingfrac, seed);
    }

    @Deprecated
    protected static Frame generate_enum_only(int numCols, int numRows, int num_factor, double missingfrac, long seed) {
        return TestUtil.generateEnumOnly(numCols, numRows, num_factor, missingfrac, seed);
    }

    protected static Frame generateEnumOnly(int numCols, int numRows, int num_factor, double missingfrac, long seed) {
        CreateFrame cf = new CreateFrame();
        cf.rows = numRows;
        cf.cols = numCols;
        cf.factors = num_factor;
        cf.binary_fraction = 0.0;
        cf.integer_fraction = 0.0;
        cf.categorical_fraction = 1.0;
        cf.has_response = false;
        cf.missing_fraction = missingfrac;
        cf.seed = seed;
        System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + cf.seed);
        return (Frame)cf.execImpl().get();
    }

    @Deprecated
    protected static Frame generate_real_only(int numCols, int numRows, double missingfrac) {
        return TestUtil.generateRealOnly(numCols, numRows, missingfrac);
    }

    protected static Frame generateRealOnly(int numCols, int numRows, double missingfrac) {
        long seed = System.currentTimeMillis();
        System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + seed);
        return TestUtil.generateRealOnly(numCols, numRows, missingfrac, seed);
    }

    @Deprecated
    protected static Frame generate_real_only(int numCols, int numRows, double missingfrac, long seed) {
        return TestUtil.generateRealOnly(numCols, numRows, missingfrac, seed);
    }

    protected static Frame generateRealOnly(int numCols, int numRows, double missingfrac, long seed) {
        return TestUtil.generateRealWithRangeOnly(numCols, numRows, missingfrac, seed, 100L);
    }

    protected static Frame generateRealWithRangeOnly(int numCols, int numRows, double missingfrac, long seed, long range) {
        CreateFrame cf = new CreateFrame();
        cf.rows = numRows;
        cf.cols = numCols;
        cf.binary_fraction = 0.0;
        cf.integer_fraction = 0.0;
        cf.categorical_fraction = 0.0;
        cf.time_fraction = 0.0;
        cf.string_fraction = 0.0;
        cf.has_response = false;
        cf.missing_fraction = missingfrac;
        cf.real_range = range;
        cf.seed = seed;
        System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + cf.seed + " range: " + range);
        return (Frame)cf.execImpl().get();
    }

    @Deprecated
    protected static Frame generate_int_only(int numCols, int numRows, int integer_range, double missingfrac) {
        return TestUtil.generateIntOnly(numCols, numRows, integer_range, missingfrac);
    }

    protected static Frame generateIntOnly(int numCols, int numRows, int integer_range, double missingfrac) {
        long seed = System.currentTimeMillis();
        System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + seed);
        return TestUtil.generateIntOnly(numCols, numRows, integer_range, missingfrac, seed);
    }

    @Deprecated
    protected static Frame generate_int_only(int numCols, int numRows, int integer_range, double missingfrac, long seed) {
        return TestUtil.generateIntOnly(numCols, numRows, integer_range, missingfrac, seed);
    }

    protected static Frame generateIntOnly(int numCols, int numRows, int integerRange, double missingfrac, long seed) {
        CreateFrame cf = new CreateFrame();
        cf.rows = numRows;
        cf.cols = numCols;
        cf.binary_fraction = 0.0;
        cf.integer_fraction = 1.0;
        cf.categorical_fraction = 0.0;
        cf.time_fraction = 0.0;
        cf.string_fraction = 0.0;
        cf.has_response = false;
        cf.missing_fraction = missingfrac;
        cf.integer_range = integerRange;
        cf.seed = seed;
        System.out.println("Createframe parameters: rows: " + numRows + " cols:" + numCols + " seed: " + cf.seed);
        return (Frame)cf.execImpl().get();
    }

    protected static int[] rangeFun(int numEle, int offset) {
        int[] ranges = new int[numEle];
        for (int index = 0; index < numEle; ++index) {
            ranges[index] = index + offset;
        }
        return ranges;
    }

    protected static int[] sortDir(int numEle, Random rand) {
        int[] sortDir = new int[numEle];
        int[] dirs = new int[]{-1, 1};
        for (int index = 0; index < numEle; ++index) {
            sortDir[index] = dirs[rand.nextInt(2)];
        }
        return sortDir;
    }

    public static void assertIdenticalUpToRelTolerance(Frame fr1, Frame fr2, double epsilon) {
        TestUtil.assertIdenticalUpToRelTolerance(fr1, fr2, epsilon, true, "");
    }

    public static void assertIdenticalUpToRelTolerance(Frame fr1, Frame fr2, double epsilon, String messagePrefix) {
        TestUtil.assertIdenticalUpToRelTolerance(fr1, fr2, epsilon, true, messagePrefix);
    }

    public static void assertIdenticalUpToRelTolerance(Frame fr1, Frame fr2, double epsilon, boolean expected) {
        TestUtil.assertIdenticalUpToRelTolerance(fr1, fr2, epsilon, expected, "");
    }

    public static void assertIdenticalUpToRelTolerance(Frame fr1, Frame fr2, double epsilon, boolean expected, String messagePrefix) {
        if (fr1 == fr2) {
            return;
        }
        if (expected) {
            Assert.assertEquals((String)"Number of columns differ.", (long)fr1.numCols(), (long)fr2.numCols());
            Assert.assertEquals((String)"Number of rows differ.", (long)fr1.numRows(), (long)fr2.numRows());
        } else if (fr1.numCols() != fr2.numCols() || fr1.numRows() != fr2.numRows()) {
            return;
        }
        Scope.enter();
        if (!fr1.isCompatible(fr2)) {
            fr1.makeCompatible(fr2);
        }
        Cmp1 cmp = (Cmp1)new Cmp1(epsilon, messagePrefix).doAll(new Frame(fr1).add(fr2));
        Scope.exit((Key[])new Key[0]);
        Assert.assertTrue((String)cmp._message, (expected == !cmp._unequal ? 1 : 0) != 0);
    }

    public static void assertBitIdentical(Frame fr1, Frame fr2) {
        TestUtil.assertIdenticalUpToRelTolerance(fr1, fr2, 0.0);
    }

    static File[] contentsOf(String name, File folder) {
        try {
            return FileUtils.contentsOf((File)folder, (String)name);
        }
        catch (IOException ioe) {
            Assert.fail((String)ioe.getMessage());
            return null;
        }
    }

    @Deprecated
    public static Frame parse_test_file(String fname) {
        return TestUtil.parseTestFile(fname);
    }

    @Deprecated
    public static Frame parse_test_file(String fname, int[] skipped_columns) {
        return TestUtil.parseTestFile(fname, skipped_columns);
    }

    public static Frame parseTestFile(String fname) {
        return TestUtil.parseTestFile(Key.make(), fname);
    }

    public static Frame parseTestFile(String fname, int[] skipped_columns) {
        return TestUtil.parseTestFile(Key.make(), fname, skipped_columns);
    }

    public static Frame parseAndTrackTestFile(String fname) {
        return Scope.track((Frame[])new Frame[]{TestUtil.parseTestFile(Key.make(), fname)});
    }

    public static Frame ensureDistributed(Frame frame) {
        int minChunks = H2O.getCloudSize() * 4;
        return TestUtil.ensureDistributed(frame, minChunks);
    }

    public static Frame ensureDistributed(Frame frame, int minChunks) {
        if (frame.anyVec().nChunks() < minChunks) {
            Key k = Key.make();
            ((RebalanceDataSet)H2O.submitTask((H2O.H2OCountedCompleter)new RebalanceDataSet(frame, k, minChunks))).join();
            frame = TestUtil.trackIfScopeActive((Frame)k.get());
        }
        if (H2O.CLOUD.size() > 1) {
            Vec v = frame.anyVec();
            H2ONode node = null;
            for (int i = 0; i < v.nChunks(); ++i) {
                H2ONode cNode = v.chunkKey(i).home_node();
                if (v.chunkLen(i) == 0) continue;
                if (node == null) {
                    node = cNode;
                    continue;
                }
                if (cNode == node) continue;
                return frame;
            }
            throw new IllegalStateException("Frame is only stored on a sigle node");
        }
        return frame;
    }

    static Frame trackIfScopeActive(Frame frame) {
        if (Scope.isActive()) {
            Scope.track((Frame[])new Frame[]{frame});
        }
        return frame;
    }

    public static NFSFileVec makeNfsFileVec(String fname) {
        try {
            long lastModified;
            File file = FileUtils.locateFile((String)fname);
            if (file == null && (TestUtil.isCI() || TestUtil.runWithoutLocalFiles()) && (lastModified = TestUtil.downloadTestFileFromS3(fname)) != 0L && TestUtil.isCI() && System.currentTimeMillis() - lastModified > 2592000000L) {
                throw new IllegalStateException("File '" + fname + "' is still not locally synchronized (more than 30 days). Talk to #devops-requests");
            }
            return NFSFileVec.make((String)fname);
        }
        catch (IOException ioe) {
            Log.err((Object[])new Object[]{ioe});
            Assert.fail((String)ioe.getMessage());
            return null;
        }
    }

    private static boolean runWithoutLocalFiles() {
        return Boolean.parseBoolean(System.getenv("H2O_JUNIT_ALLOW_NO_SMALLDATA"));
    }

    protected static long downloadTestFileFromS3(String fname) throws IOException {
        File f;
        if (fname.startsWith("./")) {
            fname = fname.substring(2);
        }
        if (!(f = new File(fname)).exists()) {
            boolean dirsCreated;
            if (f.getParentFile() != null && !(dirsCreated = f.getParentFile().mkdirs())) {
                Log.warn((Object[])new Object[]{"Failed to create directory:" + f.getParentFile()});
            }
            File tmpFile = File.createTempFile(f.getName(), "tmp", f.getParentFile());
            URL source = new URL("https://h2o-public-test-data.s3.amazonaws.com/" + fname);
            URLConnection connection = source.openConnection();
            connection.setConnectTimeout(1000);
            connection.setReadTimeout(2000);
            long lastModified = connection.getLastModified();
            try (InputStream stream = connection.getInputStream();){
                org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)stream, (File)tmpFile);
            }
            if (tmpFile.renameTo(f)) {
                return lastModified;
            }
            Log.warn((Object[])new Object[]{"Couldn't download " + fname + " from S3."});
        }
        return 0L;
    }

    @Deprecated
    protected Frame parse_test_file(Key outputKey, String fname, boolean guessSetup) {
        return this.parseTestFile(outputKey, fname, guessSetup);
    }

    protected Frame parseTestFile(Key outputKey, String fname, boolean guessSetup) {
        return this.parseTestFile(outputKey, fname, guessSetup, null);
    }

    @Deprecated
    protected Frame parse_test_file(Key outputKey, String fname, boolean guessSetup, int[] skippedColumns) {
        return this.parseTestFile(outputKey, fname, guessSetup, skippedColumns);
    }

    protected Frame parseTestFile(Key outputKey, String fname, boolean guessSetup, int[] skippedColumns) {
        NFSFileVec nfs = TestUtil.makeNfsFileVec(fname);
        ParseSetup guessParseSetup = ParseSetup.guessSetup((Key[])new Key[]{nfs._key}, (boolean)false, (int)1);
        if (skippedColumns != null) {
            guessParseSetup.setSkippedColumns(skippedColumns);
            guessParseSetup.setParseColumnIndices(guessParseSetup.getNumberColumns(), skippedColumns);
        }
        return ParseDataset.parse((Key)outputKey, (Key[])new Key[]{nfs._key}, (boolean)true, (ParseSetup)ParseSetup.guessSetup((Key[])new Key[]{nfs._key}, (boolean)false, (int)1));
    }

    @Deprecated
    protected Frame parse_test_file(Key outputKey, String fname) {
        return TestUtil.parseTestFile(outputKey, fname);
    }

    public static Frame parseTestFile(Key outputKey, String fname) {
        return TestUtil.parseTestFile(outputKey, fname, new int[0]);
    }

    @Deprecated
    protected Frame parse_test_file(Key outputKey, String fname, int[] skippedColumns) {
        return TestUtil.parseTestFile(outputKey, fname, skippedColumns);
    }

    public static Frame parseTestFile(Key outputKey, String fname, int[] skippedColumns) {
        return TestUtil.parseTestFile(outputKey, fname, null, skippedColumns);
    }

    @Deprecated
    protected Frame parse_test_file(String fname, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFile(fname, transformer);
    }

    public static Frame parseTestFile(String fname, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFile(Key.make(), fname, transformer);
    }

    @Deprecated
    protected Frame parse_test_file(String fname, ParseSetupTransformer transformer, int[] skippedColumns) {
        return TestUtil.parseTestFile(fname, transformer, skippedColumns);
    }

    public static Frame parseTestFile(String fname, ParseSetupTransformer transformer, int[] skippedColumns) {
        return TestUtil.parseTestFile(Key.make(), fname, transformer, skippedColumns);
    }

    @Deprecated
    protected Frame parse_test_file(Key outputKey, String fname, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFile(outputKey, fname, transformer);
    }

    public static Frame parseTestFile(Key outputKey, String fname, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFile(outputKey, fname, transformer, null);
    }

    @Deprecated
    protected Frame parse_test_file(Key outputKey, String fname, ParseSetupTransformer transformer, int[] skippedColumns) {
        return TestUtil.parseTestFile(outputKey, fname, transformer, skippedColumns);
    }

    public static Frame parseTestFile(Key outputKey, String fname, ParseSetupTransformer transformer, int[] skippedColumns) {
        NFSFileVec nfs = TestUtil.makeNfsFileVec(fname);
        ParseSetup guessedSetup = ParseSetup.guessSetup((Key[])new Key[]{nfs._key}, (boolean)false, (int)0);
        if (skippedColumns != null) {
            guessedSetup.setSkippedColumns(skippedColumns);
            guessedSetup.setParseColumnIndices(guessedSetup.getNumberColumns(), skippedColumns);
        }
        if (transformer != null) {
            guessedSetup = transformer.transformSetup(guessedSetup);
        }
        return ParseDataset.parse((Key)outputKey, (Key[])new Key[]{nfs._key}, (boolean)true, (ParseSetup)guessedSetup);
    }

    public static Frame parseTestFile(Key outputKey, String fname, ParseSetupTransformer transformer, int[] skippedColumns, int psetup) {
        NFSFileVec nfs = TestUtil.makeNfsFileVec(fname);
        ParseSetup guessedSetup = ParseSetup.guessSetup((Key[])new Key[]{nfs._key}, (boolean)false, (int)psetup);
        if (skippedColumns != null) {
            guessedSetup.setSkippedColumns(skippedColumns);
            guessedSetup.setParseColumnIndices(guessedSetup.getNumberColumns(), skippedColumns);
        }
        if (transformer != null) {
            guessedSetup = transformer.transformSetup(guessedSetup);
        }
        return ParseDataset.parse((Key)outputKey, (Key[])new Key[]{nfs._key}, (boolean)true, (ParseSetup)guessedSetup);
    }

    @Deprecated
    protected Frame parse_test_file(String fname, String na_string, int check_header, byte[] column_types) {
        return TestUtil.parseTestFile(fname, na_string, check_header, column_types);
    }

    public static Frame parseTestFile(String fname, String na_string, int check_header, byte[] column_types) {
        return TestUtil.parseTestFile(fname, na_string, check_header, column_types, null, null);
    }

    @Deprecated
    protected Frame parse_test_file(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFile(fname, na_string, check_header, column_types, transformer);
    }

    public static Frame parseTestFile(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFile(fname, na_string, check_header, column_types, transformer, null);
    }

    @Deprecated
    protected Frame parse_test_file(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer, int[] skippedColumns) {
        return TestUtil.parseTestFile(fname, na_string, check_header, column_types, transformer, skippedColumns);
    }

    public static Frame parseTestFile(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer, int[] skippedColumns) {
        NFSFileVec nfs = TestUtil.makeNfsFileVec(fname);
        Key[] res = new Key[]{nfs._key};
        ParseSetup p = ParseSetup.guessSetup((Key[])res, (ParseSetup)new ParseSetup(DefaultParserProviders.GUESS_INFO, 44, false, check_header, 0, null, null, (String[][])null, (String[][])null, (String[][])null, null, null));
        if (skippedColumns != null) {
            p.setSkippedColumns(skippedColumns);
            p.setParseColumnIndices(p.getNumberColumns(), skippedColumns);
        }
        if (na_string != null) {
            int column_number = p.getColumnTypes().length;
            int na_length = na_string.length() - 1;
            String[][] na_strings = new String[column_number][na_length + 1];
            for (int index = 0; index < column_number; ++index) {
                na_strings[index][na_length] = na_string;
            }
            p.setNAStrings(na_strings);
        }
        if (column_types != null) {
            p.setColumnTypes(column_types);
        }
        if (transformer != null) {
            p = transformer.transformSetup(p);
        }
        return ParseDataset.parse((Key)Key.make(), (Key[])res, (boolean)true, (ParseSetup)p);
    }

    @Deprecated
    protected Frame parse_test_folder(String fname) {
        return this.parseTestFolder(fname);
    }

    protected Frame parseTestFolder(String fname) {
        return this.parseTestFolder(fname, null);
    }

    @Deprecated
    protected Frame parse_test_folder(String fname, int[] skippedColumns) {
        return this.parseTestFolder(fname, skippedColumns);
    }

    protected Frame parseTestFolder(String fname, int[] skippedColumns) {
        File folder = FileUtils.locateFile((String)fname);
        Object[] files = TestUtil.contentsOf(fname, folder);
        Arrays.sort(files);
        ArrayList<Key> keys = new ArrayList<Key>();
        for (Object f : files) {
            if (!((File)f).isFile()) continue;
            keys.add(NFSFileVec.make((File)f)._key);
        }
        Key[] res = new Key[keys.size()];
        keys.toArray(res);
        return ParseDataset.parse((int[])skippedColumns, (Key)Key.make(), (Key[])res);
    }

    @Deprecated
    protected Frame parse_test_folder(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFolder(fname, na_string, check_header, column_types, transformer);
    }

    protected static Frame parseTestFolder(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer) {
        return TestUtil.parseTestFolder(fname, na_string, check_header, column_types, transformer, null);
    }

    @Deprecated
    protected Frame parse_test_folder(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer, int[] skipped_columns) {
        return TestUtil.parseTestFolder(fname, na_string, check_header, column_types, transformer, skipped_columns);
    }

    protected static Frame parseTestFolder(String fname, String na_string, int check_header, byte[] column_types, ParseSetupTransformer transformer, int[] skipped_columns) {
        File folder = FileUtils.locateFile((String)fname);
        Object[] files = TestUtil.contentsOf(fname, folder);
        Arrays.sort(files);
        ArrayList<Key> keys = new ArrayList<Key>();
        for (Object f : files) {
            if (!((File)f).isFile()) continue;
            keys.add(NFSFileVec.make((File)f)._key);
        }
        Key[] res = new Key[keys.size()];
        keys.toArray(res);
        ParseSetup p = ParseSetup.guessSetup((Key[])res, (ParseSetup)new ParseSetup(DefaultParserProviders.GUESS_INFO, 44, true, check_header, 0, null, null, (String[][])null, (String[][])null, (String[][])null, null, null));
        if (skipped_columns != null) {
            p.setSkippedColumns(skipped_columns);
            p.setParseColumnIndices(p.getNumberColumns(), skipped_columns);
        }
        if (na_string != null) {
            int column_number = p.getColumnTypes().length;
            int na_length = na_string.length() - 1;
            String[][] na_strings = new String[column_number][na_length + 1];
            for (int index = 0; index < column_number; ++index) {
                na_strings[index][na_length] = na_string;
            }
            p.setNAStrings(na_strings);
        }
        if (column_types != null) {
            p.setColumnTypes(column_types);
        }
        if (transformer != null) {
            p = transformer.transformSetup(p);
        }
        return ParseDataset.parse((Key)Key.make(), (Key[])res, (boolean)true, (ParseSetup)p);
    }

    public static Frames split(Frame f) {
        return TestUtil.split(f, 0.9, 0.0);
    }

    public static Frames split(Frame f, double testFraction) {
        return TestUtil.split(f, testFraction, 0.0);
    }

    public static Frames split(Frame f, double testFraction, double validFraction) {
        double trainFraction = 1.0 - testFraction - validFraction;
        double[] fractions = validFraction > 0.0 ? new double[]{trainFraction, testFraction, validFraction} : new double[]{trainFraction, testFraction};
        SplitFrame sf = new SplitFrame(f, fractions, null);
        sf.exec().get();
        Key[] splitKeys = sf._destination_frames;
        Frame trainFrame = Scope.track((Frame[])new Frame[]{(Frame)splitKeys[0].get()});
        Frame testFrame = Scope.track((Frame[])new Frame[]{(Frame)splitKeys[1].get()});
        Frame validFrame = validFraction > 0.0 ? Scope.track((Frame[])new Frame[]{(Frame)splitKeys[2].get()}) : null;
        return new Frames(trainFrame, testFrame, validFrame);
    }

    public static Vec vec(int ... rows) {
        return TestUtil.vec(null, rows);
    }

    public static Vec vec(String[] domain, int ... rows) {
        Key k = Vec.VectorGroup.VG_LEN1.addVec();
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k, 3);
        avec.setDomain(domain);
        NewChunk chunk = new NewChunk((Vec)avec, 0);
        for (int r : rows) {
            chunk.addNum((double)r);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public static Vec ivec(int ... rows) {
        return TestUtil.vec(null, rows);
    }

    public static Vec cvec(String ... rows) {
        return TestUtil.cvec(null, rows);
    }

    public static Vec cvec(String[] domain, String ... rows) {
        HashMap<String, Integer> domainMap = new HashMap<String, Integer>(10);
        ArrayList<String> domainList = new ArrayList<String>(10);
        if (domain != null) {
            int j = 0;
            for (String s : domain) {
                domainMap.put(s, j++);
                domainList.add(s);
            }
        }
        int[] irows = new int[rows.length];
        int j = 0;
        for (int i = 0; i < rows.length; ++i) {
            String s = rows[i];
            if (!domainMap.containsKey(s)) {
                domainMap.put(s, j++);
                domainList.add(s);
            }
            irows[i] = (Integer)domainMap.get(s);
        }
        return TestUtil.vec(domainList.toArray(new String[0]), irows);
    }

    public static Vec dvec(double ... rows) {
        Key k = Vec.VectorGroup.VG_LEN1.addVec();
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k, 3);
        NewChunk chunk = new NewChunk((Vec)avec, 0);
        for (double r : rows) {
            chunk.addNum(r);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public static Vec tvec(int ... rows) {
        Key k = Vec.VectorGroup.VG_LEN1.addVec();
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k, 5);
        NewChunk chunk = new NewChunk((Vec)avec, 0);
        for (int r : rows) {
            chunk.addNum((double)r);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public static Vec svec(String ... rows) {
        Key k = Vec.VectorGroup.VG_LEN1.addVec();
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k, 2);
        NewChunk chunk = new NewChunk((Vec)avec, 0);
        for (String r : rows) {
            chunk.addStr((Object)r);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public static Vec uvec(UUID ... rows) {
        Key k = Vec.VectorGroup.VG_LEN1.addVec();
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k, 1);
        NewChunk chunk = new NewChunk((Vec)avec, 0);
        for (UUID r : rows) {
            chunk.addUUID(r);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public static String[] ar(String ... a) {
        return a;
    }

    public static String[][] ar(String[] ... a) {
        return a;
    }

    public static byte[] ar(byte ... a) {
        return a;
    }

    public static long[] ar(long ... a) {
        return a;
    }

    public static long[][] ar(long[] ... a) {
        return a;
    }

    public static int[] ari(int ... a) {
        return a;
    }

    public static int[][] ar(int[] ... a) {
        return a;
    }

    public static float[] arf(float ... a) {
        return a;
    }

    public static double[] ard(double ... a) {
        return a;
    }

    public static double[][] ard(double[] ... a) {
        return a;
    }

    public static double[][] ear(double ... a) {
        double[][] r = new double[a.length][1];
        for (int i = 0; i < a.length; ++i) {
            r[i][0] = a[i];
        }
        return r;
    }

    public static <T> T[] aro(T ... a) {
        return a;
    }

    public static void assertFrameEquals(Frame expected, Frame actual, double absDelta) {
        TestUtil.assertFrameEquals(expected, actual, absDelta, null);
    }

    public static void assertFrameEquals(Frame expected, Frame actual, Double absDelta, Double relativeDelta) {
        Assert.assertEquals((String)"Frames have different number of vecs. ", (long)expected.vecs().length, (long)actual.vecs().length);
        for (int i = 0; i < expected.vecs().length; ++i) {
            if (expected.vec(i).isString()) {
                TestUtil.assertStringVecEquals(expected.vec(i), actual.vec(i));
                continue;
            }
            TestUtil.assertVecEquals(i + "/" + expected._names[i] + " ", expected.vec(i), actual.vec(i), absDelta, relativeDelta);
        }
    }

    public static void assertVecEquals(Vec expecteds, Vec actuals, double delta) {
        TestUtil.assertVecEquals("", expecteds, actuals, delta);
    }

    public static void assertVecEquals(Vec expecteds, Vec actuals, double delta, double relativeDelta) {
        TestUtil.assertVecEquals("", expecteds, actuals, delta, relativeDelta);
    }

    public static void assertVecEquals(String messagePrefix, Vec expecteds, Vec actuals, double delta) {
        TestUtil.assertVecEquals(messagePrefix, expecteds, actuals, delta, null);
    }

    public static void assertVecEquals(String messagePrefix, Vec expecteds, Vec actuals, Double absDelta, Double relativeDelta) {
        Assert.assertEquals((long)expecteds.length(), (long)actuals.length());
        int i = 0;
        while ((long)i < expecteds.length()) {
            String message = messagePrefix + i + ": " + expecteds.at((long)i) + " != " + actuals.at((long)i) + ", chunkIds = " + expecteds.elem2ChunkIdx((long)i) + ", " + actuals.elem2ChunkIdx((long)i) + ", row in chunks = " + ((long)i - expecteds.chunkForRow((long)i).start()) + ", " + ((long)i - actuals.chunkForRow((long)i).start());
            double expectedVal = expecteds.at((long)i);
            double actualVal = actuals.at((long)i);
            Assert.assertEquals((String)message, (double)expectedVal, (double)actualVal, (double)TestUtil.computeAssertionDelta(expectedVal, absDelta, relativeDelta));
            ++i;
        }
    }

    private static double computeAssertionDelta(double expectedVal, Double absDelta, Double relDelta) {
        if ((absDelta == null || absDelta.isNaN()) && (relDelta == null || relDelta.isNaN())) {
            throw new IllegalArgumentException("Either absolute or relative delta has to be non-null and non-NaN");
        }
        if (relDelta == null || relDelta.isNaN()) {
            return absDelta;
        }
        double deltaBase = Math.abs(expectedVal);
        double computedRelativeDelta = deltaBase == 0.0 ? relDelta : deltaBase * relDelta;
        if (absDelta == null || absDelta.isNaN()) {
            return computedRelativeDelta;
        }
        return Math.max(computedRelativeDelta, absDelta);
    }

    public static void assertUUIDVecEquals(Vec expecteds, Vec actuals) {
        Assert.assertEquals((long)expecteds.length(), (long)actuals.length());
        Assert.assertEquals((String)"Vec types match", (Object)expecteds.get_type_str(), (Object)actuals.get_type_str());
        int i = 0;
        while ((long)i < expecteds.length()) {
            UUID expected = new UUID(expecteds.at16l((long)i), expecteds.at16h((long)i));
            UUID actual = new UUID(actuals.at16l((long)i), actuals.at16h((long)i));
            String message = i + ": " + expected + " != " + actual + ", chunkIds = " + expecteds.elem2ChunkIdx((long)i) + ", " + actuals.elem2ChunkIdx((long)i) + ", row in chunks = " + ((long)i - expecteds.chunkForRow((long)i).start()) + ", " + ((long)i - actuals.chunkForRow((long)i).start());
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
            ++i;
        }
    }

    private static String toStr(BufferedString bs) {
        return bs != null ? bs.toString() : null;
    }

    public static void assertStringVecEquals(Vec expecteds, Vec actuals) {
        Assert.assertEquals((long)expecteds.length(), (long)actuals.length());
        Assert.assertEquals((String)"Vec types match", (Object)expecteds.get_type_str(), (Object)actuals.get_type_str());
        int i = 0;
        while ((long)i < expecteds.length()) {
            String expected = TestUtil.toStr(expecteds.atStr(new BufferedString(), (long)i));
            String actual = TestUtil.toStr(actuals.atStr(new BufferedString(), (long)i));
            String message = i + ": " + expected + " != " + actual + ", chunkIds = " + expecteds.elem2ChunkIdx((long)i) + ", " + actuals.elem2ChunkIdx((long)i) + ", row in chunks = " + ((long)i - expecteds.chunkForRow((long)i).start()) + ", " + ((long)i - actuals.chunkForRow((long)i).start());
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
            ++i;
        }
    }

    private static String getFactorAsString(Vec v, long row) {
        return v.isNA(row) ? null : v.factor((long)v.at(row));
    }

    public static void assertCatVecEquals(Vec expecteds, Vec actuals) {
        Assert.assertEquals((long)expecteds.length(), (long)actuals.length());
        Assert.assertEquals((String)"Vec types match", (Object)expecteds.get_type_str(), (Object)actuals.get_type_str());
        int i = 0;
        while ((long)i < expecteds.length()) {
            String expected = TestUtil.getFactorAsString(expecteds, i);
            String actual = TestUtil.getFactorAsString(actuals, i);
            String message = i + ": " + expected + " != " + actual + ", chunkIds = " + expecteds.elem2ChunkIdx((long)i) + ", " + actuals.elem2ChunkIdx((long)i) + ", row in chunks = " + ((long)i - expecteds.chunkForRow((long)i).start()) + ", " + ((long)i - actuals.chunkForRow((long)i).start());
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
            ++i;
        }
    }

    public static void assertTwoDimTableEquals(TwoDimTable expected, TwoDimTable actual) {
        Assert.assertEquals((String)"tableHeader different", (Object)expected.getTableHeader(), (Object)actual.getTableHeader());
        Assert.assertEquals((String)"tableDescriptionDifferent", (Object)expected.getTableDescription(), (Object)actual.getTableDescription());
        Assert.assertArrayEquals((String)"rowHeaders different", (Object[])expected.getRowHeaders(), (Object[])actual.getRowHeaders());
        Assert.assertArrayEquals((String)"colHeaders different", (Object[])expected.getColHeaders(), (Object[])actual.getColHeaders());
        Assert.assertArrayEquals((String)"colTypes different", (Object[])expected.getColTypes(), (Object[])actual.getColTypes());
        Assert.assertArrayEquals((String)"colFormats different", (Object[])expected.getColFormats(), (Object[])actual.getColFormats());
        Assert.assertEquals((String)"colHeaderForRowHeaders different", (Object)expected.getColHeaderForRowHeaders(), (Object)actual.getColHeaderForRowHeaders());
        for (int r = 0; r < expected.getRowDim(); ++r) {
            for (int c = 0; c < expected.getColDim(); ++c) {
                Object ex = expected.get(r, c);
                Object act = actual.get(r, c);
                Assert.assertEquals((String)("cellValues different at row " + r + ", col " + c), (Object)ex, (Object)act);
            }
        }
    }

    public static void checkStddev(double[] expected, double[] actual, double threshold) {
        for (int i = 0; i < actual.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)actual[i], (double)threshold);
        }
    }

    public static void checkIcedArrays(IcedWrapper[][] expected, IcedWrapper[][] actual, double threshold) {
        for (int i = 0; i < actual.length; ++i) {
            for (int j = 0; j < actual[0].length; ++j) {
                Assert.assertEquals((double)expected[i][j].d, (double)actual[i][j].d, (double)threshold);
            }
        }
    }

    public static boolean[] checkEigvec(double[][] expected, double[][] actual, double threshold) {
        int nfeat = actual.length;
        int ncomp = actual[0].length;
        boolean[] flipped = new boolean[ncomp];
        for (int j = 0; j < ncomp; ++j) {
            flipped[j] = Math.abs(expected[0][j] - actual[0][j]) > Math.abs(expected[0][j] + actual[0][j]);
            for (int i = 0; i < nfeat; ++i) {
                Assert.assertEquals((double)expected[i][j], (double)(flipped[j] ? -actual[i][j] : actual[i][j]), (double)threshold);
            }
        }
        return flipped;
    }

    public static boolean[] checkEigvec(double[][] expected, TwoDimTable actual, double threshold) {
        int nfeat = actual.getRowDim();
        int ncomp = actual.getColDim();
        boolean[] flipped = new boolean[ncomp];
        for (int j = 0; j < ncomp; ++j) {
            flipped[j] = Math.abs(expected[0][j] - (Double)actual.get(0, j)) > threshold;
            for (int i = 0; i < nfeat; ++i) {
                Assert.assertEquals((double)expected[i][j], (double)(flipped[j] ? -((Double)actual.get(i, j)).doubleValue() : (Double)actual.get(i, j)), (double)threshold);
            }
        }
        return flipped;
    }

    public static boolean equalTwoArrays(double[] array1, double[] array2, double tol) {
        assert (array1.length == array2.length) : "Arrays have different lengths";
        for (int index = 0; index < array1.length; ++index) {
            if (!(Math.abs(array1[index] - array2[index]) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalTwoHashMaps(HashMap<String, Double> coeff1, HashMap<String, Double> coeff2, double tol) {
        assert (coeff1.size() == coeff2.size()) : "HashMap sizes are differenbt";
        for (String key : coeff1.keySet()) {
            if (!(Math.abs(coeff1.get(key) - coeff2.get(key)) > tol)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalTwoDimTables(TwoDimTable tab1, TwoDimTable tab2, double tol) {
        boolean same = true;
        same = Arrays.equals(tab1.getColHeaders(), tab2.getColHeaders()) && Arrays.equals(tab1.getColTypes(), tab2.getColTypes());
        String[] colTypes = tab2.getColTypes();
        IcedWrapper[][] cellValues1 = tab1.getCellValues();
        IcedWrapper[][] cellValues2 = tab2.getCellValues();
        boolean bl = same = same && cellValues1.length == cellValues2.length;
        if (!same) {
            return false;
        }
        for (int cindex = 0; cindex < cellValues1.length; ++cindex) {
            boolean bl2 = same = same && cellValues1[cindex].length == cellValues2[cindex].length;
            if (!same) {
                return false;
            }
            for (int index = 0; index < cellValues1[cindex].length; ++index) {
                same = colTypes[index].equals("double") ? same && Math.abs(Double.parseDouble(cellValues1[cindex][index].toString()) - Double.parseDouble(cellValues2[cindex][index].toString())) < tol : same && cellValues1[cindex][index].toString().equals(cellValues2[cindex][index].toString());
            }
        }
        return same;
    }

    public static boolean[] checkEigvec(TwoDimTable expected, TwoDimTable actual, double threshold) {
        int i;
        int j;
        int nfeat = actual.getRowDim();
        int ncomp = actual.getColDim();
        boolean[] flipped = new boolean[ncomp];
        block0: for (j = 0; j < ncomp; ++j) {
            for (i = 0; i < nfeat; ++i) {
                if (!(Math.abs((Double)expected.get(i, j)) > 0.0) || !(Math.abs((Double)actual.get(i, j)) > 0.0)) continue;
                flipped[j] = Math.signum((Double)expected.get(i, j)) != Math.signum((Double)actual.get(i, j));
                continue block0;
            }
        }
        for (j = 0; j < ncomp; ++j) {
            for (i = 0; i < nfeat; ++i) {
                Assert.assertEquals((double)((Double)expected.get(i, j)), (double)(flipped[j] ? -((Double)actual.get(i, j)).doubleValue() : (Double)actual.get(i, j)), (double)threshold);
            }
        }
        return flipped;
    }

    public static boolean[] checkProjection(Frame expected, Frame actual, double threshold, boolean[] flipped) {
        Assert.assertEquals((String)"Number of columns", (long)expected.numCols(), (long)actual.numCols());
        Assert.assertEquals((String)"Number of columns in flipped", (long)expected.numCols(), (long)flipped.length);
        int nfeat = (int)expected.numRows();
        int ncomp = expected.numCols();
        for (int j = 0; j < ncomp; ++j) {
            Vec.Reader vexp = new Vec.Reader(expected.vec(j));
            Vec.Reader vact = new Vec.Reader(actual.vec(j));
            Assert.assertEquals((long)vexp.length(), (long)vact.length());
            for (int i = 0; i < nfeat; ++i) {
                if (vexp.isNA((long)i) || vact.isNA((long)i)) continue;
                Assert.assertEquals((double)vexp.at8((long)i), (double)(flipped[j] ? (double)(-vact.at8((long)i)) : (double)vact.at8((long)i)), (double)threshold);
            }
        }
        return flipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        H2O.main((String[])new String[0]);
        for (String arg : args) {
            try {
                System.out.println("=== Starting " + arg);
                Class<?> clz = Class.forName(arg);
                Method main = clz.getDeclaredMethod("main", new Class[0]);
                main.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ite) {
                Throwable e = ite.getCause();
                e.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                System.out.println("=== Stopping " + arg);
            }
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (args.length != 0) {
            UDPRebooted.T.shutdown.send(H2O.SELF);
        }
    }

    public static void assertFrameAssertion(FrameAssertion frameAssertion) {
        int[] dim = frameAssertion.dim;
        Frame frame = null;
        try {
            frame = frameAssertion.prepare();
            Assert.assertEquals((String)"Frame has to have expected number of columns", (long)dim[0], (long)frame.numCols());
            Assert.assertEquals((String)"Frame has to have expected number of rows", (long)dim[1], (long)frame.numRows());
            frameAssertion.check(frame);
        }
        finally {
            frameAssertion.done(frame);
            if (frame != null) {
                frame.delete();
            }
        }
    }

    public static Frame asFactor(Frame frame, String columnName) {
        Vec vec = frame.vec(columnName);
        frame.replace(frame.find(columnName), vec.toCategoricalVec());
        vec.remove();
        DKV.put((Keyed)frame);
        return frame;
    }

    public static void printOutFrameAsTable(Frame fr) {
        TestUtil.printOutFrameAsTable(fr, false, fr.numRows());
    }

    public static void printOutFrameAsTable(Frame fr, boolean rollups, long limit) {
        assert (limit <= Integer.MAX_VALUE);
        TwoDimTable twoDimTable = fr.toTwoDimTable(0L, (int)limit, rollups);
        System.out.println(twoDimTable.toString(2, true));
    }

    public void printOutColumnsMetadata(Frame fr) {
        for (String header : fr.toTwoDimTable().getColHeaders()) {
            String type = fr.vec(header).get_type_str();
            int cardinality = fr.vec(header).cardinality();
            System.out.println(header + " - " + type + String.format("; Cardinality = %d", cardinality));
        }
    }

    protected static RowData toRowData(Frame fr, String[] columns, long row) {
        RowData rd = new RowData();
        for (String col : columns) {
            Vec v = fr.vec(col);
            if (!v.isNumeric() && !v.isCategorical()) {
                throw new UnsupportedOperationException("Unsupported column type for column '" + col + "': " + v.get_type_str());
            }
            if (v.isNA(row)) continue;
            Object val = v.isCategorical() ? v.domain()[(int)v.at8(row)] : Double.valueOf(v.at(row));
            rd.put((Object)col, val);
        }
        return rd;
    }

    protected static double[] toNumericRow(Frame fr, long row) {
        double[] result = new double[fr.numCols()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = fr.vec(i).at(row);
        }
        return result;
    }

    public static boolean compareFrames(Frame f1, Frame f2, double delta) {
        return TestUtil.compareFrames(f1, f2, delta, 0.0);
    }

    public static boolean compareFrames(Frame f1, Frame f2, double delta, double relativeDelta) {
        Objects.requireNonNull(f1);
        Objects.requireNonNull(f2);
        if (f1.numCols() != f2.numCols()) {
            throw new IllegalArgumentException(String.format("Number of columns is not the same: {%o, %o}", f1.numCols(), f2.numCols()));
        }
        if (f1.numRows() != f2.numRows()) {
            throw new IllegalArgumentException(String.format("Number of rows is not the same: {%o, %o}", f1.numRows(), f2.numRows()));
        }
        for (int vecNum = 0; vecNum < f1.numCols(); ++vecNum) {
            Vec f1Vec = f1.vec(vecNum);
            Vec f2Vec = f2.vec(vecNum);
            TestUtil.assertVecEquals(f1Vec, f2Vec, delta, relativeDelta);
        }
        return true;
    }

    public static final String[] ignoredColumns(Frame frame, String ... usedColumns) {
        HashSet<String> ignored = new HashSet<String>(Arrays.asList(frame.names()));
        ignored.removeAll(Arrays.asList(usedColumns));
        return ignored.toArray(new String[ignored.size()]);
    }

    public static boolean compareFrames(Frame f1, Frame f2) throws IllegalStateException {
        return TestUtil.compareFrames(f1, f2, 0.0);
    }

    public static void setLocale(Locale locale) {
        new ChangeLocaleTsk(locale).doAllNodes();
    }

    public static void writeFrameToCSV(String fileNameWithPath, Frame h2oframe, boolean header, boolean hex_string) throws IOException {
        Frame.CSVStreamParams params = new Frame.CSVStreamParams().setHeaders(header).setHexString(hex_string);
        File targetFile = new File(fileNameWithPath);
        byte[] buffer = new byte[0x100000];
        try (InputStream frameToStream = h2oframe.toCSV(params);
             FileOutputStream outStream = new FileOutputStream(targetFile);){
            int bytesRead;
            while ((bytesRead = frameToStream.read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, bytesRead);
            }
        }
    }

    public static Vec createRandomBinaryWeightsVec(long len, long randomSeed) {
        Vec weightsVec = Vec.makeZero((long)len, (byte)3);
        RandomBase random = RandomUtils.getRNG((long[])new long[]{randomSeed});
        int i = 0;
        while ((long)i < weightsVec.length()) {
            weightsVec.set((long)i, random.nextBoolean() ? 1.0 : 0.0);
            ++i;
        }
        return weightsVec;
    }

    public static Vec createRandomDoubleVec(long len, long randomSeed) {
        Vec vec = Vec.makeZero((long)len, (byte)3);
        RandomBase random = RandomUtils.getRNG((long[])new long[]{randomSeed});
        int i = 0;
        while ((long)i < vec.length()) {
            vec.set((long)i, random.nextDouble());
            ++i;
        }
        return vec;
    }

    public static Vec createRandomCategoricalVec(long len, long randomSeed) {
        String[] domain = new String[100];
        for (int i = 0; i < domain.length; ++i) {
            domain[i] = "CAT_" + i;
        }
        Vec vec = Scope.track((Vec)Vec.makeZero((long)len, (byte)3)).makeZero(domain);
        RandomBase random = RandomUtils.getRNG((long[])new long[]{randomSeed});
        int i = 0;
        while ((long)i < vec.length()) {
            vec.set((long)i, (long)random.nextInt(domain.length));
            ++i;
        }
        return vec;
    }

    public static GenModel toMojo(Model model, String testName, boolean readModelMetaData) {
        Throwable throwable;
        block20: {
            String filename = testName + ".zip";
            StreamingSchema ss = new StreamingSchema((StreamWriter)model.getMojo(), filename);
            try {
                throwable = null;
                try (FileOutputStream os = new FileOutputStream(ss.getFilename());){
                    ss.getStreamWriter().writeTo((OutputStream)os, new StreamWriteOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("MOJO writing failed", e);
            }
            try {
                MojoReaderBackend cr = MojoReaderBackendFactory.createReaderBackend((String)filename);
                throwable = ModelMojoReader.readFrom((MojoReaderBackend)cr, (boolean)readModelMetaData);
                boolean deleted = new File(filename).delete();
                if (deleted) break block20;
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException("MOJO loading failed", e);
                }
                catch (Throwable throwable3) {
                    boolean deleted = new File(filename).delete();
                    if (!deleted) {
                        Log.warn((Object[])new Object[]{"Failed to delete the file"});
                    }
                    throw throwable3;
                }
            }
            Log.warn((Object[])new Object[]{"Failed to delete the file"});
        }
        return throwable;
    }

    public static boolean isCI() {
        return System.getProperty("user.name").equals("jenkins");
    }

    public static <T extends Keyed<T>> void assertInDKV(Key<T> key, T object) {
        Assert.assertEquals(key, (Object)object._key);
        Keyed dkvObject = (Keyed)DKV.getGet(key);
        Assert.assertNotNull((Object)dkvObject);
        Assert.assertEquals((long)object.checksum(true), (long)dkvObject.checksum(true));
    }

    public static Vec transformVec(Vec vec, final Function<Double, Double> transform) {
        new MRTask(){

            public void map(Chunk c) {
                for (int i = 0; i < c._len; ++i) {
                    if (c.isNA(i)) continue;
                    c.set(i, ((Double)transform.apply((Object)c.atd(i))).doubleValue());
                }
            }
        }.doAll(new Vec[]{vec});
        return vec;
    }

    @Deprecated
    public static void browser() {
        if (TestUtil.isCI()) {
            throw new IllegalStateException("Never leave browser() calls in committed source code - only for debugging");
        }
        File root = new File(".");
        while (!new File(root, "h2o-core").isDirectory()) {
            root = new File(root, "..");
        }
        H2O.registerResourceRoot((File)new File(root, "h2o-web/src/main/resources/www"));
        H2O.registerResourceRoot((File)new File(root, "h2o-core/src/main/resources/www"));
        String message = "Open H2O Flow in your web browser: ";
        System.err.println(message + H2O.getURL((String)NetworkInit.h2oHttpView.getScheme()));
        while (!H2O.getShutdownRequested()) {
            try {
                Thread.sleep(60000L);
                System.err.println("Still waiting for H2O to shutdown");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        _initial_keycnt = 0;
        MINCLOUDSIZE = Integer.parseInt(System.getProperty("cloudSize", "1"));
        DEFAULT_TIME_FOR_CLOUDING = 60000;
    }

    private static class ChangeLocaleTsk
    extends MRTask<ChangeLocaleTsk> {
        private final Locale _locale;

        public ChangeLocaleTsk(Locale locale) {
            this._locale = locale;
        }

        protected void setupLocal() {
            Locale.setDefault(this._locale);
        }
    }

    public static interface ParseSetupTransformer {
        public ParseSetup transformSetup(ParseSetup var1);
    }

    public static class Datasets {
        public static Frame iris() {
            return TestUtil.parseTestFile(Key.make((String)"iris.hex"), "smalldata/iris/iris_wheader.csv");
        }
    }

    public static abstract class GenFrameAssertion
    extends FrameAssertion {
        protected File generatedFile;
        protected ParseSetupTransformer psTransformer;

        public GenFrameAssertion(String file, int[] dim) {
            this(file, dim, null);
        }

        public GenFrameAssertion(String file, int[] dim, ParseSetupTransformer psTransformer) {
            super(file, dim);
            this.psTransformer = psTransformer;
        }

        protected abstract File prepareFile() throws IOException;

        @Override
        public Frame prepare() {
            try {
                File f = this.generatedFile = this.prepareFile();
                System.out.println("File generated into: " + f.getCanonicalPath());
                if (f.isDirectory()) {
                    return TestUtil.parseTestFolder(f.getCanonicalPath(), null, 1, null, this.psTransformer);
                }
                return TestUtil.parseTestFile(f.getCanonicalPath(), this.psTransformer);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot prepare test frame from file: " + this.file, e);
            }
        }

        @Override
        public void done(Frame frame) {
            if (this.generatedFile != null) {
                this.generatedFile.deleteOnExit();
                org.apache.commons.io.FileUtils.deleteQuietly((File)this.generatedFile);
            }
        }
    }

    public static abstract class FrameAssertion {
        protected final String file;
        private final int[] dim;

        public FrameAssertion(String file, int[] dim) {
            this.file = file;
            this.dim = dim;
        }

        public Frame prepare() {
            return TestUtil.parseTestFile(this.file);
        }

        public void done(Frame frame) {
        }

        public void check(Frame frame) {
        }

        public final int nrows() {
            return this.dim[1];
        }

        public final int ncols() {
            return this.dim[0];
        }
    }

    protected static class Cmp1
    extends MRTask<Cmp1> {
        final double _epsilon;
        final String _messagePrefix;
        public boolean _unequal;
        public String _message;

        public Cmp1(double epsilon) {
            this._epsilon = epsilon;
            this._messagePrefix = "";
        }

        public Cmp1(double epsilon, String msg) {
            this._epsilon = epsilon;
            this._messagePrefix = msg + " ";
        }

        public void map(Chunk[] chks) {
            for (int cols = 0; cols < chks.length >> 1; ++cols) {
                Chunk c0 = chks[cols];
                Chunk c1 = chks[cols + (chks.length >> 1)];
                for (int rows = 0; rows < chks[0]._len; ++rows) {
                    double cmpValue;
                    String msgBase = this._messagePrefix + "At [" + rows + ", " + cols + "]: ";
                    if (c0.isNA(rows) != c1.isNA(rows)) {
                        this._unequal = true;
                        this._message = msgBase + "c0.isNA " + c0.isNA(rows) + " != c1.isNA " + c1.isNA(rows);
                        return;
                    }
                    if (c0.isNA(rows) && c1.isNA(rows)) continue;
                    if (c0 instanceof C16Chunk && c1 instanceof C16Chunk) {
                        long lo0 = c0.at16l(rows);
                        long lo1 = c1.at16l(rows);
                        long hi0 = c0.at16h(rows);
                        long hi1 = c1.at16h(rows);
                        if (lo0 == lo1 && hi0 == hi1) continue;
                        this._unequal = true;
                        this._message = msgBase + " lo0 " + lo0 + " != lo1 " + lo1 + " || hi0 " + hi0 + " != hi1 " + hi1;
                        return;
                    }
                    if (c0 instanceof CStrChunk && c1 instanceof CStrChunk) {
                        BufferedString s0 = new BufferedString();
                        BufferedString s1 = new BufferedString();
                        c0.atStr(s0, rows);
                        c1.atStr(s1, rows);
                        if (s0.compareTo(s1) == 0) continue;
                        this._unequal = true;
                        this._message = msgBase + " s0 " + s0 + " != s1 " + s1;
                        return;
                    }
                    if (c0 instanceof C8Chunk && c1 instanceof C8Chunk) {
                        long d1;
                        long d0 = c0.at8(rows);
                        if (d0 == (d1 = c1.at8(rows))) continue;
                        this._unequal = true;
                        this._message = msgBase + " d0 " + d0 + " != d1 " + d1;
                        return;
                    }
                    double d0 = c0.atd(rows);
                    double d1 = c1.atd(rows);
                    double d = cmpValue = d0 == 0.0 || d1 == 0.0 ? 1.0 : Math.abs(d0) + Math.abs(d1);
                    if (Math.abs(d0 - d1) <= cmpValue * this._epsilon) continue;
                    this._unequal = true;
                    this._message = msgBase + " d0 " + d0 + " != d1 " + d1;
                    return;
                }
            }
        }

        public void reduce(Cmp1 cmp) {
            if (this._unequal) {
                return;
            }
            if (cmp._unequal) {
                this._unequal = true;
                this._message = cmp._message;
            }
        }
    }

    public static class StandardizeColumns
    extends MRTask<StandardizeColumns> {
        int[] _columns2Transform;
        double[] _colMeans;
        double[] _oneOStd;

        public StandardizeColumns(int[] cols, double[] colMeans, double[] oneOSigma, Frame transF) {
            assert (cols.length == colMeans.length);
            assert (colMeans.length == oneOSigma.length);
            this._columns2Transform = cols;
            this._colMeans = colMeans;
            this._oneOStd = oneOSigma;
            int numCols = transF.numCols();
            for (int cindex : cols) {
                assert (transF.vec(cindex).isNumeric());
            }
        }

        public void map(Chunk[] chks) {
            int chunkLen = chks[0].len();
            int colCount = 0;
            for (int cindex : this._columns2Transform) {
                for (int rindex = 0; rindex < chunkLen; ++rindex) {
                    double temp = (chks[cindex].atd(rindex) - this._colMeans[colCount]) * this._oneOStd[colCount];
                    chks[cindex].set(rindex, temp);
                }
                ++colCount;
            }
        }
    }

    public static class Frames {
        public final Frame train;
        public final Frame test;
        public final Frame valid;

        public Frames(Frame train, Frame test, Frame valid) {
            this.train = train;
            this.test = test;
            this.valid = valid;
        }
    }

    private static class DKVCleaner
    extends MRTask<DKVCleaner> {
        private DKVCleaner() {
        }

        public void setupLocal() {
            H2O.raw_clear();
            Vec.ESPC.clear();
        }
    }

    private static class KeyCleaner
    extends MRTask<KeyCleaner> {
        private final Class[] objectType;

        private KeyCleaner(Class[] objectType) {
            this.objectType = objectType;
        }

        protected void setupLocal() {
            Futures fs = new Futures();
            block0: for (Key k : H2O.localKeySet()) {
                Value value = Value.STORE_get((Key)k);
                if (value == null || value.isVecGroup() || value.isESPCGroup() || k == Job.LIST || value.isJob() || value.type() == TypeMap.PRIM_B) continue;
                for (Class c : this.objectType) {
                    if (!c.isInstance(value.get())) continue;
                    DKV.remove((Key)k, (Futures)fs);
                    continue block0;
                }
            }
            fs.blockForPending();
        }
    }
}

