/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Freezable;
import water.Futures;
import water.Iced;
import water.Key;
import water.TypeMap;
import water.Value;
import water.fvec.ByteVec;
import water.fvec.C1NChunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.StringUtils;

public class FVecFactory {
    public static Key makeByteVec(Key k, String ... data) {
        byte[][] chunks = new byte[data.length][];
        long[] espc = new long[data.length + 1];
        for (int i = 0; i < chunks.length; ++i) {
            chunks[i] = StringUtils.bytesOf((CharSequence)data[i]);
            espc[i + 1] = espc[i] + (long)data[i].length();
        }
        Futures fs = new Futures();
        Key key = Vec.newKey();
        ByteVec bv = new ByteVec(key, Vec.ESPC.rowLayout((Key)key, (long[])espc));
        for (int i = 0; i < chunks.length; ++i) {
            Key chunkKey = bv.chunkKey(i);
            DKV.put((Key)chunkKey, (Value)new Value(chunkKey, chunks[i].length, chunks[i], TypeMap.C1NCHUNK, 1), (Futures)fs);
        }
        DKV.put((Key)bv._key, (Iced)bv, (Futures)fs);
        Frame fr = new Frame(k, new String[]{"makeByteVec"}, new Vec[]{bv});
        DKV.put((Key)k, (Iced)fr, (Futures)fs);
        fs.blockForPending();
        return k;
    }

    public static Key makeByteVec(String ... data) {
        Futures fs = new Futures();
        long[] espc = new long[data.length + 1];
        for (int i = 0; i < data.length; ++i) {
            espc[i + 1] = espc[i] + (long)data[i].length();
        }
        Key k = Vec.newKey();
        ByteVec bv = new ByteVec(k, Vec.ESPC.rowLayout((Key)k, (long[])espc));
        DKV.put((Key)k, (Iced)bv, (Futures)fs);
        for (int i = 0; i < data.length; ++i) {
            Key ck = bv.chunkKey(i);
            DKV.put((Key)ck, (Value)new Value(ck, (Freezable)new C1NChunk(StringUtils.bytesOf((CharSequence)data[i]))), (Futures)fs);
        }
        fs.blockForPending();
        return k;
    }
}

