/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.junit.Ignore;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import water.DKV;
import water.Key;
import water.Value;
import water.udf.CBlock;
import water.udf.CFuncRef;
import water.util.ArrayUtils;

@Ignore(value="Support for tests, but no actual tests here")
public class JFuncUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key loadTestJar(String keyName, String testJarPath) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream is = cl.getResourceAsStream(testJarPath);){
            byte[] ba = IOUtils.toByteArray((InputStream)is);
            Key key = Key.make((String)keyName);
            DKV.put((Key)key, (Value)new Value(key, ba));
            Key key2 = key;
            return key2;
        }
    }

    public static CFuncRef loadTestFunc(String keyName, Class klazz) throws IOException {
        String klazzName = klazz.getName().replaceAll("\\.", "/") + ".class";
        return JFuncUtils.loadTestFunc("java", keyName, new String[]{klazzName}, klazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFuncRef loadTestFunc(String lang, String keyName, String[] resourcePaths, String entryFuncName) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (JarOutputStream jos = new JarOutputStream(bos);){
            for (String resourcePath : resourcePaths) {
                byte[] ba;
                try (InputStream is = cl.getResourceAsStream(resourcePath);){
                    ba = IOUtils.toByteArray((InputStream)is);
                }
                jos.putNextEntry(new ZipEntry(resourcePath));
                jos.write(ba);
            }
        }
        Key key = Key.make((String)keyName);
        DKV.put((Key)key, (Value)new Value(key, bos.toByteArray()));
        return new CFuncRef(lang, keyName, entryFuncName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CFuncRef loadRawTestFunc(String lang, String keyName, String funcName, byte[] rawDef, String pathInJar) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (JarOutputStream jos = new JarOutputStream(bos);){
            jos.putNextEntry(new ZipEntry(pathInJar));
            jos.write(rawDef);
        }
        Key key = Key.make((String)keyName);
        DKV.put((Key)key, (Value)new Value(key, bos.toByteArray()));
        return new CFuncRef(lang, keyName, funcName);
    }

    public static ClassLoader getSkippingClassloader(ClassLoader parent, String[] skipClassNames) {
        return JFuncUtils.getSkippingClassloader(parent, skipClassNames, new String[0]);
    }

    public static ClassLoader getSkippingClassloader(ClassLoader parent, final String[] skipClassNames, final String[] skipResources) {
        return new ClassLoader(parent){

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                return ArrayUtils.contains((Object[])skipClassNames, (Object)name) ? null : super.loadClass(name, resolve);
            }

            @Override
            public URL getResource(String name) {
                return ArrayUtils.contains((Object[])skipResources, (Object)name) ? null : super.getResource(name);
            }
        };
    }

    static CBlock.CRow mockedRow(int len, double value) {
        CBlock.CRow row = (CBlock.CRow)Mockito.mock(CBlock.CRow.class);
        Mockito.when((Object)row.len()).thenReturn((Object)len);
        Mockito.when((Object)row.readDouble(ArgumentMatchers.anyInt())).thenReturn((Object)value);
        Mockito.when((Object)row.readDoubles()).thenReturn((Object)ArrayUtils.constAry((int)len, (double)value));
        return row;
    }
}

