/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.UUID;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.Key;
import water.Scope;
import water.TestUtil;
import water.fvec.Frame;
import water.fvec.TestFrameBuilder;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.FrameUtils;

public class TestFrameBuilderTest
extends TestUtil {
    private static double DELTA = 1.0E-5;

    @BeforeClass
    public static void setup() {
        TestFrameBuilderTest.stall_till_cloudsize(1);
    }

    @Test
    public void testEmpty() {
        Frame fr = new TestFrameBuilder().build();
        Assert.assertEquals((long)fr.vecs().length, (long)0L);
        Assert.assertEquals((long)fr.numRows(), (long)0L);
        Assert.assertEquals((long)fr.numCols(), (long)0L);
        Assert.assertNull((Object)fr.anyVec());
        fr.remove();
    }

    @Test
    public void testName() {
        Frame fr = new TestFrameBuilder().withName("FrameName").build();
        Assert.assertEquals((Object)fr._key.toString(), (Object)"FrameName");
        Assert.assertEquals((long)fr.vecs().length, (long)0L);
        Assert.assertEquals((long)fr.numRows(), (long)0L);
        Assert.assertEquals((long)fr.numCols(), (long)0L);
        Assert.assertNull((Object)fr.anyVec());
        fr.remove();
    }

    @Test
    public void testVecTypes() {
        Frame fr = new TestFrameBuilder().withVecTypes(4, 3, 5, 2).build();
        Assert.assertArrayEquals((Object[])fr.names(), (Object[])TestFrameBuilderTest.ar("col_0", "col_1", "col_2", "col_3"));
        Assert.assertEquals((long)fr.vecs().length, (long)4L);
        Assert.assertEquals((long)fr.numRows(), (long)0L);
        Assert.assertEquals((long)fr.numCols(), (long)4L);
        Assert.assertEquals((long)fr.vec(0).get_type(), (long)4L);
        Assert.assertEquals((long)fr.vec(1).get_type(), (long)3L);
        Assert.assertEquals((long)fr.vec(2).get_type(), (long)5L);
        Assert.assertEquals((long)fr.vec(3).get_type(), (long)2L);
        fr.remove();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongVecNameSize() {
        Frame fr = new TestFrameBuilder().withVecTypes(4, 3, 5, 2).withColNames("A", "B").build();
        fr.remove();
    }

    @Test
    public void testColNames() {
        Frame fr = new TestFrameBuilder().withVecTypes(4, 3, 5, 2).withColNames("A", "B", "C", "D").build();
        Assert.assertEquals((long)fr.vecs().length, (long)4L);
        Assert.assertEquals((long)fr.numRows(), (long)0L);
        Assert.assertEquals((long)fr.numCols(), (long)4L);
        Assert.assertArrayEquals((Object[])fr.names(), (Object[])TestFrameBuilderTest.ar("A", "B", "C", "D"));
        fr.remove();
    }

    @Test
    public void testDefaultChunks() {
        Frame fr = new TestFrameBuilder().withVecTypes(4, 3, 5, 2).withColNames("A", "B", "C", "D").build();
        Assert.assertArrayEquals((long[])fr.anyVec().espc(), (long[])TestFrameBuilderTest.ar(0L, 0L));
        Assert.assertEquals((long)fr.anyVec().nChunks(), (long)1L);
        fr.remove();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetChunksToMany() {
        Frame fr = new TestFrameBuilder().withVecTypes(4, 3, 5, 2).withColNames("A", "B", "C", "D").withChunkLayout(2L, 2L, 2L, 1L).build();
        fr.remove();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetChunksFewerThanProvidedData() {
        Frame fr = new TestFrameBuilder().withVecTypes(4, 3).withColNames("A", "B").withDataForCol(0, TestFrameBuilderTest.ar("A", "B", "B", null, "F", "I")).withDataForCol(1, TestFrameBuilderTest.ard(Double.NaN, 1.0, 2.0, 3.0, 4.0, 5.6)).withChunkLayout(1L, 1L, 2L, 1L).build();
        fr.remove();
    }

    @Test
    public void testSetChunks() {
        Frame fr = new TestFrameBuilder().withName("frameName").withColNames("ColA", "ColB").withVecTypes(3, 2).withDataForCol(0, TestFrameBuilderTest.ard(Double.NaN, 1.0, 2.0, 3.0, 4.0, 5.6, 7.0)).withDataForCol(1, TestFrameBuilderTest.ar("A", "B", "C", null, "F", "I", "J")).withChunkLayout(2L, 2L, 2L, 1L).build();
        Assert.assertEquals((long)fr.anyVec().nChunks(), (long)4L);
        Assert.assertArrayEquals((long[])fr.anyVec().espc(), (long[])new long[]{0L, 2L, 4L, 6L, 7L});
        Assert.assertEquals((double)fr.vec(0).at(0L), (double)Double.NaN, (double)DELTA);
        Assert.assertEquals((double)fr.vec(0).at(5L), (double)5.6, (double)DELTA);
        Assert.assertEquals((double)fr.vec(0).at(6L), (double)7.0, (double)DELTA);
        BufferedString strBuf = new BufferedString();
        Assert.assertEquals((Object)fr.vec(1).atStr(strBuf, 0L).toString(), (Object)"A");
        Assert.assertNull((Object)fr.vec(1).atStr(strBuf, 3L));
        Assert.assertEquals((Object)fr.vec(1).atStr(strBuf, 6L).toString(), (Object)"J");
        fr.remove();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDataDifferentSize() {
        Frame fr = new TestFrameBuilder().withVecTypes(3, 2).withDataForCol(0, TestFrameBuilderTest.ard(Double.NaN, 1.0)).withDataForCol(1, TestFrameBuilderTest.ar("A", "B", "C")).build();
        fr.remove();
    }

    @Test
    public void withRandomIntDataForColTest() {
        long seed = 44L;
        int size = 1000;
        int min = 1;
        int max = 5;
        Frame fr = new TestFrameBuilder().withName("testFrame").withColNames("ColA").withVecTypes(3).withRandomIntDataForCol(0, size, min, max, seed).build();
        TestFrameBuilderTest.printOutFrameAsTable(fr, false, size);
        Vec generatedVec = fr.vec(0);
        for (int i = 0; i < size; ++i) {
            Assert.assertTrue((generatedVec.at((long)i) <= (double)max && generatedVec.at((long)i) >= (double)min ? 1 : 0) != 0);
        }
        fr.delete();
    }

    @Test
    public void withRandomDoubleDataForColTest() {
        long seed = 44L;
        int size = 1000;
        int min = 1;
        int max = 5;
        Frame fr = new TestFrameBuilder().withName("testFrame").withColNames("ColA").withVecTypes(3).withRandomDoubleDataForCol(0, size, min, max, seed).build();
        TestFrameBuilderTest.printOutFrameAsTable(fr, false, size);
        Vec generatedVec = fr.vec(0);
        for (int i = 0; i < size; ++i) {
            Assert.assertTrue((generatedVec.at((long)i) <= (double)max && generatedVec.at((long)i) >= (double)min ? 1 : 0) != 0);
        }
        fr.delete();
    }

    @Test
    public void numRowsIsWorkingForRandomlyGeneratedColumnsTest() {
        long seed = 44L;
        Frame fr = new TestFrameBuilder().withName("testFrame").withColNames("ColA").withVecTypes(3).withRandomDoubleDataForCol(0, 1000, 1, 5, seed).build();
        long numberOfRowsGenerated = fr.numRows();
        Assert.assertEquals((long)1000L, (long)numberOfRowsGenerated);
        fr.delete();
    }

    @Test
    public void withRandomBinaryDataForColTest() {
        long seed = 44L;
        Frame fr = new TestFrameBuilder().withName("testFrame").withColNames("ColA").withVecTypes(4).withRandomBinaryDataForCol(0, 1000, seed).build();
        Assert.assertEquals((long)2L, (long)fr.vec("ColA").cardinality());
        fr.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadVec() {
        try {
            Scope.enter();
            Frame frame = new TestFrameBuilder().withVecTypes(0).withDataForCol(0, TestFrameBuilderTest.ard(Double.NaN, Double.NaN, Double.NaN)).withName("fr").build();
            Assert.assertNotNull((Object)frame);
            Assert.assertEquals((long)1L, (long)frame.numCols());
            Vec badVec = frame.vec(0);
            Assert.assertEquals((long)0L, (long)badVec._type);
            Assert.assertEquals((long)3L, (long)badVec.length());
            Assert.assertTrue((boolean)badVec.isBad());
            int i = 0;
            while ((long)i < badVec.length()) {
                Assert.assertEquals((double)Double.NaN, (double)badVec.at((long)i), (double)0.0);
                ++i;
            }
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testSequenceIntDataForCol() {
        Scope.enter();
        try {
            Frame f = new TestFrameBuilder().withVecTypes(3).withSequenceIntDataForCol(0, 0, 10).build();
            Assert.assertEquals((String)"Unexpected number of rows", (long)10L, (long)f.numRows());
            Assert.assertArrayEquals((String)"It is not a valid sequence column", (int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, (int[])FrameUtils.asInts((Vec)f.vec(0)));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test(expected=AssertionError.class)
    public void testSequenceIntDataForColBadInput() {
        Scope.enter();
        try {
            new TestFrameBuilder().withVecTypes(3).withSequenceIntDataForCol(0, 0, 0).build();
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }

    @Test
    public void testUUID() {
        Scope.enter();
        try {
            UUID expectedUUID = UUID.randomUUID();
            Frame f = new TestFrameBuilder().withVecTypes(1).withDataForCol(0, TestFrameBuilderTest.ar(expectedUUID.toString(), null)).build();
            Assert.assertEquals((long)2L, (long)f.numRows());
            Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])f.types());
            Assert.assertEquals((long)expectedUUID.getLeastSignificantBits(), (long)f.vec(0).at16l(0L));
            Assert.assertEquals((long)expectedUUID.getMostSignificantBits(), (long)f.vec(0).at16h(0L));
            Assert.assertTrue((boolean)f.vec(0).isNA(1L));
        }
        finally {
            Scope.exit((Key[])new Key[0]);
        }
    }
}

