"use strict";(function(){var DATA_PATH, EOL, GOLD_PATH, SYSTEM_TEST, Xhr, argv, async, bailout, createCloud, createContext, cwd, diag, dumpAssertion, dumpAssertions, fs, httpRequest, i, path, pp, readGoldFile, readGoldJson, spawn, spool, tapediff, tdiff, test, _;

argv = (require('minimist'))(process.argv.slice(2));

EOL = (require('os')).EOL;

fs = require('fs');

path = require('path');

spawn = (require('child_process')).spawn;

httpRequest = require('request');

_ = require('lodash');

async = require('async');

test = require('tape');

cwd = path.resolve.apply(path, [__dirname].concat((function() {
  var _i, _results;
  _results = [];
  for (i = _i = 1; _i <= 6; i = ++_i) {
    _results.push('..');
  }
  return _results;
})()));

DATA_PATH = argv.data ? path.resolve(argv.data) : path.resolve(cwd, '..', 'smalldata');

if (!fs.existsSync(DATA_PATH)) {
  throw "Data path '" + DATA_PATH + "' not found!";
}

GOLD_PATH = argv.gold ? path.resolve(argv.gold) : path.resolve(cwd, path.join('src', 'main', 'steam', 'tests', 'gold'));

if (!fs.existsSync(GOLD_PATH)) {
  throw "Gold file path '" + GOLD_PATH + "' not found!";
}

if (argv.s) {
  spool = function(data) {
    return fs.appendFileSync('spool.log', data + EOL + EOL);
  };
} else {
  spool = function() {};
}

SYSTEM_TEST = argv.u ? false : true;

diag = function(message) {
  return console.log('# ' + message);
};

bailout = function(message) {
  return console.log('Bail out! ' + message);
};

pp = function(error) {
  return JSON.stringify(error);
};

dumpAssertion = function(path, value) {
  var element, escapedValue, index, _i, _len;
  if (isUndefined(value)) {
    console.log("t.ok (isUndefined " + path + "), '" + path + " is undefined'");
  } else if (value === null) {
    console.log("t.ok (null is " + path + "), '" + path + " is null'");
  } else if (isString(value)) {
    escapedValue = value.replace(/\n/g, '\\n').replace(/\t/g, '\\t');
    console.log("t.equal " + path + ", '" + escapedValue + "', 'String " + path + " equals [" + escapedValue + "]'");
  } else if (isBoolean(value)) {
    console.log("t.equal " + path + ", " + value + ", 'Boolean " + path + " equals [" + value + "]'");
  } else if (isNumber(value)) {
    console.log("t.equal " + path + ", " + value + ", 'Number " + path + " equals [" + value + "]'");
  } else if (isRegExp(value)) {
    console.log("t.equal " + path + ".toString(), " + value + ".toString(), 'Regexp " + path + " equals [" + value + "]'");
  } else if (isDate(value)) {
    console.log("t.equal " + path + ".toString(), " + value + ".toString(), 'Date " + path + " equals [" + value + "]'");
  } else if (isFunction(value)) {
    console.log("t.ok (isFunction " + path + "), '" + path + " is a function'");
  } else if (isArray(value)) {
    console.log("t.equal " + path + ".length, " + value.length + ", '" + path + " array lengths match'");
    for (index = _i = 0, _len = value.length; _i < _len; index = ++_i) {
      element = value[index];
      dumpAssertion("" + path + "[" + index + "]", element);
    }
  } else if (isObject(value)) {
    dumpAssertions(value, path);
  } else {
    throw new Error("Cannot dump " + path);
  }
};

dumpAssertions = function(obj, name) {
  var key, value;
  if (name == null) {
    name = 'subject';
  }
  if (!isObject(obj)) {
    throw new Error('Not an object');
  }
  for (key in obj) {
    value = obj[key];
    if (isNode$(value)) {
      dumpAssertion("" + name + "." + key + "()", value());
    } else {
      dumpAssertion("" + name + "." + key, value);
    }
  }
};

readGoldFile = function(name) {
  return fs.readFileSync(path.join(GOLD_PATH, name), {
    encoding: 'utf8'
  });
};

readGoldJson = function(name) {
  return JSON.parse(readGoldFile(name));
};

Xhr = function(_, host) {
  var makeRequest;
  makeRequest = function(opts, go) {
    diag("Calling " + opts.url);
    spool('===============REQUEST===============');
    spool(JSON.stringify(opts, null, 2));
    return httpRequest(opts, function(error, reply, body) {
      var json, response;
      if (error) {
        spool('*****ERROR*****');
        spool(error);
        return go(error);
      } else {
        spool('-----RAW-----');
        spool(body);
        response = {
          status: reply.statusCode,
          data: body,
          xhr: reply
        };
        switch (response.status) {
          case 200:
            try {
              json = JSON.parse(response.data);
            } catch (_error) {
              error = _error;
              json = null;
            }
            if (json) {
              spool('-----JSON-----');
              spool(JSON.stringify(json, null, 2));
              return go(null, {
                status: response.status,
                data: json,
                xhr: response.xhr
              });
            } else {
              return go(response);
            }
            break;
          default:
            return go(response);
        }
      }
    });
  };
  link$(_.h2oGet, function(path, go) {
    var opts;
    opts = {
      method: 'GET',
      url: "http://" + host + path,
      timeout: 900000
    };
    return makeRequest(opts, go);
  });
  return link$(_.h2oPost, function(path, parameters, go) {
    var opts;
    opts = {
      method: 'POST',
      url: "http://" + host + path,
      form: parameters,
      timeout: 900000
    };
    return makeRequest(opts, go);
  });
};

createContext = function(host) {
  _ = Steam.ApplicationContext();
  Xhr(_, host);
  Steam.H2OProxy(_);
  return _;
};

createCloud = function(go) {
  var runTests;
  runTests = function(host) {
    return function() {
      return go(createContext(host), function(t) {});
    };
  };
  return setTimeout(runTests(argv.usecloud), 1000);
};

tapediff = function(x, y, opts) {
  var glob, _compile, _diff, _dig, _message;
  _compile = function(pattern) {
    pattern = pattern.replace(/\./g, '\\.');
    pattern = pattern.replace(/\*{2,}/g, '.+?');
    pattern = pattern.replace(/\*/g, '[^.]+?');
    return new RegExp('^' + pattern + '$');
  };
  glob = opts ? {
    include: map(opts.include || [], _compile),
    exclude: map(opts.exclude || [], _compile)
  } : null;
  _dig = function(path) {
    var exclude, include, _i, _j, _k, _l, _len, _len1, _len2, _len3, _ref, _ref1, _ref2, _ref3;
    if (glob) {
      if (glob.include.length > 0 && glob.exclude.length > 0) {
        _ref = glob.include;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          include = _ref[_i];
          if (include.test(path)) {
            _ref1 = glob.exclude;
            for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
              exclude = _ref1[_j];
              if (exclude.test(path)) {
                return false;
              }
            }
            return true;
          }
        }
        return false;
      } else if (glob.include.length > 0) {
        _ref2 = glob.include;
        for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
          include = _ref2[_k];
          if (include.test(path)) {
            return true;
          }
        }
        return false;
      } else {
        _ref3 = glob.exclude;
        for (_l = 0, _len3 = _ref3.length; _l < _len3; _l++) {
          exclude = _ref3[_l];
          if (exclude.test(path)) {
            return false;
          }
        }
        return true;
      }
    } else {
      return true;
    }
  };
  _message = function(path, x, y) {
    return "Mismatched " + path + ": expected '" + x + "', actual '" + y + "'";
  };
  _diff = function(path, x, y) {
    var k, result, subpath, vx, vy, xi, yi, _i, _len;
    if ((isArray(x)) && (isArray(y))) {
      subpath = "" + path + (path ? '.' : '') + "#";
      if (_dig(subpath)) {
        for (i = _i = 0, _len = x.length; _i < _len; i = ++_i) {
          xi = x[i];
          yi = y[i];
          if (result = _diff(subpath, xi, yi)) {
            return result;
          }
        }
      }
      return null;
    } else if ((isObject(x)) && (isObject(y))) {
      for (k in x) {
        vx = x[k];
        subpath = "" + path + (path ? '.' : '') + k;
        if (_dig(subpath)) {
          vy = y[k];
          if (result = _diff(subpath, vx, vy)) {
            return result;
          }
        }
      }
      return null;
    } else if ((isNaN(x)) && (isNaN(y))) {
      return null;
    } else {
      if (x === y) {
        return null;
      } else {
        return _message(path, x, y);
      }
    }
  };
  return _diff('', x, y);
};

tdiff = function(t, x, y, opts) {
  var result;
  return t.pass('diff skipped');
  if (result = tapediff(x, y, opts)) {
    return t.fail(result);
  } else {
    return t.pass('diff ok');
  }
};

test('tapediff', function(t) {
  t.equal(tapediff(null, null), null);
  t.equal(tapediff(null, {
    foo: 3.1415,
    bar: 'bar',
    baz: 'baz'
  }), "Mismatched : expected 'null', actual '[object Object]'");
  t.equal(tapediff({
    foo: 3.1415,
    bar: 'bar',
    baz: 'baz'
  }, null), "Mismatched : expected '[object Object]', actual 'null'");
  t.equal(tapediff({
    foo: 3.1415,
    bar: 'bar',
    baz: 'baz'
  }, {
    foo: 3.1415,
    bar: 'bar',
    baz: 'baz'
  }), null);
  t.equal(tapediff({
    foo: 3.1415,
    bar: 'bar',
    baz: Number.NaN
  }, {
    foo: 3.1415,
    bar: 'bar',
    baz: Number.NaN
  }), null);
  t.equal(tapediff({
    foo: 3.1415,
    bar: 'ba',
    baz: 'baz'
  }, {
    foo: 3.1415,
    bar: 'bar',
    baz: 'baz'
  }), "Mismatched bar: expected 'ba', actual 'bar'");
  t.equal(tapediff({
    foo: 3.1415,
    bar: 'ba',
    baz: 'baz'
  }, {
    foo: 3.1415,
    bar: 'bar',
    baz: 'baz'
  }), "Mismatched bar: expected 'ba', actual 'bar'");
  t.equal(tapediff({
    qux: {
      foo: 3.1415,
      bar: 'bar',
      baz: 'baz'
    }
  }, {
    qux: {
      foo: 3.1415,
      bar: 'bar',
      baz: 'baz'
    }
  }), null);
  t.equal(tapediff({
    qux: {
      foo: 3.1415,
      bar: 'bar',
      baz: 'baz'
    }
  }, {
    qux: {
      foo: 3.1415,
      bar: 10,
      baz: 'baz'
    }
  }), "Mismatched qux.bar: expected 'bar', actual '10'");
  t.equal(tapediff({
    qux: {
      foo: 3.1415,
      bar: 'bar',
      baz: 'baz'
    }
  }, {
    qux: {
      foo: 3.1415,
      bar: 10,
      baz: 'baz'
    }
  }, {
    include: ['qux.foo', 'qux.baz']
  }), null);
  t.equal(tapediff({
    qux: {
      foo: 3.1415,
      bar: 'bar',
      baz: 'baz'
    }
  }, {
    qux: {
      foo: 3.1415,
      bar: 10,
      baz: 'baz'
    }
  }, {
    exclude: ['qux.bar']
  }), null);
  return t.end();
});

var Steam, after, always, apply, at, clear, clone, cloneDeep, compact, compose, concat, constant, contains, copy, countBy, curry, debounce, defaults, defer, delay, describeCount, difference, escape, every, extend, filter, find, findIndex, findKey, findLast, findLastIndex, findLastKey, flatten, forEach, forEachAsync, forEachRight, forIn, forInRight, forOwn, forOwnRight, formatTimeDuration, functions, groupBy, has, head, identity, indexBy, indexOf, initial, intersection, invert, isArguments, isArray, isBoolean, isDate, isDefined, isElement, isEmpty, isEqual, isError, isFalsy, isFinite, isFunction, isNaN, isNull, isNumber, isObject, isPlainObject, isRegExp, isString, isTruthy, isUndefined, join, keys, last, lastIndexOf, luid, map, mapValues, mapWithKey, max, memoize, merge, min, negate, never, noop, now, omit, once, pairs, partial, partialRight, pick, pluck, pop, property, pull, push, pushAll, random, range, reduce, reduceRight, reject, remove, removeWhere, repeat, reverse, same, sample, shift, shuffle, size, some, sort, sortBy, sortedIndex, splice, split, tail, throttle, times, toArray, transform, unescape, union, unique, uniqueId, unshift, unshiftAll, values, valuesAreEqual, where, without, words, wrap, xor, zip, zipCompare, zipObject,
  __slice = [].slice;

Steam = typeof exports !== "undefined" && exports !== null ? exports : this.Steam = {};

compact = _.compact;

difference = _.difference;

findIndex = _.findIndex;

findLastIndex = _.findLastIndex;

flatten = _.flatten;

head = _.head;

indexOf = _.indexOf;

initial = _.initial;

intersection = _.intersection;

last = _.last;

lastIndexOf = _.lastIndexOf;

pull = _.pull;

range = _.range;

removeWhere = _.remove;

sortedIndex = _.sortedIndex;

tail = _.tail;

union = _.union;

unique = _.unique;

without = _.without;

xor = _.xor;

zip = _.zip;

zipObject = _.zipObject;

at = _.at;

contains = _.contains;

countBy = _.countBy;

every = _.every;

filter = _.filter;

find = _.find;

findLast = _.findLast;

forEach = _.forEach;

forEachRight = _.forEachRight;

groupBy = _.groupBy;

indexBy = _.indexBy;

map = _.map;

max = _.max;

min = _.min;

pluck = _.pluck;

reduce = _.reduce;

reduceRight = _.reduceRight;

reject = _.reject;

sample = _.sample;

shuffle = _.shuffle;

size = _.size;

some = _.some;

sortBy = _.sortBy;

toArray = _.toArray;

where = _.where;

after = _.after;

compose = _.compose;

curry = _.curry;

debounce = _.debounce;

defer = _.defer;

delay = _.delay;

memoize = _.memoize;

once = _.once;

partial = _.partial;

partialRight = _.partialRight;

throttle = _.throttle;

wrap = _.wrap;

clone = _.clone;

cloneDeep = _.cloneDeep;

defaults = _.defaults;

extend = _.extend;

findKey = _.findKey;

findLastKey = _.findLastKey;

forIn = _.forIn;

forInRight = _.forInRight;

forOwn = _.forOwn;

forOwnRight = _.forOwnRight;

functions = _.functions;

has = _.has;

invert = _.invert;

isArguments = _.isArguments;

isArray = _.isArray;

isBoolean = _.isBoolean;

isDate = _.isDate;

isElement = _.isElement;

isEmpty = _.isEmpty;

isEqual = _.isEqual;

isFinite = _.isFinite;

isFunction = _.isFunction;

isNaN = _.isNaN;

isNull = _.isNull;

isNumber = _.isNumber;

isObject = _.isObject;

isPlainObject = _.isPlainObject;

isRegExp = _.isRegExp;

isString = _.isString;

isUndefined = _.isUndefined;

keys = _.keys;

mapValues = _.mapValues;

merge = _.merge;

omit = _.omit;

pairs = _.pairs;

pick = _.pick;

transform = _.transform;

values = _.values;

now = _.now;

constant = _.constant;

escape = _.escape;

identity = _.identity;

noop = _.noop;

property = _.property;

random = _.random;

times = _.times;

unescape = _.unescape;

uniqueId = _.uniqueId;

apply = function(func, args) {
  return func.apply(null, args);
};

isDefined = function(value) {
  return !isUndefined(value);
};

isTruthy = function(value) {
  if (value) {
    return true;
  } else {
    return false;
  }
};

isFalsy = function(value) {
  if (value) {
    return false;
  } else {
    return true;
  }
};

isError = function(value) {
  return value instanceof Error;
};

negate = function(value) {
  return !value;
};

always = function() {
  return true;
};

never = function() {
  return false;
};

join = function(array, delimiter) {
  return array.join(delimiter);
};

split = function(text, delimiter) {
  return text.split(delimiter);
};

words = function(text) {
  return split(text, /\s+/);
};

sort = function(array, comparator) {
  return array.sort(comparator);
};

copy = function(array) {
  return array.slice(0);
};

concat = function() {
  var array, arrays;
  array = arguments[0], arrays = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
  return array.concat.apply(array, arrays);
};

unshift = function(array, arg) {
  array.unshift(arg);
  return array;
};

unshiftAll = function(array, elements) {
  array.splice.apply(array, [0, 0].concat(elements));
  return array;
};

shift = function(array) {
  return array.shift();
};

push = function(array, arg) {
  array.push(arg);
  return array;
};

pushAll = function(array, elements) {
  var element, _i, _len;
  for (_i = 0, _len = elements.length; _i < _len; _i++) {
    element = elements[_i];
    array.push(element);
  }
  return array;
};

pop = function(array) {
  return array.pop();
};

splice = function() {
  var args, array;
  array = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
  return array.splice.apply(array, args);
};

remove = function(array, element) {
  var index;
  if (-1 < (index = array.indexOf(element))) {
    return head(array.splice(index, 1));
  } else {
    return void 0;
  }
};

reverse = function(array) {
  return (array.slice(0)).reverse();
};

clear = function(array) {
  array.length = 0;
  return array;
};

repeat = function(count, value) {
  var array, i, _i;
  array = [];
  for (i = _i = 0; 0 <= count ? _i < count : _i > count; i = 0 <= count ? ++_i : --_i) {
    array.push(value);
  }
  return array;
};

zipCompare = function(array1, array2, areEqual) {
  var a, b, i, _i, _j, _len, _len1;
  if (!isArray(array1)) {
    return false;
  }
  if (!isArray(array2)) {
    return false;
  }
  if (array1.length !== array2.length) {
    return false;
  }
  if (areEqual) {
    for (i = _i = 0, _len = array1.length; _i < _len; i = ++_i) {
      a = array1[i];
      b = array2[i];
      if (!areEqual(a, b)) {
        return false;
      }
    }
  } else {
    for (i = _j = 0, _len1 = array1.length; _j < _len1; i = ++_j) {
      a = array1[i];
      b = array2[i];
      if (a !== b) {
        return false;
      }
    }
  }
  return true;
};

same = function(array, areEqual) {
  var i, value, _i, _j, _ref, _ref1;
  if (array.length > 1) {
    value = head(array);
    if (isFunction(areEqual)) {
      for (i = _i = 1, _ref = array.length; 1 <= _ref ? _i < _ref : _i > _ref; i = 1 <= _ref ? ++_i : --_i) {
        if (!areEqual(value, array[i])) {
          return false;
        }
      }
    } else {
      for (i = _j = 1, _ref1 = array.length; 1 <= _ref1 ? _j < _ref1 : _j > _ref1; i = 1 <= _ref1 ? ++_j : --_j) {
        if (value !== array[i]) {
          return false;
        }
      }
    }
    return true;
  } else {
    return true;
  }
};

valuesAreEqual = function(array, pluck, areEqual) {
  var i, value, _i, _j, _ref, _ref1;
  if (array.length > 1) {
    value = pluck(head(array));
    if (isFunction(areEqual)) {
      for (i = _i = 1, _ref = array.length; 1 <= _ref ? _i < _ref : _i > _ref; i = 1 <= _ref ? ++_i : --_i) {
        if (!areEqual(value, pluck(array[i]))) {
          return false;
        }
      }
    } else {
      for (i = _j = 1, _ref1 = array.length; 1 <= _ref1 ? _j < _ref1 : _j > _ref1; i = 1 <= _ref1 ? ++_j : --_j) {
        if (value !== pluck(array[i])) {
          return false;
        }
      }
    }
    return true;
  } else {
    return true;
  }
};

mapWithKey = function(obj, map) {
  var key, result, value;
  result = [];
  for (key in obj) {
    value = obj[key];
    result.push(map(value, key));
  }
  return result;
};

describeCount = function(count, singular, plural) {
  if (!plural) {
    plural = singular + 's';
  }
  switch (count) {
    case 0:
      return "No " + plural;
    case 1:
      return "1 " + singular;
    default:
      return "" + count + " " + plural;
  }
};

luid = function() {
  var d;
  d = new Date().getTime();
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
    var r;
    r = (d + Math.random() * 16) % 16 | 0;
    d = Math.floor(d / 16);
    return (c === 'x' ? r : r & 0x7 | 0x8).toString(16);
  });
};

forEachAsync = function(actions, go) {
  var queue, results, runNext;
  queue = copy(actions);
  results = [];
  runNext = function() {
    var action;
    if (action = shift(queue)) {
      return action(actions.length - queue.length, function(result) {
        results.push(result);
        return defer(runNext);
      });
    } else {
      return go(results);
    }
  };
  return defer(runNext);
};

formatTimeDuration = function(ms) {
  var units;
  if (ms > 1000) {
    ms /= 1000;
    units = 'sec';
    if (ms > 60) {
      ms /= 60;
      units = 'min';
      if (ms > 60) {
        ms /= 60;
        units = 'hrs';
      }
    }
    return "" + (ms.toFixed(2)) + " " + units;
  } else {
    return "" + ms + " ms";
  }
};

var geyser,
  __slice = [].slice;

geyser = (function() {
  var GeyserNode, GeyserTag, createTag, generate, getOrCreateTag, parseTagSpec, render, _tagCache;
  _tagCache = {};
  GeyserTag = (function() {
    function GeyserTag(name, classes, attrs) {
      this.name = name;
      this.classes = classes;
      this.attrs = attrs;
    }

    return GeyserTag;

  })();
  GeyserNode = (function() {
    function GeyserNode(tag, params, content) {
      this.tag = tag;
      this.params = params;
      this.content = content;
    }

    return GeyserNode;

  })();
  createTag = function(tagSpec, attrSpec) {
    var classes, tag, _ref;
    switch (tagSpec.indexOf('.')) {
      case -1:
        return new GeyserTag(tagSpec, null, attrSpec);
      case 0:
        return new GeyserTag('div', ((tagSpec.substr(1)).split('.')).join(' '), attrSpec);
      default:
        _ref = tagSpec.split('.'), tag = _ref[0], classes = 2 <= _ref.length ? __slice.call(_ref, 1) : [];
        return new GeyserTag(tag, classes.join(' '), attrSpec);
    }
  };
  parseTagSpec = function(spec) {
    var i;
    if (-1 === (i = spec.indexOf(' '))) {
      return createTag(spec, null);
    } else {
      return createTag(spec.substr(0, i), spec.substr(i + 1));
    }
  };
  getOrCreateTag = function(spec) {
    var tag;
    if (tag = _tagCache[spec]) {
      return tag;
    } else {
      return _tagCache[spec] = parseTagSpec(spec);
    }
  };
  generate = function() {
    var specs;
    specs = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    if (specs.length === 1 && isArray(head(specs))) {
      specs = head(specs);
    }
    return map(specs, function(spec) {
      var tag;
      tag = getOrCreateTag(spec);
      return function(arg, params) {
        return new GeyserNode(tag, params, isArray(arg) ? arg : arg instanceof GeyserNode ? [arg] : arg);
      };
    });
  };
  render = function(arg) {
    var attrs, classes, content, id, k, name, tag, v, _ref;
    if (arg instanceof GeyserNode) {
      id = arg.id ? " id='" + arg.id + "'" : '';
      tag = arg.tag;
      name = tag.name;
      classes = tag.classes ? " class='" + tag.classes + "'" : '';
      attrs = tag.attrs ? " " + tag.attrs : '';
      if (attrs && arg.params) {
        _ref = arg.params;
        for (k in _ref) {
          v = _ref[k];
          attrs = attrs.replace("" + k, v);
        }
      }
      content = render(arg.content);
      return "<" + name + classes + attrs + ">" + content + "</" + name + ">";
    } else if (isArray(arg)) {
      return join(map(arg, render), '');
    } else {
      if (isUndefined(arg)) {
        return '';
      } else {
        return arg;
      }
    }
  };
  return {
    generate: generate,
    render: render
  };
})();

var and$, apply$, call$, context$, debounce$, edge$, edges$, filter$, if$, isNode$, join$, lift$, link$, node$, nodes$, not$, or$, switch$, throttle$, unlink$, zip$, _ref,
  __slice = [].slice;

Steam.Hypergraph = (function() {
  var applyOnChange, callOnChange, createContext, createEdge, createHyperedge, createNode, createObservable, createObservableArray, createPolynode, debounceNode, filterNode, isNode, isObservable, joinNodes, liftNodes, link, switchNodes, throttleNode, unlink, zipNodes, _apply;
  createEdge = function() {
    var arrow, self;
    arrow = null;
    self = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      if (arrow) {
        return arrow.func.apply(null, args);
      } else {
        return void 0;
      }
    };
    self.subscribe = function(func) {
      console.assert(isFunction(func));
      if (arrow) {
        throw new Error('Cannot re-attach edge');
      } else {
        return arrow = {
          func: func,
          dispose: function() {
            return arrow = null;
          }
        };
      }
    };
    self.dispose = function() {
      if (arrow) {
        return arrow.dispose();
      }
    };
    return self;
  };
  createHyperedge = function() {
    var arrows, self;
    arrows = [];
    self = function() {
      var args;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      return map(arrows, function(arrow) {
        return arrow.func.apply(null, args);
      });
    };
    self.subscribe = function(func) {
      var arrow;
      console.assert(isFunction(func));
      arrows.push(arrow = {
        func: func,
        dispose: function() {
          return remove(arrows, arrow);
        }
      });
      return arrow;
    };
    self.dispose = function() {
      return forEach(copy(arrows), function(arrow) {
        return arrow.dispose();
      });
    };
    return self;
  };
  if (typeof ko !== "undefined" && ko !== null) {
    createObservable = ko.observable;
    createObservableArray = ko.observableArray;
    isObservable = ko.isObservable;
  } else {
    createObservable = function(initialValue) {
      var arrows, currentValue, notifySubscribers, self;
      arrows = [];
      currentValue = initialValue;
      notifySubscribers = function(arrows, newValue) {
        var arrow, _i, _len;
        for (_i = 0, _len = arrows.length; _i < _len; _i++) {
          arrow = arrows[_i];
          arrow.func(newValue);
        }
      };
      self = function(newValue) {
        var unchanged;
        if (arguments.length === 0) {
          return currentValue;
        } else {
          unchanged = self.equalityComparer ? self.equalityComparer(currentValue, newValue) : currentValue === newValue;
          if (!unchanged) {
            currentValue = newValue;
            return notifySubscribers(arrows, newValue);
          }
        }
      };
      self.subscribe = function(func) {
        var arrow;
        console.assert(isFunction(func));
        arrows.push(arrow = {
          func: func,
          dispose: function() {
            return remove(arrows, arrow);
          }
        });
        return arrow;
      };
      self.__observable__ = true;
      return self;
    };
    createObservableArray = createObservable;
    isObservable = function(obj) {
      if (obj.__observable__) {
        return true;
      } else {
        return false;
      }
    };
  }
  createNode = function(value, equalityComparer) {
    var observable;
    if (arguments.length === 0) {
      return createNode(void 0, never);
    } else {
      observable = createObservable(value);
      if (isFunction(equalityComparer)) {
        observable.equalityComparer = equalityComparer;
      }
      return observable;
    }
  };
  isNode = isObservable;
  createPolynode = function(array) {
    return createObservableArray(array || []);
  };
  createContext = function(edges, parent) {
    var context, edge, name;
    if (parent == null) {
      parent = null;
    }
    context = {
      root: null,
      parent: null
    };
    if (parent) {
      console.assert(isDefined(parent.root));
      context.root = parent.root;
      context.parent = parent;
    } else {
      context.root = context.parent = context;
    }
    for (name in edges) {
      edge = edges[name];
      console.assert(isFunction(edge));
      console.assert(!(name in context));
      context[name] = edge;
    }
    return context;
  };
  link = function(node, func) {
    console.assert(isFunction(node, '[node] is not a function'));
    console.assert(isFunction(node.subscribe, '[node] does not have a [dispose] method'));
    console.assert(isFunction(func, '[func] is not a function'));
    return node.subscribe(func);
  };
  unlink = function(arrows) {
    var arrow, _i, _len, _results;
    if (isArray(arrows)) {
      _results = [];
      for (_i = 0, _len = arrows.length; _i < _len; _i++) {
        arrow = arrows[_i];
        console.assert(isFunction(arrow.dispose, '[arrow] does not have a [dispose] method'));
        _results.push(arrow.dispose());
      }
      return _results;
    } else {
      console.assert(isFunction(arrows.dispose, '[arrow] does not have a [dispose] method'));
      return arrows.dispose();
    }
  };
  _apply = function(sources, func) {
    return func.apply(null, map(sources, function(source) {
      return source();
    }));
  };
  callOnChange = function() {
    var func, sources, _i;
    sources = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), func = arguments[_i++];
    func();
    return map(sources, function(source) {
      return link(source, function() {
        return func();
      });
    });
  };
  applyOnChange = function() {
    var func, sources, _i;
    sources = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), func = arguments[_i++];
    _apply(sources, func);
    return map(sources, function(source) {
      return link(source, function() {
        return _apply(sources, func);
      });
    });
  };
  joinNodes = function() {
    var func, sources, target, _i;
    sources = 3 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 2) : (_i = 0, []), target = arguments[_i++], func = arguments[_i++];
    console.assert(isFunction(target, '[target] is not a function'));
    target(_apply(sources, func));
    return map(sources, function(source) {
      return link(source, function() {
        return target(_apply(sources, func));
      });
    });
  };
  zipNodes = function(sources, func) {
    var evaluate, target;
    evaluate = function() {
      return _apply(sources, func);
    };
    target = createNode(evaluate());
    map(sources, function(source) {
      return link(source, function() {
        return target(evaluate());
      });
    });
    return target;
  };
  liftNodes = function() {
    var func, sources, _i;
    sources = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), func = arguments[_i++];
    return zipNodes(sources, func);
  };
  filterNode = function(source, predicate) {
    var target, value;
    target = createNode(predicate(value = source()) ? value : void 0);
    link(source, function(value) {
      if (predicate(value)) {
        return target(value);
      }
    });
    return target;
  };
  switchNodes = function(defaultValue, count) {
    var choices, i, _i;
    choices = [];
    for (i = _i = 0; 0 <= count ? _i < count : _i > count; i = 0 <= count ? ++_i : --_i) {
      choices.push(node$(defaultValue, function(a, b) {
        return a === b;
      }));
    }
    forEach(choices, function(source) {
      return link(source, function(value) {
        var target, _j, _len;
        if (value !== defaultValue) {
          for (i = _j = 0, _len = choices.length; _j < _len; i = ++_j) {
            target = choices[i];
            if (source !== target) {
              target(defaultValue);
            }
          }
        }
      });
    });
    return choices;
  };
  debounceNode = function(source, wait, options) {
    var target;
    target = createNode(void 0);
    link(source, debounce(target, wait, options));
    return target;
  };
  throttleNode = function(source, wait, options) {
    var target;
    target = createNode(void 0);
    link(source, throttle(target, wait, options));
    return target;
  };
  return {
    createEdge: createEdge,
    createHyperedge: createHyperedge,
    createNode: createNode,
    isNode: isNode,
    createPolynode: createPolynode,
    createContext: createContext,
    link: link,
    unlink: unlink,
    callOnChange: callOnChange,
    applyOnChange: applyOnChange,
    joinNodes: joinNodes,
    zipNodes: zipNodes,
    liftNodes: liftNodes,
    filterNode: filterNode,
    switchNodes: switchNodes,
    debounceNode: debounceNode,
    throttleNode: throttleNode
  };
})();

_ref = Steam.Hypergraph, edge$ = _ref.createEdge, edges$ = _ref.createHyperedge, node$ = _ref.createNode, isNode$ = _ref.isNode, nodes$ = _ref.createPolynode, context$ = _ref.createContext, link$ = _ref.link, unlink$ = _ref.unlink, call$ = _ref.callOnChange, apply$ = _ref.applyOnChange, join$ = _ref.joinNodes, zip$ = _ref.zipNodes, lift$ = _ref.liftNodes, filter$ = _ref.filterNode, switch$ = _ref.switchNodes, debounce$ = _ref.debounceNode, throttle$ = _ref.throttleNode;

if$ = function(condition, valueIfTrue, valueIfFalse) {
  return zip$([condition, valueIfTrue, valueIfFalse], function(c, t, f) {
    if (c) {
      return t;
    } else {
      return f;
    }
  });
};

and$ = function() {
  var sources;
  sources = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
  return zip$(sources, function() {
    var values;
    values = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return every(values);
  });
};

or$ = function() {
  var sources;
  sources = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
  return zip$(sources, function() {
    var values;
    values = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return some(values);
  });
};

not$ = function(source) {
  return zip$([source], negate);
};

var T,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
  __slice = [].slice;

Steam.Typedef = (function() {
  var Builtin, Reference, Struct, Type, builtinChecks, isBuiltin, t_any, t_array, t_boolean, t_check, t_checkBuiltin, t_checkEnum, t_checkReference, t_checkStruct, t_date, t_dump, t_error, t_function, t_number, t_object, t_primitive, t_regexp, t_string, t_tuple, t_union, typedef;
  Type = (function() {
    function Type() {}

    return Type;

  })();
  Builtin = (function(_super) {
    __extends(Builtin, _super);

    function Builtin(name, checks, inspect) {
      this.name = name;
      this.checks = checks;
      this.inspect = inspect;
    }

    return Builtin;

  })(Type);
  Reference = (function(_super) {
    __extends(Reference, _super);

    function Reference(name, type, checks) {
      this.name = name;
      this.type = type;
      this.checks = checks;
      this.inspect = __bind(this.inspect, this);
    }

    Reference.prototype.inspect = function() {
      var description;
      description = {};
      description[this.name] = this.type.inspect();
      return description;
    };

    return Reference;

  })(Type);
  Struct = (function(_super) {
    __extends(Struct, _super);

    function Struct(name, definition, checks) {
      this.name = name;
      this.definition = definition;
      this.checks = checks;
      this.inspect = __bind(this.inspect, this);
    }

    Struct.prototype.inspect = function() {
      var description, k, struct, v, _ref;
      description = {};
      description[this.name] = struct = {};
      _ref = this.definition;
      for (k in _ref) {
        v = _ref[k];
        struct[k] = v.inspect();
      }
      return description;
    };

    return Struct;

  })(Type);
  builtinChecks = {
    'Any': function() {
      return true;
    },
    'Number': isNumber,
    'String': isString,
    'Boolean': isBoolean,
    'Function': isFunction,
    'Error': isError,
    'Date': isDate,
    'RegExp': isRegExp,
    'Object': isObject
  };
  t_checkEnum = function(validValues) {
    return function(value) {
      var validValue, _i, _len;
      for (_i = 0, _len = validValues.length; _i < _len; _i++) {
        validValue = validValues[_i];
        if (value === validValue) {
          return null;
        }
      }
      return "Enum value [" + value + "] does not match one of [" + (validValues.join(', ')) + "]";
    };
  };
  t_checkBuiltin = function(value, type) {
    var check, error, errors, _i, _len, _ref;
    errors = [];
    _ref = type.checks;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      check = _ref[_i];
      if (error = check(value)) {
        errors.push(error);
      }
    }
    if (errors.length > 0) {
      return errors;
    } else {
      return null;
    }
  };
  t_checkReference = function(value, type) {
    var check, error, errors, _i, _len, _ref;
    errors = [];
    if (error = t_check(value, type.type)) {
      errors.push(error);
    }
    _ref = type.checks;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      check = _ref[_i];
      if (error = check(value)) {
        errors.push(error);
      }
    }
    if (errors.length > 0) {
      return errors;
    } else {
      return null;
    }
  };
  t_checkStruct = function(value, type) {
    var attributeName, attributeType, attributeValue, check, error, errors, _i, _len, _ref, _ref1;
    errors = [];
    _ref = type.definition;
    for (attributeName in _ref) {
      attributeType = _ref[attributeName];
      if ((isObject(value)) && attributeName in value) {
        attributeValue = value[attributeName];
        if (error = t_check(attributeValue, attributeType)) {
          errors.push(error);
        }
      } else {
        errors.push("Required attribute [" + attributeName + "] not found.");
      }
    }
    _ref1 = type.checks;
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      check = _ref1[_i];
      if (error = check(value)) {
        errors.push(error);
      }
    }
    if (errors.length > 0) {
      return errors;
    } else {
      return null;
    }
  };
  t_check = function(value, type) {
    if (type instanceof Builtin) {
      return t_checkBuiltin(value, type);
    } else if (type instanceof Reference) {
      return t_checkReference(value, type);
    } else if (type instanceof Struct) {
      return t_checkStruct(value, type);
    } else {
      throw new Error("Unknown type [" + type + "]");
    }
  };
  t_primitive = function(name, args) {
    var arg, check, checks, primitiveCheck, value, _i, _j, _len, _len1;
    primitiveCheck = builtinChecks[name];
    check = function(value) {
      if (primitiveCheck(value)) {
        return null;
      } else {
        return "[" + value + "] is not a " + name;
      }
    };
    checks = [check];
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      arg = args[_i];
      if (isArray(arg)) {
        for (_j = 0, _len1 = arg.length; _j < _len1; _j++) {
          value = arg[_j];
          if (!primitiveCheck(value)) {
            throw new Error("Enum value [" + value + "] is not a " + name);
          }
        }
        checks.push(t_checkEnum(arg));
      } else if (isFunction(arg)) {
        checks.push(arg);
      } else {
        throw new Error("Invalid type arg [" + arg + "]");
      }
    }
    return new Builtin(name, checks, function() {
      return name;
    });
  };
  t_any = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Any', args);
  };
  t_number = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Number', args);
  };
  t_string = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('String', args);
  };
  t_boolean = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Boolean', args);
  };
  t_function = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Function', args);
  };
  t_error = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Error', args);
  };
  t_date = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Date', args);
  };
  t_regexp = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('RegExp', args);
  };
  t_object = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    return t_primitive('Object', args);
  };
  isBuiltin = function(f) {
    return f === t_any || f === t_number || f === t_string || f === t_boolean || f === t_function || f === t_error || f === t_date || f === t_regexp || f === t_object;
  };
  t_array = function() {
    var arg, args, checks, type, types, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    types = [];
    checks = [];
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      arg = args[_i];
      if (arg instanceof Type) {
        types.push(arg);
      } else if (isFunction(arg)) {
        if (isBuiltin(arg)) {
          types.push(arg());
        } else {
          checks.push(arg);
        }
      } else {
        throw new Error("Invalid arg [" + arg + "]");
      }
    }
    if (types.length > 0) {
      type = t_union.apply(null, types);
      checks.unshift(function(array) {
        var element, error, errors, index, _j, _len1;
        errors = [];
        if (isArray(array)) {
          for (index = _j = 0, _len1 = array.length; _j < _len1; index = ++_j) {
            element = array[index];
            if (error = t_check(element, type)) {
              errors.push("Array[" + index + "]: " + error);
            }
          }
        } else {
          errors.push("[" + array + "] is not an Array");
        }
        if (errors.length > 0) {
          return errors;
        } else {
          return null;
        }
      });
    } else {
      throw new Error("Array type not specified");
    }
    return new Builtin('Array', checks, function() {
      return "Array[" + (type.inspect()) + "]";
    });
  };
  t_union = function() {
    var arg, args, checks, types, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    if (args.length === 0) {
      throw new Error("Variant types not specified");
    } else if (args.length === 1) {
      arg = head(args);
      if (isBuiltin(arg)) {
        return arg();
      } else if (arg instanceof Type) {
        return arg;
      } else {
        throw new Error("Invalid arg [" + arg + "]");
      }
    } else {
      types = [];
      checks = [];
      for (_i = 0, _len = args.length; _i < _len; _i++) {
        arg = args[_i];
        if (isBuiltin(arg)) {
          types.push(arg());
        } else if (arg instanceof Type) {
          types.push(arg);
        } else if (isFunction(arg)) {
          checks.push(arg);
        } else {
          throw new Error("Invalid type arg [" + arg + "]");
        }
      }
      checks.unshift(function(value) {
        var error, errors, matched, type, _j, _len1;
        errors = [];
        matched = false;
        for (_j = 0, _len1 = types.length; _j < _len1; _j++) {
          type = types[_j];
          if (error = t_check(value, type)) {
            errors.push(error);
          } else {
            matched = true;
            break;
          }
        }
        if (matched) {
          return null;
        } else {
          return map(errors, function(error) {
            return "Variant [" + value + "]: " + error;
          });
        }
      });
      return new Builtin('Variant', checks, function() {
        return "" + (types.map(function(type) {
          return type.inspect();
        }).join('|'));
      });
    }
  };
  t_tuple = function() {
    var arg, args, checks, types, _i, _len;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    types = [];
    checks = [];
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      arg = args[_i];
      if (isBuiltin(arg)) {
        types.push(arg());
      } else if (arg instanceof Type) {
        types.push(arg);
      } else if (isFunction(arg)) {
        checks.push(arg);
      } else {
        throw new Error("Invalid arg [" + arg + "]");
      }
    }
    if (types.length > 0) {
      checks.unshift(function(tuple) {
        var error, errors, index, type, value, _j, _len1;
        if (isArray(tuple)) {
          errors = [];
          for (index = _j = 0, _len1 = types.length; _j < _len1; index = ++_j) {
            type = types[index];
            value = tuple[index];
            if (error = t_check(value, type)) {
              errors.push("Tuple[" + index + "]: " + error);
            }
          }
          if (tuple.length !== types.length) {
            errors.push("Invalid tuple length. Expected " + types.length + ". Got " + tuple.length);
          }
          if (errors.length > 0) {
            return errors;
          } else {
            return null;
          }
        } else {
          return "Value [" + tuple + "] is not a Tuple";
        }
      });
      return new Builtin('Tuple', checks, function() {
        return "Tuple[" + (types.map(function(type) {
          return type.inspect();
        }).join(', ')) + "]";
      });
    } else {
      throw new Error("Tuple types not specified");
    }
  };
  t_dump = function(arg) {
    var dump, lines, tab;
    tab = '  ';
    dump = function(lines, offset, arg) {
      var indent, item, _i, _len;
      if (isArray(arg)) {
        indent = offset + tab;
        for (_i = 0, _len = arg.length; _i < _len; _i++) {
          item = arg[_i];
          dump(lines, indent, item);
        }
      } else if (isString(arg)) {
        lines.push(offset + arg);
      }
    };
    dump(lines = [], '', arg);
    return lines;
  };
  typedef = function() {
    var arg, attr, attrType, checks, definition, name, specification, _ref;
    specification = arguments[0], checks = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
    _ref = head(pairs(specification)), name = _ref[0], arg = _ref[1];
    if (isBuiltin(arg)) {
      return new Reference(name, arg(), checks);
    } else if (arg instanceof Type) {
      return new Reference(name, arg, checks);
    } else if (isFunction(arg)) {
      throw new Error("Arbitrary functions not allowed on structs");
    } else if (isObject(arg)) {
      definition = {};
      for (attr in arg) {
        attrType = arg[attr];
        if (isBuiltin(attrType)) {
          definition[attr] = attrType();
        } else if (isArray(attrType)) {
          definition[attr] = t_union.apply(null, attrType);
        } else if (attrType instanceof Type) {
          definition[attr] = attrType;
        } else {
          throw new Error("Unrecognized type [" + attr + "] : [" + attrType + "]");
        }
      }
      return new Struct(name, definition, checks);
    } else {
      throw new Error("Invalid arg [" + arg + "]");
    }
  };
  typedef.any = t_any;
  typedef.num = t_number;
  typedef.str = t_string;
  typedef.bool = t_boolean;
  typedef.func = t_function;
  typedef.err = t_error;
  typedef.date = t_date;
  typedef.regexp = t_regexp;
  typedef.arr = t_array;
  typedef.obj = t_object;
  typedef.union = t_union;
  typedef.tuple = t_tuple;
  typedef.check = t_check;
  typedef.dump = t_dump;
  return typedef;
})();

T = Steam.Typedef;

var typecheck, typedump;

typedump = function(key, value, indent) {
  var k, v;
  if (indent == null) {
    indent = '';
  }
  if (isNumber(value)) {
    console.log(indent + ("" + key + ": T.num"));
  } else if (isString(value)) {
    console.log(indent + ("" + key + ": T.str"));
  } else if (isBoolean(value)) {
    console.log(indent + ("" + key + ": T.bool"));
  } else if (isFunction(value)) {
    console.log(indent + ("" + key + ": T.func"));
  } else if (isError(value)) {
    console.log(indent + ("" + key + ": T.error"));
  } else if (isDate(value)) {
    console.log(indent + ("" + key + ": T.date"));
  } else if (isRegExp(value)) {
    console.log(indent + ("" + key + ": T.regexp"));
  } else if (isArray(value)) {
    console.log(indent + ("" + key + ": T.arr T.any"));
  } else if (isObject(value)) {
    console.log(indent + ("" + key + ":"));
    for (k in value) {
      v = value[k];
      typedump(k, v, indent + '  ');
    }
  }
};

typecheck = function(value, type) {
  var error, lines, message;
  if (error = T.check(value, type)) {
    lines = T.dump(error);
    message = "Typecheck failed for " + type.name;
    if (typeof exports !== "undefined" && exports !== null) {
      console.error(message, lines);
    } else {
      if (window.steam) {
        window.steam.context.fatal(message, {
          errors: lines
        });
      } else {
        console.error(message, lines);
      }
    }
    return false;
  } else {
    return true;
  }
};

(function() {
  Steam.AdminListView = function(_) {
    var activateAndDisplayItem, createItem, displayActiveItem, displayItem, initialize, loadCloud, loadPerfbar, loadTimeline, _cloudView, _items, _perfbarView, _timelineView;
    _items = nodes$();
    _cloudView = null;
    _timelineView = null;
    _perfbarView = null;
    displayItem = function(item) {
      if (item) {
        item.load();
      } else {
        _.displayEmpty();
      }
      return _.inspect(null);
    };
    displayActiveItem = function() {
      var activeItem;
      activeItem = find(_items(), function(item) {
        return item.isActive();
      });
      if (activeItem) {
        return displayItem(activeItem);
      } else {
        return activateAndDisplayItem(head(_items()));
      }
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createItem = function(title, caption, action) {
      var self;
      return self = {
        title: title,
        caption: caption,
        display: function() {
          return activateAndDisplayItem(self);
        },
        load: action,
        isActive: node$(false)
      };
    };
    loadCloud = function() {
      if (!_cloudView) {
        _cloudView = Steam.CloudView(_);
      }
      return _.displayView(_cloudView);
    };
    loadTimeline = function() {
      if (!_timelineView) {
        _timelineView = Steam.TimelineView(_);
      }
      return _.displayView(_timelineView);
    };
    loadPerfbar = function() {
      if (!_perfbarView) {
        _perfbarView = Steam.PerfbarView(_);
      }
      return _.displayView(_perfbarView);
    };
    initialize = function() {
      var items;
      items = [createItem('Cloud', 'Monitor status of each node.', loadCloud), createItem('Timeline', 'Monitor cluster activity.', loadTimeline), createItem('Water Meter (Perfbar)', 'Perfbar CPU activity meter.', loadPerfbar)];
      return _items(items);
    };
    initialize();
    link$(_.loadAdmin, function() {
      return displayActiveItem();
    });
    return {
      items: _items,
      template: 'admin-list-view'
    };
  };

}).call(this);

(function() {
  Steam.AlertDialog = function(_, _title, _message, _go) {
    var cancel, confirm;
    confirm = function() {
      return _go('confirm');
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _title,
      message: _message,
      confirm: confirm,
      cancel: cancel,
      template: 'alert-dialog'
    };
  };

}).call(this);

(function() {


}).call(this);

(function() {
  Steam.ApplicationContext = function() {
    return context$({
      ready: edges$(),
      error: edge$(),
      warn: edge$(),
      info: edge$(),
      fatal: edge$(),
      notify: edge$(),
      callout: edge$(),
      tooltip: edge$(),
      measureTextSpan: edge$(),
      schedule: edge$(),
      unschedule: edge$(),
      timeout: edge$(),
      man: edge$(),
      help: edge$(),
      status: edge$(),
      inspect: edge$(),
      route: edge$(),
      setRoute: edge$(),
      getRoute: edge$(),
      onRouteSucceeded: edge$(),
      onRouteFailed: edge$(),
      loadDialog: edge$(),
      unloadDialog: edge$(),
      positionDialog: edge$(),
      alert: edge$(),
      confirm: edge$(),
      fail: edge$(),
      h2oGet: edge$(),
      h2oPost: edge$(),
      requestRemoveAll: edge$(),
      requestLogAndEcho: edge$(),
      requestFileGlob: edge$(),
      requestImportFile: edge$(),
      requestImportFiles: edge$(),
      requestParseSetup: edge$(),
      requestParseFiles: edge$(),
      requestInspect: edge$(),
      requestFrames: edge$(),
      requestFramesAndCompatibleModels: edge$(),
      requestFrame: edge$(),
      requestFrameAndCompatibleModels: edge$(),
      requestColumnSummary: edge$(),
      requestModelBuilder: edge$(),
      requestModelBuilders: edge$(),
      requestModelBuild: edge$(),
      requestModelMetrics: edge$(),
      requestScoringOnFrame: edge$(),
      requestModels: edge$(),
      requestModel: edge$(),
      requestModelsAndCompatibleFrames: edge$(),
      requestModelAndCompatibleFrames: edge$(),
      requestJobs: edge$(),
      requestJob: edge$(),
      requestCloud: edge$(),
      requestTimeline: edge$(),
      putLocalObject: edge$(),
      getLocalObject: edge$(),
      getLocalObjects: edge$(),
      deleteLocalObject: edge$(),
      putIntoCache: edge$(),
      getFromCache: edge$(),
      removeFromCache: edge$(),
      switchTopic: edge$(),
      switchToFrames: edge$(),
      switchToModels: edge$(),
      switchToScoring: edge$(),
      switchToNotifications: edge$(),
      switchToJobs: edge$(),
      displayEmpty: edge$(),
      displayView: edge$(),
      promptImportFiles: edge$(),
      promptParseFiles: edge$(),
      loadFrames: edge$(),
      refreshFrames: edge$(),
      framesLoaded: edge$(),
      displayFrame: edge$(),
      promptForFrame: edge$(),
      activeFrameChanged: edge$(),
      promptCreateModel: edge$(),
      loadModels: edge$(),
      refreshModels: edge$(),
      displayModel: edge$(),
      activeModelChanged: edge$(),
      modelSelectionChanged: edge$(),
      modelSelectionCleared: edge$(),
      deselectAllModels: edge$(),
      clearModelSelection: edge$(),
      loadNotifications: edge$(),
      displayNotification: edge$(),
      loadScorings: edge$(),
      displayScoring: edge$(),
      scoringSelectionChanged: edge$(),
      scoringSelectionCleared: edge$(),
      scoringsSelected: edge$(),
      scoringsDeselected: edge$(),
      deselectAllScorings: edge$(),
      clearScoringSelection: edge$(),
      deleteScorings: edge$(),
      deleteActiveScoring: edge$(),
      scoringAvailable: edge$(),
      rescore: edge$(),
      configureStripPlot: edge$(),
      loadJobs: edge$(),
      displayJob: edge$(),
      jobsLoaded: edge$(),
      refreshJobs: edge$(),
      loadAdmin: edge$()
    });
  };

}).call(this);

(function() {
  Steam.Application = function(_) {
    var _view;
    if (typeof exports === "undefined" || exports === null) {
      Steam.ErrorMonitor(_);
      Steam.TextMetrics(_);
      Steam.CalloutManager(_);
      Steam.TooltipManager(_);
    }
    Steam.Timers(_);
    Steam.EventLog(_);
    Steam.Cache(_);
    Steam.LocalStorage(_);
    Steam.Xhr(_);
    Steam.H2OProxy(_);
    Steam.HelpServer(_);
    _view = Steam.MainView(_);
    Steam.Router(_, Steam.Routes(_));
    Steam.DialogManager(_);
    return {
      context: _,
      view: _view
    };
  };

}).call(this);

(function() {


}).call(this);

(function() {
  Steam.Cache = function(_) {
    var _cache;
    _cache = {};
    link$(_.putIntoCache, function(key, value) {
      return _cache[key] = value;
    });
    link$(_.getFromCache, function(key) {
      return _cache[key];
    });
    return link$(_.removeFromCache, function(key) {
      return delete _cache[key];
    });
  };

}).call(this);

(function() {
  Steam.CalloutManager = function(_) {
    var callout, createCallout, displayCallout, hideCallout, initialize, pointerSize, s2, s3, setCallout, switchPointer, table, tabulate, tbody, td, th, tr, _$text, __message, __offsetX, __offsetY, __pointer, __style, __textX, __textY, _calloutEl, _containerEl, _pointerEls, _pointerNE, _pointerNW, _pointerSE, _pointerSW, _ref, _textEl;
    pointerSize = 20;
    s2 = pointerSize * 2;
    s3 = pointerSize * 3;
    _containerEl = null;
    _calloutEl = null;
    _textEl = null;
    _pointerSW = null;
    _pointerSE = null;
    _pointerNW = null;
    _pointerNE = null;
    _pointerEls = null;
    _$text = null;
    _ref = geyser.generate(words('table tbody tr th td')), table = _ref[0], tbody = _ref[1], tr = _ref[2], th = _ref[3], td = _ref[4];
    initialize = function() {
      var $overlays;
      $overlays = $('.y-overlays');
      _containerEl = $overlays.parent().get(0);
      _calloutEl = document.createElement('div');
      _calloutEl.className = 'y-callout y-monospace';
      _pointerSW = createCallout('w', 's');
      _pointerSE = createCallout('e', 's');
      _pointerNW = createCallout('w', 'n');
      _pointerNE = createCallout('e', 'n');
      _pointerEls = [_pointerSW, _pointerSE, _pointerNW, _pointerNE];
      _textEl = document.createElement('div');
      _textEl.className = 'y-callout-text';
      _$text = $(_textEl);
      _calloutEl.appendChild(_pointerSW);
      _calloutEl.appendChild(_pointerSE);
      _calloutEl.appendChild(_pointerNW);
      _calloutEl.appendChild(_pointerNE);
      _calloutEl.appendChild(_textEl);
      return $overlays.append(_calloutEl);
    };
    switchPointer = function(target) {
      var source, _i, _len;
      for (_i = 0, _len = _pointerEls.length; _i < _len; _i++) {
        source = _pointerEls[_i];
        source.style.display = source === target ? null : 'none';
      }
    };
    createCallout = function(ew, ns) {
      var scaleX, scaleY, svg, translateX, translateY, x, y;
      x = ew === 'e' ? 0 : -s3;
      y = ns === 's' ? 0 : -s3;
      translateX = ew === 'e' ? 0 : s3;
      translateY = ns === 's' ? 0 : s3;
      scaleX = ew === 'e' ? 1 : -1;
      scaleY = ns === 's' ? 1 : -1;
      svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      d3.select(svg).attr('width', s3).attr('height', s3).style('position', 'absolute').style('display', 'none').style('left', "" + x + "px").style('top', "" + y + "px").append('g').attr('class', 'y-svg-callout').attr('transform', "translate(" + translateX + ", " + translateY + ") scale(" + scaleX + "," + scaleY + ")").append('polyline').attr('points', "0,0 " + s2 + "," + s2 + " " + s3 + "," + s2);
      return svg;
    };
    __style = 'none';
    __message = null;
    __pointer = null;
    __offsetX = __offsetY = __textX = __textY = 0;
    setCallout = function(message, offsetX, offsetY, textX, textY, pointer) {
      if (__message !== message) {
        _$text.html(__message = message);
      }
      if (__textX !== textX) {
        __textX = textX;
        _textEl.style.left = "" + textX + "px";
      }
      if (__textY !== textY) {
        __textY = textY;
        _textEl.style.top = "" + textY + "px";
      }
      if (__offsetX !== offsetX) {
        __offsetX = offsetX;
        _calloutEl.style.left = "" + offsetX + "px";
      }
      if (__offsetY !== offsetY) {
        __offsetY = offsetY;
        _calloutEl.style.top = "" + offsetY + "px";
      }
      if (__pointer !== pointer) {
        __pointer = pointer;
        switchPointer(pointer);
      }
    };
    hideCallout = function() {
      if (__style !== 'none') {
        return _calloutEl.style.display = __style = 'none';
      }
    };
    tabulate = function(obj) {
      var k, rows, v;
      rows = [];
      for (k in obj) {
        v = obj[k];
        rows.push(tr([th(k), td(v)]));
      }
      return geyser.render(table(tbody(rows)));
    };
    displayCallout = function(x, y, message) {
      var bleedsRight, bleedsTop, calloutTextHeight, calloutTextRect, calloutTextWidth, containerHeight, containerRect, containerWidth, ew, ns, offset, offsetX, offsetY, pointer, textX, textY;
      if (__style !== 'block') {
        _calloutEl.style.display = __style = 'block';
      }
      containerRect = _containerEl.getBoundingClientRect();
      containerWidth = containerRect.right - containerRect.left;
      containerHeight = containerRect.bottom - containerRect.top;
      calloutTextRect = _textEl.getBoundingClientRect();
      calloutTextWidth = calloutTextRect.right - calloutTextRect.left;
      calloutTextHeight = calloutTextRect.bottom - calloutTextRect.top;
      bleedsRight = x + s3 + calloutTextWidth > containerRect.right;
      bleedsTop = y - s2 - calloutTextHeight / 2 < containerRect.top;
      ew = bleedsRight ? 'w' : 'e';
      ns = bleedsTop ? 's' : 'n';
      offset = 3;
      offsetX = ew === 'w' ? -offset : offset;
      offsetY = ns === 'n' ? -offset : offset;
      textX = ew === 'w' ? -(calloutTextWidth + s3) : s3;
      textY = (2 * 20 + calloutTextHeight / 2) * (ns === 'n' ? -1 : 1);
      switch (ns + ew) {
        case 'ne':
          pointer = _pointerNE;
          break;
        case 'nw':
          pointer = _pointerNW;
          break;
        case 'se':
          pointer = _pointerSE;
          break;
        case 'sw':
          pointer = _pointerSW;
      }
      setCallout(message, x + offsetX, y + offsetY, textX, textY, pointer);
    };
    callout = function(message, x, y) {
      if (message) {
        return displayCallout(x, y, isObject(message) ? tabulate(message) : message);
      } else {
        return hideCallout();
      }
    };
    link$(_.callout, callout);
    return link$(_.ready, initialize);
  };

}).call(this);

(function() {
  Steam.CloudView = function(_) {
    var createCloud, createNode, createNodes, format3f, formatThreads, prettyPrintBytes, refresh, _cloud, _sizes, _timestamp;
    _cloud = node$(null);
    _timestamp = node$(Date.now());
    format3f = d3.format('.3f');
    _sizes = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
    prettyPrintBytes = function(bytes) {
      var i;
      if (bytes === 0) {
        return '-';
      }
      i = Math.floor(Math.log(bytes) / Math.log(1024));
      return (bytes / Math.pow(1024, i)).toFixed(2) + ' ' + _sizes[i];
    };
    formatThreads = function(fjs) {
      var i, max_lo, s, _i, _j, _k, _ref;
      for (max_lo = _i = 120; _i > 0; max_lo = --_i) {
        if (fjs[max_lo - 1] !== -1) {
          break;
        }
      }
      s = '[';
      for (i = _j = 0; 0 <= max_lo ? _j < max_lo : _j > max_lo; i = 0 <= max_lo ? ++_j : --_j) {
        s += Math.max(fjs[i], 0);
        s += '/';
      }
      s += '.../';
      for (i = _k = 120, _ref = fjs.length - 1; 120 <= _ref ? _k < _ref : _k > _ref; i = 120 <= _ref ? ++_k : --_k) {
        s += fjs[i];
        s += '/';
      }
      s += fjs[fjs.length - 1];
      s += ']';
      return s;
    };
    createNode = function(node) {
      return {
        isUnhealthy: !node.healthy,
        name: node.h2o.node,
        ping: (moment(new Date(node.last_ping))).fromNow(),
        cores: node.num_cpus,
        keys: node.num_keys,
        tcps: node.tcps_active,
        fds: node.open_fds < 0 ? '-' : node.open_fds,
        loadProgress: "" + (Math.ceil(node.sys_load)) + "%",
        load: format3f(node.sys_load),
        dataProgress: "" + (Math.ceil(node.mem_value_size / node.total_value_size * 100)) + "%",
        data: "" + (prettyPrintBytes(node.mem_value_size)) + " / " + (prettyPrintBytes(node.total_value_size)),
        cachedData: node.total_value_size === 0 ? '-' : " (" + (Math.floor(node.mem_value_size * 100 / node.total_value_size)) + "%)",
        memoryProgress1: "" + (Math.ceil((node.tot_mem - node.free_mem) / node.max_mem * 100)) + "%",
        memoryProgress2: "" + (Math.ceil(node.free_mem / node.max_mem * 100)) + "%",
        memory: "" + (prettyPrintBytes(node.free_mem)) + " / " + (prettyPrintBytes(node.tot_mem)) + " / " + (prettyPrintBytes(node.max_mem)),
        diskProgress: "" + (Math.ceil((node.max_disk - node.free_disk) / node.max_disk * 100)) + "%",
        disk: "" + (prettyPrintBytes(node.free_disk)) + " / " + (prettyPrintBytes(node.max_disk)),
        freeDisk: node.max_disk === 0 ? '' : " (" + (Math.floor(node.free_disk * 100 / node.max_disk)) + "%)",
        rpcs: node.rpcs_active,
        threads: formatThreads(node.fjthrds),
        tasks: formatThreads(node.fjqueue),
        pid: node.pid
      };
    };
    createNodes = function(nodes) {
      return map(nodes, createNode);
    };
    createCloud = function(result) {
      return {
        name: result.cloud_name,
        size: describeCount(result.cloud_size, 'Node'),
        canAcceptNodes: !result.locked,
        isAddingNodes: !result.consensus,
        badNodeMessage: "" + result.bad_nodes + " nodes in this cloud are unhealthy.",
        hasBadNodes: result.bad_nodes > 0,
        nodes: createNodes(result.nodes)
      };
    };
    refresh = function() {
      return _.requestCloud(function(error, result) {
        if (error) {
          return _.error('Error requesting cloud status', null, error);
        } else {
          _cloud(createCloud(result));
          return _timestamp(Date.now());
        }
      });
    };
    refresh();
    return {
      cloud: _cloud,
      timestamp: _timestamp,
      template: 'cloud-view'
    };
  };

}).call(this);

(function() {
  Steam.ConfigureStripPlotDialog = function(_, parameters, _go) {
    var cancel, confirm, wrap, _parameters;
    wrap = function(parameter) {
      return {
        id: parameter.id,
        caption: parameter.caption,
        isSelected: node$(parameter.isSelected()),
        source: parameter
      };
    };
    _parameters = {
      group1: map(parameters.group1(), wrap),
      group2: map(parameters.group2(), wrap),
      group3: map(parameters.group3(), wrap)
    };
    confirm = function() {
      return _go(_parameters);
    };
    cancel = function() {
      return _go(null);
    };
    return {
      parameters: _parameters,
      confirm: confirm,
      cancel: cancel,
      template: 'configure-strip-plot-dialog'
    };
  };

}).call(this);

(function() {
  Steam.ConfirmDialog = function(_, _message, _opts, _go) {
    var cancel, confirm;
    confirm = function() {
      return _go('confirm');
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _opts.title || 'Confirm',
      confirmCaption: _opts.confirmCaption || 'Yes',
      cancelCaption: _opts.cancelCaption || 'No',
      message: _message,
      confirm: confirm,
      cancel: cancel,
      template: 'confirm-dialog'
    };
  };

}).call(this);

(function() {
  var createCheckboxControl, createControlFromParameter, createDropdownControl, createListControl, createTextboxControl, findParameter;

  createTextboxControl = function(parameter) {
    var value;
    value = node$(parameter.actual_value);
    return {
      kind: 'textbox',
      name: parameter.name,
      label: parameter.label,
      description: parameter.help,
      required: parameter.required,
      value: value,
      defaultValue: parameter.default_value,
      help: node$('Help goes here.'),
      isInvalid: node$(false)
    };
  };

  createDropdownControl = function(parameter) {
    var value;
    value = node$(parameter.actual_value);
    return {
      kind: 'dropdown',
      name: parameter.name,
      label: parameter.label,
      description: parameter.help,
      required: parameter.required,
      values: parameter.values,
      value: value,
      defaultValue: parameter.default_value,
      help: node$('Help goes here.'),
      isInvalid: node$(false)
    };
  };

  createListControl = function(parameter) {
    var selection, value;
    value = node$(parameter.actual_value || []);
    selection = lift$(value, function(values) {
      var caption;
      caption = "" + (describeCount(values.length, 'column')) + " selected";
      if (values.length > 0) {
        caption += ": " + (values.join(', '));
      }
      return "(" + caption + ")";
    });
    return {
      kind: 'list',
      name: parameter.name,
      label: parameter.label,
      description: parameter.help,
      required: parameter.required,
      values: parameter.values,
      value: value,
      selection: selection,
      defaultValue: parameter.default_value,
      help: node$('Help goes here.'),
      isInvalid: node$(false)
    };
  };

  createCheckboxControl = function(parameter) {
    var value;
    value = node$(parameter.actual_value === 'true');
    return {
      clientId: uniqueId(),
      kind: 'checkbox',
      name: parameter.name,
      label: parameter.label,
      description: parameter.help,
      required: parameter.required,
      value: value,
      defaultValue: parameter.default_value === 'true',
      help: node$('Help goes here.'),
      isInvalid: node$(false)
    };
  };

  createControlFromParameter = function(parameter) {
    switch (parameter.type) {
      case 'enum':
      case 'Frame':
      case 'string':
        return createDropdownControl(parameter);
      case 'string[]':
        return createListControl(parameter);
      case 'boolean':
        return createCheckboxControl(parameter);
      case 'Key':
      case 'int':
      case 'long':
      case 'float':
      case 'double':
      case 'int[]':
      case 'long[]':
      case 'float[]':
      case 'double[]':
        return createTextboxControl(parameter);
      default:
        console.error('Invalid field', JSON.stringify(parameter, null, 2));
        return null;
    }
  };

  findParameter = function(parameters, name) {
    return find(parameters, function(parameter) {
      return parameter.name === name;
    });
  };

  Steam.ModelBuilderForm = function(_, _algorithm, _parameters, _go) {
    var createModel, parameterTemplateOf, _controls, _criticalControls, _expertControls, _parametersByLevel, _secondaryControls, _validationError;
    _validationError = node$(null);
    _parametersByLevel = groupBy(_parameters, function(parameter) {
      return parameter.level;
    });
    _controls = map(['critical', 'secondary', 'expert'], function(type) {
      return filter(map(_parametersByLevel[type], createControlFromParameter), isTruthy);
    });
    _criticalControls = _controls[0], _secondaryControls = _controls[1], _expertControls = _controls[2];
    parameterTemplateOf = function(control) {
      return "" + control.kind + "-model-parameter";
    };
    createModel = function() {
      var control, controls, parameters, value, _i, _j, _len, _len1;
      _validationError(null);
      parameters = {};
      for (_i = 0, _len = _controls.length; _i < _len; _i++) {
        controls = _controls[_i];
        for (_j = 0, _len1 = controls.length; _j < _len1; _j++) {
          control = controls[_j];
          if (control.defaultValue !== (value = control.value())) {
            switch (control.kind) {
              case 'dropdown':
                if (value) {
                  parameters[control.name] = value;
                }
                break;
              case 'list':
                if (value.length) {
                  parameters[control.name] = "[" + (value.join(',')) + "]";
                }
                break;
              default:
                parameters[control.name] = value;
            }
          }
        }
      }
      return _.requestModelBuild(_algorithm.key, parameters, function(error, result) {
        if (error) {
          return _validationError({
            message: error.data.errmsg
          });
        } else {
          return _go('confirm');
        }
      });
    };
    return {
      title: "Configure " + _algorithm.title + " Model",
      criticalControls: _criticalControls,
      secondaryControls: _secondaryControls,
      expertControls: _expertControls,
      validationError: _validationError,
      parameterTemplateOf: parameterTemplateOf,
      createModel: createModel
    };
  };

  Steam.CreateModelDialog = function(_, _frameKey, _sourceModel, _go) {
    var backToAlgorithms, cancel, createModel, populateFramesAndColumns, _algorithms, _canChangeAlgorithm, _isAlgorithmSelectionMode, _isModelCreationMode, _modelForm, _ref, _title;
    _ref = switch$(false, 2), _isAlgorithmSelectionMode = _ref[0], _isModelCreationMode = _ref[1];
    _title = node$('New Model');
    _canChangeAlgorithm = node$(true);
    _algorithms = nodes$([]);
    _modelForm = node$(null);
    populateFramesAndColumns = function(frameKey, algorithm, parameters, go) {
      return _.requestFrames(function(error, result) {
        var columnLabels, ignoredColumnsParameter, responseColumnParameter, trainingFrame, trainingFrameParameter, validationFrameParameter;
        if (error) {

        } else {
          trainingFrameParameter = findParameter(parameters, 'training_frame');
          if (!trainingFrameParameter) {
            console.error("Model does not have a 'training_frame' parameter!");
            return go();
          }
          trainingFrameParameter.values = map(result.frames, function(frame) {
            return frame.key.name;
          });
          if (frameKey) {
            trainingFrameParameter.actual_value = frameKey;
          } else {
            frameKey = trainingFrameParameter.actual_value;
          }
          if (algorithm.key === 'deeplearning') {
            validationFrameParameter = findParameter(parameters, 'validation_frame');
            responseColumnParameter = findParameter(parameters, 'response_column');
            ignoredColumnsParameter = findParameter(parameters, 'ignored_columns');
            validationFrameParameter.values = copy(trainingFrameParameter.values);
            if (trainingFrame = find(result.frames, function(frame) {
              return frame.key.name === frameKey;
            })) {
              columnLabels = map(trainingFrame.columns, function(column) {
                return column.label;
              });
              sort(columnLabels);
              responseColumnParameter.values = columnLabels;
              ignoredColumnsParameter.values = columnLabels;
            }
          } else if (algorithm.key === 'gbm') {
            responseColumnParameter = findParameter(parameters, 'response_column');
            if (trainingFrame = find(result.frames, function(frame) {
              return frame.key.name === frameKey;
            })) {
              columnLabels = map(trainingFrame.columns, function(column) {
                return column.label;
              });
              sort(columnLabels);
              responseColumnParameter.values = columnLabels;
            }
          }
          return go();
        }
      });
    };
    _.requestModelBuilders(function(error, algorithms) {
      var algorithm, hasRateAnnealing, parameters, selectAlgorithm;
      algorithms = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = algorithms.length; _i < _len; _i++) {
          algorithm = algorithms[_i];
          _results.push({
            key: algorithm,
            title: algorithm
          });
        }
        return _results;
      })();
      if (_sourceModel) {
        _title('Clone Model');
        _canChangeAlgorithm(false);
        _isModelCreationMode(true);
        selectAlgorithm = noop;
        parameters = _sourceModel.parameters;
        hasRateAnnealing = find(_sourceModel.parameters, function(parameter) {
          return parameter.name === 'rate_annealing';
        });
        algorithm = hasRateAnnealing ? find(algorithms, function(algorithm) {
          return algorithm.key === 'deeplearning';
        }) : find(algorithms, function(algorithm) {
          return algorithm.key === 'kmeans';
        });
        return populateFramesAndColumns(_frameKey, algorithm, parameters, function() {
          return _modelForm(Steam.ModelBuilderForm(_, algorithm, parameters, _go));
        });
      } else {
        _isAlgorithmSelectionMode(true);
        selectAlgorithm = function(algorithm) {
          return _.requestModelBuilder(algorithm.key, function(error, result) {
            if (error) {

            } else {
              parameters = result.model_builders[algorithm.key].parameters;
              return populateFramesAndColumns(_frameKey, algorithm, parameters, function() {
                _modelForm(Steam.ModelBuilderForm(_, algorithm, parameters, _go));
                return _isModelCreationMode(true);
              });
            }
          });
        };
        return _algorithms(map(algorithms, function(algorithm) {
          var self;
          return self = {
            title: algorithm.title,
            data: algorithm,
            select: function() {
              return selectAlgorithm(self.data);
            }
          };
        }));
      }
    });
    backToAlgorithms = function() {
      return _isAlgorithmSelectionMode(true);
    };
    createModel = function() {
      return _modelForm().createModel();
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _title,
      isAlgorithmSelectionMode: _isAlgorithmSelectionMode,
      isModelCreationMode: _isModelCreationMode,
      algorithms: _algorithms,
      modelForm: _modelForm,
      cancel: cancel,
      canChangeAlgorithm: _canChangeAlgorithm,
      backToAlgorithms: backToAlgorithms,
      createModel: createModel,
      template: 'create-model-dialog'
    };
  };

}).call(this);

(function() {
  var __slice = [].slice;

  Steam.DialogManager = function(_) {
    var initialize, linkDialog;
    initialize = function() {
      linkDialog(_.alert, Steam.AlertDialog);
      linkDialog(_.fail, Steam.ErrorDialog);
      linkDialog(_.confirm, Steam.ConfirmDialog);
      linkDialog(_.promptForFrame, Steam.SelectFrameDialog);
      linkDialog(_.configureStripPlot, Steam.ConfigureStripPlotDialog);
      linkDialog(_.promptImportFiles, Steam.ImportFilesDialog);
      linkDialog(_.promptParseFiles, Steam.ParseFilesDialog);
      return linkDialog(_.promptCreateModel, Steam.CreateModelDialog);
    };
    linkDialog = function(edge, createDialog) {
      return link$(edge, function() {
        var dialog, go, requestArgs, _i;
        requestArgs = 2 <= arguments.length ? __slice.call(arguments, 0, _i = arguments.length - 1) : (_i = 0, []), go = arguments[_i++];
        if (!isFunction(go)) {
          throw new Error('No continuation provided.');
        }
        requestArgs.unshift(_);
        requestArgs.push(function() {
          var responseArgs;
          responseArgs = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
          _.unloadDialog(dialog);
          return go.apply(null, responseArgs);
        });
        return _.loadDialog(dialog = createDialog.apply(null, requestArgs));
      });
    };
    link$(_.positionDialog, function(element) {
      var $container, $dialog, $dialogBody, $dialogContainer, $dialogHeader, dialogBodyHeight, dialogHeaderHeight, dialogHeight, dialogLeft, dialogTop, dialogWidth, heightAttr, parentHeight, parentWidth, widthAttr, _ref;
      if (element.nodeType !== 1) {
        return;
      }
      $dialogContainer = $(element);
      $dialog = $($dialogContainer.children()[0]);
      _ref = map($dialog.children(), function(child) {
        return $(child);
      }), $dialogHeader = _ref[0], $dialogBody = _ref[1];
      widthAttr = $dialog.attr('data-dialog-width');
      heightAttr = $dialog.attr('data-dialog-height');
      dialogWidth = isUndefined(widthAttr) ? 0 : parseInt(widthAttr);
      dialogHeight = isUndefined(heightAttr) ? 0 : parseInt(heightAttr);
      $container = $dialog.parent().parent();
      parentWidth = $container.width();
      if (dialogWidth === 0) {
        dialogWidth = parentWidth * 0.75;
      } else if (dialogWidth === -1) {
        dialogWidth = parentWidth * 0.95;
      }
      $dialog.width(dialogWidth);
      if (dialogHeight === 0) {
        dialogHeight = $dialog.height();
      } else if (dialogHeight === -1) {
        parentHeight = $container.height();
        dialogHeight = parentHeight * 0.95;
      }
      dialogLeft = -dialogWidth / 2;
      dialogTop = -dialogHeight / 2;
      dialogHeaderHeight = $dialogHeader.height();
      dialogBodyHeight = dialogHeight - dialogHeaderHeight;
      $dialog.attr('style', "position:absolute;width:" + dialogWidth + "px;height:" + dialogHeight + "px;left:" + dialogLeft + "px;top:" + dialogTop + "px");
      $dialogHeader.attr('style', 'position:absolute;top:0;left:0;right:0');
      return $dialogBody.attr('style', "position:absolute;left:0;right:0;bottom:0;top:" + dialogHeaderHeight + "px");
    });
    initialize();
  };

}).call(this);

(function() {
  Steam.ErrorDialog = function(_, _title, _message, error, _go) {
    var cancel, confirm, message;
    if (isObject(_message)) {
      message = JSON.stringify(_message, null, 2);
    } else {
      message = _message;
    }
    confirm = function() {
      return _go('confirm');
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      title: _title,
      message: message,
      confirm: confirm,
      cancel: cancel,
      error: error,
      template: 'error-dialog'
    };
  };

}).call(this);

(function() {
  Steam.ErrorMonitor = function(_) {
    return window.onerror = function(message, url, lineNumber) {
      return _.fatal(message, {
        url: url,
        lineNumber: lineNumber
      });
    };
  };

}).call(this);

(function() {
  Steam.EventLog = function(_) {
    var log, logError;
    log = function(level, message, data, cause) {
      return _.notify({
        level: level,
        message: message,
        data: data,
        cause: cause,
        timestamp: new Date()
      });
    };
    logError = function(level, message, data, error) {
      var stackTrace;
      stackTrace = error ? printStackTrace({
        e: error
      }) : printStackTrace();
      return log(level, message, data, {
        error: error,
        stackTrace: stackTrace
      });
    };
    link$(_.info, function(message, data) {
      if (message == null) {
        message = '';
      }
      return log('info', message, data);
    });
    link$(_.warn, function(message, data) {
      if (message == null) {
        message = '';
      }
      return log('warn', message, data);
    });
    link$(_.error, function(message, data, error) {
      if (message == null) {
        message = '';
      }
      return logError('error', message, data, error);
    });
    link$(_.fatal, function(message, data, error) {
      if (message == null) {
        message = '';
      }
      return logError('fatal', message, data, error);
    });
  };

}).call(this);

(function() {
  Steam.FrameInspectionView = function(_, _frame) {
    return {
      title: _frame.key,
      key: _frame.key,
      columns: _frame.column_names,
      columnCount: "(" + _frame.column_names.length + ")",
      isRawFrame: _frame.is_raw_frame,
      template: 'frame-inspection-view'
    };
  };

}).call(this);

(function() {
  Steam.FrameListView = function(_) {
    var activateAndDisplayItem, clearPredicate, createItem, displayActiveItem, displayFrames, displayItem, importFile, loadFrames, _canClearPredicate, _hasItems, _items, _predicate, _predicateCaption;
    _predicate = node$({
      type: 'all'
    });
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    _canClearPredicate = lift$(_predicate, function(predicate) {
      return predicate.type !== 'all';
    });
    _predicateCaption = lift$(_predicate, function(predicate) {
      switch (predicate.type) {
        case 'all':
          return 'Showing\nall datasets';
        case 'one':
          return 'Showing\none dataset';
        case 'compatibleWithModel':
          return "Showing datasets compatible with\n" + predicate.modelKey;
        default:
          throw new Error('Invalid predicate type');
      }
    });
    displayItem = function(item) {
      if (item) {
        _.displayFrame(item.data);
        _.activeFrameChanged(item.data);
      } else {
        _.displayEmpty();
        _.activeFrameChanged(null);
      }
      return _.inspect(null);
    };
    displayActiveItem = function() {
      return displayItem(find(_items(), function(item) {
        return item.isActive();
      }));
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createItem = function(frame) {
      var self;
      console.assert(isArray(frame.columns));
      return self = {
        data: frame,
        title: frame.key.name,
        caption: (describeCount(frame.columns.length, 'column')) + ': ' + join(map(head(frame.columns, 5), function(column) {
          return column.label;
        }), ', '),
        timestamp: frame.creation_epoch_time_millis,
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false)
      };
    };
    displayFrames = function(frames) {
      var items;
      _items(items = map(frames, createItem));
      activateAndDisplayItem(head(items));
      return _.framesLoaded();
    };
    loadFrames = function(predicate) {
      switch (predicate.type) {
        case 'all':
          _.requestFrames(function(error, result) {
            if (error) {
              return _.error('Error requesting all frames', null, error);
            } else {
              return displayFrames(result.frames);
            }
          });
          break;
        case 'one':
          _.requestFrame(predicate.key, function(error, result) {
            if (error) {
              return _.error('Error requesting frame', predicate.key, error);
            } else {
              return displayFrames(result.frames);
            }
          });
      }
      _predicate(predicate);
    };
    importFile = function() {
      return _.promptImportFiles(function(action, job) {
        switch (action) {
          case 'confirm':
            _.switchToJobs();
        }
      });
    };
    clearPredicate = function() {
      return loadFrames({
        type: 'all'
      });
    };
    link$(_.loadFrames, function(predicate) {
      if (predicate) {
        return loadFrames(predicate);
      } else {
        return loadFrames({
          type: 'all'
        });
      }
    });
    link$(_.refreshFrames, function() {
      return loadFrames(_predicate());
    });
    return {
      items: _items,
      predicateCaption: _predicateCaption,
      clearPredicate: clearPredicate,
      canClearPredicate: _canClearPredicate,
      importFile: importFile,
      hasItems: _hasItems,
      template: 'frame-list-view'
    };
  };

}).call(this);

(function() {
  Steam.FrameSelectionView = function(_) {
    var createModel, deleteFrame, _activeFrame, _hasActiveFrame;
    _activeFrame = node$();
    _hasActiveFrame = lift$(_activeFrame, isTruthy);
    createModel = function() {
      return _.promptCreateModel(_activeFrame().key.name, null, function(action) {
        switch (action) {
          case 'confirm':
            return _.switchToJobs();
        }
      });
    };
    deleteFrame = function() {};
    link$(_.activeFrameChanged, function(frame) {
      return _activeFrame(frame);
    });
    return {
      createModel: createModel,
      hasActiveFrame: _hasActiveFrame,
      deleteFrame: deleteFrame,
      template: 'frame-selection-view'
    };
  };

}).call(this);

(function() {
  var computeBoxplot, computeCharacteristics, computeHistogram, computeTopCounts, createHistogram, formatDateTime, formatReal, formatTime, formatToSignificantDigits, localConfig, renderBoxplot, renderCharacteristics, renderHistogram, renderTopCounts, significantDigitsBeforeDecimal;

  localConfig = {
    chartWidth: 275
  };

  significantDigitsBeforeDecimal = function(value) {
    return 1 + Math.floor(Math.log(Math.abs(value)) / Math.LN10);
  };

  formatToSignificantDigits = function(digits, value) {
    var magnitude, sd;
    if (value === 0) {
      return 0;
    } else {
      sd = significantDigitsBeforeDecimal(value);
      if (sd >= digits) {
        return value.toFixed(0);
      } else {
        magnitude = Math.pow(10, digits - sd);
        return Math.round(value * magnitude) / magnitude;
      }
    }
  };

  if (typeof exports === "undefined" || exports === null) {
    formatTime = d3.time.format('%Y-%m-%d %H:%M:%S');
  }

  formatDateTime = function(time) {
    if (time) {
      return formatTime(new Date(time));
    } else {
      return '-';
    }
  };

  formatReal = (function() {
    var getFormatFunction, __formatFunctions;
    __formatFunctions = {};
    getFormatFunction = function(precision) {
      if (precision === -1) {
        return identity;
      } else {
        return __formatFunctions[precision] || (__formatFunctions[precision] = d3.format("." + precision + "f"));
      }
    };
    return function(precision, value) {
      return (getFormatFunction(precision))(value);
    };
  })();

  computeTopCounts = function(column, rowCount, top) {
    var bins, domain, levels, sortedLevels;
    bins = column.bins, domain = column.domain;
    levels = map(bins, function(count, index) {
      return {
        count: count,
        index: index
      };
    });
    sortedLevels = sortBy(levels, function(level) {
      return -level.count;
    });
    return {
      cardinality: column.domain.length,
      levels: map(head(sortedLevels, top), function(level) {
        return {
          label: domain[level.index],
          percent: "" + (formatReal(1, level.count / rowCount * 100)) + "%",
          count: level.count
        };
      })
    };
  };

  renderTopCounts = function(topCounts, bounds) {
    var height, scaleY, width;
    width = bounds.width - bounds.margin.left - bounds.margin.right;
    height = bounds.height - bounds.margin.top - bounds.margin.bottom;
    return scaleY = d3.scale.linear().domain([0, histogram.maxCount]).range([height, 0]);
  };

  renderHistogram = function(_, histogram, bounds) {
    var bar, el, height, intervalWidth, scaleX, scaleY, svg, width;
    width = bounds.width - bounds.margin.left - bounds.margin.right;
    height = bounds.height - bounds.margin.top - bounds.margin.bottom;
    scaleX = d3.scale.linear().domain(histogram.domain).range([0, width]);
    scaleY = d3.scale.linear().domain([0, histogram.maxCount]).range([height, 0]);

    /*
    axisX = d3.svg.axis()
      .scale scaleX
      .orient 'bottom'
    
    axisY = d3.svg.axis()
      .scale scaleY
      .orient 'left'
      .ticks 5
     */
    el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg = d3.select(el).attr('width', bounds.width).attr('height', bounds.height).append('g').attr('transform', "translate(" + bounds.margin.left + "," + bounds.margin.top + ")");
    svg.append('line').attr('x1', 0).attr('x2', width).attr('y1', height).attr('y2', height).style('fill', 'none').style('stroke', 'lightskyblue');
    bar = svg.selectAll('.bar').data(histogram.bins).enter().append('g').attr('class', 'bar').attr('transform', function(bin) {
      return "translate(" + (scaleX(bin.start)) + "," + (scaleY(bin.count)) + ")";
    });
    intervalWidth = scaleX(histogram.domain[0] + histogram.stride) - scaleX(histogram.domain[0]);
    bar.append('rect').attr('x', 1).attr('width', intervalWidth - 1).attr('height', function(bin) {
      return height - scaleY(bin.count);
    }).on('mouseover', function(bin) {
      var column, tooltip;
      column = histogram.column;
      tooltip = column.type === 'real' ? {
        From: formatReal(column.precision, bin.start),
        To: formatReal(column.precision, bin.end),
        Count: bin.count
      } : {
        From: bin.start,
        To: bin.end,
        Count: bin.count
      };
      return _.tooltip(this, tooltip, 'top');
    }).on('mouseout', function() {
      return _.tooltip(null);
    });

    /*
    bar.append 'title'
      .text (bin) ->
        column = histogram.column
        if column.type is 'real'
          "#{bin.count} (#{formatReal column.precision, bin.start} - #{formatReal column.precision, bin.end})"
        else
          "#{bin.count} (#{bin.start} - #{bin.end})"
    
    svg.append 'g'
      .attr 'class', 'x axis'
      .attr 'transform', "translate(0,#{height})"
      .call axisX
    
    svg.append 'g'
      .attr 'class', 'y axis'
      .call axisY
     */
    return el;
  };

  createHistogram = function(column, stride, interval, bins) {
    var end, start;
    start = (head(bins)).start;
    end = (last(bins)).end;
    return {
      column: column,
      bins: bins,
      stride: stride * interval,
      domain: [start, end],
      start: column.type === 'real' ? formatReal(column.precision, start) : start,
      end: column.type === 'real' ? formatReal(column.precision, end) : end,
      maxCount: d3.max(bins, function(bin) {
        return bin.count;
      })
    };
  };

  computeCharacteristics = function(column, rowCount) {
    var chunks, missing, ninfs, offset, other, parts, pinfs, zeros;
    missing = column.missing, zeros = column.zeros, pinfs = column.pinfs, ninfs = column.ninfs;
    other = rowCount - missing - zeros - pinfs - ninfs;
    chunks = [['Missing', missing, 'tomato'], ['-Inf', ninfs, 'lightseagreen'], ['Zero', zeros, 'lightslategray'], ['+Inf', pinfs, 'lightskyblue'], ['Other', other, '#aaa']];
    offset = 0;
    parts = map(chunks, function(chunk) {
      var color, count, label, part, percent;
      label = chunk[0], count = chunk[1], color = chunk[2];
      percent = "" + (formatReal(1, count / rowCount * 100)) + "%";
      part = {
        label: "" + label,
        percent: percent,
        offset: offset,
        count: count,
        color: color
      };
      offset += count;
      return part;
    });
    return {
      total: rowCount,
      parts: parts
    };
  };

  renderCharacteristics = function(characteristics, bounds) {
    var bar, el, height, scaleX, svg, width;
    width = bounds.width - bounds.margin.left - bounds.margin.right;
    height = bounds.height - bounds.margin.top - bounds.margin.bottom;
    scaleX = d3.scale.linear().domain([0, characteristics.total]).range([0, width]);
    el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg = d3.select(el).attr('width', bounds.width).attr('height', bounds.height).append('g').attr('transform', "translate(" + bounds.margin.left + "," + bounds.margin.top + ")");
    bar = svg.selectAll('.bar').data(characteristics.parts).enter().append('g').attr('class', 'bar').attr('transform', function(part) {
      return "translate(" + (scaleX(part.offset)) + ",0)";
    });
    bar.append('rect').attr('x', 1).attr('width', function(part) {
      return scaleX(part.count);
    }).attr('height', bounds.height).style('fill', function(part) {
      return part.color;
    });
    bar.append('title').text(function(part) {
      return "" + part.label + " (" + part.percent + ")";
    });
    return el;
  };

  computeBoxplot = function(percentiles, column) {
    return {
      q1: column.pctiles[percentiles.indexOf(0.25)],
      q2: column.pctiles[percentiles.indexOf(0.5)],
      q3: column.pctiles[percentiles.indexOf(0.75)],
      mean: column.mean,
      min: head(column.mins),
      max: head(column.maxs),
      mins: column.mins,
      maxs: column.maxs
    };
  };

  renderBoxplot = function(_, boxplot, bounds) {
    var drawCircle, drawHotspot, drawRule, g, h25, h50, h75, height, max, maxs, mean, min, mins, q1, q2, q3, scaleX, svg, width;
    width = bounds.width - bounds.margin.left - bounds.margin.right;
    height = bounds.height - bounds.margin.top - bounds.margin.bottom;
    scaleX = d3.scale.linear().domain([boxplot.min, boxplot.max]).range([0, width]);
    svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    g = d3.select(svg).attr('width', bounds.width).attr('height', bounds.height).append('g').attr('transform', "translate(" + bounds.margin.left + "," + bounds.margin.top + ")");
    h25 = height / 4;
    h50 = height / 2;
    h75 = height * 0.75;
    q1 = scaleX(boxplot.q1);
    q2 = scaleX(boxplot.q2);
    q3 = scaleX(boxplot.q3);
    mean = scaleX(boxplot.mean);
    min = scaleX(boxplot.min);
    max = scaleX(boxplot.max);
    mins = map(boxplot.mins, scaleX);
    maxs = map(boxplot.maxs, scaleX);
    drawRule = function(x1, y1, x2, y2) {
      return g.append('line').attr('class', 'rule').attr('x1', x1).attr('y1', y1).attr('x2', x2).attr('y2', y2);
    };
    drawCircle = function(x) {
      return g.append('circle').attr('class', 'rule').attr('cx', x).attr('cy', h50).attr('r', 3);
    };
    drawHotspot = function(x, name, value) {
      return g.append('circle').attr('class', 'hotspot').attr('cx', x).attr('cy', h50).attr('r', 5).on('mouseover', function() {
        var tooltip;
        tooltip = {};
        tooltip[name] = value;
        return _.tooltip(this, tooltip, 'top');
      }).on('mouseout', function() {
        return _.tooltip(null);
      });
    };
    g.append('rect').attr('class', 'rule').attr('x', q1).attr('y', 0).attr('width', q3 - q1).attr('height', height);
    drawRule(0, h50, q1, h50);
    drawRule(q3, h50, width, h50);
    drawRule(0, h25, 0, h75);
    drawRule(width, h25, width, h75);
    drawRule(q2, 0, q2, height).style('stroke-dasharray', '3,3');
    drawRule(mean - 5, h50, mean + 5, h50);
    drawRule(mean, h50 - 5, mean, h50 + 5);
    forEach(mins, function(value) {
      if (value !== min) {
        return drawCircle(value);
      }
    });
    forEach(maxs, function(value) {
      if (value !== max) {
        return drawCircle(value);
      }
    });
    drawHotspot(q1, 'Q1', boxplot.q1);
    drawHotspot(q2, 'Q2', boxplot.q2);
    drawHotspot(q3, 'Q3', boxplot.q3);
    drawHotspot(mean, 'Mean', boxplot.mean);
    forEach(mins, function(value, i) {
      return drawHotspot(value, "Min #" + (i + 1), boxplot.mins[i]);
    });
    forEach(maxs, function(value, i) {
      return drawHotspot(value, "Max #" + (i + 1), boxplot.maxs[i]);
    });
    return svg;
  };

  computeHistogram = function(column, minIntervalCount) {
    var base, bins, interval, intervalCount, stride;
    base = column.base, stride = column.stride, bins = column.bins;
    interval = Math.floor(bins.length / minIntervalCount);
    if (interval > 0) {
      intervalCount = minIntervalCount + (bins.length % interval > 0 ? 1 : 0);
      return createHistogram(column, stride, interval, times(intervalCount, function(intervalIndex) {
        var binIndex, count, m, n, _i;
        m = intervalIndex * interval;
        n = m + interval;
        count = 0;
        for (binIndex = _i = m; m <= n ? _i < n : _i > n; binIndex = m <= n ? ++_i : --_i) {
          if (n < bins.length) {
            count += bins[binIndex];
          }
        }
        return {
          start: base + intervalIndex * stride * interval,
          end: base + (intervalIndex + 1) * stride * interval,
          count: count
        };
      }));
    } else {
      return createHistogram(column, stride, 1, map(bins, function(count, intervalIndex) {
        return {
          start: base + intervalIndex * stride,
          end: base + (intervalIndex + 1) * stride,
          count: count
        };
      }));
    }
  };

  Steam.FrameView = function(_, _frame) {
    var createCardinalityRow, createDataRow, createDataRows, createFrameTable, createInfRow, createMeanRow, createMinMaxRow, createMissingsRow, createPlainRow, createSigmaRow, createSummaryInspection, createSummaryRow, renderTopCountsTable;
    createMinMaxRow = function(attribute, columns) {
      return map(columns, function(column) {
        switch (column.type) {
          case 'time':
            return formatDateTime(head(column[attribute]));
          case 'real':
            return formatReal(column.precision, head(column[attribute]));
          case 'int':
            return formatToSignificantDigits(6, head(column[attribute]));
          default:
            return '-';
        }
      });
    };
    createMeanRow = function(columns) {
      return map(columns, function(column) {
        switch (column.type) {
          case 'time':
            return formatDateTime(column.mean);
          case 'real':
            return formatReal(column.precision, column.mean);
          case 'int':
            return formatToSignificantDigits(6, column.mean);
          default:
            return '-';
        }
      });
    };
    createSigmaRow = function(columns) {
      return map(columns, function(column) {
        switch (column.type) {
          case 'time':
          case 'real':
          case 'int':
            return formatToSignificantDigits(6, column.sigma);
          default:
            return '-';
        }
      });
    };
    createCardinalityRow = function(columns) {
      return map(columns, function(column) {
        switch (column.type) {
          case 'enum':
            return column.domain.length;
          default:
            return '-';
        }
      });
    };
    createPlainRow = function(attribute, columns) {
      return map(columns, function(column) {
        return column[attribute];
      });
    };
    createMissingsRow = function(columns) {
      return map(columns, function(column) {
        if (column.missing === 0) {
          return '-';
        } else {
          return column.missing;
        }
      });
    };
    createInfRow = function(attribute, columns) {
      return map(columns, function(column) {
        switch (column.type) {
          case 'real':
          case 'int':
            if (column[attribute] === 0) {
              return '-';
            } else {
              return column[attribute];
            }
            break;
          default:
            return '-';
        }
      });
    };
    renderTopCountsTable = function(topCounts) {
      var datacell, div, maxCount, table, tbody, td, tr, _ref;
      _ref = geyser.generate(words('div table.table.table-condensed.table-striped.y-monospace tbody tr td')), div = _ref[0], table = _ref[1], tbody = _ref[2], tr = _ref[3], td = _ref[4];
      datacell = geyser.generate(["td.y-chart data-value='$value'"])[0];
      maxCount = d3.max(topCounts.levels, function(level) {
        return level.count;
      });
      return div(table(tbody(map(topCounts.levels, function(level) {
        return tr([
          td(level.label), td(level.count), datacell('', {
            $value: level.count / maxCount
          }), td(level.percent)
        ]);
      }))));
    };
    createSummaryInspection = function(frame) {
      var appendBoxplot, appendCharacteristics, appendHistogram, boxplot, boxplotInspection, characteristics, characteristicsInspection, column, div, histogram, histogramInspection, maxBarSize, topCounts, topCountsInspection, topCountsTable, updateTopCountsTable;
      column = head(frame.columns);
      div = geyser.generate(['div'])[0];
      switch (column.type) {
        case 'int':
        case 'real':
          histogram = computeHistogram(column, 32);
          appendHistogram = function($element) {
            return $element.empty().append(renderHistogram(_, histogram, {
              width: localConfig.chartWidth,
              height: 100,
              margin: {
                top: 0,
                right: 0,
                bottom: 0,
                left: 0
              }
            }));
          };
          histogramInspection = {
            data: histogram,
            graphic: {
              markup: div(),
              behavior: appendHistogram
            }
          };
          boxplot = computeBoxplot(frame.default_pctiles, column);
          appendBoxplot = function($element) {
            return $element.empty().append(renderBoxplot(_, boxplot, {
              width: localConfig.chartWidth,
              height: 70,
              margin: {
                top: 5,
                right: 5,
                bottom: 5,
                left: 5
              }
            }));
          };
          boxplotInspection = {
            data: boxplot,
            graphic: {
              markup: div(),
              behavior: appendBoxplot
            }
          };
          break;
        default:
          topCounts = computeTopCounts(column, frame.rows, 15);
          topCountsTable = renderTopCountsTable(topCounts);
          maxBarSize = 100;
          updateTopCountsTable = function($element) {
            var bar, container, _ref;
            _ref = geyser.generate(["div.y-box", "div.y-bar style='width:$width'"]), container = _ref[0], bar = _ref[1];
            return $('td.y-chart', $element).each(function() {
              var $el, value;
              $el = $(this);
              value = parseFloat($el.attr('data-value'));
              return $el.append(geyser.render(container(bar('', {
                $width: "" + (Math.round(value * 100)) + "%"
              }))));
            });
          };
          topCountsInspection = {
            caption: topCounts.cardinality === topCounts.levels.length ? 'Levels' : "Top " + (describeCount(topCounts.levels.length, 'Level')),
            graphic: {
              markup: topCountsTable,
              behavior: updateTopCountsTable
            }
          };
      }
      characteristics = computeCharacteristics(column, frame.rows);
      appendCharacteristics = function($element) {
        return $element.empty().append(renderCharacteristics(characteristics, {
          width: localConfig.chartWidth,
          height: 10,
          margin: {
            top: 0,
            right: 0,
            bottom: 0,
            left: 0
          }
        }));
      };
      characteristicsInspection = {
        parts: characteristics.parts,
        graphic: {
          markup: div(),
          behavior: appendCharacteristics
        }
      };
      return _.inspect({
        columnLabel: column.label,
        histogram: histogramInspection,
        boxplot: boxplotInspection,
        topCounts: topCountsInspection,
        characteristics: characteristicsInspection,
        template: 'column-summary-view'
      });
    };
    createSummaryRow = function(frameKey, columns) {
      return map(columns, function(column) {
        return {
          displaySummary: function() {
            return _.requestColumnSummary(frameKey, column.label, function(error, result) {
              if (error) {
                return _.error('Error requesting column summary', column, error);
              } else {
                return createSummaryInspection(head(result.frames));
              }
            });
          }
        };
      });
    };
    createDataRow = function(offset, index, columns) {
      return {
        header: "Row " + (offset + index + 1),
        cells: map(columns, function(column) {
          var value;
          switch (column.type) {
            case 'uuid':
            case 'string':
              return column.str_data[index] || '-';
            case 'enum':
              return column.domain[column.data[index]];
            case 'time':
              return formatDateTime(column.data[index]);
            default:
              value = column.data[index];
              if (value === 'NaN') {
                return '-';
              } else {
                if (column.type === 'real') {
                  return formatReal(column.precision, value);
                } else {
                  return value;
                }
              }
          }
        })
      };
    };
    createDataRows = function(offset, rowCount, columns) {
      var index, rows, _i;
      rows = [];
      for (index = _i = 0; 0 <= rowCount ? _i < rowCount : _i > rowCount; index = 0 <= rowCount ? ++_i : --_i) {
        rows.push(createDataRow(offset, index, columns));
      }
      return rows;
    };
    createFrameTable = function(offset, rowCount, columns) {
      var column, hasEnums, hasMissings, hasNinfs, hasPinfs, hasZeros, _i, _len;
      hasMissings = hasZeros = hasPinfs = hasNinfs = hasEnums = false;
      for (_i = 0, _len = columns.length; _i < _len; _i++) {
        column = columns[_i];
        if (!hasMissings && column.missing > 0) {
          hasMissings = true;
        }
        if (!hasZeros && column.zeros > 0) {
          hasZeros = true;
        }
        if (!hasPinfs && column.pinfs > 0) {
          hasPinfs = true;
        }
        if (!hasNinfs && column.ninfs > 0) {
          hasNinfs = true;
        }
        if (!hasEnums && column.type === 'enum') {
          hasEnums = true;
        }
      }
      return {
        header: createPlainRow('label', columns),
        typeRow: createPlainRow('type', columns),
        minRow: createMinMaxRow('mins', columns),
        maxRow: createMinMaxRow('maxs', columns),
        meanRow: createMeanRow(columns),
        sigmaRow: createSigmaRow(columns),
        cardinalityRow: hasEnums ? createCardinalityRow(columns) : null,
        missingsRow: hasMissings ? createMissingsRow(columns) : null,
        zerosRow: hasZeros ? createInfRow('zeros', columns) : null,
        pinfsRow: hasPinfs ? createInfRow('pinfs', columns) : null,
        ninfsRow: hasNinfs ? createInfRow('ninfs', columns) : null,
        summaryRow: createSummaryRow(_frame.key.name, columns),
        hasMissings: hasMissings,
        hasZeros: hasZeros,
        hasPinfs: hasPinfs,
        hasNinfs: hasNinfs,
        hasEnums: hasEnums,
        dataRows: createDataRows(offset, rowCount, columns)
      };
    };
    return {
      data: _frame,
      key: _frame.key.name,
      timestamp: _frame.creation_epoch_time_millis,
      title: _frame.key.name,
      columns: _frame.column_names,
      table: createFrameTable(_frame.off, _frame.len, _frame.columns),
      dispose: function() {},
      template: 'frame-view'
    };
  };

}).call(this);

(function() {
  test("geyser generates div (scalar arg)", function(t) {
    var div, dom;
    div = geyser.generate('div')[0];
    dom = div('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: null,
        attrs: null
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<div>hello</div>");
    return t.end();
  });

  test("geyser generates div (vector arg)", function(t) {
    var div, dom;
    div = geyser.generate(['div'])[0];
    dom = div('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: null,
        attrs: null
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<div>hello</div>");
    return t.end();
  });

  test("geyser generates div with id", function(t) {
    var div, dom;
    div = geyser.generate("div id='$id'")[0];
    dom = div('hello', {
      $id: 'foo'
    });
    t.deepEqual(dom, {
      params: {
        $id: 'foo'
      },
      tag: {
        name: 'div',
        classes: null,
        attrs: "id='$id'"
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<div id='foo'>hello</div>");
    return t.end();
  });

  test("geyser generates .foo", function(t) {
    var div, dom;
    div = geyser.generate('.foo')[0];
    dom = div('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: 'foo',
        attrs: null
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<div class='foo'>hello</div>");
    return t.end();
  });

  test("geyser generates .foo.bar", function(t) {
    var div, dom;
    div = geyser.generate('.foo.bar')[0];
    dom = div('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: 'foo bar',
        attrs: null
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<div class='foo bar'>hello</div>");
    return t.end();
  });

  test("geyser generates span.foo.bar", function(t) {
    var dom, span;
    span = geyser.generate('span.foo.bar')[0];
    dom = span('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'span',
        classes: 'foo bar',
        attrs: null
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<span class='foo bar'>hello</span>");
    return t.end();
  });

  test("geyser generates a.foo href='http://localhost/'", function(t) {
    var a, dom;
    a = geyser.generate("a.foo href='http://localhost/'")[0];
    dom = a('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'a',
        classes: 'foo',
        attrs: "href='http://localhost/'"
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<a class='foo' href='http://localhost/'>hello</a>");
    return t.end();
  });

  test("geyser generates .foo data-id='bar'", function(t) {
    var div, dom;
    div = geyser.generate(".foo data-id='bar'")[0];
    dom = div('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: 'foo',
        attrs: "data-id='bar'"
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<div class='foo' data-id='bar'>hello</div>");
    return t.end();
  });

  test("geyser generates input type='checkbox' data-id='bar' checked", function(t) {
    var dom, input;
    input = geyser.generate("input type='checkbox' data-id='bar' checked")[0];
    dom = input('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'input',
        classes: null,
        attrs: "type='checkbox' data-id='bar' checked"
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<input type='checkbox' data-id='bar' checked>hello</input>");
    return t.end();
  });

  test("geyser generates input.foo type='checkbox' data-id='bar' checked", function(t) {
    var dom, input;
    input = geyser.generate("input.foo type='checkbox' data-id='bar' checked")[0];
    dom = input('hello');
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'input',
        classes: 'foo',
        attrs: "type='checkbox' data-id='bar' checked"
      },
      content: 'hello'
    });
    t.equal(geyser.render(dom), "<input class='foo' type='checkbox' data-id='bar' checked>hello</input>");
    return t.end();
  });

  test("geyser generates 1 nested element", function(t) {
    var div, dom;
    div = geyser.generate('.foo')[0];
    dom = div(div('hello'));
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: 'foo',
        attrs: null
      },
      content: [
        {
          params: void 0,
          tag: {
            name: 'div',
            classes: 'foo',
            attrs: null
          },
          content: 'hello'
        }
      ]
    });
    t.equal(geyser.render(dom), "<div class='foo'><div class='foo'>hello</div></div>");
    return t.end();
  });

  test("geyser generates 2 levels of nested elements", function(t) {
    var div, dom;
    div = geyser.generate('.foo')[0];
    dom = div(div(div('hello')));
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: 'foo',
        attrs: null
      },
      content: [
        {
          params: void 0,
          tag: {
            name: 'div',
            classes: 'foo',
            attrs: null
          },
          content: [
            {
              params: void 0,
              tag: {
                name: 'div',
                classes: 'foo',
                attrs: null
              },
              content: 'hello'
            }
          ]
        }
      ]
    });
    t.equal(geyser.render(dom), "<div class='foo'><div class='foo'><div class='foo'>hello</div></div></div>");
    return t.end();
  });

  test("geyser generates 1+ nested elements", function(t) {
    var div, dom;
    div = geyser.generate('.foo')[0];
    dom = div([div('hello'), div('world')]);
    t.deepEqual(dom, {
      params: void 0,
      tag: {
        name: 'div',
        classes: 'foo',
        attrs: null
      },
      content: [
        {
          params: void 0,
          tag: {
            name: 'div',
            classes: 'foo',
            attrs: null
          },
          content: 'hello'
        }, {
          params: void 0,
          tag: {
            name: 'div',
            classes: 'foo',
            attrs: null
          },
          content: 'world'
        }
      ]
    });
    t.equal(geyser.render(dom), "<div class='foo'><div class='foo'>hello</div><div class='foo'>world</div></div>");
    return t.end();
  });

}).call(this);

(function() {
  Steam.H2OProxy = function(_) {
    var composePath, encodeArray, filterSupportedModels, isSupportedModel, post, processResponse, request, requestCloud, requestFileGlob, requestFrames, requestImportFile, requestImportFiles, requestInspect, requestJob, requestJobs, requestLogAndEcho, requestModel, requestModelBuild, requestModelBuilder, requestModelBuilders, requestModelMetrics, requestModels, requestParseFiles, requestParseSetup, requestRemoveAll, requestTimeline, requestWithOpts;
    processResponse = function(go) {
      return function(error, result) {
        var _ref;
        if (error) {
          return go(error, result);
        } else {
          if (((_ref = result.data.response) != null ? _ref.status : void 0) === 'error') {
            return go(result.data.error, result.data);
          } else {
            return go(error, result.data);
          }
        }
      };
    };
    request = function(path, go) {
      return _.h2oGet(path, processResponse(go));
    };
    post = function(path, opts, go) {
      return _.h2oPost(path, opts, processResponse(go));
    };
    composePath = function(path, opts) {
      var params;
      if (opts) {
        params = mapWithKey(opts, function(v, k) {
          return "" + k + "=" + v;
        });
        return path + '?' + join(params, '&');
      } else {
        return path;
      }
    };
    requestWithOpts = function(path, opts, go) {
      return request(composePath(path, opts), go);
    };
    requestFileGlob = function(path, limit, go) {
      var opts;
      opts = {
        src: encodeURIComponent(path),
        limit: limit
      };
      return requestWithOpts('/Typeahead.json/files', opts, go);
    };
    requestImportFile = function(path, go) {
      var opts;
      opts = {
        path: encodeURIComponent(path)
      };
      return requestWithOpts('/ImportFiles.json', opts, go);
    };
    requestImportFiles = function(paths, go) {
      var actions;
      actions = map(paths, function(path) {
        return function(index, go) {
          return requestImportFile(path, function(error, result) {
            return go({
              error: error,
              result: result
            });
          });
        };
      });
      return forEachAsync(actions, go);
    };
    requestParseSetup = function(sources, go) {
      var encodedPaths, opts;
      encodedPaths = map(sources, encodeURIComponent);
      opts = {
        srcs: "[" + (join(encodedPaths, ',')) + "]"
      };
      return requestWithOpts('/ParseSetup.json', opts, go);
    };
    encodeArray = function(array) {
      return "[" + (join(map(array, encodeURIComponent), ',')) + "]";
    };
    requestParseFiles = function(sourceKeys, destinationKey, parserType, separator, columnCount, useSingleQuotes, columnNames, deleteOnDone, checkHeader, go) {
      var opts;
      opts = {
        hex: encodeURIComponent(destinationKey),
        srcs: encodeArray(sourceKeys),
        pType: parserType,
        sep: separator,
        ncols: columnCount,
        singleQuotes: useSingleQuotes,
        columnNames: encodeArray(columnNames),
        checkHeader: checkHeader,
        delete_on_done: deleteOnDone
      };
      return requestWithOpts('/Parse.json', opts, go);
    };
    requestInspect = function(key, go) {
      var opts;
      opts = {
        key: encodeURIComponent(key)
      };
      return requestWithOpts('/Inspect.json', opts, go);
    };
    isSupportedModel = function(model) {
      return true;
    };
    filterSupportedModels = function(models) {
      return filter(models, isSupportedModel);
    };
    requestFrames = function(go, opts) {
      return requestWithOpts('/3/Frames.json', opts, go);
    };
    requestModelBuilders = function(go) {
      return request("/2/ModelBuilders.json", function(error, result) {
        var k, v;
        if (error) {
          return go(error);
        } else {
          return go(null, (function() {
            var _ref, _results;
            _ref = result.model_builders;
            _results = [];
            for (k in _ref) {
              v = _ref[k];
              if (k !== 'example') {
                _results.push(k);
              }
            }
            return _results;
          })());
        }
      });
    };
    requestModelBuilder = function(algo, go) {
      return request("/2/ModelBuilders.json/" + algo, go);
    };
    requestModelBuild = function(algo, parameters, go) {
      return post("/2/ModelBuilders.json/" + algo, parameters, go);
    };
    requestModels = function(go, opts) {
      return requestWithOpts('/3/Models.json', opts, function(error, result) {
        if (error) {
          return go(error, result);
        } else {
          return go(error, filterSupportedModels(result.models));
        }
      });
    };
    requestModel = function(key, go) {
      return request("/3/Models.json/" + (encodeURIComponent(key)), function(error, result) {
        if (error) {
          return go(error, result);
        } else {
          return go(error, head(filterSupportedModels(result.models)));
        }
      });
    };
    requestModelMetrics = function(modelKey, frameKey, go) {
      return post("/3/ModelMetrics.json/models/" + (encodeURIComponent(modelKey)) + "/frames/" + (encodeURIComponent(frameKey)), {}, go);
    };
    requestJobs = function(go) {
      return request('/Jobs.json', go);
    };
    requestJob = function(key, go) {
      return request("/Jobs.json/" + (encodeURIComponent(key)), function(error, result) {
        if (error) {
          return go(error, result);
        } else {
          return go(error, result.jobs[0]);
        }
      });
    };
    requestCloud = function(go) {
      return request('/Cloud.json', go);
    };
    requestTimeline = function(go) {
      return request('/Timeline.json', go);
    };
    requestRemoveAll = function(go) {
      return request('/RemoveAll.json', go);
    };
    requestLogAndEcho = function(go) {
      return request('/LogAndEcho.json', go);
    };
    link$(_.requestRemoveAll, requestRemoveAll);
    link$(_.requestLogAndEcho, requestLogAndEcho);
    link$(_.requestFileGlob, requestFileGlob);
    link$(_.requestImportFile, requestImportFile);
    link$(_.requestImportFiles, requestImportFiles);
    link$(_.requestParseSetup, requestParseSetup);
    link$(_.requestParseFiles, requestParseFiles);
    link$(_.requestInspect, requestInspect);
    link$(_.requestFrames, function(go) {
      return requestFrames(go);
    });
    link$(_.requestFramesAndCompatibleModels, function(go) {
      return requestFrames(go, {
        find_compatible_models: true
      });
    });
    link$(_.requestFrame, function(key, go) {
      return request("/3/Frames/" + (encodeURIComponent(key)), go);
    });
    link$(_.requestColumnSummary, function(key, column, go) {
      return request("/3/Frames/" + (encodeURIComponent(key)) + "/columns/" + column + "/summary", go);
    });
    link$(_.requestFrameAndCompatibleModels, function(key, go) {
      return requestFrames(go, {
        key: encodeURIComponent(key),
        find_compatible_models: true
      });
    });
    link$(_.requestModelBuilder, requestModelBuilder);
    link$(_.requestModelBuilders, requestModelBuilders);
    link$(_.requestModelBuild, requestModelBuild);
    link$(_.requestScoringOnFrame, function(frameKey, modelKey, go) {
      return requestFrames(go, {
        key: encodeURIComponent(frameKey),
        score_model: modelKey
      });
    });
    link$(_.requestModels, requestModels);
    link$(_.requestModel, requestModel);
    link$(_.requestModelMetrics, requestModelMetrics);
    link$(_.requestModelsAndCompatibleFrames, function(go) {
      return requestModels(go, {
        find_compatible_frames: true
      });
    });
    link$(_.requestModelAndCompatibleFrames, function(key, go) {
      return requestModels(go, {
        key: encodeURIComponent(key),
        find_compatible_frames: true
      });
    });
    link$(_.requestJobs, requestJobs);
    link$(_.requestJob, requestJob);
    link$(_.requestCloud, requestCloud);
    return link$(_.requestTimeline, requestTimeline);
  };

}).call(this);

(function() {
  if (!SYSTEM_TEST) {
    return;
  }

  test('empty cloud', function(t) {
    t.plan(6);
    return createCloud(function(_, go) {
      var ensureNoFramesExist, ensureNoJobsExist, logAndEcho, operations, removeAll;
      logAndEcho = function(go) {
        return _.requestLogAndEcho(function(error, result) {
          if (error) {
            t.fail('log and echo request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got log and echo reply');
            return go(null);
          }
        });
      };
      removeAll = function(go) {
        return _.requestRemoveAll(function(error, result) {
          if (error) {
            t.fail('remove all request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got remove all reply');
            return go(null);
          }
        });
      };
      ensureNoFramesExist = function(go) {
        return _.requestFrames(function(error, result) {
          if (error) {
            t.fail('frames request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got frames reply');
            tdiff(t, readGoldJson('frames-empty.json'), result);
            return go(null);
          }
        });
      };
      ensureNoJobsExist = function(go) {
        return _.requestJobs(function(error, result) {
          if (error) {
            t.fail('request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got jobs reply');
            tdiff(t, readGoldJson('jobs-empty.json'), result);
            return go(null);
          }
        });
      };
      operations = [logAndEcho, removeAll, ensureNoFramesExist, ensureNoJobsExist];
      return async.waterfall(operations, function() {
        return go(t);
      });
    });
  });

  test('airlines ingest and model building flow', function(t) {
    t.plan(45);
    createCloud(function(_, go) {
      var buildAirlinesDeepLearningModel, buildAirlinesKmeansModel, ensureNoFramesExist, fetchAirlinesFrame, fetchDeepLearningModelBuilder, fetchJobs, fetchKmeansModelBuilder, findAirlines, findNonExistentFile, importAirlinesFrame, inspectAirlinesDeepLearningModel, inspectAirlinesFrame, inspectAirlinesKmeansModel, logAndEcho, operations, parseAirlinesFrame, parseSetupAirlinesFrame, pollJob, removeAll, scoreAirlinesDeepLearningModel;
      logAndEcho = function(go) {
        return _.requestLogAndEcho(function(error, result) {
          if (error) {
            t.fail('log and echo request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got log and echo reply');
            return go(null);
          }
        });
      };
      removeAll = function(go) {
        return _.requestRemoveAll(function(error, result) {
          if (error) {
            t.fail('remove all request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got remove all reply');
            return go(null);
          }
        });
      };
      ensureNoFramesExist = function(go) {
        return _.requestFrames(function(error, result) {
          if (error) {
            t.fail('frames request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got frames reply');
            tdiff(t, readGoldJson('frames-empty.json'), result);
            return go(null);
          }
        });
      };
      findNonExistentFile = function(go) {
        return _.requestFileGlob('/non/existent/path', 10, function(error, result) {
          if (error) {
            t.fail('glob request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got glob reply');
            tdiff(t, readGoldJson('glob-empty.json'), result);
            return go(null);
          }
        });
      };
      findAirlines = function(go) {
        return _.requestFileGlob(path.join(DATA_PATH, 'airlines'), 10, function(error, result) {
          var airlinesZip, expectedGlobResponse;
          if (error) {
            t.fail('glob request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got glob reply');
            expectedGlobResponse = {
              src: null,
              limit: 0
            };
            tdiff(t, expectedGlobResponse, result, {
              exclude: ['matches']
            });
            t.ok(isArray(result.matches), 'has matches');
            t.ok(result.matches.length > 0, 'has matches');
            airlinesZip = find(result.matches, function(match) {
              return /allyears2k_headers\.zip$/.test(match);
            });
            t.ok(airlinesZip !== null, 'found airlines zip');
            return go(null, airlinesZip);
          }
        });
      };
      importAirlinesFrame = function(airlinesZip, go) {
        return _.requestImportFile(airlinesZip, function(error, result) {
          var expectedImportResponse;
          if (error) {
            t.fail('import request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got import reply');
            expectedImportResponse = {
              dels: [],
              fails: [],
              path: airlinesZip,
              files: [airlinesZip],
              keys: ["nfs://" + (airlinesZip.substr(1))]
            };
            tdiff(t, expectedImportResponse, result);
            return go(null, result.keys[0]);
          }
        });
      };
      parseSetupAirlinesFrame = function(airlinesZipKey, go) {
        return _.requestParseSetup([airlinesZipKey], function(error, result) {
          if (error) {
            t.fail('parse setup request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got parse setup reply');
            tdiff(t, readGoldJson('parse-setup-allyears2k_headers-zip.json'), result, {
              exclude: ['srcs']
            });
            t.ok(isArray(result.srcs), 'has srcs');
            t.equal(result.srcs.length, 1, 'has 1 src');
            t.ok(isString(result.srcs[0].name), 'has src name');
            return go(null, result);
          }
        });
      };
      parseAirlinesFrame = function(parseSetup, go) {
        var sourceKeys;
        sourceKeys = map(parseSetup.srcs, function(src) {
          return src.name;
        });
        return _.requestParseFiles(sourceKeys, parseSetup.hexName, parseSetup.pType, parseSetup.sep, parseSetup.ncols, parseSetup.singleQuotes, parseSetup.columnNames, true, parseSetup.checkHeader, function(error, result) {
          if (error) {
            t.fail('parse request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got parse reply');
            tdiff(t, readGoldJson('parse-allyears2k_headers-zip.json'), result, {
              exclude: ['job']
            });
            t.ok(isString(result.job.name), 'has job name');
            return go(null, result.job.name);
          }
        });
      };
      fetchJobs = function(jobKey, go) {
        return _.requestJobs(function(error, result) {
          if (error) {
            t.fail('jobs request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got jobs reply');
            t.ok(result.jobs.length === 1);
            t.equal(result.jobs[0].key.name, jobKey);
            return go(null, jobKey);
          }
        });
      };
      pollJob = function(jobKey, go) {
        var poll;
        poll = function(go) {
          return _.requestJob(jobKey, function(error, job) {
            if (error) {
              t.fail('job poll failed ' + pp(error));
              return go(error);
            } else {
              if (job.status === 'CREATED' || job.status === 'RUNNING') {
                return delay(poll, 1000, go);
              } else {
                return go(null, job);
              }
            }
          });
        };
        return poll(function(error, job) {
          if (error) {
            return go(error);
          } else {
            t.equal(job.status, 'DONE', 'job status ok');
            return go(null, job.dest.name);
          }
        });
      };
      inspectAirlinesFrame = function(frameKey, go) {
        return _.requestInspect(frameKey, function(error, result) {
          if (error) {
            t.fail('frame inspect request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got frame inspect reply');
            tdiff(t, readGoldJson('inspect-allyears2k_headers-zip.json'), result);
            return go(null, frameKey);
          }
        });
      };
      fetchAirlinesFrame = function(frameKey, go) {
        return _.requestFrame(frameKey, function(error, result) {
          if (error) {
            t.fail('frame request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got frame reply');
            tdiff(t, readGoldJson('frames-allyears2k_headers-zip.json'), result);
            return go(null, frameKey);
          }
        });
      };
      fetchKmeansModelBuilder = function(frameKey, go) {
        return _.requestModelBuilder('kmeans', function(error, result) {
          if (error) {
            t.fail('model builders request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got model builders reply');
            tdiff(t, readGoldJson('model-builders-kmeans.json'), result, {
              exclude: ['model_builders.kmeans.job', 'model_builders.kmeans.parameters.#.default_value', 'model_builders.kmeans.parameters.#.actual_value', 'model_builders.kmeans.parameters.#.required']
            });
            return go(null, frameKey);
          }
        });
      };
      buildAirlinesKmeansModel = function(frameKey, go) {
        var parameters;
        parameters = {
          training_frame: frameKey,
          K: 2,
          max_iters: 1000,
          normalize: 'true',
          seed: 1410214121289766000,
          init: 'Furthest'
        };
        return _.requestModelBuild('kmeans', parameters, function(error, result) {
          if (error) {
            t.fail('model build request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got model build reply');
            tdiff(t, readGoldJson('kmeans-allyears2k_headers-zip.json'), result, {
              include: ['jobs.#.description', 'jobs.#.dest', 'jobs.#.exception']
            });
            t.ok(isString(result.key.name), 'has job name');
            return go(null, result.key.name);
          }
        });
      };
      inspectAirlinesKmeansModel = function(modelKey, go) {
        return _.requestInspect(modelKey, function(error, result) {
          if (error) {
            t.fail('model inspect request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got model inspect reply');
            tdiff(t, readGoldJson('inspect-kmeans-allyears2k_headers-zip.json'), result, {
              exclude: ['key.name', 'schema.key']
            });
            return go(null);
          }
        });
      };
      fetchDeepLearningModelBuilder = function(go) {
        return _.requestModelBuilder('deeplearning', function(error, result) {
          var parameters, seedParameter;
          if (error) {
            t.fail('model builders request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got model builders reply');
            parameters = result.model_builders.deeplearning.parameters;
            seedParameter = find(parameters, function(parameter) {
              return parameter.name === 'seed';
            });
            seedParameter.default_value = seedParameter.actual_value = 'random';
            tdiff(t, readGoldJson('model-builders-deeplearning.json'), result, {
              exclude: ['model_builders.deeplearning.job', 'model_builders.deeplearning.parameters.#.default_value', 'model_builders.deeplearning.parameters.#.actual_value', 'model_builders.deeplearning.parameters.#.required']
            });
            return go(null);
          }
        });
      };
      buildAirlinesDeepLearningModel = function(go) {
        var parameters;
        parameters = {
          training_frame: 'allyears2k_headers.hex',
          response_column: 'IsDepDelayed',
          reproducible: true
        };
        return _.requestModelBuild('deeplearning', parameters, function(error, result) {
          if (error) {
            t.fail('model build request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got model build reply');
            tdiff(t, readGoldJson('deeplearning-allyears2k_headers-zip.json'), result, {
              include: ['jobs.#.description', 'jobs.#.dest', 'jobs.#.exception']
            });
            t.ok(isString(result.key.name), 'has job name');
            return go(null, result.key.name);
          }
        });
      };
      inspectAirlinesDeepLearningModel = function(modelKey, go) {
        return _.requestInspect(modelKey, function(error, result) {
          var seedParameter;
          if (error) {
            t.fail('model inspect request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got model inspect reply');
            seedParameter = find(result.schema.parameters, function(parameter) {
              return parameter.name === 'seed';
            });
            seedParameter.default_value = seedParameter.actual_value = 'random';
            tdiff(t, readGoldJson('inspect-deeplearning-allyears2k_headers-zip.json'), result, {
              exclude: ['key.name', 'schema.key']
            });
            return go(null, modelKey);
          }
        });
      };
      scoreAirlinesDeepLearningModel = function(modelKey, go) {
        return _.requestModelMetrics(modelKey, 'allyears2k_headers.hex', function(error, result) {
          var metric, parameters, seedParameter;
          if (error) {
            t.fail('model metrics request failed ' + pp(error));
            return go(error);
          } else {
            t.pass('got model metrics reply');
            metric = result.model_metrics[0];
            parameters = metric.model.parameters;
            seedParameter = find(parameters, function(parameter) {
              return parameter.name === 'seed';
            });
            seedParameter.default_value = seedParameter.actual_value = 'random';
            t.equal(metric.model.key, modelKey);
            t.ok(isNumber(metric.model_checksum), 'isNumber metric.model_checksum');
            t.ok(isNumber(metric.frame_checksum), 'isNumber metric.frame_checksum');
            t.ok(isNumber(metric.duration_in_ms), 'isNumber metric.duration_in_ms');
            t.ok(isNumber(metric.scoring_time), 'isNumber metric.scoring_time');
            t.ok(isArray(metric.auc.thresholds), 'isArray metric.auc.thresholds');
            t.ok(isNumber(metric.auc.AUC), 'isNumber metric.auc.AUC');
            t.ok(isNumber(metric.auc.Gini), 'isNumber metric.auc.Gini');
            t.ok(isArray(metric.auc.confusion_matrices), 'isArray metric.auc.confusion_matrices');
            t.ok(isArray(metric.auc.F1), 'isArray metric.auc.F1');
            t.ok(isArray(metric.auc.F2), 'isArray metric.auc.F2');
            t.ok(isArray(metric.auc.F0point5), 'isArray metric.auc.F0point5');
            t.ok(isArray(metric.auc.accuracy), 'isArray metric.auc.accuracy');
            t.ok(isArray(metric.auc.errorr), 'isArray metric.auc.errorr');
            t.ok(isArray(metric.auc.precision), 'isArray metric.auc.precision');
            t.ok(isArray(metric.auc.recall), 'isArray metric.auc.recall');
            t.ok(isArray(metric.auc.specificity), 'isArray metric.auc.specificity');
            t.ok(isArray(metric.auc.mcc), 'isArray metric.auc.mcc');
            t.ok(isArray(metric.auc.max_per_class_error), 'isArray metric.auc.max_per_class_error');
            tdiff(t, readGoldJson('score-deeplearning-allyears2k_headers-zip.json'), result, {
              exclude: ['model_metrics.#.model.key', 'model_metrics.#.model_checksum', 'model_metrics.#.frame_checksum', 'model_metrics.#.duration_in_ms', 'model_metrics.#.scoring_time', 'model_metrics.#.auc.thresholds', 'model_metrics.#.auc.AUC', 'model_metrics.#.auc.Gini', 'model_metrics.#.auc.confusion_matrices', 'model_metrics.#.auc.F1', 'model_metrics.#.auc.F2', 'model_metrics.#.auc.F0point5', 'model_metrics.#.auc.accuracy', 'model_metrics.#.auc.errorr', 'model_metrics.#.auc.precision', 'model_metrics.#.auc.recall', 'model_metrics.#.auc.specificity', 'model_metrics.#.auc.mcc', 'model_metrics.#.auc.max_per_class_error', "model_metrics.#.auc.threshold_for_criteria", "model_metrics.#.auc.F1_for_criteria", "model_metrics.#.auc.F2_for_criteria", "model_metrics.#.auc.F0point5_for_criteria", "model_metrics.#.auc.accuracy_for_criteria", "model_metrics.#.auc.error_for_criteria", "model_metrics.#.auc.precision_for_criteria", "model_metrics.#.auc.recall_for_criteria", "model_metrics.#.auc.specificity_for_criteria", "model_metrics.#.auc.mcc_for_criteria", "model_metrics.#.auc.max_per_class_error_for_criteria", "model_metrics.#.auc.confusion_matrix_for_criteria"]
            });
            return go(null, modelKey);
          }
        });
      };
      operations = [logAndEcho, removeAll, ensureNoFramesExist, findNonExistentFile, findAirlines, importAirlinesFrame, parseSetupAirlinesFrame, parseAirlinesFrame, fetchJobs, pollJob, inspectAirlinesFrame, fetchAirlinesFrame, fetchKmeansModelBuilder, buildAirlinesKmeansModel, pollJob, inspectAirlinesKmeansModel, fetchDeepLearningModelBuilder, buildAirlinesDeepLearningModel, pollJob, inspectAirlinesDeepLearningModel];
      return async.waterfall(operations, function() {
        return go(t);
      });
    });
  });


  /*
  t_h2o_response = T
    h2o_response:
      h2o: T.str
      node: T.str
      status: T.str
      time: T.num
  
  t_h2o_frame = T
    h2o_frame:
      id: T.str
      key: T.str
      column_names: T.arr T.str
       *TODO handle recursive references in typedef
       *compatible_models: T.arr t_h2o_model
      creation_epoch_time_millis: T.num
      is_raw_frame: T.bool
  
  t_h2o_frames_response = T
    h2o_frames_response:
      response: t_h2o_response
      frames: T.arr t_h2o_frame
  
  t_h2o_model = T
    h2o_model:
      id: T.str
      key: T.str
      model_algorithm: T.str
      model_category: T.str
      state: T.str
      input_column_names: T.arr T.str
      response_column_name: T.str
      critical_parameters: T.obj
      secondary_parameters: T.obj
      expert_parameters: T.obj
       *TODO handle recursive references in typedef
       *compatible_frames: T.arr t_h2o_frame
      creation_epoch_time_millis: T.num
  
  t_h2o_models_response = T
    h2o_models_response:
      response: t_h2o_response
      models: T.arr t_h2o_model
  
  typecheckFramesResult = (t, error, result) ->
    t.equal error, null
    { response, frames } = result
    t.equal response.status, 'done'
    t.ok frames.length > 0
    t.ok typecheck result, t_h2o_frames_response
    t.ok every frames, (frame) ->
       *TODO handle recursive references in typedef
      for compatibleModel in frame.compatible_models
        t.ok typecheck compatibleModel, t_h2o_model
    return
  
  typecheckModelsResult = (t, error, result) ->
    t.equal error, null
    { response, models } = result
    t.equal response.status, 'done'
    t.ok models.length > 0
    t.ok typecheck result, t_h2o_models_response
    t.ok every models, (model) ->
       *TODO handle recursive references in typedef
      for compatibleFrame in model.compatible_frames
        t.ok typecheck compatibleFrame, t_h2o_frame
    return
  
  test 'requestFrames', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 6
    _.requestFrames (error, result) ->
      typecheckFramesResult t, error, result
      { frames } = result
      t.ok every frames, (frame) -> frame.compatible_models.length is 0
      t.end()
  
  test 'requestFrame', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 8
    _.requestFrame 'airlines_train.hex', (error, result) ->
      typecheckFramesResult t, error, result
      { frames } = result
      t.equal frames.length, 1
      frame0 = head frames
      t.ok frame0.key, 'airlines_train.hex'
      t.equal frame0.compatible_models.length, 0
      t.end()
  
  test 'requestFramesAndCompatibleModels', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 23
    _.requestFramesAndCompatibleModels (error, result) ->
      typecheckFramesResult t, error, result
      { frames } = result
      t.ok frames.length > 0
      t.ok every frames, (frame) -> frame.compatible_models.length > 0
      t.end()
  
  test 'requestFrameAndCompatibleModels', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 15
    _.requestFrameAndCompatibleModels 'airlines_train.hex', (error, result) ->
      typecheckFramesResult t, error, result
      { response, frames } = result
      t.equal frames.length, 1
      frame0 = head frames
      t.ok frame0.key, 'airlines_train.hex'
      t.ok frame0.compatible_models.length > 0
      t.end()
  
  test 'requestModels', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 7
    _.requestModels (error, result) ->
      typecheckModelsResult t, error, result
      { models } = result
      t.ok models.length > 0
      t.ok every models, (model) -> model.compatible_frames.length is 0
      t.end()
  
  test 'requestModel', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 8
    _.requestFrameAndCompatibleModels 'airlines_train.hex', (error, result) ->
      { response, frames } = result
      frame0 = head frames
      model0 = head frame0.compatible_models
      modelKey = model0.key
      _.requestModel modelKey, (error, result) ->
        typecheckModelsResult t, error, result
        { response, models } = result
        t.equal models.length, 1
        model = head models
        t.equal model.key, modelKey
        t.equal model.compatible_frames.length, 0 
        t.end()
  
  test 'requestModelsAndCompatibleFrames', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 23
    _.requestModelsAndCompatibleFrames (error, result) ->
      typecheckModelsResult t, error, result
      { models } = result
      t.ok models.length > 0
      t.ok every models, (model) -> model.compatible_frames.length > 0
      t.end()
  
  test 'requestModelAndCompatibleFrames', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    t.plan 10
    _.requestFrameAndCompatibleModels 'airlines_train.hex', (error, result) ->
      { response, frames } = result
      frame0 = head frames
      model0 = head frame0.compatible_models
      modelKey = model0.key
      _.requestModelAndCompatibleFrames modelKey, (error, result) ->
        typecheckModelsResult t, error, result
        { response, models } = result
        t.equal models.length, 1
        model = head models
        t.equal model.key, modelKey
        t.ok model.compatible_frames.length > 0
        t.end()
  
  test 'FrameListView: should display all frames when no predicate is applied', (t) ->
    _ = createContext()
    frameListView = Steam.FrameListView _
  
    link$ _.framesLoaded, ->
      t.equal frameListView.items().length, 3, 'frameListView.items() array lengths match'
      t.equal frameListView.items()[0].title, 'airlines_test.hex', 'String frameListView.items()[0].title equals [airlines_test.hex]'
      t.equal frameListView.items()[0].caption, '13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime', 'String frameListView.items()[0].caption equals [13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime]'
      t.ok (isFunction frameListView.items()[0].display), 'frameListView.items()[0].display is a function'
      t.equal frameListView.items()[0].isActive(), true, 'Boolean frameListView.items()[0].isActive() equals [true]'
      t.equal frameListView.items()[1].title, 'airlines_train.hex', 'String frameListView.items()[1].title equals [airlines_train.hex]'
      t.equal frameListView.items()[1].caption, '13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime', 'String frameListView.items()[1].caption equals [13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime]'
      t.ok (isFunction frameListView.items()[1].display), 'frameListView.items()[1].display is a function'
      t.equal frameListView.items()[1].isActive(), false, 'Boolean frameListView.items()[1].isActive() equals [false]'
      t.equal frameListView.items()[2].title, 'prostate.hex', 'String frameListView.items()[2].title equals [prostate.hex]'
      t.equal frameListView.items()[2].caption, '9 columns: ID, CAPSULE, AGE, RACE, DPROS', 'String frameListView.items()[2].caption equals [9 columns: ID, CAPSULE, AGE, RACE, DPROS]'
      t.ok (isFunction frameListView.items()[2].display), 'frameListView.items()[2].display is a function'
      t.equal frameListView.items()[2].isActive(), false, 'Boolean frameListView.items()[2].isActive() equals [false]'
      t.equal frameListView.predicateCaption(), 'Showing\nall datasets', 'String frameListView.predicateCaption() equals [Showing\nall datasets]'
      t.ok (isFunction frameListView.clearPredicate), 'frameListView.clearPredicate is a function'
      t.equal frameListView.canClearPredicate(), false, 'Boolean frameListView.canClearPredicate() equals [false]'
      t.equal frameListView.hasItems(), true, 'Boolean frameListView.hasItems() equals [true]'
      t.equal frameListView.template, 'frame-list-view', 'String frameListView.template equals [frame-list-view]'
      t.end()
  
    _.loadFrames type: 'all'
  
  test 'FrameListView: should display compatible frames when a model predicate is applied', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    _.requestFrameAndCompatibleModels 'airlines_train.hex', (error, data) ->
      throw Error if error
      frameListView = Steam.FrameListView _
      link$ _.framesLoaded, ->
        t.equal frameListView.items().length, 2, 'frameListView.items() array lengths match'
        t.equal frameListView.items()[0].title, 'airlines_test.hex', 'String frameListView.items()[0].title equals [airlines_test.hex]'
        t.equal frameListView.items()[0].caption, '13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime', 'String frameListView.items()[0].caption equals [13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime]'
        t.ok (isFunction frameListView.items()[0].display), 'frameListView.items()[0].display is a function'
        t.equal frameListView.items()[0].isActive(), true, 'Boolean frameListView.items()[0].isActive() equals [true]'
        t.equal frameListView.items()[1].title, 'airlines_train.hex', 'String frameListView.items()[1].title equals [airlines_train.hex]'
        t.equal frameListView.items()[1].caption, '13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime', 'String frameListView.items()[1].caption equals [13 columns: fYear, fMonth, fDayofMonth, fDayOfWeek, DepTime]'
        t.ok (isFunction frameListView.items()[1].display), 'frameListView.items()[1].display is a function'
        t.equal frameListView.items()[1].isActive(), false, 'Boolean frameListView.items()[1].isActive() equals [false]'
        t.equal frameListView.predicateCaption(), 'Showing datasets compatible with\ndl_AirlinesTrain_binary_1', 'String frameListView.predicateCaption() equals [Showing datasets compatible with\ndl_AirlinesTrain_binary_1]'
        t.ok (isFunction frameListView.clearPredicate), 'frameListView.clearPredicate is a function'
        t.equal frameListView.canClearPredicate(), true, 'Boolean frameListView.canClearPredicate() equals [true]'
        t.equal frameListView.hasItems(), true, 'Boolean frameListView.hasItems() equals [true]'
        t.equal frameListView.template, 'frame-list-view', 'String frameListView.template equals [frame-list-view]'
  
        t.end()
  
      frame = head data.frames
      model = head frame.compatible_models
      _.loadFrames type: 'compatibleWithModel', modelKey: model.key
  
  test 'FrameListView: Clicking on a frame item marks it as active and launches the frame', (t) ->
    _ = Steam.ApplicationContext()
    Steam.Xhr _
    Steam.H2OProxy _
    frameListView = Steam.FrameListView _
  
    t.plan 9
  
    item0 = item1 = item2 = null
    activeItemData = null
  
    link$ _.displayFrame, (itemData) ->
      t.ok itemData isnt null, 'launched a frame'
      activeItemData = itemData
  
    link$ _.framesLoaded, ->
      item0 = frameListView.items()[0]
      item1 = frameListView.items()[1]
      item2 = frameListView.items()[2]
  
      t.ok activeItemData is item0.data, 'launched frame0'
      t.ok item0.isActive() is yes and item1.isActive() is no and item2.isActive() is no, 'item0 is active'
      
      item1.display() # click on item1
      t.ok activeItemData is item1.data, 'launched frame1'
      t.ok item0.isActive() is no and item1.isActive() is yes and item2.isActive() is no, 'item1 is active'
  
      _.loadFrames null # switch to frame list from the top level menu while on frames view
      t.ok activeItemData is item1.data, 'launched frame1 again'
      t.ok item0.isActive() is no and item1.isActive() is yes and item2.isActive() is no, 'item1 is active'
  
    _.loadFrames type: 'all'
   */

}).call(this);

(function() {
  Steam.HelpServer = function(_) {
    var createHelpView;
    createHelpView = function(title, content) {
      return $("<h1>" + title + "</h1><div>" + content + "</div>");
    };
    return link$(_.man, function(id) {
      var $help, entry;
      if (id == null) {
        id = 'home';
      }
      entry = Steam.Help[id];
      if (entry) {
        $help = createHelpView(entry.title, entry.content || 'No help available.');
        $('a', $help).each(function() {
          var $self, url;
          $self = $(this);
          url = $self.attr('href');
          if (url) {
            if (0 === url.indexOf('help:')) {
              $self.removeAttr('href');
              return $self.click(function() {
                return _.help(url.substr(1 + url.indexOf(':')));
              });
            } else {
              return $self.attr('target', '_blank');
            }
          }
        });
        return $help;
      } else {
        return createHelpView('Help not found', 'Could not find help content for this item.');
      }
    });
  };

}).call(this);

(function() {
  Steam.Help = {
    'model.key': {
      title: 'Model Key',
      content: ''
    },
    'model.method': {
      title: 'Model Method',
      content: ''
    },
    'model.category': {
      title: 'Model Category',
      content: ''
    },
    'model.response_column': {
      title: 'Model Response Column',
      content: ''
    },
    'model.category.binomial': {
      title: 'Binomial',
      content: ''
    },
    'model.method.deep_learning': {
      title: 'Deep Learning',
      content: ''
    },
    'model.method.speed_drf': {
      title: 'SpeeDRF',
      content: ''
    },
    'model.method.drf': {
      title: 'DRF',
      content: ''
    },
    'model.method.glm': {
      title: 'GLM',
      content: ''
    },
    'model.method.gbm': {
      title: 'GBM',
      content: ''
    }
  };

  (function() {
    var h2, icon, li, p, span, ul, _ref;
    _ref = geyser.generate(words('h2 p ul li i.fa.fa-question-circle span')), h2 = _ref[0], p = _ref[1], ul = _ref[2], li = _ref[3], icon = _ref[4], span = _ref[5];
    return Steam.Help.home = {
      title: 'Welcome to H<sub>2</sub>O',
      content: geyser.render([p('H<sub>2</sub>O by 0xdata brings better algorithms to big data. H<sub>2</sub>O is the open source math and machine learning platform for speed and scale. With H<sub>2</sub>O, enterprises can use all of their data (instead of sampling) in real-time for better predictions. Data Scientists can take both simple and sophisticated models to production from H<sub>2</sub>O the same interactive platform used for modeling, within R and JSON. H<sub>2</sub>O is also used as an algorithms library for Making Hadoop Do Math.'), h2('User Guide'), ul([li([icon(), span(' General')]), li([icon(), span(' Data')]), li([icon(), span(' Model')]), li([icon(), span(' Score')]), li([icon(), span(' Administration')])]), h2('Walkthroughs'), ul([li([icon(), span(' GLM')]), li([icon(), span(' GLM Grid')]), li([icon(), span(' K Means')]), li([icon(), span(' Random Forest')]), li([icon(), span(' PCA')]), li([icon(), span(' GBM')]), li([icon(), span(' GBM Grid')])])])
    };
  })();

}).call(this);

(function() {
  test('hypergraph api should have functions available in application scope', function(t) {
    var func, funcs, _i, _len;
    funcs = [edge$, edges$, node$, isNode$, nodes$, link$, unlink$, call$, apply$, join$, zip$, lift$, filter$, switch$, if$, and$, or$, not$, debounce$, throttle$];
    for (_i = 0, _len = funcs.length; _i < _len; _i++) {
      func = funcs[_i];
      t.equal(typeof func, 'function');
    }
    return t.end();
  });

  test('hypergraph edge should not fail when unlinked', function(t) {
    var func, result;
    func = edge$();
    result = null;
    t.doesNotThrow(function() {
      return result = func(1, 2, 3);
    });
    t.ok(isUndefined(result));
    return t.end();
  });

  test('hypergraph edge should propagate when linked', function(t) {
    var func;
    func = edge$();
    link$(func, function(a, b, c) {
      return a + b + c;
    });
    t.equal(func(1, 2, 3), 6);
    return t.end();
  });

  test('hypergraph edge should raise exception when re-linked', function(t) {
    var func;
    func = edge$();
    link$(func, function(a, b, c) {
      return a + b + c;
    });
    t.equal(func(1, 2, 3), 6);
    t.throws(function() {
      return link$(func, function(a, b, c) {
        return a * b * c;
      });
    });
    return t.end();
  });

  test('hypergraph edge should stop propagating when unlinked', function(t) {
    var arrow, func, result, target;
    func = edge$();
    target = function(a, b, c) {
      return a + b + c;
    };
    arrow = link$(func, target);
    t.equal(func(1, 2, 3), 6);
    unlink$(arrow);
    result = null;
    t.doesNotThrow(function() {
      return result = func(1, 2, 3);
    });
    t.ok(isUndefined(result));
    return t.end();
  });

  test('hypergraph edge should stop propagating when disposed', function(t) {
    var arrow, func, result, target;
    func = edge$();
    target = function(a, b, c) {
      return a + b + c;
    };
    arrow = link$(func, target);
    t.equal(func(1, 2, 3), 6);
    func.dispose();
    result = null;
    t.doesNotThrow(function() {
      return result = func(1, 2, 3);
    });
    t.ok(isUndefined(result));
    return t.end();
  });

  test('hypergraph edges should not fail when unlinked', function(t) {
    var func, result;
    func = edges$();
    result = null;
    t.doesNotThrow(function() {
      return result = func(1, 2, 3);
    });
    t.deepEqual(result, []);
    return t.end();
  });

  test('hypergraph edges should propagate when linked', function(t) {
    var func;
    func = edges$();
    link$(func, function(a, b, c) {
      return a + b + c;
    });
    t.deepEqual(func(1, 2, 3), [6]);
    return t.end();
  });

  test('hypergraph edges should allow multicasting', function(t) {
    var addition, func, multiplication;
    func = edges$();
    addition = function(a, b, c) {
      return a + b + c;
    };
    multiplication = function(a, b, c) {
      return a * b * c;
    };
    link$(func, addition);
    link$(func, multiplication);
    t.deepEqual(func(2, 3, 4), [9, 24]);
    return t.end();
  });

  test('hypergraph edges should stop propagating when unlinked', function(t) {
    var addition, additionArrow, func, multiplication, multiplicationArrow;
    func = edges$();
    addition = function(a, b, c) {
      return a + b + c;
    };
    multiplication = function(a, b, c) {
      return a * b * c;
    };
    additionArrow = link$(func, addition);
    multiplicationArrow = link$(func, multiplication);
    t.deepEqual(func(2, 3, 4), [9, 24]);
    unlink$(additionArrow);
    t.deepEqual(func(2, 3, 4), [24]);
    unlink$(multiplicationArrow);
    t.deepEqual(func(2, 3, 4), []);
    return t.end();
  });

  test('hypergraph edges should stop propagating when disposed', function(t) {
    var addition, additionArrow, func, multiplication, multiplicationArrow;
    func = edges$();
    addition = function(a, b, c) {
      return a + b + c;
    };
    multiplication = function(a, b, c) {
      return a * b * c;
    };
    additionArrow = link$(func, addition);
    multiplicationArrow = link$(func, multiplication);
    t.deepEqual(func(2, 3, 4), [9, 24]);
    func.dispose();
    t.deepEqual(func(2, 3, 4), []);
    return t.end();
  });

  test('hypergraph node should hold value when initialized', function(t) {
    var node;
    node = node$(42);
    t.equal(node(), 42);
    return t.end();
  });

  test('hypergraph node should return value when called without arguments', function(t) {
    var node;
    node = node$(42);
    t.equal(node(), 42);
    return t.end();
  });

  test('hypergraph node should hold new value when reassigned', function(t) {
    var node;
    node = node$(42);
    t.equal(node(), 42);
    node(43);
    t.equal(node(), 43);
    return t.end();
  });

  test('hypergraph node should not propagate unless value is changed (without comparator)', function(t) {
    var node, propagated;
    node = node$(42);
    propagated = false;
    link$(node, function(value) {
      return propagated = true;
    });
    t.equal(propagated, false);
    node(42);
    t.equal(propagated, false);
    return t.end();
  });

  test('hypergraph node should propagate value when value is changed (without comparator)', function(t) {
    var node, propagated, propagatedValue;
    node = node$(42);
    propagated = false;
    propagatedValue = 0;
    link$(node, function(value) {
      propagated = true;
      return propagatedValue = value;
    });
    t.equal(propagated, false);
    node(43);
    t.equal(propagated, true);
    t.equal(propagatedValue, 43);
    return t.end();
  });

  test('hypergraph node should not propagate unless value is changed (with comparator)', function(t) {
    var comparator, node, propagated;
    comparator = function(a, b) {
      return a.answer === b.answer;
    };
    node = node$({
      answer: 42
    }, comparator);
    propagated = false;
    link$(node, function(value) {
      return propagated = true;
    });
    t.equal(propagated, false);
    node({
      answer: 42
    });
    t.equal(propagated, false);
    return t.end();
  });

  test('hypergraph node should propagate when value is changed (with comparator)', function(t) {
    var comparator, newValue, node, propagated, propagatedValue;
    comparator = function(a, b) {
      return a.answer === b.answer;
    };
    node = node$({
      answer: 42
    }, comparator);
    propagated = false;
    propagatedValue = null;
    link$(node, function(value) {
      propagated = true;
      return propagatedValue = value;
    });
    t.equal(propagated, false);
    newValue = {
      answer: 43
    };
    node(newValue);
    t.equal(propagated, true);
    t.equal(propagatedValue, newValue);
    return t.end();
  });

  test('hypergraph node should allow multicasting', function(t) {
    var node, propagated1, propagated2, target1, target2;
    node = node$(42);
    propagated1 = false;
    propagated2 = false;
    target1 = function(value) {
      return propagated1 = true;
    };
    target2 = function(value) {
      return propagated2 = true;
    };
    link$(node, target1);
    link$(node, target2);
    t.equal(propagated1, false);
    t.equal(propagated2, false);
    node(43);
    t.equal(propagated1, true);
    t.equal(propagated2, true);
    return t.end();
  });

  test('hypergraph node should stop propagating when unlinked', function(t) {
    var arrow1, arrow2, node, propagated1, propagated2, target1, target2;
    node = node$(42);
    propagated1 = false;
    propagated2 = false;
    target1 = function(value) {
      return propagated1 = true;
    };
    target2 = function(value) {
      return propagated2 = true;
    };
    arrow1 = link$(node, target1);
    arrow2 = link$(node, target2);
    t.equal(propagated1, false);
    t.equal(propagated2, false);
    node(43);
    t.equal(propagated1, true);
    t.equal(propagated2, true);
    propagated1 = false;
    propagated2 = false;
    unlink$(arrow2);
    node(44);
    t.equal(propagated1, true);
    t.equal(propagated2, false);
    propagated1 = false;
    propagated2 = false;
    unlink$(arrow1);
    node(45);
    t.equal(propagated1, false);
    t.equal(propagated2, false);
    return t.end();
  });

  test('hypergraph empty nodes should always propagate', function(t) {
    var event, propagated;
    event = node$();
    propagated = false;
    link$(event, function() {
      return propagated = true;
    });
    t.equal(propagated, false);
    event(true);
    t.equal(propagated, true);
    return t.end();
  });

  test('hypergraph context should enclose deeply nested subgraphs correctly', function(t) {
    var bar1, bar2, bar3, baz1, baz2, baz3, child, foo1, foo2, foo3, grandparent, parent;
    foo1 = function() {};
    bar1 = function() {};
    baz1 = function() {};
    foo2 = function() {};
    bar2 = function() {};
    baz2 = function() {};
    foo3 = function() {};
    bar3 = function() {};
    baz3 = function() {};
    grandparent = context$({
      foo1: foo1,
      bar1: bar1,
      baz1: baz1
    });
    parent = context$({
      foo2: foo2,
      bar2: bar2,
      baz2: baz2
    }, grandparent);
    child = context$({
      foo3: foo3,
      bar3: bar3,
      baz3: baz3
    }, parent);
    t.equal(grandparent.root, grandparent);
    t.equal(grandparent.parent, grandparent);
    t.equal(grandparent.foo1, foo1);
    t.equal(grandparent.bar1, bar1);
    t.equal(grandparent.baz1, baz1);
    t.equal(parent.root, grandparent);
    t.equal(parent.parent, grandparent);
    t.equal(parent.foo2, foo2);
    t.equal(parent.bar2, bar2);
    t.equal(parent.baz2, baz2);
    t.equal(child.root, grandparent);
    t.equal(child.parent, parent);
    t.equal(child.foo3, foo3);
    t.equal(child.bar3, bar3);
    t.equal(child.baz3, baz3);
    return t.end();
  });

  test('hypergraph context should unlink multiple arrows at once', function(t) {
    var arrow1, arrow2, node, propagated1, propagated2, target1, target2;
    node = node$(42);
    propagated1 = false;
    propagated2 = false;
    target1 = function(value) {
      return propagated1 = true;
    };
    target2 = function(value) {
      return propagated2 = true;
    };
    arrow1 = link$(node, target1);
    arrow2 = link$(node, target2);
    t.equal(propagated1, false);
    t.equal(propagated2, false);
    node(43);
    t.equal(propagated1, true);
    t.equal(propagated2, true);
    propagated1 = false;
    propagated2 = false;
    unlink$([arrow1, arrow2]);
    node(44);
    t.equal(propagated1, false);
    t.equal(propagated2, false);
    return t.end();
  });

  test('hypergraph call$', function(t) {
    var area, arrow, height, width;
    width = node$(2);
    height = node$(6);
    area = 0;
    arrow = call$(width, height, function() {
      return area = width() * height();
    });
    t.equal(area, 12);
    width(7);
    t.equal(area, 42);
    unlink$(arrow);
    width(2);
    t.equal(area, 42);
    return t.end();
  });

  test('hypergraph apply$', function(t) {
    var area, arrow, height, width;
    width = node$(2);
    height = node$(6);
    area = 0;
    arrow = apply$(width, height, function(w, h) {
      return area = w * h;
    });
    t.equal(area, 12);
    width(7);
    t.equal(area, 42);
    unlink$(arrow);
    width(2);
    t.equal(area, 42);
    return t.end();
  });

  test('hypergraph join$', function(t) {
    var area, arrow, height, width;
    width = node$(2);
    height = node$(6);
    area = node$(0);
    arrow = join$(width, height, area, function(w, h) {
      return w * h;
    });
    t.equal(area(), 12);
    width(7);
    t.equal(area(), 42);
    unlink$(arrow);
    width(2);
    t.equal(area(), 42);
    return t.end();
  });

  test('hypergraph zip$', function(t) {
    var area, height, width;
    width = node$(2);
    height = node$(6);
    area = zip$([width, height], function(w, h) {
      return w * h;
    });
    t.equal(area(), 12);
    width(7);
    t.equal(area(), 42);
    return t.end();
  });

  test('hypergraph lift$', function(t) {
    var area, height, width;
    width = node$(2);
    height = node$(6);
    area = lift$(width, height, function(w, h) {
      return w * h;
    });
    t.equal(area(), 12);
    width(7);
    t.equal(area(), 42);
    return t.end();
  });

  test('hypergraph filter$', function(t) {
    var evens, integers;
    integers = node$(10);
    evens = filter$(integers, function(n) {
      return n % 2 === 0;
    });
    t.equal(evens(), 10);
    integers(9);
    t.equal(evens(), 10);
    integers(8);
    t.equal(evens(), 8);
    return t.end();
  });

  test('hypergraph switch$', function(t) {
    var choice1, choice2, choice3, defaultValue, someValue, _ref;
    defaultValue = {};
    someValue = {};
    _ref = switch$(defaultValue, 3), choice1 = _ref[0], choice2 = _ref[1], choice3 = _ref[2];
    t.equal(choice1(), defaultValue);
    t.equal(choice2(), defaultValue);
    t.equal(choice3(), defaultValue);
    choice1(someValue);
    t.equal(choice1(), someValue);
    t.equal(choice2(), defaultValue);
    t.equal(choice3(), defaultValue);
    choice2(someValue);
    t.equal(choice1(), defaultValue);
    t.equal(choice2(), someValue);
    t.equal(choice3(), defaultValue);
    choice3(someValue);
    t.equal(choice1(), defaultValue);
    t.equal(choice2(), defaultValue);
    t.equal(choice3(), someValue);
    return t.end();
  });

  test('hypergraph if$', function(t) {
    var english, greeting, isEnglish, language, spanish;
    english = node$('thank you');
    spanish = node$('gracias');
    language = node$('english');
    isEnglish = lift$(language, function(language) {
      return language === 'english';
    });
    greeting = if$(isEnglish, english, spanish);
    t.equal(greeting(), 'thank you');
    language('spanish');
    t.equal(greeting(), 'gracias');
    return t.end();
  });

  test('hypergraph and$', function(t) {
    var hasBlue, hasColor, hasGreen, hasRed;
    hasRed = node$(true);
    hasGreen = node$(true);
    hasBlue = node$(true);
    hasColor = and$(hasRed, hasGreen, hasBlue);
    t.equal(hasColor(), true);
    hasRed(false);
    t.equal(hasColor(), false);
    hasRed(true);
    t.equal(hasColor(), true);
    return t.end();
  });

  test('hypergraph or$', function(t) {
    var hasBlue, hasComponent, hasGreen, hasRed;
    hasRed = node$(false);
    hasGreen = node$(false);
    hasBlue = node$(false);
    hasComponent = or$(hasRed, hasGreen, hasBlue);
    t.equal(hasComponent(), false);
    hasRed(true);
    t.equal(hasComponent(), true);
    hasRed(false);
    t.equal(hasComponent(), false);
    return t.end();
  });

  test('hypergraph not$', function(t) {
    var isOpaque, isTransparent;
    isTransparent = node$(true);
    isOpaque = not$(isTransparent);
    t.equal(isOpaque(), false);
    isTransparent(false);
    t.equal(isOpaque(), true);
    return t.end();
  });

}).call(this);

(function() {
  var parseDelimiters, parserTypes;

  parserTypes = map(['AUTO', 'XLS', 'CSV', 'SVMLight'], function(type) {
    return {
      type: type,
      caption: type
    };
  });

  parseDelimiters = (function() {
    var characterDelimiters, createDelimiter, otherDelimiters, whitespaceDelimiters, whitespaceSeparators;
    whitespaceSeparators = ['NULL', 'SOH (start of heading)', 'STX (start of text)', 'ETX (end of text)', 'EOT (end of transmission)', 'ENQ (enquiry)', 'ACK (acknowledge)', "BEL '\\a' (bell)", "BS  '\\b' (backspace)", "HT  '\\t' (horizontal tab)", "LF  '\\n' (new line)", "VT  '\\v' (vertical tab)", "FF  '\\f' (form feed)", "CR  '\\r' (carriage ret)", 'SO  (shift out)', 'SI  (shift in)', 'DLE (data link escape)', 'DC1 (device control 1) ', 'DC2 (device control 2)', 'DC3 (device control 3)', 'DC4 (device control 4)', 'NAK (negative ack.)', 'SYN (synchronous idle)', 'ETB (end of trans. blk)', 'CAN (cancel)', 'EM  (end of medium)', 'SUB (substitute)', 'ESC (escape)', 'FS  (file separator)', 'GS  (group separator)', 'RS  (record separator)', 'US  (unit separator)', "' ' SPACE"];
    createDelimiter = function(caption, charCode) {
      return {
        charCode: charCode,
        caption: "" + caption + ": '" + (('00' + charCode).slice(-2)) + "'"
      };
    };
    whitespaceDelimiters = map(whitespaceSeparators, createDelimiter);
    characterDelimiters = times(126 - whitespaceSeparators.length, function(i) {
      var charCode;
      charCode = i + whitespaceSeparators.length;
      return createDelimiter(String.fromCharCode(charCode), charCode);
    });
    otherDelimiters = [
      {
        charCode: -1,
        caption: 'AUTO'
      }
    ];
    return concat(whitespaceDelimiters, characterDelimiters, otherDelimiters);
  })();

  Steam.ImportFilesDialog = function(_, _go) {
    var backToImport, cancel, createFileItem, createFileItems, createSelectedFileItem, deselectAllFiles, importFiles, importSelectedFiles, listPathHints, parseFiles, processImportResult, processParseSetupResult, selectAllFiles, tryImportFiles, _columnCount, _columns, _deleteOnDone, _delimiter, _destinationKey, _errorMessage, _hasColumns, _hasErrorMessage, _hasImportedFiles, _hasSelectedFiles, _headerOption, _headerOptions, _importedFileCount, _importedFiles, _isImportMode, _isParseMode, _parsedFiles, _parserType, _rows, _selectedFileCount, _selectedFiles, _selectedFilesDictionary, _specifiedPath, _useSingleQuotes;
    _isImportMode = node$(true);
    _isParseMode = node$(false);
    _specifiedPath = node$('');
    _errorMessage = node$('');
    _hasErrorMessage = lift$(_errorMessage, isTruthy);
    tryImportFiles = function() {
      var specifiedPath;
      specifiedPath = _specifiedPath();
      return _.requestFileGlob(specifiedPath, 0, function(error, result) {
        if (error) {
          return _errorMessage(error.data.errmsg);
        } else {
          _errorMessage('');
          return processImportResult(result);
        }
      });
    };
    _importedFiles = nodes$([]);
    _importedFileCount = lift$(_importedFiles, function(files) {
      return "Found " + (describeCount(files.length, 'file')) + ".";
    });
    _hasImportedFiles = lift$(_importedFiles, function(files) {
      return files.length > 0;
    });
    _selectedFiles = nodes$([]);
    _selectedFilesDictionary = lift$(_selectedFiles, function(files) {
      var dictionary, file, _i, _len;
      dictionary = {};
      for (_i = 0, _len = files.length; _i < _len; _i++) {
        file = files[_i];
        dictionary[file.path] = true;
      }
      return dictionary;
    });
    _selectedFileCount = lift$(_selectedFiles, function(files) {
      return "" + (describeCount(files.length, 'file')) + " selected.";
    });
    _hasSelectedFiles = lift$(_selectedFiles, function(files) {
      return files.length > 0;
    });
    importFiles = function(files) {
      var paths;
      paths = map(files, function(file) {
        return file.path;
      });
      _.requestImportFiles(paths, function(responses) {
        var passedResponses, sourceKeys;
        passedResponses = filter(responses, function(response) {
          return !response.error;
        });
        sourceKeys = flatten(map(passedResponses, function(response) {
          return response.result.keys;
        }));
        return _.requestParseSetup(sourceKeys, function(error, result) {
          if (error) {
            return _.fail('Error', error, null, noop);
          } else {
            _isImportMode(false);
            processParseSetupResult(result);
            return _isParseMode(true);
          }
        });
      });
    };
    importSelectedFiles = function() {
      return importFiles(_selectedFiles());
    };
    createSelectedFileItem = function(path) {
      var self;
      return self = {
        path: path,
        deselect: function() {
          var file, _i, _len, _ref;
          _selectedFiles.remove(self);
          _ref = _importedFiles();
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            file = _ref[_i];
            if (file.path === path) {
              file.isSelected(false);
            }
          }
        }
      };
    };
    createFileItem = function(path, isSelected) {
      var self;
      return self = {
        path: path,
        isSelected: node$(isSelected),
        toggle: function() {
          if (self.isSelected()) {
            return self.deselect();
          } else {
            return self.select();
          }
        },
        select: function() {
          _selectedFiles.push(createSelectedFileItem(self.path));
          return self.isSelected(true);
        },
        deselect: function() {
          var file;
          if (file = find(_selectedFiles(), function(file) {
            return file.path === path;
          })) {
            return file.deselect();
          }
        }
      };
    };
    listPathHints = function(query, process) {
      return _.requestFileGlob(query, 10, function(error, result) {
        if (error) {

        } else {
          return process(map(result.matches, function(value) {
            return {
              value: value
            };
          }));
        }
      });
    };
    selectAllFiles = function() {
      var file, _i, _len, _ref;
      _selectedFiles(map(_importedFiles(), function(file) {
        return createSelectedFileItem(file.path);
      }));
      _ref = _importedFiles();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        file = _ref[_i];
        file.isSelected(true);
      }
    };
    deselectAllFiles = function() {
      var file, _i, _len, _ref;
      _selectedFiles([]);
      _ref = _importedFiles();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        file = _ref[_i];
        file.isSelected(false);
      }
    };
    createFileItems = function(result) {
      return map(result.matches, function(path) {
        return createFileItem(path, _selectedFilesDictionary()[path]);
      });
    };
    processImportResult = function(result) {
      var files;
      files = createFileItems(result);
      return _importedFiles(files);
    };
    _parserType = node$(null);
    _delimiter = node$(null);
    _useSingleQuotes = node$(false);
    _columns = node$([]);
    _rows = node$([]);
    _columnCount = node$(0);
    _hasColumns = lift$(_columnCount, function(count) {
      return count > 0;
    });
    _destinationKey = node$('');
    _parsedFiles = nodes$([]);
    _headerOption = node$('auto');
    _deleteOnDone = node$(true);
    _headerOptions = {
      auto: 0,
      header: 1,
      data: -1
    };
    processParseSetupResult = function(result) {
      _parserType(find(parserTypes, function(parserType) {
        return parserType.type === result.pType;
      }));
      _delimiter(find(parseDelimiters, function(delimiter) {
        return delimiter.charCode === result.sep;
      }));
      _useSingleQuotes(result.singleQuotes);
      _destinationKey(result.hexName);
      _headerOption(result.checkHeader === 0 ? 'auto' : result.checkHeader === -1 ? 'data' : 'header');
      _columnCount(result.ncols);
      _parsedFiles(result.srcs);
      _columns(map(result.columnNames, function(name) {
        return {
          name: node$(name)
        };
      }));
      return _rows(result.data);
    };
    parseFiles = function() {
      var columnNames, sourceKeys;
      sourceKeys = map(_parsedFiles(), function(file) {
        return file.name;
      });
      columnNames = map(_columns(), function(column) {
        return column.name();
      });
      return _.requestParseFiles(sourceKeys, _destinationKey(), _parserType().type, _delimiter().charCode, _columnCount(), _useSingleQuotes(), columnNames, _deleteOnDone(), _headerOptions[_headerOption()], function(error, result) {
        if (error) {
          return _.fail('Error', error, null, noop);
        } else {
          return _go('confirm', result.job);
        }
      });
    };
    backToImport = function() {
      _isParseMode(false);
      return _isImportMode(true);
    };
    cancel = function() {
      return _go('cancel');
    };
    return {
      isImportMode: _isImportMode,
      isParseMode: _isParseMode,
      specifiedPath: _specifiedPath,
      hasErrorMessage: _hasErrorMessage,
      errorMessage: _errorMessage,
      tryImportFiles: tryImportFiles,
      listPathHints: throttle(listPathHints, 100),
      hasImportedFiles: _hasImportedFiles,
      importedFiles: _importedFiles,
      importedFileCount: _importedFileCount,
      selectedFiles: _selectedFiles,
      selectAllFiles: selectAllFiles,
      deselectAllFiles: deselectAllFiles,
      hasSelectedFiles: _hasSelectedFiles,
      selectedFileCount: _selectedFileCount,
      importSelectedFiles: importSelectedFiles,
      parserTypes: parserTypes,
      delimiters: parseDelimiters,
      parserType: _parserType,
      delimiter: _delimiter,
      useSingleQuotes: _useSingleQuotes,
      columns: _columns,
      rows: _rows,
      columnCount: _columnCount,
      hasColumns: _hasColumns,
      destinationKey: _destinationKey,
      headerOption: _headerOption,
      parsedFiles: _parsedFiles,
      deleteOnDone: _deleteOnDone,
      backToImport: backToImport,
      parseFiles: parseFiles,
      cancel: cancel,
      template: 'import-files-dialog'
    };
  };

}).call(this);

(function() {


}).call(this);

(function() {
  var getProgressPercent, getStatusColor, _statusColors;

  _statusColors = {
    failed: '#d9534f',
    done: '#ccc',
    running: '#f0ad4e'
  };

  getStatusColor = function(status) {
    switch (status) {
      case 'DONE':
        return _statusColors.done;
      case 'CREATED':
      case 'RUNNING':
        return _statusColors.running;
      default:
        return _statusColors.failed;
    }
  };

  getProgressPercent = function(progress) {
    return "" + (Math.ceil(100 * progress)) + "%";
  };

  Steam.JobListView = function(_) {
    var activateAndDisplayItem, clearPredicate, createItem, createJobCaption, displayActiveItem, displayItem, displayJobs, isJobRunning, loadJobs, pollJobStatus, updateItem, _canClearPredicate, _hasItems, _items, _predicate, _predicateCaption;
    _predicate = node$({
      type: 'all'
    });
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    _canClearPredicate = lift$(_predicate, function(predicate) {
      return predicate.type !== 'all';
    });
    _predicateCaption = lift$(_predicate, function(predicate) {
      switch (predicate.type) {
        case 'all':
          return 'Showing\nall jobs';
        default:
          throw new Error('Invalid predicate type');
      }
    });
    displayItem = function(item) {
      if (item) {
        _.displayJob(item);
      } else {
        _.displayEmpty();
      }
      return _.inspect(null);
    };
    displayActiveItem = function() {
      return displayItem(find(_items(), function(item) {
        return item.isActive();
      }));
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    isJobRunning = function(job) {
      return job.status === 'CREATED' || job.status === 'RUNNING';
    };
    pollJobStatus = function(item) {
      return _.requestJob(item.data.key.name, function(error, job) {
        if (error) {

        } else {
          if (job) {
            updateItem(item, job);
            if (isJobRunning(job)) {
              return delay(pollJobStatus, 1000, item);
            } else {
              return item.isRunning(false);
            }
          }
        }
      });
    };
    createJobCaption = function(job) {
      return "" + job.status + ": " + (getProgressPercent(job.progress)) + " (" + (formatTimeDuration(job.msec)) + ")";
    };
    updateItem = function(item, job) {
      item.caption(createJobCaption(job));
      item.status(job.status);
      item.statusColor(getStatusColor(job.status));
      item.progress(getProgressPercent(job.progress));
      item.duration(formatTimeDuration(job.msec));
      return item.exception(job.exception);
    };
    createItem = function(job) {
      var self;
      self = {
        data: job,
        title: job.key.name,
        key: job.key.name,
        caption: node$(null),
        status: node$(null),
        statusColor: node$(null),
        progress: node$(null),
        duration: node$(null),
        exception: node$(null),
        destinationKey: job.dest.name,
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false),
        isRunning: node$(isJobRunning(job)),
        result: node$(null)
      };
      updateItem(self, job);
      if (self.isRunning()) {
        delay(pollJobStatus, 1000, self);
      }
      return self;
    };
    displayJobs = function(jobs) {
      var items;
      _items(items = map(jobs, createItem));
      activateAndDisplayItem(head(items));
      return _.jobsLoaded();
    };
    loadJobs = function(predicate) {
      console.assert(isDefined(predicate));
      switch (predicate.type) {
        case 'all':
          _.requestJobs(function(error, result) {
            if (error) {
              return _.error('Error requesting job list', null, error);
            } else {
              return displayJobs(reverse(result.jobs));
            }
          });
      }
      _predicate(predicate);
    };
    clearPredicate = function() {
      return loadJobs({
        type: 'all'
      });
    };
    link$(_.loadJobs, function(predicate) {
      if (predicate) {
        return loadJobs(predicate);
      } else {
        return displayActiveItem();
      }
    });
    link$(_.refreshJobs, function() {
      return loadJobs(_predicate());
    });
    return {
      items: _items,
      predicateCaption: _predicateCaption,
      clearPredicate: clearPredicate,
      canClearPredicate: _canClearPredicate,
      hasItems: _hasItems,
      template: 'job-list-view'
    };
  };

}).call(this);

(function() {
  Steam.JobView = function(_, _jobItem) {
    var getJobResult, viewResult;
    getJobResult = function(go) {
      var jobResult;
      if (!(jobResult = _jobItem.result())) {
        return _.requestInspect(_jobItem.destinationKey, function(error, result) {
          if (error) {
            return _.error('Error inspecting job result', _jobItem.destinationKey, error);
          } else {
            jobResult = {
              kind: result.kind,
              key: _jobItem.destinationKey
            };
            _jobItem.result(jobResult);
            return go(jobResult);
          }
        });
      } else {
        return go(jobResult);
      }
    };
    viewResult = function() {
      return getJobResult(function(jobResult) {
        switch (jobResult.kind) {
          case 'frame':
            return _.switchToFrames({
              type: 'one',
              key: jobResult.key
            });
          case 'model':
            return _.switchToModels({
              type: 'one',
              key: jobResult.key
            });
        }
      });
    };
    return {
      job: _jobItem,
      viewResult: viewResult,
      dispose: function() {},
      template: 'job-view'
    };
  };

}).call(this);

(function() {
  var captureClickAndDrag, makeGrabBar, momentTimestampFormat, timeagoUpdateInterval;

  if (typeof exports !== "undefined" && exports !== null) {
    return;
  }

  ko.bindingHandlers.paragraph = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var data, html;
      html = '';
      if (data = ko.unwrap(valueAccessor())) {
        if (-1 !== data.indexOf('\n')) {
          html = "<span>" + (data.replace(/\n/g, '<br/>')) + "</span>";
        } else {
          html = data;
        }
      }
      return ko.utils.setHtml(element, html);
    }
  };

  ko.bindingHandlers.json = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var data;
      data = ko.unwrap(valueAccessor());
      return $(element).text(JSON.stringify(data, null, 2));
    }
  };

  ko.bindingHandlers.geyser = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, data;
      if (data = ko.unwrap(valueAccessor())) {
        $element = $(element);
        if (data.markup) {
          $element.html(geyser.render(data.markup));
          if (data.behavior) {
            data.behavior($element);
          }
          if (data.dispose) {
            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
              return data.dispose();
            });
          }
        } else {
          $element.html(geyser.render(data));
        }
      } else {
        $(element).text('-');
      }
    }
  };

  ko.bindingHandlers.icon = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var icon;
      if (icon = ko.unwrap(valueAccessor())) {
        element.className = "fa fa-" + icon.image;
        element.style.color = icon.color ? icon.color : null;
        element.title = icon.caption ? icon.caption : '';
      }
    }
  };

  ko.bindingHandlers.hover = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, handler, handlerIn, handlerOut;
      handler = ko.unwrap(valueAccessor());
      if (!isFunction(handler)) {
        throw new Error('Not a function');
      }
      $element = $(element);
      handlerIn = function() {
        return handler(true);
      };
      handlerOut = function() {
        return handler(false);
      };
      $element.hover(handlerIn, handlerOut);
      return ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
        return $element.off('mouseenter mouseleave');
      });
    }
  };

  ko.bindingHandlers.tooltip = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, title;
      title = ko.unwrap(valueAccessor());
      $element = $(element);
      $element.tooltip('destroy');
      if (title) {
        $element.tooltip({
          title: title
        });
      }
      return ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
        return $element.tooltip('destroy');
      });
    }
  };

  timeagoUpdateInterval = 60000;

  momentTimestampFormat = 'MMMM Do YYYY, h:mm:ss a';

  ko.bindingHandlers.timeago = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, date, tick, timestamp;
      timestamp = ko.unwrap(valueAccessor());
      if (isString(timestamp)) {
        timestamp = parseInt(timestamp);
      }
      $element = $(element);
      date = moment(new Date(timestamp));
      $element.attr('title', date.format(momentTimestampFormat));
      tick = function() {
        var label;
        label = date.fromNow();
        if ($element.text() !== label) {
          $element.text(label);
        }
      };
      if (window.steam) {
        window.steam.context.schedule(timeagoUpdateInterval, tick);
        ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
          return window.steam.context.unschedule(timeagoUpdateInterval, tick);
        });
      }
      tick();
    }
  };

  ko.bindingHandlers.collapse = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $disclosureEl, $el, $nextEl, angleDown, angleRight, disclosureEl, isCollapsed, toggle;
      angleDown = 'fa-angle-down';
      angleRight = 'fa-angle-right';
      isCollapsed = ko.unwrap(valueAccessor());
      disclosureEl = document.createElement('i');
      disclosureEl.className = 'fa';
      element.appendChild(disclosureEl);
      $el = $(element);
      $nextEl = $el.next();
      if (!$nextEl.length) {
        throw new Error('No collapsible sibling found');
      }
      $disclosureEl = $(disclosureEl);
      toggle = function() {
        if (isCollapsed) {
          $disclosureEl.removeClass(angleDown).addClass(angleRight);
          $nextEl.hide();
        } else {
          $disclosureEl.removeClass(angleRight).addClass(angleDown);
          $nextEl.show();
        }
        return isCollapsed = !isCollapsed;
      };
      $el.css('cursor', 'pointer');
      $el.attr('title', 'Click to expand/collapse');
      $disclosureEl.css('margin-left', '10px');
      $el.on('click', toggle);
      toggle();
      ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
        return $el.off('click');
      });
    }
  };

  ko.bindingHandlers.raw = {
    update: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, arg;
      arg = ko.unwrap(valueAccessor());
      if (arg) {
        $element = $(element);
        $element.empty();
        $element.append(arg);
      }
    }
  };

  ko.bindingHandlers.help = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, arg, steam;
      if (steam = window.steam) {
        $element = $(element);
        arg = ko.unwrap(valueAccessor());
        if (isFunction(arg)) {
          $element.on('click', function() {
            return arg();
          });
        } else if (isString(arg)) {
          $element.on('click', function() {
            return steam.context.help(arg);
          });
        } else {
          throw new Error('Invalid argument');
        }
        ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
          return $element.off('click');
        });
      }
    }
  };

  captureClickAndDrag = function($el, onClick, onDrag, onRelease) {
    var $document;
    $document = $(document);
    return $el.on('mousedown', function(e) {
      var onMouseMove, onMouseUp, zIndex;
      if (e.which !== 1) {
        return;
      }
      zIndex = $el.css('z-index');
      $el.css('z-index', 1000);
      onMouseMove = function(e) {
        return onDrag(e.pageX, e.pageY);
      };
      onMouseUp = function(e) {
        $el.css('z-index', zIndex);
        $document.off('mousemove', onMouseMove);
        $document.off('mouseup', onMouseUp);
        return onRelease(e.pageX, e.pageY);
      };
      $document.on('mousemove', onMouseMove);
      $document.on('mouseup', onMouseUp);
      e.preventDefault();
      onClick(e.pageX, e.pageY);
    });
  };

  makeGrabBar = function($el, _opts, go) {
    var onClick, onDrag, onRelease, readElementSize, _height, _left, _offset, _top, _width, _x, _y;
    _offset = null;
    _left = _top = _width = _height = _x = _y = 0;
    readElementSize = function() {
      _width = $el.outerWidth();
      _height = $el.outerHeight();
      return _offset = $el.offset();
    };
    onClick = function(x, y) {
      readElementSize();
      _x = _offset.left + _width - x;
      return _y = _offset.top + _height - y;
    };
    onDrag = function(x, y) {
      var left, top;
      left = _opts.allowHorizontalMovement ? x + _x - _width : _offset.left;
      top = _opts.allowVerticalMovement ? y + _y - _height : _offset.top;
      if (left !== _left || top !== _top) {
        _left = left;
        _top = top;
        return $el.offset({
          left: left,
          top: top
        });
      }
    };
    onRelease = function(x, y) {
      readElementSize();
      return go({
        left: _offset.left,
        top: _offset.top,
        width: _width,
        height: _height
      });
    };
    return captureClickAndDrag($el, onClick, onDrag, onRelease);
  };

  ko.bindingHandlers.draggable = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $el, grabBarOpts;
      $el = $(element);
      grabBarOpts = {
        allowVerticalMovement: true,
        allowHorizontalMovement: false
      };
      return makeGrabBar($el, grabBarOpts, function(rect) {
        return console.log(rect);
      });
    }
  };

  ko.bindingHandlers.enterKey = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, action;
      if (action = ko.unwrap(valueAccessor())) {
        if (isFunction(action)) {
          $element = $(element);
          $element.keydown(function(e) {
            if (e.which === 13) {
              action(viewModel);
            }
          });
        } else {
          throw 'Enter key action is not a function';
        }
      }
    }
  };

  ko.bindingHandlers.typeahead = {
    init: function(element, valueAccessor, allBindings, viewModel, bindingContext) {
      var $element, action;
      if (action = ko.unwrap(valueAccessor())) {
        if (isFunction(action)) {
          $element = $(element);
          $element.typeahead(null, {
            displayKey: 'value',
            source: action
          });
        } else {
          throw 'Typeahead action is not a function';
        }
      }
    }
  };

}).call(this);

(function() {
  Steam.LocalStorage = function(_) {
    var deleteLocalObject, getLocalObject, getLocalObjects, putLocalObject, _hasLocalStorage;
    _hasLocalStorage = (function() {
      var error;
      try {
        localStorage.setItem('test', 'test');
        localStorage.removeItem('test');
        return true;
      } catch (_error) {
        error = _error;
        return false;
      }
    })();
    if (!_hasLocalStorage) {
      return;
    }
    putLocalObject = function(key, value) {
      return localStorage.setItem(key, JSON.stringify(value));
    };
    getLocalObject = function(key) {
      var value;
      value = localStorage.getItem(key);
      if (isDefined(value)) {
        return JSON.parse(value);
      } else {
        return void 0;
      }
    };
    getLocalObjects = function(predicate) {
      var hasPredicate, index, value, values, _i, _ref;
      values = [];
      hasPredicate = isFunction(predicate);
      for (index = _i = 0, _ref = localStorage.length; 0 <= _ref ? _i < _ref : _i > _ref; index = 0 <= _ref ? ++_i : --_i) {
        value = getLocalObject(localStorage.key(index));
        if (hasPredicate) {
          if (predicate(value)) {
            values.push(value);
          }
        } else {
          values.push(value);
        }
      }
      return values;
    };
    deleteLocalObject = function(key) {
      return localStorage.removeItem(key);
    };
    link$(_.putLocalObject, putLocalObject);
    link$(_.getLocalObject, getLocalObject);
    link$(_.getLocalObjects, getLocalObjects);
    link$(_.deleteLocalObject, deleteLocalObject);
  };

}).call(this);

(function() {
  var defaultStatusMessage;

  defaultStatusMessage = 'Ready.';

  Steam.MainView = function(_) {
    var createTopic, displayStatus, fixDialogPlacement, help, initialize, inspect, navigateHelp, navigateHelpBack, navigateHelpForward, navigateHelpHome, refresh, switchListView, switchModalView, switchPageView, switchSelectionView, switchToAdmin, switchToFrames, switchToJobs, switchToModels, switchToNotifications, switchToScoring, switchTopic, switchView, template, toggleInspector, toggleTopics, _adminListView, _adminTopic, _canNavigateHelpBack, _canNavigateHelpForward, _frameListView, _frameSelectionView, _frameTopic, _hasInspections, _hasModalDialog, _hasModalView, _help, _helpHistory, _helpHistoryIndex, _inspectorViews, _isDisplayingTopics, _isInspectorHidden, _isListMasked, _isNavigatorMasked, _isViewMasked, _jobListView, _jobTopic, _listViews, _modalDialogs, _modalViews, _modelListView, _modelSelectionView, _modelTopic, _notificationListView, _notificationTopic, _pageViews, _scoringSelectionView, _scoringTopic, _selectionViews, _status, _timelineTopic, _topic, _topicListView, _topicTitle, _topics;
    _help = node$(null);
    _helpHistory = [];
    _helpHistoryIndex = -1;
    _canNavigateHelpBack = node$(false);
    _canNavigateHelpForward = node$(false);
    _status = node$(defaultStatusMessage);
    _listViews = nodes$();
    _selectionViews = nodes$();
    _pageViews = nodes$();
    _modalViews = nodes$();
    _modalDialogs = nodes$();
    _inspectorViews = nodes$(null);
    _hasInspections = lift$(_inspectorViews, function(inspections) {
      return inspections.length > 0;
    });
    _isInspectorHidden = node$(false);
    _topic = node$(null);
    _isDisplayingTopics = node$(false);
    _hasModalView = lift$(_modalViews, function(modalViews) {
      return modalViews.length > 0;
    });
    _hasModalDialog = lift$(_modalDialogs, function(modalDialogs) {
      return modalDialogs.length > 0;
    });
    _isNavigatorMasked = lift$(_hasModalDialog, _hasModalView, function(hasModalDialog, hasModalView) {
      return hasModalDialog || hasModalView;
    });
    _isListMasked = lift$(_hasModalDialog, identity);
    _isViewMasked = lift$(_hasModalDialog, _isDisplayingTopics, function(hasModalDialog, isDisplayingTopics) {
      return hasModalDialog || isDisplayingTopics;
    });
    _topicTitle = lift$(_topic, _isDisplayingTopics, function(topic, isDisplayingTopics) {
      if (isDisplayingTopics) {
        return 'Menu';
      } else if (topic) {
        return topic.title;
      } else {
        return '';
      }
    });
    toggleTopics = function() {
      return _isDisplayingTopics(!_isDisplayingTopics());
    };
    toggleInspector = function() {
      return _isInspectorHidden(!_isInspectorHidden());
    };
    apply$(_isDisplayingTopics, function(isDisplayingTopics) {
      if (isDisplayingTopics) {
        return _listViews.push(_topicListView);
      } else {
        return _listViews.remove(_topicListView);
      }
    });
    initialize = function() {
      navigateHelpHome();
      return switchToFrames({
        type: 'all'
      });
    };
    createTopic = function(title, handle) {
      var self;
      return self = {
        title: title,
        isDisabled: !isFunction(handle),
        display: function() {
          if (handle) {
            return handle();
          }
        }
      };
    };
    switchTopic = function(topic) {
      switch (topic) {
        case _frameTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_frameListView);
            switchSelectionView(_frameSelectionView);
          }
          break;
        case _modelTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_modelListView);
            switchSelectionView(_modelSelectionView);
          }
          break;
        case _scoringTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_scoringListView);
            switchSelectionView(_scoringSelectionView);
          }
          break;
        case _notificationTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_notificationListView);
            switchSelectionView(null);
          }
          break;
        case _jobTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_jobListView);
            switchSelectionView(null);
          }
          break;
        case _adminTopic:
          if (_topic() !== topic) {
            _topic(topic);
            switchListView(_adminListView);
            switchSelectionView(null);
          }
      }
      _isDisplayingTopics(false);
    };
    switchToFrames = function(predicate) {
      switchTopic(_frameTopic);
      return _.loadFrames(predicate);
    };
    switchToModels = function(predicate) {
      switchTopic(_modelTopic);
      return _.loadModels(predicate);
    };
    switchToScoring = function(predicate) {
      switchTopic(_scoringTopic);
      return _.loadScorings(predicate);
    };
    switchToNotifications = function(predicate) {
      switchTopic(_notificationTopic);
      return _.loadNotifications(predicate);
    };
    switchToJobs = function(predicate) {
      switchTopic(_jobTopic);
      return _.loadJobs(predicate ? predicate : {
        type: 'all'
      });
    };
    switchToAdmin = function() {
      switchTopic(_adminTopic);
      return _.loadAdmin();
    };
    _topics = node$([_frameTopic = createTopic('Datasets', switchToFrames), _modelTopic = createTopic('Models', switchToModels), _scoringTopic = createTopic('Scoring', null), _timelineTopic = createTopic('Timeline', null), _notificationTopic = createTopic('Notifications', switchToNotifications), _jobTopic = createTopic('Jobs', switchToJobs), _adminTopic = createTopic('Administration', switchToAdmin)]);
    _topicListView = Steam.TopicListView(_, _topics);
    _frameListView = Steam.FrameListView(_);
    _modelListView = Steam.ModelListView(_);
    _notificationListView = Steam.NotificationListView(_);
    _jobListView = Steam.JobListView(_);
    _adminListView = Steam.AdminListView(_);
    _frameSelectionView = Steam.FrameSelectionView(_);
    _modelSelectionView = Steam.ModelSelectionView(_);
    _scoringSelectionView = Steam.ScoringSelectionView(_);
    switchView = function(views, view) {
      var oldView, _i, _len, _ref;
      _ref = views();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        oldView = _ref[_i];
        if (isFunction(oldView.dispose)) {
          oldView.dispose();
        }
      }
      if (view) {
        return views([view]);
      } else {
        return views([]);
      }
    };
    switchListView = function(view) {
      return switchView(_listViews, view);
    };
    switchSelectionView = function(view) {
      return switchView(_selectionViews, view);
    };
    switchPageView = function(view) {
      return switchView(_pageViews, view);
    };
    switchModalView = function(view) {
      return switchView(_modalViews, view);
    };
    fixDialogPlacement = function(element) {
      return _.positionDialog(element);
    };
    refresh = function() {
      switch (_topic()) {
        case _frameTopic:
          _.refreshFrames();
          break;
        case _modelTopic:
          _.refreshModels();
          break;
        case _jobTopic:
          _.refreshJobs();
      }
    };
    displayStatus = function(message) {
      if (message) {
        _status(message);
        return _.timeout('status', 7000, function() {
          return _.status(null);
        });
      } else {
        return _status(defaultStatusMessage);
      }
    };
    inspect = function(view) {
      if (view) {
        switchView(_inspectorViews, view);
      } else {
        switchView(_inspectorViews, null);
      }
    };
    navigateHelpHome = function() {
      return help('home');
    };
    navigateHelp = function() {
      _help(_.man(_helpHistory[_helpHistoryIndex]));
      _canNavigateHelpBack(_helpHistoryIndex > 0);
      return _canNavigateHelpForward(_helpHistoryIndex < _helpHistory.length - 1);
    };
    navigateHelpBack = function() {
      if (_helpHistoryIndex > 0) {
        _helpHistoryIndex--;
        return navigateHelp();
      }
    };
    navigateHelpForward = function() {
      if (_helpHistoryIndex < _helpHistory.length - 1) {
        _helpHistoryIndex++;
        return navigateHelp();
      }
    };
    help = function(id) {
      if (_helpHistory[_helpHistoryIndex] !== id) {
        if (_helpHistoryIndex < _helpHistory.length - 1) {
          _helpHistory.length = _helpHistoryIndex + 1;
          _helpHistoryIndex = _helpHistory.length - 1;
        }
        if (_helpHistory.length > 50) {
          _helpHistory.splice(0, _helpHistory.length - 50);
          _helpHistoryIndex = _helpHistory.length - 1;
        }
        _helpHistory.push(id);
        return navigateHelpForward();
      }
    };
    template = function(view) {
      return view.template;
    };
    link$(_.loadDialog, function(dialog) {
      return _modalDialogs.push(dialog);
    });
    link$(_.unloadDialog, function(dialog) {
      return _modalDialogs.remove(dialog);
    });
    link$(_.displayEmpty, function() {
      return switchPageView({
        template: 'empty-view'
      });
    });
    link$(_.displayView, function(view) {
      return switchPageView(view);
    });
    link$(_.displayFrame, function(frame) {
      if (_topic() === _frameTopic) {
        return switchPageView(Steam.FrameView(_, frame));
      }
    });
    link$(_.displayModel, function(model) {
      if (_topic() === _modelTopic) {
        return switchPageView(Steam.ModelView(_, model));
      }
    });
    link$(_.displayScoring, function(scoring) {
      if (_topic() === _scoringTopic) {
        return switchPageView(Steam.ScoringView(_, scoring));
      }
    });
    link$(_.displayNotification, function(notification) {
      if (_topic() === _notificationTopic) {
        return switchPageView(Steam.NotificationView(_, notification));
      }
    });
    link$(_.displayJob, function(job) {
      if (_topic() === _jobTopic) {
        return switchPageView(Steam.JobView(_, job));
      }
    });
    link$(_.switchToFrames, switchToFrames);
    link$(_.switchToModels, switchToModels);
    link$(_.switchToScoring, switchToScoring);
    link$(_.switchToNotifications, switchToNotifications);
    link$(_.switchToJobs, switchToJobs);
    link$(_.inspect, inspect);
    link$(_.status, displayStatus);
    link$(_.help, help);
    initialize();
    return {
      topicTitle: _topicTitle,
      toggleTopics: toggleTopics,
      toggleInspector: toggleInspector,
      listViews: _listViews,
      selectionViews: _selectionViews,
      pageViews: _pageViews,
      modalViews: _modalViews,
      modalDialogs: _modalDialogs,
      hasModalView: _hasModalView,
      hasModalDialog: _hasModalDialog,
      isNavigatorMasked: _isNavigatorMasked,
      isListMasked: _isListMasked,
      isViewMasked: _isViewMasked,
      isInspectorHidden: _isInspectorHidden,
      inspectorViews: _inspectorViews,
      hasInspections: _hasInspections,
      refresh: refresh,
      help: _help,
      navigateHelpHome: navigateHelpHome,
      canNavigateHelpBack: _canNavigateHelpBack,
      navigateHelpBack: navigateHelpBack,
      canNavigateHelpForward: _canNavigateHelpForward,
      navigateHelpForward: navigateHelpForward,
      status: _status,
      fixDialogPlacement: fixDialogPlacement,
      template: template
    };
  };

}).call(this);

(function() {


}).call(this);

(function() {
  Steam.ModelInspectionView = function(_, _model) {
    var collateParameters, collateSummary, kv, stringify;
    stringify = function(value) {
      if (isArray(value)) {
        return join(value, ', ');
      } else {
        return value;
      }
    };
    kv = function(key, value) {
      return {
        key: key,
        value: stringify(value)
      };
    };
    collateSummary = function(model) {
      return [kv('Response Column', model.response_column_name), kv('Model Category', model.model_category)];
    };
    collateParameters = function(model) {
      var parameters;
      parameters = [pairs(model.critical_parameters), pairs(model.secondary_parameters), pairs(model.expert_parameters)];
      return map(flatten(parameters, true), function(_arg) {
        var key, value;
        key = _arg[0], value = _arg[1];
        return kv(key, value);
      });
    };
    return {
      data: _model,
      key: _model.key,
      timestamp: _model.creation_epoch_time_millis,
      summary: collateSummary(_model),
      parameters: collateParameters(_model),
      inputColumns: _model.input_column_names,
      inputColumnsCount: "(" + _model.input_column_names.length + ")",
      template: 'model-inspection-view'
    };
  };

}).call(this);

(function() {
  Steam.ModelListView = function(_) {
    var activateAndDisplayItem, clearPredicate, createItem, createModel, deselectAllModels, determineModelAlgorithm, displayActiveItem, displayItem, displayModels, loadModels, _canClearPredicate, _hasItems, _isLive, _isSelectAll, _items, _predicate, _predicateCaption;
    _predicate = node$({
      type: 'all'
    });
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    _isSelectAll = node$(false);
    _isLive = node$(true);
    apply$(_isSelectAll, function(isSelected) {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(isSelected);
      }
      _isLive(true);
    });
    _canClearPredicate = lift$(_predicate, function(predicate) {
      return predicate.type !== 'all';
    });
    _predicateCaption = lift$(_predicate, function(predicate) {
      switch (predicate.type) {
        case 'all':
          return 'Showing\nall models';
        case 'one':
          return 'Showing\none model';
        case 'compatibleWithFrame':
          return "Showing models compatible with\n" + predicate.frameKey;
        default:
          return '';
      }
    });
    displayItem = function(item) {
      if (item) {
        _.displayModel(item.data);
        _.activeModelChanged(item.data);
      } else {
        _.displayEmpty();
        _.activeModelChanged(null);
      }
      return _.inspect(null);
    };
    displayActiveItem = function() {
      return displayItem(find(_items(), function(item) {
        return item.isActive();
      }));
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    determineModelAlgorithm = function(model) {
      var hasRateAnnealing;
      hasRateAnnealing = find(model.parameters, function(parameter) {
        return parameter.name === 'rate_annealing';
      });
      if (hasRateAnnealing) {
        return 'Deep Learning';
      } else {
        return 'k-means';
      }
    };
    createItem = function(model) {
      var self;
      self = {
        data: model,
        title: model.key,
        caption: determineModelAlgorithm(model),
        timestamp: Date.now(),
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false),
        isSelected: node$(false)
      };
      apply$(_isLive, self.isSelected, function(isLive, isSelected) {
        if (isLive) {
          return _.modelSelectionChanged(isSelected, self);
        }
      });
      return self;
    };
    displayModels = function(models) {
      var items;
      _items(items = map(models, createItem));
      return activateAndDisplayItem(head(items));
    };
    loadModels = function(predicate) {
      _.modelSelectionCleared();
      switch (predicate.type) {
        case 'all':
          _.requestModels(function(error, models) {
            if (error) {

            } else {
              return displayModels(models);
            }
          });
          break;
        case 'one':
          _.requestModel(predicate.key, function(error, model) {
            if (error) {

            } else {
              return displayModels([model]);
            }
          });
          break;
        case 'compatibleWithFrame':
          _.requestFrameAndCompatibleModels(predicate.frameKey, function(error, data) {
            var compatibleModelsByKey;
            if (error) {

            } else {
              compatibleModelsByKey = indexBy((head(data.frames)).compatible_models, function(model) {
                return model.key;
              });
              return _.requestModelsAndCompatibleFrames(function(error, data) {
                if (error) {

                } else {
                  return displayModels(filter(data.models, function(model) {
                    if (compatibleModelsByKey[model.key]) {
                      return true;
                    } else {
                      return false;
                    }
                  }));
                }
              });
            }
          });
      }
      _predicate(predicate);
    };
    deselectAllModels = function() {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(false);
      }
      return _isLive(true);
    };
    clearPredicate = function() {
      deselectAllModels();
      return loadModels({
        type: 'all'
      });
    };
    link$(_.loadModels, function(predicate) {
      if (predicate) {
        return loadModels(predicate);
      } else {
        loadModels({
          type: 'all'
        });
        return displayActiveItem();
      }
    });
    link$(_.deselectAllModels, deselectAllModels);
    link$(_.refreshModels, function() {
      return loadModels(_predicate());
    });
    createModel = function() {
      return _.promptCreateModel(null, null, function(action) {
        switch (action) {
          case 'confirm':
            return console.log('TODO CONFIRMED');
        }
      });
    };
    return {
      items: _items,
      hasItems: _hasItems,
      predicateCaption: _predicateCaption,
      clearPredicate: clearPredicate,
      canClearPredicate: _canClearPredicate,
      isSelectAll: _isSelectAll,
      createModel: createModel,
      template: 'model-list-view'
    };
  };

}).call(this);

(function() {
  var defaultScoringSelectionMessage;

  defaultScoringSelectionMessage = 'Score selected models.';

  Steam.ModelSelectionView = function(_) {
    var clearSelections, cloneModel, scoreSelections, tryScoreSelections, _activeModel, _canScoreSelections, _caption, _compatibleFrames, _hasActiveModel, _hasSelection, _modelSelectionMessage, _selections;
    _activeModel = node$();
    _hasActiveModel = lift$(_activeModel, isTruthy);
    _selections = nodes$([]);
    _hasSelection = lift$(_selections, function(selections) {
      return selections.length > 0;
    });
    _caption = lift$(_selections, function(selections) {
      return "" + (describeCount(selections.length, 'model')) + " selected.";
    });
    _compatibleFrames = lift$(_selections, function(selections) {
      var commonFrameKeys, framesByKey, framesPerModel;
      framesPerModel = map(selections, function(selection) {
        return selection.data.compatible_frames;
      });
      framesByKey = indexBy(flatten(framesPerModel), function(frame) {
        return frame.key;
      });
      commonFrameKeys = sortBy(intersection.apply(null, map(framesPerModel, function(frames) {
        return map(frames, function(frame) {
          return frame.key;
        });
      })));
      return map(commonFrameKeys, function(key) {
        return framesByKey[key];
      });
    });
    _canScoreSelections = lift$(_compatibleFrames, function(frames) {
      return frames.length > 0;
    });
    _modelSelectionMessage = lift$(_compatibleFrames, function(frames) {
      if (frames.length) {
        return defaultScoringSelectionMessage;
      } else {
        return 'No compatible datasets found.';
      }
    });
    cloneModel = function() {
      return _.promptCreateModel(null, _activeModel(), function(action) {
        switch (action) {
          case 'confirm':
            return _.switchToJobs();
        }
      });
    };
    scoreSelections = function() {
      return _.promptForFrame(_compatibleFrames(), function(action, frameKey) {
        var scorings;
        switch (action) {
          case 'confirm':
            scorings = map(_selections(), function(selection) {
              return {
                frameKey: frameKey,
                model: selection.data,
                status: null,
                time: null,
                result: null,
                timestamp: Date.now()
              };
            });
            _.switchToScoring({
              type: 'scoring',
              scorings: scorings
            });
            return _.deselectAllModels();
        }
      });
    };
    tryScoreSelections = function(hover) {
      return _.status(hover ? _modelSelectionMessage() : null);
    };
    clearSelections = function() {
      return _.deselectAllModels();
    };
    link$(_.activeModelChanged, function(model) {
      return _activeModel(model);
    });
    link$(_.modelSelectionChanged, function(isSelected, model) {
      if (isSelected) {
        return _selections.push(model);
      } else {
        return _selections.remove(model);
      }
    });
    link$(_.modelSelectionCleared, function() {
      return _selections.removeAll();
    });
    return {
      caption: _caption,
      hasActiveModel: _hasActiveModel,
      cloneModel: cloneModel,
      hasSelection: _hasSelection,
      clearSelections: clearSelections,
      canScoreSelections: _canScoreSelections,
      tryScoreSelections: tryScoreSelections,
      scoreSelections: scoreSelections,
      template: 'model-selection-view'
    };
  };

}).call(this);

(function() {
  var modelParameterLevelSortCriteria;

  modelParameterLevelSortCriteria = {
    critical: 1,
    secondary: 2,
    expert: 3
  };

  Steam.ModelView = function(_, _model) {
    var collateCompatibleFrames, collateParameters, collateSummary, compatibleFrames, compatibleFramesCount, determineModelAlgorithm, kv, loadCompatibleFrames, nonRawFrames, stringify;
    stringify = function(value) {
      if (isArray(value)) {
        return join(value, ', ');
      } else {
        return value;
      }
    };
    kv = function(key, value) {
      return {
        key: key,
        value: stringify(value)
      };
    };
    determineModelAlgorithm = function(model) {
      var hasRateAnnealing;
      hasRateAnnealing = find(model.parameters, function(parameter) {
        return parameter.name === 'rate_annealing';
      });
      if (hasRateAnnealing) {
        return 'Deep Learning';
      } else {
        return 'k-means';
      }
    };
    collateSummary = function(model) {
      return [kv('Algorithm', determineModelAlgorithm(model))];
    };
    collateParameters = function(model) {
      var parameters;
      parameters = sortBy(model.parameters, function(parameter) {
        return modelParameterLevelSortCriteria[parameter.level];
      });
      return map(parameters, function(parameter) {
        return kv(parameter.label, parameter.actual_value || '-');
      });
    };
    collateCompatibleFrames = function(frames) {
      return map(frames, function(frame) {
        return {
          frameKey: frame.key,
          columns: join(frame.column_names, ', '),
          inspect: function() {
            return _.inspect(Steam.FrameInspectionView(_, frame));
          }
        };
      });
    };
    nonRawFrames = filter(_model.compatible_frames, function(frame) {
      return !frame.is_raw_frame;
    });
    compatibleFrames = collateCompatibleFrames(nonRawFrames);
    compatibleFramesCount = "(" + nonRawFrames.length + ")";
    loadCompatibleFrames = function() {
      return _.switchToFrames({
        type: 'compatibleWithModel',
        modelKey: _model.key
      });
    };
    return {
      data: _model,
      key: _model.key,
      timestamp: Date.now(),
      summary: collateSummary(_model),
      parameters: collateParameters(_model),
      inputColumns: _model.output.names,
      inputColumnsCount: "(" + _model.output.names.length + ")",
      template: 'model-view'
    };
  };

}).call(this);

(function() {
  Steam.NotificationListView = function(_) {
    var activateAndDisplayItem, createItem, displayActiveItem, displayItem, _hasItems, _items;
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    displayItem = function(item) {
      if (item) {
        _.displayNotification(item.data);
      } else {
        _.displayEmpty();
      }
      return _.inspect(null);
    };
    displayActiveItem = function() {
      return displayItem(find(_items(), function(item) {
        return item.isActive();
      }));
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createItem = function(notification) {
      var self;
      return self = {
        data: notification,
        title: notification.level,
        caption: notification.message,
        cutline: notification.timestamp.toString(),
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false)
      };
    };
    link$(_.notify, function(notification) {
      return _items.unshift(createItem(notification));
    });
    link$(_.loadNotifications, function() {
      return displayActiveItem();
    });
    return {
      items: _items,
      hasItems: _hasItems,
      template: 'notification-list-view'
    };
  };

}).call(this);

(function() {
  Steam.NotificationView = function(_, _notification) {
    return {
      title: _notification.message,
      level: _notification.level,
      data: _notification.data,
      cause: _notification.cause,
      timestamp: _notification.timestamp.toString(),
      dispose: function() {},
      template: 'notification-view'
    };
  };

}).call(this);

(function() {
  Steam.PerfbarView = function(_) {
    window.createPerfbar();
    return {
      template: 'perfbar-view'
    };
  };

}).call(this);

(function() {
  var falsy, truthy;

  truthy = [
    [1, 2, 3], true, new Date(), {
      'a': 1
    }, 42, /x/, 'a'
  ];

  falsy = ['', 0, false, NaN, null, void 0];

  test('prelude availability in application scope', function(t) {
    var func, funcs, _i, _len;
    funcs = [compact, difference, findIndex, findLastIndex, flatten, head, indexOf, initial, intersection, last, lastIndexOf, pull, range, removeWhere, sortedIndex, tail, union, unique, without, xor, zip, zipObject, at, contains, countBy, every, filter, find, findLast, forEach, forEachRight, groupBy, indexBy, map, max, min, pluck, reduce, reduceRight, reject, sample, shuffle, size, some, sortBy, toArray, where, after, compose, curry, debounce, defer, delay, memoize, once, partial, partialRight, throttle, wrap, clone, cloneDeep, defaults, extend, findKey, findLastKey, forIn, forInRight, forOwn, forOwnRight, functions, has, invert, isArguments, isArray, isBoolean, isDate, isElement, isEmpty, isEqual, isFinite, isFunction, isNaN, isNull, isNumber, isObject, isPlainObject, isRegExp, isString, isUndefined, keys, mapValues, merge, omit, pairs, pick, transform, values, now, constant, escape, identity, noop, property, random, times, unescape, uniqueId, apply, isDefined, isTruthy, isFalsy, isError, negate, always, never, join, split, words, sort, copy, concat, unshift, unshiftAll, shift, push, pushAll, pop, splice, remove, clear, repeat, mapWithKey, zipCompare, same, valuesAreEqual];
    for (_i = 0, _len = funcs.length; _i < _len; _i++) {
      func = funcs[_i];
      t.equal(typeof func, 'function');
    }
    return t.end();
  });

  test('isDefined', function(t) {
    var arg, _i, _j, _len, _len1;
    for (_i = 0, _len = falsy.length; _i < _len; _i++) {
      arg = falsy[_i];
      t.equal(isDefined(arg), arg !== void 0);
    }
    for (_j = 0, _len1 = truthy.length; _j < _len1; _j++) {
      arg = truthy[_j];
      t.equal(isDefined(arg), true);
    }
    return t.end();
  });

  test('isTruthy', function(t) {
    var arg, _i, _j, _len, _len1;
    for (_i = 0, _len = falsy.length; _i < _len; _i++) {
      arg = falsy[_i];
      t.equal(isTruthy(arg), arg ? true : false);
    }
    for (_j = 0, _len1 = truthy.length; _j < _len1; _j++) {
      arg = truthy[_j];
      t.equal(isTruthy(arg), arg ? true : false);
    }
    return t.end();
  });

  test('isFalsy', function(t) {
    var arg, _i, _j, _len, _len1;
    for (_i = 0, _len = falsy.length; _i < _len; _i++) {
      arg = falsy[_i];
      t.equal(isFalsy(arg), arg ? false : true);
    }
    for (_j = 0, _len1 = truthy.length; _j < _len1; _j++) {
      arg = truthy[_j];
      t.equal(isFalsy(arg), arg ? false : true);
    }
    return t.end();
  });

  test('isError', function(t) {
    t.equal(isError(new Error()), true);
    t.equal(isError({}), false);
    return t.end();
  });

  test('join', function(t) {
    var array, delim, delims, _i, _len;
    array = ['foo', 'bar'];
    delims = [void 0, null, '', ' ', ','];
    for (_i = 0, _len = delims.length; _i < _len; _i++) {
      delim = delims[_i];
      t.equal(join(array, delim), array.join(delim));
    }
    return t.end();
  });

  test('split', function(t) {
    var arg, args, delim, str, _i, _len;
    args = [['foo bar   baz', /\s+/], ['foo, bar, baz', ', ']];
    for (_i = 0, _len = args.length; _i < _len; _i++) {
      arg = args[_i];
      str = arg[0], delim = arg[1];
      t.deepEqual(split(str, delim), str.split(delim));
    }
    return t.end();
  });

  test('words', function(t) {
    t.deepEqual(words('foo bar baz'), ['foo', 'bar', 'baz']);
    t.deepEqual(words(' foo   bar    baz   '), ['', 'foo', 'bar', 'baz', '']);
    return t.end();
  });

  test('sort without comparator', function(t) {
    var array, expected;
    array = ['foo', 'bar', 'baz'];
    expected = array.slice(0).sort();
    t.deepEqual(sort(array), expected);
    return t.end();
  });

  test('sort with comparator', function(t) {
    var array, comparator, expected;
    array = [40, 100, 1, 5, 25, 10];
    comparator = function(a, b) {
      return b - a;
    };
    expected = array.slice(0).sort(comparator);
    t.deepEqual(sort(array, comparator), expected);
    return t.end();
  });

  test('copy', function(t) {
    var actual, array, expected, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1, o2, o3];
    expected = array.slice(0);
    actual = copy(array);
    t.deepEqual(actual, expected);
    t.notEqual(actual, expected);
    return t.end();
  });

  test('concat', function(t) {
    var actual, array1, array2, array3;
    array1 = [1, 2, 3];
    array2 = [4, 5, 6];
    array3 = [7, 8, 9];
    actual = concat(array1, array2, array3);
    t.notEqual(array1, actual);
    t.deepEqual(actual, [1, 2, 3, 4, 5, 6, 7, 8, 9]);
    return t.end();
  });

  test('unshift', function(t) {
    var actual, array, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o2, o3];
    actual = unshift(array, o1);
    t.deepEqual(actual, [o1, o2, o3]);
    t.equal(actual, array);
    return t.end();
  });

  test('unshiftAll', function(t) {
    var actual, array, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1];
    actual = unshiftAll(array, [o2, o3]);
    t.deepEqual(actual, [o2, o3, o1]);
    t.equal(actual, array);
    return t.end();
  });

  test('shift', function(t) {
    var actual, array, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1, o2, o3];
    actual = shift(array);
    t.deepEqual(array, [o2, o3]);
    t.equal(actual, o1);
    return t.end();
  });

  test('push', function(t) {
    var actual, array, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1, o2];
    actual = push(array, o3);
    t.deepEqual(actual, [o1, o2, o3]);
    t.equal(actual, array);
    return t.end();
  });

  test('pushAll', function(t) {
    var actual, array, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1];
    actual = pushAll(array, [o2, o3]);
    t.deepEqual(actual, [o1, o2, o3]);
    t.equal(actual, array);
    return t.end();
  });

  test('pop', function(t) {
    var actual, array, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1, o2, o3];
    actual = pop(array);
    t.deepEqual(array, [o1, o2]);
    t.equal(actual, o3);
    return t.end();
  });

  test('splice', function(t) {
    var actual, array, o1, o2, o3;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1, o2, o3];
    actual = splice(array, 1, 1);
    t.deepEqual(array, [o1, o3]);
    t.deepEqual(actual, [o2]);
    return t.end();
  });

  test('remove', function(t) {
    var array, o1, o2, o3, o4, o5;
    o1 = {};
    o2 = {};
    o3 = {};
    array = [o1, o2, o3];
    o4 = remove(array, o2);
    t.equal(o4, o2);
    t.equal(array.length, 2);
    t.equal(array[0], o1);
    t.equal(array[1], o3);
    o5 = remove(array, o2);
    t.equal(o5, void 0);
    t.equal(array.length, 2);
    return t.end();
  });

  test('clear', function(t) {
    var array1, array2;
    array1 = ['foo', 'bar'];
    array2 = clear(array1);
    t.equal(array1.length, 0);
    t.equal(array1, array2);
    return t.end();
  });

  test('repeat', function(t) {
    t.deepEqual(repeat(3, 5), [5, 5, 5]);
    t.deepEqual(repeat(3, 'a'), ['a', 'a', 'a']);
    return t.end();
  });

  test('zipCompare', function(t) {
    t.ok(!zipCompare(void 0, void 0));
    t.ok(!zipCompare(null, null));
    t.ok(!zipCompare(1, 2));
    t.ok(!zipCompare(1, 1));
    t.ok(!zipCompare([], [10]));
    t.ok(!zipCompare([], null));
    t.ok(!zipCompare(null, []));
    t.ok(zipCompare([10], [10]));
    t.ok(zipCompare([10, 20], [10, 20]));
    t.ok(!zipCompare({
      foo: 'bar'
    }, {
      foo: 'bar'
    }));
    t.ok(zipCompare([
      {
        foo: 'bar'
      }
    ], [
      {
        foo: 'bar'
      }
    ], function(a, b) {
      return a.foo === b.foo;
    }));
    return t.end();
  });

  test('same', function(t) {
    var compareBaz;
    compareBaz = function(a, b) {
      return a.baz === b.baz;
    };
    t.ok(same([]));
    t.ok(same(['bar']));
    t.ok(same(['bar', 'bar']));
    t.ok(!same(['bar', 'qux']));
    t.ok(same([
      {
        baz: 'bar'
      }, {
        baz: 'bar'
      }
    ], compareBaz));
    t.ok(!same([
      {
        baz: 'bar'
      }, {
        baz: 'qux'
      }
    ], compareBaz));
    return t.end();
  });

  test('valuesAreEqual', function(t) {
    var compareBaz, pluckFoo;
    pluckFoo = function(obj) {
      return obj.foo;
    };
    compareBaz = function(a, b) {
      return a.baz === b.baz;
    };
    t.ok(valuesAreEqual([], pluckFoo));
    t.ok(valuesAreEqual([
      {
        foo: 'bar'
      }
    ], pluckFoo));
    t.ok(valuesAreEqual([
      {
        foo: 'bar'
      }, {
        foo: 'bar'
      }
    ], pluckFoo));
    t.ok(!valuesAreEqual([
      {
        foo: 'bar'
      }, {
        foo: 'qux'
      }
    ], pluckFoo));
    t.ok(valuesAreEqual([
      {
        foo: {
          baz: 'bar'
        }
      }, {
        foo: {
          baz: 'bar'
        }
      }
    ], pluckFoo, compareBaz));
    t.ok(!valuesAreEqual([
      {
        foo: {
          baz: 'bar'
        }
      }, {
        foo: {
          baz: 'qux'
        }
      }
    ], pluckFoo, compareBaz));
    return t.end();
  });

  test('mapWithKey', function(t) {
    var mapper, obj;
    obj = {
      foo: 10,
      bar: 20,
      baz: 30
    };
    mapper = function(v, k) {
      return k + '=' + v;
    };
    t.equal((mapWithKey(obj, mapper)).join(','), 'foo=10,bar=20,baz=30');
    return t.end();
  });

}).call(this);

(function() {
  Steam.Router = function(_, routes) {
    var handler, notifyCrossroads, route;
    crossroads.routed.add(function(route, data) {
      return _.onRouteSucceeded(route);
    });
    crossroads.bypassed.add(function(route) {
      return _.onRouteFailed(route);
    });
    for (route in routes) {
      handler = routes[route];
      crossroads.addRoute(route, handler);
    }
    notifyCrossroads = function(newHash, oldHash) {
      return crossroads.parse(newHash);
    };
    hasher.initialized.add(notifyCrossroads);
    hasher.changed.add(notifyCrossroads);
    link$(_.route, hasher.setHash);
    link$(_.getRoute, hasher.getHash);
    link$(_.setRoute, function(address) {
      hasher.changed.active = false;
      hasher.setHash(address);
      return hasher.changed.active = true;
    });
    hasher.init();
  };

}).call(this);

(function() {
  Steam.Routes = function(_) {};

}).call(this);

(function() {
  Steam.ScoringListView = function(_) {
    var activateAndDisplayItem, clearPredicate, createComparisonItem, createScoringItem, createScoringJobs, deleteActiveScoring, deleteScorings, deselectAllScorings, displayItem, findActiveItem, loadScorings, _canClearPredicate, _hasItems, _isLive, _isSelectAll, _items, _predicate, _predicateCaption;
    _predicate = node$({
      type: 'all'
    });
    _items = nodes$();
    _hasItems = lift$(_items, function(items) {
      return items.length > 0;
    });
    _isSelectAll = node$(false);
    _isLive = node$(true);
    apply$(_isSelectAll, function(isSelected) {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(isSelected);
      }
      _isLive(true);
    });
    _canClearPredicate = false;
    _predicateCaption = 'Showing\nall scorings';
    displayItem = function(item) {
      if (item) {
        _.displayScoring(item);
        return _.scoringAvailable(true);
      } else {
        _.displayEmpty();
        return _.scoringAvailable(false);
      }
    };
    findActiveItem = function() {
      return find(_items(), function(item) {
        return item.isActive();
      });
    };
    activateAndDisplayItem = function(item) {
      var other, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        other = _ref[_i];
        if (other === item) {
          other.isActive(true);
        } else {
          other.isActive(false);
        }
      }
      return displayItem(item);
    };
    createScoringItem = function(scoring) {
      var self;
      self = {
        type: 'scoring',
        data: {
          input: scoring,
          output: null
        },
        title: "Scoring on " + scoring.frameKey,
        caption: "" + scoring.model.key + " (" + scoring.model.response_column_name + ")",
        timestamp: scoring.timestamp,
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false),
        isSelected: node$(false),
        state: node$('waiting'),
        isReady: node$(false),
        hasFailed: node$(false)
      };
      apply$(_isLive, self.isSelected, function(isLive, isSelected) {
        if (isLive) {
          return _.scoringSelectionChanged(isSelected, self);
        }
      });
      return self;
    };
    createComparisonItem = function(comparison) {
      var self;
      self = {
        type: 'comparison',
        data: comparison,
        title: 'Comparison',
        caption: describeCount(comparison.scorings.length, 'scoring'),
        timestamp: node$(comparison.timestamp),
        display: function() {
          return activateAndDisplayItem(self);
        },
        isActive: node$(false),
        isSelected: node$(false),
        isReady: node$(true),
        hasFailed: node$(false)
      };
      apply$(_isLive, self.isSelected, function(isLive, isSelected) {
        if (isLive) {
          return _.scoringSelectionChanged(isSelected, self);
        }
      });
      return self;
    };
    createScoringJobs = function(items) {
      return map(items, function(item) {
        var frameKey, modelKey;
        frameKey = item.data.input.frameKey;
        modelKey = item.data.input.model.key;
        return function(index, go) {
          item.state('running');
          return _.requestScoringOnFrame(frameKey, modelKey, function(error, result) {
            if (error) {
              _.error('Scoring failed', {
                frameKey: frameKey,
                modelKey: modelKey
              }, error);
              item.state('error');
              item.hasFailed(true);
              item.data.output = result;
            } else {
              item.state('success');
              item.hasFailed(false);
              item.data.output = result;
            }
            item.isReady(true);
            return go();
          });
        };
      });
    };
    loadScorings = function(predicate) {
      var item, items, jobs;
      console.assert(isDefined(predicate));
      switch (predicate.type) {
        case 'scoring':
          items = map(predicate.scorings, createScoringItem);
          _items.splice.apply(_items, [0, 0].concat(items));
          jobs = createScoringJobs(items);
          forEachAsync(jobs, function() {
            var item, _i, _len;
            for (_i = 0, _len = items.length; _i < _len; _i++) {
              item = items[_i];
              if (!item.hasFailed()) {
                item.timestamp = (head(item.data.output.metrics)).scoring_time;
              }
            }
            if (items.length > 1) {
              return _.loadScorings({
                type: 'comparison',
                scorings: items,
                timestamp: Date.now()
              });
            } else {
              return activateAndDisplayItem(head(items));
            }
          });
          break;
        case 'comparison':
          item = createComparisonItem({
            scorings: predicate.scorings,
            timestamp: predicate.timestamp
          });
          _items.unshift(item);
          activateAndDisplayItem(item);
      }
      _predicate(predicate);
    };
    link$(_.loadScorings, function(predicate) {
      if (predicate) {
        return loadScorings(predicate);
      } else {
        return displayItem(findActiveItem());
      }
    });
    deselectAllScorings = function() {
      var item, _i, _len, _ref;
      _isLive(false);
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isSelected(false);
      }
      _isLive(true);
      return _.scoringSelectionCleared();
    };
    link$(_.rescore, function() {
      var allFrames, compatibleFrames, item, model, models, scoring, _i, _len, _ref;
      scoring = findActiveItem();
      models = [];
      allFrames = [];
      switch (scoring.type) {
        case 'scoring':
          model = scoring.data.input.model;
          push(models, model);
          pushAll(allFrames, model.compatible_frames);
          break;
        case 'comparison':
          _ref = scoring.data.scorings;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            item = _ref[_i];
            model = item.data.input.model;
            push(models, model);
            pushAll(allFrames, model.compatible_frames);
          }
      }
      compatibleFrames = unique(allFrames, function(frame) {
        return frame.id;
      });
      return _.promptForFrame(compatibleFrames, function(action, frameKey) {
        switch (action) {
          case 'confirm':
            return _.switchToScoring({
              type: 'scoring',
              scorings: map(models, function(model) {
                return {
                  frameKey: frameKey,
                  model: model,
                  status: null,
                  time: null,
                  result: null,
                  timestamp: Date.now()
                };
              })
            });
        }
      });
    });
    deleteActiveScoring = function() {
      _items.remove(findActiveItem());
      return displayItem(null);
    };
    deleteScorings = function(scorings) {
      deselectAllScorings();
      _items.removeAll(scorings);
      if (!findActiveItem()) {
        return displayItem(null);
      }
    };
    clearPredicate = function() {};
    link$(_.deselectAllScorings, deselectAllScorings);
    link$(_.deleteScorings, deleteScorings);
    link$(_.deleteActiveScoring, deleteActiveScoring);
    return {
      items: _items,
      hasItems: _hasItems,
      predicateCaption: _predicateCaption,
      clearPredicate: clearPredicate,
      canClearPredicate: _canClearPredicate,
      isSelectAll: _isSelectAll,
      template: 'scoring-list-view'
    };
  };

}).call(this);

(function() {
  var defaultScoringComparisonMessage;

  defaultScoringComparisonMessage = 'Compare selected scorings.';

  Steam.ScoringSelectionView = function(_) {
    var clearSelections, compareScorings, deleteActiveScoring, deleteScorings, rescore, tryCompareScorings, _canCompareScorings, _caption, _hasScorings, _hasSelection, _scoringComparisonMessage, _selections;
    _selections = nodes$();
    _hasSelection = lift$(_selections, function(selections) {
      return selections.length > 0;
    });
    _caption = lift$(_selections, function(selections) {
      return "" + (describeCount(selections.length, 'item')) + " selected";
    });
    _scoringComparisonMessage = lift$(_selections, function(selections) {
      if (selections.length < 2) {
        return 'Select two or more scorings to compare.';
      }
      if (some(selections, function(selection) {
        return !selection.isReady();
      })) {
        return 'Remove pending scorings from your selection.';
      }
      if (some(selections, function(selection) {
        return selection.hasFailed();
      })) {
        return 'Remove failed scorings from your selection.';
      }
      if (some(selections, function(selection) {
        return selection.type === 'comparison';
      })) {
        return 'Remove comparison tables from your selection.';
      }
      if (!valuesAreEqual(selections, function(selection) {
        return selection.data.input.frameKey;
      })) {
        return 'Ensure that all selected scorings refer to conforming datasets.';
      }
      if (!valuesAreEqual(selections, function(selection) {
        return selection.data.input.model.model_category;
      })) {
        return 'Ensure that all selected scorings belong to the same model category.';
      }
      if (!valuesAreEqual(selections, function(selection) {
        return selection.data.input.model.response_column_name;
      })) {
        return 'Ensure that all selected scorings refer to the same response column.';
      }
      return defaultScoringComparisonMessage;
    });
    _canCompareScorings = lift$(_scoringComparisonMessage, function(message) {
      return message === defaultScoringComparisonMessage;
    });
    _hasScorings = node$(false);
    compareScorings = function() {
      _.loadScorings({
        type: 'comparison',
        scorings: clone(_selections()),
        timestamp: Date.now()
      });
      return _.deselectAllScorings();
    };
    tryCompareScorings = function(hover) {
      return _.status(hover ? _scoringComparisonMessage() : null);
    };
    deleteActiveScoring = function() {
      var confirmDialogOpts;
      confirmDialogOpts = {
        title: 'Delete Scoring?',
        confirmCaption: 'Delete',
        cancelCaption: 'Keep'
      };
      return _.confirm('This scoring will be permanently deleted. Are you sure?', confirmDialogOpts, function(response) {
        if (response === 'confirm') {
          return _.deleteActiveScoring();
        }
      });
    };
    deleteScorings = function() {
      var confirmDialogOpts;
      confirmDialogOpts = {
        title: 'Delete Scorings?',
        confirmCaption: 'Delete',
        cancelCaption: 'Keep'
      };
      return _.confirm('These scorings will be permanently deleted. Are you sure?', confirmDialogOpts, function(response) {
        if (response === 'confirm') {
          return _.deleteScorings(clone(_selections()));
        }
      });
    };
    clearSelections = function() {
      return _.deselectAllScorings();
    };
    rescore = function() {
      return _.rescore();
    };
    link$(_.scoringSelectionChanged, function(isSelected, scoring) {
      if (isSelected) {
        return _selections.push(scoring);
      } else {
        return _selections.remove(scoring);
      }
    });
    link$(_.scoringSelectionCleared, function() {
      return _selections.removeAll();
    });
    link$(_.scoringAvailable, _hasScorings);
    return {
      caption: _caption,
      hasSelection: _hasSelection,
      clearSelections: clearSelections,
      canCompareScorings: _canCompareScorings,
      tryCompareScorings: tryCompareScorings,
      rescore: rescore,
      compareScorings: compareScorings,
      hasScorings: _hasScorings,
      deleteScorings: deleteScorings,
      deleteActiveScoring: deleteActiveScoring,
      template: 'scoring-selection-view'
    };
  };

}).call(this);

(function() {
  var computeExtents, computeFPR, computeTPR, createMetricFrameFromScorings, format4f, importMetricData, importThresholdData, metricCriteria, metricTypes, metricVariables, thresholdVariables;

  format4f = typeof exports === "undefined" || exports === null ? d3.format('.4f') : null;

  metricCriteria = [
    {
      key: 'maximum F1',
      caption: 'Max F1'
    }, {
      key: 'maximum F2',
      caption: 'Max F2'
    }, {
      key: 'maximum F0point5',
      caption: 'Max F0.5'
    }, {
      key: 'maximum Accuracy',
      caption: 'Max Accuracy'
    }, {
      key: 'maximum Precision',
      caption: 'Max Precision'
    }, {
      key: 'maximum Recall',
      caption: 'Max Recall'
    }, {
      key: 'maximum Specificity',
      caption: 'Max Specificity'
    }, {
      key: 'maximum absolute MCC',
      caption: 'Max Absolute MCC'
    }, {
      key: 'minimizing max per class Error',
      caption: 'Min MPCE'
    }
  ];

  metricTypes = [
    {
      key: 'threshold_for_criteria',
      caption: 'Threshold',
      domain: [0, 1]
    }, {
      key: 'error_for_criteria',
      caption: 'Error',
      domain: [0, 1]
    }, {
      key: 'F0point5_for_criteria',
      caption: 'F0.5',
      domain: [0, 1]
    }, {
      key: 'F1_for_criteria',
      caption: 'F1',
      domain: [0, 1]
    }, {
      key: 'F2_for_criteria',
      caption: 'F2',
      domain: [0, 1]
    }, {
      key: 'accuracy_for_criteria',
      caption: 'Accuracy',
      domain: [0, 1]
    }, {
      key: 'precision_for_criteria',
      caption: 'Precision',
      domain: [0, 1]
    }, {
      key: 'recall_for_criteria',
      caption: 'Recall',
      domain: [0, 1]
    }, {
      key: 'specificity_for_criteria',
      caption: 'Specificity',
      domain: [0, 1]
    }, {
      key: 'mcc_for_criteria',
      caption: 'MCC',
      domain: [-1, 1]
    }, {
      key: 'max_per_class_error_for_criteria',
      caption: 'MPCE',
      domain: [0, 1]
    }
  ];

  metricVariables = [];

  metricVariables.push({
    id: uniqueId(),
    name: 'auc',
    caption: 'AUC',
    type: 'float',
    read: function(metrics) {
      return +metrics.auc.AUC;
    },
    domain: [0, 1],
    format: format4f
  });

  metricVariables.push({
    id: uniqueId(),
    name: 'gini',
    caption: 'Gini',
    type: 'float',
    read: function(metrics) {
      return +metrics.auc.Gini;
    },
    domain: [0, 1],
    format: format4f
  });

  forEach(metricCriteria, function(criterion, criterionIndex) {
    return forEach(metricTypes, function(metricType) {
      return metricVariables.push({
        id: uniqueId(),
        name: "" + criterion.key + "-" + metricType.key,
        caption: "" + criterion.caption + " " + metricType.caption,
        type: 'float',
        read: function(metrics) {
          return +metrics.auc[metricType.key][criterionIndex];
        },
        domain: [0, 1],
        format: format4f
      });
    });
  });

  computeTPR = function(cm) {
    var fn, fp, tn, tp, _ref, _ref1;
    (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
    return tp / (tp + fn);
  };

  computeFPR = function(cm) {
    var fn, fp, tn, tp, _ref, _ref1;
    (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
    return fp / (fp + tn);
  };

  thresholdVariables = [
    {
      name: 'threshold',
      caption: 'Threshold',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.thresholds[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'error',
      caption: 'Error',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.errorr[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'f0.5',
      caption: 'F0.5',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.F0point5[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'f1',
      caption: 'F1',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.F1[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'f2',
      caption: 'F2',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.F2[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'accuracy',
      caption: 'Accuracy',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.accuracy[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'precision',
      caption: 'Precision',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.precision[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'recall',
      caption: 'Recall',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.recall[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'specificity',
      caption: 'Specificity',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.specificity[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'mcc',
      caption: 'MCC',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.mcc[index];
      },
      domain: [-1, 1],
      format: format4f
    }, {
      name: 'mpce',
      caption: 'MPCE',
      type: 'float',
      read: function(metrics, index) {
        return +metrics.auc.max_per_class_error[index];
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'cm',
      caption: 'Confusion Matrix',
      type: 'blob',
      read: function(metrics, index) {
        return metrics.auc.confusion_matrices[index];
      },
      domain: null,
      format: function() {}
    }, {
      name: 'tpr',
      caption: 'TPR',
      type: 'float',
      read: function(metrics, index) {
        return computeTPR(metrics.auc.confusion_matrices[index]);
      },
      domain: [0, 1],
      format: format4f
    }, {
      name: 'fpr',
      caption: 'FPR',
      type: 'float',
      read: function(metrics, index) {
        return computeFPR(metrics.auc.confusion_matrices[index]);
      },
      domain: [0, 1],
      format: format4f
    }
  ];

  importMetricData = function(metrics, variables) {
    var datum;
    datum = {};
    forEach(variables, function(variable) {
      return datum[variable.name] = variable.read(metrics);
    });
    return datum;
  };

  importThresholdData = function(metrics, variables, count) {
    return times(count, function(index) {
      var datum;
      datum = {};
      forEach(thresholdVariables, function(variable) {
        return datum[variable.name] = variable.read(metrics, index);
      });
      return datum;
    });
  };

  computeExtents = function(variables, data) {
    return map(variables, function(variable) {
      return d3.extent(data, function(datum) {
        return datum[variable.name];
      });
    });
  };

  createMetricFrameFromScorings = function(scores) {
    var colorScale, createUniqueScoringName, metrics, modelVariables, palette, uniqueScoringNames;
    uniqueScoringNames = {};
    createUniqueScoringName = function(frameKey, modelKey) {
      var index, name;
      name = "" + modelKey + " on " + frameKey;
      if (index = uniqueScoringNames[name]) {
        uniqueScoringNames[name] = index++;
        name += ' #' + index;
      } else {
        uniqueScoringNames[name] = 1;
      }
      return name;
    };
    palette = scores.length > 10 ? d3.scale.category20 : d3.scale.category10;
    colorScale = palette().domain(d3.range(scores.length));
    metrics = map(scores, function(score, index) {
      var metricData, model, thresholdData;
      model = score.data.input.model;
      metrics = head(score.data.output.metrics);
      metricData = importMetricData(metrics, metricVariables);
      thresholdData = importThresholdData(metrics, thresholdVariables, metrics.auc.thresholds.length);
      return {
        name: index,
        caption: createUniqueScoringName(metrics.frame.key, metrics.model.key),
        model: model,
        data: metricData,
        thresholdFrame: {
          data: thresholdData,
          metadata: {
            extents: computeExtents(thresholdVariables, thresholdData)
          }
        },
        color: colorScale(index)
      };
    });
    modelVariables = null;
    return {
      metrics: metrics,
      modelVariables: modelVariables,
      metricVariables: metricVariables,
      thresholdVariables: thresholdVariables
    };
  };

  Steam.ScoringSheetView = function(_, _scorings) {
    var createMetricTable, initialize, _metricFrame, _metricTable;
    _metricFrame = null;
    _metricTable = node$(null);
    initialize = function(scorings) {
      console.log('scorings', scorings);
      _metricFrame = createMetricFrameFromScorings(scorings);
      return _metricTable(createMetricTable(_metricFrame, 'auc', false));
    };
    createMetricTable = function(metricFrame, sortByVariableName, sortAscending) {
      var behavior, header, markup, rows, span, table, tbody, td, th, thead, tr, _ref;
      _ref = geyser.generate(words('table.table.table-condensed thead tbody tr th td')), table = _ref[0], thead = _ref[1], tbody = _ref[2], tr = _ref[3], th = _ref[4], td = _ref[5];
      span = geyser.generate(["a data-variable-id='$id'"])[0];
      metricFrame.metrics.sort(function(a, b) {
        if (sortAscending) {
          return a.data[sortByVariableName] - b.data[sortByVariableName];
        } else {
          return b.data[sortByVariableName] - a.data[sortByVariableName];
        }
      });
      header = tr(map(metricFrame.metricVariables, function(variable) {
        return th(span(variable.caption, {
          $id: variable.id
        }));
      }));
      rows = map(metricFrame.metrics, function(metric) {
        return tr(map(metricFrame.metricVariables, function(variable) {
          return td(variable.format(metric.data[variable.name]));
        }));
      });
      markup = table([thead(header), tbody(rows)]);
      behavior = function($element) {
        return $('a', $element).each(function() {
          var $anchor;
          $anchor = $(this);
          return $anchor.click(function() {
            var sortById, sortByVariable;
            sortById = $anchor.attr('data-variable-id');
            sortByVariable = find(metricFrame.metricVariables, function(variable) {
              return variable.id === sortById;
            });
            sortByVariableName = sortByVariable.name;
            return _metricTable(createMetricTable(metricFrame, sortByVariableName, false));
          });
        });
      };
      return {
        markup: markup,
        behavior: behavior
      };
    };
    initialize(_scorings);
    return {
      metricTable: _metricTable
    };
  };

}).call(this);

(function() {
  var aucCategories, aucCategoryMap, aucCriteria, aucCriteriaMap, aucOutputMap, aucOutputs, aucVariableMap, aucVariables, createRocMarkInspection, createScoringInspection, createStripPlotRowInspection, createStripPlotValueInspection, createThresholdPlotInspection, format4f;

  if (typeof exports === "undefined" || exports === null) {
    format4f = d3.format('.4f');
  }

  aucCriteria = [
    {
      key: 'maximum F1',
      caption: 'Max F1'
    }, {
      key: 'maximum F2',
      caption: 'Max F2'
    }, {
      key: 'maximum F0point5',
      caption: 'Max F0.5'
    }, {
      key: 'maximum Accuracy',
      caption: 'Max Accuracy'
    }, {
      key: 'maximum Precision',
      caption: 'Max Precision'
    }, {
      key: 'maximum Recall',
      caption: 'Max Recall'
    }, {
      key: 'maximum Specificity',
      caption: 'Max Specificity'
    }, {
      key: 'maximum absolute MCC',
      caption: 'Max Absolute MCC'
    }, {
      key: 'minimizing max per class Error',
      caption: 'Min MPCE'
    }
  ];

  aucOutputs = [
    {
      key: 'threshold_for_criteria',
      caption: 'Threshold',
      domain: [0, 1]
    }, {
      key: 'error_for_criteria',
      caption: 'Error',
      domain: [0, 1]
    }, {
      key: 'F0point5_for_criteria',
      caption: 'F0.5',
      domain: [0, 1]
    }, {
      key: 'F1_for_criteria',
      caption: 'F1',
      domain: [0, 1]
    }, {
      key: 'F2_for_criteria',
      caption: 'F2',
      domain: [0, 1]
    }, {
      key: 'accuracy_for_criteria',
      caption: 'Accuracy',
      domain: [0, 1]
    }, {
      key: 'precision_for_criteria',
      caption: 'Precision',
      domain: [0, 1]
    }, {
      key: 'recall_for_criteria',
      caption: 'Recall',
      domain: [0, 1]
    }, {
      key: 'specificity_for_criteria',
      caption: 'Specificity',
      domain: [0, 1]
    }, {
      key: 'mcc_for_criteria',
      caption: 'MCC',
      domain: [-1, 1]
    }, {
      key: 'max_per_class_error_for_criteria',
      caption: 'MPCE',
      domain: [0, 1]
    }
  ];

  aucCategories = (function() {
    var categories, criterion, criterionIndex, output, _i, _j, _len, _len1;
    categories = [
      {
        index: 0,
        key: 'AUC',
        caption: 'AUC',
        domain: [0, 1],
        isGrouped: false
      }, {
        index: 0,
        key: 'Gini',
        caption: 'Gini',
        domain: [0, 1],
        isGrouped: false
      }
    ];
    for (criterionIndex = _i = 0, _len = aucCriteria.length; _i < _len; criterionIndex = ++_i) {
      criterion = aucCriteria[criterionIndex];
      for (_j = 0, _len1 = aucOutputs.length; _j < _len1; _j++) {
        output = aucOutputs[_j];
        categories.push({
          index: 0,
          key: "" + criterion.caption + "\0" + output.caption,
          caption: "" + criterion.caption + " - " + output.caption,
          domain: output.domain,
          isGrouped: true,
          criterion: criterion,
          output: output,
          criterionIndex: criterionIndex
        });
      }
    }
    return map(categories, function(category, index) {
      category.index = index;
      return category;
    });
  })();

  aucVariables = [['Threshold', [0, 1]], ['Error', [0, 1]], ['F0.5', [0, 1]], ['F1', [0, 1]], ['F2', [0, 1]], ['Accuracy', [0, 1]], ['Precision', [0, 1]], ['Recall', [0, 1]], ['Specificity', [0, 1]], ['MCC', [-1, 1]], ['MPCE', [0, 1]], ['TPR', [0, 1]], ['FPR', [0, 1]]].map(function(attr) {
    var domain, key;
    key = attr[0], domain = attr[1];
    return {
      key: key,
      caption: key,
      domain: domain
    };
  });

  aucCriteriaMap = indexBy(aucCriteria, function(criterion) {
    return criterion.key;
  });

  aucOutputMap = indexBy(aucOutputs, function(output) {
    return output.key;
  });

  aucCategoryMap = indexBy(aucCategories, function(cateogory) {
    return cateogory.key;
  });

  aucVariableMap = indexBy(aucVariables, function(variable) {
    return variable.key;
  });

  createThresholdPlotInspection = function(series, mark) {
    var div, formatConfusionMatrix, grid, h1, h2, table, tabulateProperties, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed table.table.table-bordered tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], grid = _ref[4], tbody = _ref[5], tr = _ref[6], th = _ref[7], td = _ref[8];
    formatConfusionMatrix = function(domain, cm) {
      var d1, d2, fn, fp, tn, tp, _ref1, _ref2;
      d1 = domain[0], d2 = domain[1];
      (_ref1 = cm[0], tn = _ref1[0], fp = _ref1[1]), (_ref2 = cm[1], fn = _ref2[0], tp = _ref2[1]);
      return grid([tr([th(''), th(d1), th(d2)]), tr([th(d1), td(tn), td(fp)]), tr([th(d2), td(fn), td(tp)])]);
    };
    tabulateProperties = function(mark) {
      return table(tbody(map(aucVariables, function(variable) {
        var term, value;
        term = property[0], value = property[1];
        return tr([th(variable.caption), td(format4f(mark[variable.key]))]);
      })));
    };
    return div([h1(series.caption), h2('Outputs'), tabulateProperties(mark), h2('Confusion Matrix'), formatConfusionMatrix(series.metrics.auc.actual_domain, mark['Confusion Matrix'])]);
  };

  createRocMarkInspection = function(metrics, mark) {
    var auc, collectProperties, div, formatConfusionMatrix, grid, h1, h2, table, tabulateProperties, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed table.table.table-bordered tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], grid = _ref[4], tbody = _ref[5], tr = _ref[6], th = _ref[7], td = _ref[8];
    formatConfusionMatrix = function(domain, cm) {
      var d1, d2, fn, fp, tn, tp, _ref1, _ref2;
      d1 = domain[0], d2 = domain[1];
      (_ref1 = cm[0], tn = _ref1[0], fp = _ref1[1]), (_ref2 = cm[1], fn = _ref2[0], tp = _ref2[1]);
      return grid([tr([th(''), th(d1), th(d2)]), tr([th(d1), td(tn), td(fp)]), tr([th(d2), td(fn), td(tp)])]);
    };
    collectProperties = function(auc, index) {
      return [['Threshold', format4f(auc.thresholds[index])], ['Error', format4f(auc.errorr[index])], ['F0.5', format4f(auc.F0point5[index])], ['F1', format4f(auc.F1[index])], ['F2', format4f(auc.F2[index])], ['Accuracy', format4f(auc.accuracy[index])], ['Precision', format4f(auc.precision[index])], ['Recall', format4f(auc.recall[index])], ['Specificity', format4f(auc.specificity[index])], ['MCC', format4f(auc.mcc[index])], ['MPCE', format4f(auc.max_per_class_error[index])], ['False Positive Rate', format4f(mark.fpr)], ['True Positive Rate', format4f(mark.tpr)]];
    };
    tabulateProperties = function(auc, index) {
      var properties;
      properties = collectProperties(auc, index);
      return table(tbody(map(properties, function(property) {
        var term, value;
        term = property[0], value = property[1];
        return tr([th(term), td(value)]);
      })));
    };
    auc = metrics.metrics.auc;
    return div([h1(metrics.caption), h2('Outputs'), tabulateProperties(auc, mark.index), h2('Confusion Matrix'), formatConfusionMatrix(auc.actual_domain, auc.confusion_matrices[mark.index])]);
  };

  createStripPlotRowInspection = function(series, category) {
    var div, h1, rows, sortedRows, table, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 table.table.table-condensed tbody tr th td')), div = _ref[0], h1 = _ref[1], table = _ref[2], tbody = _ref[3], tr = _ref[4], th = _ref[5], td = _ref[6];
    rows = map(series, function(series) {
      return {
        caption: series.caption,
        value: series.outputs[category.key]
      };
    });
    sortedRows = sortBy(rows, function(row) {
      return -row.value;
    });
    return div([
      h1(category.caption), table(tbody(map(sortedRows, function(row) {
        return tr([th(row.caption), td(isNaN(row.value) ? 'NaN' : format4f(row.value))]);
      })))
    ]);
  };

  createStripPlotValueInspection = function(series) {
    var div, h1, h2, table, tbody, td, th, tr, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], tbody = _ref[4], tr = _ref[5], th = _ref[6], td = _ref[7];
    return div([
      h1(series.caption), table(tbody(map(aucCategories, function(category) {
        var value;
        value = series.outputs[category.key];
        return tr([th(category.caption), td(isNaN(value) ? 'NaN' : format4f(value))]);
      })))
    ]);
  };

  createScoringInspection = function(series) {
    var createStripPlotMarkInspectionTable, div, groupedCategories, groupedCategoriesByOutput, h1, h2, table, tbody, td, th, tr, ungroupedCategories, _ref;
    _ref = geyser.generate(words('div h1 h2 table.table.table-condensed tbody tr th td')), div = _ref[0], h1 = _ref[1], h2 = _ref[2], table = _ref[3], tbody = _ref[4], tr = _ref[5], th = _ref[6], td = _ref[7];
    createStripPlotMarkInspectionTable = function(series, categories) {
      return table(tbody(map(categories, function(category) {
        var value;
        value = series.outputs[category.key];
        return tr([th(category.isGrouped ? category.criterion.caption : category.caption), td(isNaN(value) ? 'NaN' : format4f(value))]);
      })));
    };
    ungroupedCategories = filter(aucCategories, function(category) {
      return !category.isGrouped;
    });
    groupedCategories = filter(aucCategories, function(category) {
      return category.isGrouped;
    });
    groupedCategoriesByOutput = groupBy(groupedCategories, function(category) {
      return category.output.caption;
    });
    return div([
      h1(series.caption), h2('Outputs'), createStripPlotMarkInspectionTable(series, ungroupedCategories), div(mapWithKey(groupedCategoriesByOutput, function(categories, caption) {
        return div([h2(caption), createStripPlotMarkInspectionTable(series, categories)]);
      }))
    ]);
  };

  Steam.ScoringView = function(_, _scoring) {
    var buildAucCategories, collateInputParameters, combineInputParameters, compareInputParameters, computeTPRandFPR, computeTPRandFPR2, configureStripPlot, createComparisonTable, createInputAndOutputVariables, createInputParameterAndValue, createInputParameterForDisplay, createMarkForScoringMetrics, createMarksForThresholdMetrics, createMetricsPlot, createModelSummary, createRocCurve, createScoringList, createSeriesFromMetrics, createStripPlot, createStripPlotParameters2, createStripPlotParameters3, createThresholdPlot, generateComparison, initialize, markAsDifferent, renderMetricsPlot, renderRocCurve, renderStripPlot, renderThresholdPlot, switchToAdvancedView, switchToSheetView, switchToTabularView, _caption, _categories, _comparisonMode, _comparisonPlot, _comparisonTable, _failure, _hasFailed, _inputOutputCategories, _inputOutputPlot, _inputOutputPlotX, _inputOutputPlotY, _isAdvancedComparisonView, _isComparisonView, _isScoringView, _isSheetView, _isTabularComparisonView, _modelSummary, _multiRocPlot, _scoringList, _scoringType, _selectedCategory, _sheetView, _stripPlot, _stripPlotParameters, _tag, _thresholdPlot, _thresholdPlotVariables, _thresholdPlotX, _thresholdPlotY, _timestamp;
    _tag = node$('');
    _caption = node$('');
    _timestamp = node$(Date.now());
    _comparisonTable = node$(null);
    _scoringList = node$(null);
    _categories = node$(null);
    _selectedCategory = node$(aucCategoryMap.AUC);
    _comparisonPlot = node$(null);
    _inputOutputCategories = node$(null);
    _inputOutputPlotX = node$(null);
    _inputOutputPlotY = node$(null);
    _inputOutputPlot = node$(null);
    _multiRocPlot = node$(null);
    _thresholdPlotVariables = sortBy(aucVariables, function(variable) {
      return variable.caption;
    });
    _thresholdPlotX = node$(aucVariableMap.Threshold);
    _thresholdPlotY = node$(aucVariableMap.Error);
    _thresholdPlot = node$(null);
    _stripPlot = node$(null);
    _stripPlotParameters = {
      group1: node$(null),
      group2: node$(null),
      group3: node$(null)
    };
    _modelSummary = nodes$([]);
    _hasFailed = node$(false);
    _failure = node$(null);
    _scoringType = node$(null);
    _isScoringView = lift$(_scoringType, function(type) {
      return type === 'scoring';
    });
    _isComparisonView = lift$(_scoringType, function(type) {
      return type === 'comparison';
    });
    _comparisonMode = node$('tabular');
    _isTabularComparisonView = lift$(_comparisonMode, function(mode) {
      return mode === 'tabular';
    });
    _isAdvancedComparisonView = lift$(_comparisonMode, function(mode) {
      return mode === 'advanced';
    });
    _isSheetView = lift$(_comparisonMode, function(mode) {
      return mode === 'sheet';
    });
    switchToTabularView = function() {
      return _comparisonMode('tabular');
    };
    switchToAdvancedView = function() {
      return _comparisonMode('advanced');
    };
    switchToSheetView = function() {
      return _comparisonMode('sheet');
    };
    _sheetView = node$(null);
    createModelSummary = function(model) {
      return [
        {
          key: 'Model Category',
          value: model.model_category
        }, {
          key: 'Response Column',
          value: model.response_column_name
        }
      ];
    };
    initialize = function(item) {
      var comparison, input, scoring, scorings;
      switch (item.type) {
        case 'scoring':
          scoring = item;
          input = scoring.data.input;
          _tag('Scoring');
          _caption("Scoring on " + input.frameKey);
          _modelSummary(createModelSummary(input.model));
          apply$(scoring.isReady, scoring.hasFailed, function(isReady, hasFailed) {
            if (isReady) {
              if (hasFailed) {
                _hasFailed(true);
                return _failure(scoring.data.output);
              } else {
                _timestamp((head(scoring.data.output.metrics)).scoring_time);
                return _comparisonTable(createComparisonTable([scoring]));
              }
            }
          });
          break;
        case 'comparison':
          comparison = item;
          _tag('Comparison');
          _caption("Scoring Comparison");
          _timestamp(comparison.data.timestamp);
          _modelSummary(null);
          scorings = comparison.data.scorings;
          apply$(_comparisonMode, function(mode) {
            var areModelsComparable, defaultInputVariable, defaultOutputVariable, inputAndOutputVariables, inputParameterKeys, inputParameters, series, _ref, _ref1, _ref2;
            switch (mode) {
              case 'tabular':
                if (scorings.length > 0) {
                  return _comparisonTable(createComparisonTable(scorings));
                } else {
                  return _comparisonTable(null);
                }
                break;
              case 'advanced':
                if (scorings.length > 0) {
                  series = createSeriesFromMetrics(scorings);
                  areModelsComparable = same(series, function(a, b) {
                    return a.model.model_category === b.model.model_category && a.model.model_algorithm === b.model.model_algorithm;
                  });
                  if (areModelsComparable) {
                    _ref = collateInputParameters(series), inputParameterKeys = _ref[0], inputParameters = _ref[1];
                    _ref1 = createInputAndOutputVariables(inputParameterKeys, inputParameters, aucCategories), inputAndOutputVariables = _ref1[0], defaultInputVariable = _ref1[1], defaultOutputVariable = _ref1[2];
                  } else {
                    _ref2 = createInputAndOutputVariables([], [], aucCategories), inputAndOutputVariables = _ref2[0], defaultInputVariable = _ref2[1], defaultOutputVariable = _ref2[2];
                  }
                  _inputOutputPlotX(defaultInputVariable);
                  _inputOutputPlotY(defaultOutputVariable);
                  _inputOutputCategories(inputAndOutputVariables);
                  apply$(_inputOutputPlotX, _inputOutputPlotY, function(x, y) {
                    return _inputOutputPlot(createMetricsPlot(series, x, y));
                  });
                  _scoringList(createScoringList(series));
                  _categories(aucCategories);
                  apply$(_selectedCategory, function(category) {
                    return _comparisonPlot(generateComparison(category, series));
                  });
                  _multiRocPlot(createThresholdPlot(series, 'FPR', 'TPR', true));
                  apply$(_thresholdPlotX, _thresholdPlotY, function(x, y) {
                    return _thresholdPlot(createThresholdPlot(series, x.key, y.key, false));
                  });
                  _stripPlotParameters.group1([]);
                  _stripPlotParameters.group2(map(aucCriteria, createStripPlotParameters2));
                  _stripPlotParameters.group3(map(aucOutputs, createStripPlotParameters3));
                  return _stripPlot(createStripPlot(series, aucCategories));
                } else {
                  _scoringList(null);
                  _comparisonPlot(null);
                  _multiRocPlot(null);
                  _thresholdPlot(null);
                  return _stripPlot(null);
                }
                break;
              case 'sheet':
                return _sheetView(Steam.ScoringSheetView(_, scorings));
            }
          });
      }
      return _scoringType(item.type);
    };
    createStripPlotParameters2 = function(criterion) {
      return {
        id: "y-" + (uniqueId()),
        caption: criterion.caption,
        criterion: criterion,
        isSelected: node$(false)
      };
    };
    createStripPlotParameters3 = function(output) {
      var isSelected;
      isSelected = node$(false);
      return {
        id: "y-" + (uniqueId()),
        caption: output.caption,
        output: output,
        isSelected: node$(false)
      };
    };
    renderRocCurve = function(data) {
      var axisX, axisY, el, height, line, margin, svg, width, x, y;
      margin = {
        top: 20,
        right: 20,
        bottom: 20,
        left: 30
      };
      width = 175;
      height = 175;
      x = d3.scale.linear().domain([0, 1]).range([0, width]);
      y = d3.scale.linear().domain([0, 1]).range([height, 0]);
      axisX = d3.svg.axis().scale(x).orient('bottom').ticks(5);
      axisY = d3.svg.axis().scale(y).orient('left').ticks(5);
      line = d3.svg.line().x(function(d) {
        return x(d.fpr);
      }).y(function(d) {
        return y(d.tpr);
      });
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-roc-curve').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text('FPR');
      svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text('TPR');
      svg.append('line').attr('class', 'guide').attr('stroke-dasharray', '3,3').attr({
        x1: x(0),
        y1: y(0),
        x2: x(1),
        y2: y(1)
      });
      svg.selectAll('.dot').data(data).enter().append('circle').attr('class', 'dot').attr('r', 1).attr('cx', function(d) {
        return x(d.fpr);
      }).attr('cy', function(d) {
        return y(d.tpr);
      });
      svg.append('path').datum(data).attr('class', 'line').attr('d', line);
      return el;
    };
    computeTPRandFPR2 = function(cm, index) {
      var fn, fp, tn, tp, _ref, _ref1;
      (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
      return [tp / (tp + fn), fp / (fp + tn)];
    };
    computeTPRandFPR = function(cm, index) {
      var fn, fp, tn, tp, _ref, _ref1;
      (_ref = cm[0], tn = _ref[0], fp = _ref[1]), (_ref1 = cm[1], fn = _ref1[0], tp = _ref1[1]);
      return {
        cm: cm,
        index: index,
        tpr: tp / (tp + fn),
        fpr: fp / (fp + tn)
      };
    };
    createRocCurve = function(cms) {
      var rates;
      rates = map(cms, computeTPRandFPR);
      return renderRocCurve(rates);
    };
    createInputParameterForDisplay = function(key, value, isVisible) {
      var scalarValue;
      scalarValue = isArray(value) ? value.join(', ') : value;
      return {
        key: key,
        value: scalarValue,
        isVisible: isVisible,
        isDifferent: false
      };
    };
    createInputParameterAndValue = function(value, key) {
      var scalarValue;
      scalarValue = isArray(value) ? value.join(', ') : value;
      return {
        key: key,
        value: scalarValue,
        isNumber: isNumber(value)
      };
    };
    createInputAndOutputVariables = function(inputKeys, inputParameters, aucVariables) {
      var allVariables, defaultInputVariable, defaultOutputVariable, inputVariables, outputVariables;
      inputVariables = map(inputKeys, function(inputKey) {
        var values;
        values = map(inputParameters, function(parameter) {
          return parameter[inputKey];
        });
        return {
          type: 'input',
          key: inputKey,
          caption: "Input: " + inputKey,
          domain: d3.extent(values)
        };
      });
      outputVariables = map(aucVariables, function(variable) {
        return {
          type: 'output',
          key: variable.key,
          caption: "Output: " + variable.caption,
          variable: variable
        };
      });
      allVariables = sortBy(flatten([inputVariables, outputVariables]), function(variable) {
        return variable.caption;
      });
      defaultInputVariable = inputVariables.length > 0 ? head(inputVariables) : outputVariables[1];
      defaultOutputVariable = head(outputVariables);
      return [allVariables, defaultInputVariable, defaultOutputVariable];
    };
    collateInputParameters = function(series) {
      var i, inputParameters, key, models, numericParametersByModel, parameter, parameters, parametersByKey, parametersByModel, plottableParameterKeys, _i, _j, _len, _len1, _ref;
      models = map(series, function(series) {
        return series.model;
      });
      parametersByModel = map(models, function(model) {
        return flatten([mapWithKey(model.critical_parameters, createInputParameterAndValue), mapWithKey(model.secondary_parameters, createInputParameterAndValue), mapWithKey(model.expert_parameters, createInputParameterAndValue)]);
      });
      numericParametersByModel = map(parametersByModel, function(parameters) {
        return filter(parameters, function(parameter) {
          return parameter.isNumber;
        });
      });
      parametersByKey = groupBy(flatten(numericParametersByModel), function(parameter) {
        return parameter.key;
      });
      plottableParameterKeys = [];
      for (key in parametersByKey) {
        parameters = parametersByKey[key];
        if (parameters.length === models.length) {
          plottableParameterKeys.push(key);
        }
      }
      inputParameters = times(models.length, function() {
        return {};
      });
      for (_i = 0, _len = plottableParameterKeys.length; _i < _len; _i++) {
        key = plottableParameterKeys[_i];
        _ref = parametersByKey[key];
        for (i = _j = 0, _len1 = _ref.length; _j < _len1; i = ++_j) {
          parameter = _ref[i];
          inputParameters[i][key] = parameter.value;
        }
      }
      forEach(series, function(series, i) {
        return series.inputs = inputParameters[i];
      });
      return [plottableParameterKeys, inputParameters];
    };
    combineInputParameters = function(model) {
      var critical, secondary;
      critical = mapWithKey(model.critical_parameters, function(value, key) {
        return createInputParameterForDisplay(key, value, true);
      });
      secondary = mapWithKey(model.secondary_parameters, function(value, key) {
        return createInputParameterForDisplay(key, value, false);
      });
      return concat(critical, secondary);
    };
    markAsDifferent = function(parametersArray, index) {
      var parameter, parameters, _i, _len;
      for (_i = 0, _len = parametersArray.length; _i < _len; _i++) {
        parameters = parametersArray[_i];
        parameter = parameters[index];
        parameter.isDifferent = true;
        parameter.isVisible = true;
      }
    };
    compareInputParameters = function(parametersArray) {
      var headParameters, index, parameters, tailParameters, tailParametersArray, _i, _j, _len, _len1;
      headParameters = head(parametersArray);
      tailParametersArray = tail(parametersArray);
      for (index = _i = 0, _len = headParameters.length; _i < _len; index = ++_i) {
        parameters = headParameters[index];
        for (_j = 0, _len1 = tailParametersArray.length; _j < _len1; _j++) {
          tailParameters = tailParametersArray[_j];
          if (parameters.value !== tailParameters[index].value) {
            markAsDifferent(parametersArray, index);
            break;
          }
        }
      }
    };
    renderStripPlot = function(series, categories) {
      var axis, el, g, height, line, margin, path, rowHeight, scaleX, scaleY, svg, width, x;
      margin = {
        top: 20,
        right: 70,
        bottom: 20,
        left: 140
      };
      width = 140;
      rowHeight = 18;
      height = categories.length * rowHeight;
      scaleX = zipObject(map(categories, function(category) {
        scaleX = d3.scale.linear().domain(category.domain).range([0, width]);
        return [category.key, scaleX];
      }));
      scaleY = d3.scale.ordinal().domain(map(categories, function(category) {
        return category.key;
      })).rangePoints([0, height], 1);
      line = d3.svg.line();
      axis = d3.svg.axis().orient('left');
      x = function(value) {
        if (isNaN(value)) {
          return 0;
        } else {
          return value;
        }
      };
      path = function(d) {
        return line(map(categories, function(category) {
          var key;
          key = category.key;
          return [scaleX[key](x(d.outputs[key])), scaleY(key)];
        }));
      };
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-strip-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      line = svg.append('g').attr('class', 'line').selectAll('path').data(series).enter().append('path').attr('d', path).attr('id', function(d) {
        return "strip-plot-" + d.id + "-path";
      });
      forEach(series, function(series) {
        return svg.append('g').attr('id', "strips-" + series.id).selectAll('.strip').data(categories).enter().append('line').attr('class', 'strip').attr('x1', function(d) {
          return scaleX[d.key](x(series.outputs[d.key]));
        }).attr('y1', function(d) {
          return -5 + scaleY(d.key);
        }).attr('x2', function(d) {
          return scaleX[d.key](x(series.outputs[d.key]));
        }).attr('y2', function(d) {
          return 5 + scaleY(d.key);
        }).attr('stroke', series.color).on('mouseover', function(d) {
          svg.select("#strip-plot-" + series.id + "-path").style('stroke', '#ddd');
          return svg.select("#strip-plot-" + series.id + "-labels").style('display', 'block');
        }).on('mouseout', function(d) {
          svg.select("#strip-plot-" + series.id + "-path").style('stroke', 'none');
          return svg.select("#strip-plot-" + series.id + "-labels").style('display', 'none');
        }).on('click', function(d) {
          return _.inspect({
            content: createStripPlotValueInspection(series),
            template: 'geyser'
          });
        });
      });
      g = svg.selectAll('.category').data(categories).enter().append('g').attr('transform', function(d) {
        return "translate(" + (-margin.left) + ", " + (scaleY(d.key)) + ")";
      });
      g.append('text').attr('class', 'labels').attr('dy', 5).text(function(d) {
        return d.caption;
      }).on('click', function(d) {
        return _.inspect({
          content: createStripPlotRowInspection(series, d),
          template: 'geyser'
        });
      });
      forEach(series, function(series) {
        return svg.append('g').attr('id', "strip-plot-" + series.id + "-labels").attr('transform', function(d) {
          return "translate(" + (width + 10) + ")";
        }).style('display', 'none').selectAll('.label').data(categories).enter().append('text').attr('transform', function(d) {
          return "translate(0, " + (scaleY(d.key)) + ")";
        }).attr('dy', 5).text(function(d) {
          var value;
          value = series.outputs[d.key];
          if (isNaN(value)) {
            return 'NaN';
          } else {
            return format4f(value);
          }
        });
      });
      g.append('line').attr('class', 'guide').attr('x1', 0).attr('y1', rowHeight / 2).attr('x2', margin.left + width).attr('y2', rowHeight / 2);
      return el;
    };
    buildAucCategories = function() {
      var categories, criterion, criterionIndex, id, output, _i, _j, _len, _len1;
      categories = [];
      id = 0;
      for (criterionIndex = _i = 0, _len = aucCriteria.length; _i < _len; criterionIndex = ++_i) {
        criterion = aucCriteria[criterionIndex];
        for (_j = 0, _len1 = aucOutputs.length; _j < _len1; _j++) {
          output = aucOutputs[_j];
          categories.push({
            id: id,
            caption: "" + criterion.caption + " - " + output.caption,
            criterion: criterion,
            output: output,
            criterionIndex: criterionIndex,
            domain: [0, 1]
          });
          id++;
        }
      }
      return {
        criteria: aucCriteria,
        outputs: aucOutputs,
        categories: categories
      };
    };
    generateComparison = function(category, series) {
      var filteredSeries, scale, sortedSeries, span;
      filteredSeries = filter(series, function(series) {
        return !isNaN(series.outputs[category.key]);
      });
      sortedSeries = sortBy(filteredSeries, function(series) {
        return -series.outputs[category.key];
      });
      span = 300;
      scale = d3.scale.linear().domain(category.domain).range([0, span]);
      return map(sortedSeries, function(series) {
        var left, origin, value, width, x;
        value = series.outputs[category.key];
        origin = scale(0);
        x = scale(value);
        if (x > origin) {
          left = origin;
          width = x - origin;
        } else if (x < origin) {
          left = x;
          width = origin - x;
        } else {
          left = 0;
          width = 1;
        }
        return {
          caption: series.caption,
          value: format4f(value),
          span: "" + span + "px",
          width: "" + width + "px",
          left: "" + left + "px",
          color: series.color,
          inspect: function() {
            return _.inspect({
              content: createScoringInspection(series),
              template: 'geyser'
            });
          }
        };
      });
    };
    createScoringList = function(series) {
      return map(series, function(series) {
        return {
          caption: series.caption,
          color: series.color,
          inspect: function() {
            return _.inspect({
              content: createScoringInspection(series),
              template: 'geyser'
            });
          }
        };
      });
    };
    createSeriesFromMetrics = function(scores) {
      var colorScale, createUniqueScoringName, palette, uniqueScoringNames;
      uniqueScoringNames = {};
      createUniqueScoringName = function(frameKey, modelKey) {
        var index, name;
        name = "" + modelKey + " on " + frameKey;
        if (index = uniqueScoringNames[name]) {
          uniqueScoringNames[name] = index++;
          name += ' #' + index;
        } else {
          uniqueScoringNames[name] = 1;
        }
        return name;
      };
      palette = scores.length > 10 ? d3.scale.category20 : d3.scale.category10;
      colorScale = palette().domain(d3.range(scores.length));
      return map(scores, function(score, index) {
        var metrics, model;
        metrics = head(score.data.output.metrics);
        model = score.data.input.model;
        return {
          id: index,
          caption: createUniqueScoringName(metrics.frame.key, metrics.model.key),
          model: model,
          inputs: null,
          metrics: metrics,
          outputs: createMarkForScoringMetrics(metrics),
          thresholdMarks: createMarksForThresholdMetrics(metrics),
          color: colorScale(index)
        };
      });
    };
    createMarkForScoringMetrics = function(metrics) {
      var auc, category, mark, _i, _len;
      auc = metrics.auc;
      mark = {};
      for (_i = 0, _len = aucCategories.length; _i < _len; _i++) {
        category = aucCategories[_i];
        if (category.isGrouped) {
          mark[category.key] = +auc[category.output.key][category.criterionIndex];
        } else {
          mark[category.key] = +auc[category.key];
        }
      }
      return mark;
    };
    createMarksForThresholdMetrics = function(metrics) {
      var auc;
      auc = metrics.auc;
      return map(auc.thresholds, function(threshold, index) {
        var cm, fpr, tpr, _ref;
        cm = auc.confusion_matrices[index];
        _ref = computeTPRandFPR2(cm), tpr = _ref[0], fpr = _ref[1];
        return {
          'Threshold': +threshold,
          'Error': +auc.errorr[index],
          'F0.5': +auc.F0point5[index],
          'F1': +auc.F1[index],
          'F2': +auc.F2[index],
          'Accuracy': +auc.accuracy[index],
          'Precision': +auc.precision[index],
          'Recall': +auc.recall[index],
          'Specificity': +auc.specificity[index],
          'MCC': +auc.mcc[index],
          'MPCE': +auc.max_per_class_error[index],
          'Confusion Matrix': cm,
          'TPR': tpr,
          'FPR': fpr
        };
      });
    };
    renderMetricsPlot = function(series, variableX, variableY) {
      var axisX, axisY, el, height, isInputX, isInputY, line, margin, readX, readY, scaleX, scaleY, svg, width;
      margin = {
        top: 20,
        right: 20,
        bottom: 20,
        left: 30
      };
      width = 300;
      height = 300;
      isInputX = variableX.type === 'input';
      isInputY = variableY.type === 'input';
      readX = function(series) {
        if (isInputX) {
          return series.inputs[variableX.key];
        } else {
          return series.outputs[variableX.key];
        }
      };
      readY = function(series) {
        if (isInputY) {
          return series.inputs[variableY.key];
        } else {
          return series.outputs[variableY.key];
        }
      };
      scaleX = d3.scale.linear().domain(isInputX ? variableX.domain : variableX.variable.domain).range([0, width]).nice();
      scaleY = d3.scale.linear().domain(isInputY ? variableY.domain : variableY.variable.domain).range([height, 0]).nice();
      axisX = d3.svg.axis().scale(scaleX).orient('bottom').ticks(5);
      axisY = d3.svg.axis().scale(scaleY).orient('left').ticks(5);
      line = d3.svg.line().x(function(d) {
        return scaleX(readX(d));
      }).y(function(d) {
        return scaleY(readY(d));
      });
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-metrics-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text(variableX.caption);
      svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text(variableY.caption);
      svg.selectAll('.dot').data(series).enter().append('circle').attr('class', 'dot').attr('r', 5).attr('cx', function(d) {
        return scaleX(readX(d));
      }).attr('cy', function(d) {
        return scaleY(readY(d));
      }).attr('stroke', function(d) {
        return d.color;
      }).on('click', function(d) {
        return _.inspect({
          content: createStripPlotValueInspection(d),
          template: 'geyser'
        });
      });
      return el;
    };
    renderThresholdPlot = function(series, attrX, attrY, showReferenceLine) {
      var axisX, axisY, curve, el, height, line, margin, scaleX, scaleY, svg, validMarks, variableX, variableY, width;
      variableX = aucVariableMap[attrX];
      variableY = aucVariableMap[attrY];
      margin = {
        top: 20,
        right: 20,
        bottom: 20,
        left: 30
      };
      width = 300;
      height = 300;
      validMarks = zipObject(map(series, function(series) {
        var marks;
        marks = filter(series.thresholdMarks, function(mark) {
          return (!isNaN(mark[attrX])) && (!isNaN(mark[attrY]));
        });
        return [series.id, marks];
      }));
      scaleX = d3.scale.linear().domain(variableX.domain).range([0, width]);
      scaleY = d3.scale.linear().domain(variableY.domain).range([height, 0]);
      axisX = d3.svg.axis().scale(scaleX).orient('bottom').ticks(5);
      axisY = d3.svg.axis().scale(scaleY).orient('left').ticks(5);
      line = d3.svg.line().x(function(d) {
        return scaleX(d[attrX]);
      }).y(function(d) {
        return scaleY(d[attrY]);
      });
      el = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
      svg = (d3.select(el)).attr('class', 'y-custom-plot').attr('width', width + margin.left + margin.right).attr('height', height + margin.top + margin.bottom).append('g').attr('transform', "translate(" + margin.left + "," + margin.top + ")");
      svg.append('g').attr('class', 'x axis').attr('transform', "translate(0, " + height + ")").call(axisX).append('text').attr('x', width).attr('y', -6).style('text-anchor', 'end').text(variableX.caption);
      svg.append('g').attr('class', 'y axis').call(axisY).append('text').attr('transform', 'rotate(-90)').attr('y', 6).attr('dy', '.71em').style('text-anchor', 'end').text(variableY.caption);
      if (showReferenceLine) {
        svg.append('line').attr('class', 'guide').attr('stroke-dasharray', '3,3').attr({
          x1: scaleX(0),
          y1: scaleY(0),
          x2: scaleX(1),
          y2: scaleY(1)
        });
      }
      curve = svg.selectAll('.y-curve').data(series).enter().append('g').attr('class', 'y-curve');
      curve.append('path').attr('id', function(d) {
        return "curve" + d.id;
      }).attr('class', 'line').attr('d', function(d) {
        return line(validMarks[d.id]);
      }).style('stroke', function(d) {
        return d.color;
      });
      forEach(series, function(series) {
        return svg.append('g').selectAll('.dot').data(validMarks[series.id]).enter().append('circle').attr('class', 'dot').attr('r', 5).attr('cx', function(d) {
          return scaleX(d[attrX]);
        }).attr('cy', function(d) {
          return scaleY(d[attrY]);
        }).on('click', function(d) {
          return _.inspect({
            content: createThresholdPlotInspection(series, d),
            template: 'geyser'
          });
        }).on('mouseover', function(d) {
          return d3.select(this).style('stroke', series.color);
        }).on('mouseout', function(d) {
          return d3.select(this).style('stroke', 'none');
        });
      });
      return el;
    };
    createMetricsPlot = function(series, variableX, variableY) {
      var div, render;
      div = geyser.generate(['div'])[0];
      render = function($element) {
        var plot;
        plot = renderMetricsPlot(series, variableX, variableY);
        return $element.empty().append(plot);
      };
      return {
        markup: div(),
        behavior: render
      };
    };
    createThresholdPlot = function(series, attrX, attrY, showReferenceLine) {
      var div, render;
      div = geyser.generate(['div'])[0];
      render = function($element) {
        var plot;
        plot = renderThresholdPlot(series, attrX, attrY, showReferenceLine);
        return $element.empty().append(plot);
      };
      return {
        markup: div(),
        behavior: render
      };
    };
    createStripPlot = function(series, categories) {
      var div, render;
      div = geyser.generate(['div'])[0];
      render = function($element) {
        var stripPlot;
        stripPlot = renderStripPlot(series, categories);
        return $element.empty().append(stripPlot);
      };
      return {
        markup: div(),
        behavior: render
      };
    };
    createComparisonTable = function(scores) {
      var createComparisonGrid, createParameterTable, diffSpan, div, hyperlink, kvtable, table, tbody, td, tdId, th, thIndent, thWide, thead, tr, trExpert, _ref, _ref1;
      _ref = geyser.generate(words('div table.table.table-condensed table.table-kv thead tbody tr tr.y-expert span.y-diff th th.y-indent td div.y-link')), div = _ref[0], table = _ref[1], kvtable = _ref[2], thead = _ref[3], tbody = _ref[4], tr = _ref[5], trExpert = _ref[6], diffSpan = _ref[7], th = _ref[8], thIndent = _ref[9], td = _ref[10], hyperlink = _ref[11];
      _ref1 = geyser.generate("td id='$id'", "th colspan='" + (scores.length + 1) + "' style='background:#f5f5f5'"), tdId = _ref1[0], thWide = _ref1[1];
      createParameterTable = function(_arg) {
        var parameters;
        parameters = _arg.parameters;
        return kvtable([
          tbody(map(parameters, function(parameter) {
            var trow;
            trow = parameter.isVisible ? tr : trExpert;
            return trow([th(parameter.key), td(parameter.isDifferent ? diffSpan(parameter.value) : parameter.value)]);
          }))
        ]);
      };
      createComparisonGrid = function(scores) {
        var algorithmRow, auc, aucOutput, aucRow, cm, comparisonRows, criterion, criterionIndex, durationRow, errorBadge, inputParametersRow, inputParamsByAlgorithm, inputParamsByScoreIndex, inputParamsWithAlgorithm, metrics, model, nameRow, outputRow, renderRocCurves, rocCurveRow, score, scoreIndex, scoreWithLowestError, toggleAdvancedParameters, value, _i, _j, _k, _l, _len, _len1, _len2, _len3;
        comparisonRows = [];
        comparisonRows.push(algorithmRow = [th('Method')]);
        comparisonRows.push(nameRow = [th('Name')]);
        comparisonRows.push(rocCurveRow = [th('ROC Curve')]);
        comparisonRows.push(inputParametersRow = [th([div('Input Parameters'), hyperlink('Show more', 'toggle-advanced-parameters')])]);
        comparisonRows.push(durationRow = [th('Time')]);
        comparisonRows.push(aucRow = [th('AUC')]);
        scoreWithLowestError = min(scores, function(score) {
          return (head(score.data.output.metrics)).error_measure;
        });
        inputParamsWithAlgorithm = map(scores, function(score) {
          var model;
          model = score.data.input.model;
          return {
            algorithm: model.model_algorithm,
            parameters: combineInputParameters(model)
          };
        });
        inputParamsByScoreIndex = map(inputParamsWithAlgorithm, function(a) {
          return a.parameters;
        });
        inputParamsByAlgorithm = values(groupBy(inputParamsWithAlgorithm, function(a) {
          return a.algorithm;
        }));
        forEach(inputParamsByAlgorithm, function(groups) {
          return compareInputParameters(map(groups, function(group) {
            return group.parameters;
          }));
        });
        for (scoreIndex = _i = 0, _len = scores.length; _i < _len; scoreIndex = ++_i) {
          score = scores[scoreIndex];
          model = score.data.input.model;
          metrics = head(score.data.output.metrics);
          auc = metrics.auc;
          cm = metrics.cm;
          errorBadge = scores.length > 1 && score === scoreWithLowestError ? ' (Lowest)' : '';
          algorithmRow.push(td(model.model_algorithm));
          nameRow.push(td(model.key));
          rocCurveRow.push(tdId('Loading...', {
            $id: "roc-" + scoreIndex
          }));
          inputParametersRow.push(td(createParameterTable({
            parameters: inputParamsByScoreIndex[scoreIndex]
          })));
          durationRow.push(td("" + metrics.duration_in_ms + " ms"));
          aucRow.push(td(format4f(auc.AUC)));
        }
        for (criterionIndex = _j = 0, _len1 = aucCriteria.length; _j < _len1; criterionIndex = ++_j) {
          criterion = aucCriteria[criterionIndex];
          comparisonRows.push([thWide("Outputs by " + criterion.caption)]);
          for (_k = 0, _len2 = aucOutputs.length; _k < _len2; _k++) {
            aucOutput = aucOutputs[_k];
            outputRow = [[th(aucOutput.caption)]];
            for (scoreIndex = _l = 0, _len3 = scores.length; _l < _len3; scoreIndex = ++_l) {
              score = scores[scoreIndex];
              model = score.data.input.model;
              metrics = head(score.data.output.metrics);
              auc = metrics.auc;
              value = auc[aucOutput.key][criterionIndex];
              outputRow.push(td(value === 'NaN' ? value : format4f(value)));
            }
            comparisonRows.push(outputRow);
          }
        }
        renderRocCurves = function($element) {
          forEach(scores, function(score, scoreIndex) {
            return defer(function() {
              var rocCurve;
              rocCurve = createRocCurve((head(score.data.output.metrics)).auc.confusion_matrices);
              return $("#roc-" + scoreIndex, $element).empty().append(rocCurve);
            });
          });
        };
        toggleAdvancedParameters = function($element) {
          var $toggleLink, isHidden;
          isHidden = true;
          $toggleLink = $('#toggle-advanced-parameters', $element);
          $toggleLink.click(function() {
            if (isHidden) {
              $('.y-expert', $element).show();
              $toggleLink.text('Show less');
            } else {
              $('.y-expert', $element).hide();
              $toggleLink.text('Show more');
            }
            isHidden = !isHidden;
          });
        };
        return {
          markup: table(tbody(map(comparisonRows, function(row) {
            return tr(row);
          }))),
          behavior: function($element) {
            renderRocCurves($element);
            return toggleAdvancedParameters($element);
          }
        };
      };
      return createComparisonGrid(scores);
    };
    configureStripPlot = function() {
      return _.configureStripPlot(_stripPlotParameters, function(parameters) {
        var parameter, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2;
        if (parameters) {
          _ref = parameters.group1;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            parameter = _ref[_i];
            parameter.source.isSelected(parameter.isSelected());
          }
          _ref1 = parameters.group2;
          for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
            parameter = _ref1[_j];
            parameter.source.isSelected(parameter.isSelected());
          }
          _ref2 = parameters.group3;
          for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
            parameter = _ref2[_k];
            parameter.source.isSelected(parameter.isSelected());
          }
        }
      });
    };
    initialize(_scoring);
    return {
      tag: _tag,
      caption: _caption,
      timestamp: _timestamp,
      isScoringView: _isScoringView,
      isComparisonView: _isComparisonView,
      isTabularComparisonView: _isTabularComparisonView,
      isAdvancedComparisonView: _isAdvancedComparisonView,
      isSheetView: _isSheetView,
      switchToTabularView: switchToTabularView,
      switchToAdvancedView: switchToAdvancedView,
      switchToSheetView: switchToSheetView,
      modelSummary: _modelSummary,
      comparisonTable: _comparisonTable,
      scoringList: _scoringList,
      multiRocPlot: _multiRocPlot,
      categories: _categories,
      selectedCategory: _selectedCategory,
      comparisonPlot: _comparisonPlot,
      inputOutputCategories: _inputOutputCategories,
      inputOutputPlotX: _inputOutputPlotX,
      inputOutputPlotY: _inputOutputPlotY,
      inputOutputPlot: _inputOutputPlot,
      thresholdPlot: _thresholdPlot,
      thresholdPlotX: _thresholdPlotX,
      thresholdPlotY: _thresholdPlotY,
      thresholdPlotVariables: _thresholdPlotVariables,
      stripPlot: _stripPlot,
      configureStripPlot: configureStripPlot,
      sheetView: _sheetView,
      hasFailed: _hasFailed,
      failure: _failure,
      template: 'scoring-view'
    };
  };

}).call(this);

(function() {
  Steam.SelectFrameDialog = function(_, _frames, _go) {
    var cancel, confirm, createItem, initialize, selectItem, _hasSelection, _items, _selectedItem;
    _items = nodes$();
    _selectedItem = node$(null);
    _hasSelection = lift$(_selectedItem, isTruthy);
    initialize = function(frames) {
      var items;
      _items(items = map(frames, createItem));
      return selectItem(head(items));
    };
    selectItem = function(target) {
      var item, _i, _len, _ref;
      _ref = _items();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        item = _ref[_i];
        item.isActive(item === target);
      }
      return _selectedItem(target);
    };
    createItem = function(frame) {
      var self;
      return self = {
        data: frame,
        key: frame.key,
        count: describeCount(frame.column_names.length, 'column'),
        timestamp: frame.creation_epoch_time_millis,
        select: function() {
          return selectItem(self);
        },
        isActive: node$(false)
      };
    };
    confirm = function() {
      return _go('confirm', _selectedItem().data.key);
    };
    cancel = function() {
      return _go('cancel');
    };
    initialize(_frames);
    return {
      items: _items,
      hasSelection: _hasSelection,
      confirm: confirm,
      cancel: cancel,
      template: 'select-frame-dialog'
    };
  };

}).call(this);

(function() {
  if (typeof exports === "undefined" || exports === null) {
    $(function() {
      var steam;
      window.steam = steam = Steam.Application(Steam.ApplicationContext());
      ko.applyBindings(steam);
      return steam.context.ready();
    });
  }

}).call(this);

(function() {
  Steam.TextMetrics = function(_) {
    var initialize, measureTextSpan, _$box;
    _$box = null;
    initialize = function() {
      var boxEl, containerEl;
      containerEl = document.createElement('div');
      containerEl.className = 'y-cloaked';
      boxEl = document.createElement('span');
      containerEl.appendChild(boxEl);
      $('.y-overlays').append(containerEl);
      return _$box = $(boxEl);
    };
    measureTextSpan = function(text) {
      _$box.text(text);
      return _$box.width();
    };
    link$(_.measureTextSpan, measureTextSpan);
    return link$(_.ready, initialize);
  };

}).call(this);

(function() {
  Steam.TimelineView = function(_) {
    var createEvent, createTimeline, refresh, _header, _timeline, _timestamp;
    _header = ['HH:MM:SS:MS', 'nanosec', 'Who', 'I/O Type', 'Event', 'Bytes'];
    _timeline = node$(null);
    _timestamp = node$(Date.now());
    createEvent = function(event) {
      switch (event.type) {
        case 'io':
          return [event.date, event.nanos, event.node, event.ioFlavor || '-', 'I/O', event.data];
        case 'heartbeat':
          return [event.date, event.nanos, 'many &#8594;  many', 'UDP', 'heartbeat', "" + event.sends + " sent " + event.recvs + " received"];
        case 'network_msg':
          return [event.date, event.nanos, "" + event.from + " &#8594; " + event.to, event.protocol, event.msgType, event.data];
      }
    };
    createTimeline = function(result) {
      return map(result.events, createEvent);
    };
    refresh = function() {
      return _.requestTimeline(function(error, result) {
        if (error) {
          return _.error('Error fetching timeline', null, error);
        } else {
          _timeline(createTimeline(result));
          return _timestamp(Date.now());
        }
      });
    };
    refresh();
    return {
      header: _header,
      timeline: _timeline,
      timestamp: _timestamp,
      template: 'timeline-view'
    };
  };

}).call(this);

(function() {
  Steam.Timers = function(_) {
    var _timeouts, _timers;
    _timers = {};
    _timeouts = {};
    link$(_.timeout, function(id, ms, func) {
      var timeout;
      console.assert(isFunction(func));
      if (timeout = _timeouts[id]) {
        clearInterval(timeout.id);
        return timeout.id = setInterval(func, ms);
      } else {
        return _timeouts[id] = {
          id: setInterval(func, ms)
        };
      }
    });
    link$(_.schedule, function(ms, func) {
      var tick, timer, timerId;
      console.assert(isFunction(func));
      if (timer = _timers[ms]) {
        return push(timer.functions, func);
      } else {
        tick = function() {
          var f, _i, _len, _ref;
          _ref = _timers[ms].functions;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            f = _ref[_i];
            if (f) {
              f();
            }
          }
        };
        timerId = setInterval(tick, ms);
        return _timers[ms] = {
          id: timerId,
          functions: [func]
        };
      }
    });
    return link$(_.unschedule, function(ms, func) {
      var timer;
      if (timer = _timers[ms]) {
        if (func) {
          remove(timer.functions, func);
          if (timer.functions.length === 0) {
            clearInterval(timer.id);
            delete _timers[ms];
          }
        } else {
          clearInterval(timer.id);
          delete _timers[ms];
        }
      }
    });
  };

}).call(this);

(function() {
  Steam.TooltipManager = function(_) {
    var applyStyle, createEl, initialize, moveTooltip, switchArrow, table, tabulate, tbody, td, th, tooltip, tr, wrap, _$tooltipText, _containerEl, _offset, _ref, _tooltipArrowDownEl, _tooltipArrowLeftEl, _tooltipArrowRightEl, _tooltipArrowUpEl, _tooltipArrows, _tooltipEl, _tooltipTextEl;
    _offset = 5;
    _containerEl = null;
    _tooltipEl = null;
    _tooltipArrowUpEl = null;
    _tooltipArrowRightEl = null;
    _tooltipArrowDownEl = null;
    _tooltipArrowLeftEl = null;
    _tooltipArrows = null;
    _tooltipTextEl = null;
    _$tooltipText = null;
    _ref = geyser.generate(words('table.y-tooltip-table tbody tr th td')), table = _ref[0], tbody = _ref[1], tr = _ref[2], th = _ref[3], td = _ref[4];
    createEl = function(className, tag) {
      var el;
      if (tag == null) {
        tag = 'div';
      }
      el = document.createElement(tag);
      if (className) {
        el.className = className;
      }
      return el;
    };
    initialize = function() {
      var $overlays;
      _containerEl = $('.y-main').get(0);
      $overlays = $('.y-overlays');
      _tooltipEl = createEl('y-tooltip');
      _tooltipArrowUpEl = createEl('y-tooltip-arrow-up');
      _tooltipArrowRightEl = createEl('y-tooltip-arrow-right');
      _tooltipArrowDownEl = createEl('y-tooltip-arrow-down');
      _tooltipArrowLeftEl = createEl('y-tooltip-arrow-left');
      _tooltipArrows = [_tooltipArrowUpEl, _tooltipArrowRightEl, _tooltipArrowDownEl, _tooltipArrowLeftEl];
      _tooltipTextEl = createEl('y-tooltip-text');
      _$tooltipText = $(_tooltipTextEl);
      _tooltipEl.appendChild(_tooltipArrowUpEl);
      _tooltipEl.appendChild(_tooltipArrowRightEl);
      _tooltipEl.appendChild(_tooltipArrowDownEl);
      _tooltipEl.appendChild(_tooltipArrowLeftEl);
      _tooltipEl.appendChild(_tooltipTextEl);
      return $overlays.append(_tooltipEl);
    };
    tabulate = function(obj) {
      var key, rows, value;
      rows = [];
      for (key in obj) {
        value = obj[key];
        rows.push(tr([th(key), td(value)]));
      }
      return geyser.render(table(tbody(rows)));
    };
    wrap = function(text) {
      return geyser.render(table(tbody(tr(td(text)))));
    };
    switchArrow = function(arrowEl) {
      var el, _i, _len;
      for (_i = 0, _len = _tooltipArrows.length; _i < _len; _i++) {
        el = _tooltipArrows[_i];
        el.style.display = el === arrowEl ? 'block' : 'none';
      }
    };
    applyStyle = function(style, attr, value) {
      if (isNull(value)) {
        return style.removeProperty(attr);
      } else {
        return style[attr] = value + 'px';
      }
    };
    moveTooltip = function(x, y, width, height, left, top, bottom, right) {
      var style;
      _tooltipEl.style.left = x + 'px';
      _tooltipEl.style.top = y + 'px';
      style = _tooltipTextEl.style;
      style.width = width + 'px';
      style.height = height + 'px';
      applyStyle(style, 'left', left);
      applyStyle(style, 'top', top);
      applyStyle(style, 'right', right);
      return applyStyle(style, 'bottom', bottom);
    };
    tooltip = function(el, tip, anchor) {
      var bottom, bounds, content, contentBounds, height, left, parentBounds, right, rightFits, top, topFits, width, x, y, _contentEl;
      if (el) {
        _tooltipEl.style.display = 'block';
      } else {
        _tooltipEl.style.display = 'none';
        return;
      }
      content = isObject(tip) ? tabulate(tip) : wrap(tip);
      _$tooltipText.html(content);
      _contentEl = _$tooltipText.children().first().get(0);
      contentBounds = _contentEl.getBoundingClientRect();
      if (!contentBounds) {
        return;
      }
      width = contentBounds.right - contentBounds.left;
      height = contentBounds.bottom - contentBounds.top;
      bounds = el.getBoundingClientRect();
      if (!bounds) {
        return;
      }
      left = bounds.left, top = bounds.top, right = bounds.right, bottom = bounds.bottom;
      x = left + (right - left) / 2;
      y = top + (bottom - top) / 2;
      if (!anchor) {
        parentBounds = _containerEl.getBoundingClientRect();
        if (!bounds) {
          return;
        }
        topFits = top - _offset - height > parentBounds.top;
        rightFits = right + _offset + width < parentBounds.right;
        if (topFits) {
          if (rightFits) {
            anchor = 'top';
          } else {
            anchor = 'left';
          }
        } else {
          if (rightFits) {
            anchor = 'right';
          } else {
            anchor = 'left';
          }
        }
      }
      switch (anchor) {
        case 'top':
          moveTooltip(x, top, width, height, -width / 2, null, _offset, null);
          switchArrow(_tooltipArrowDownEl);
          break;
        case 'right':
          moveTooltip(right, y, width, height, _offset, -height / 2, null, null);
          switchArrow(_tooltipArrowLeftEl);
          break;
        case 'left':
          moveTooltip(left, y, width, height, null, -height / 2, null, _offset);
          switchArrow(_tooltipArrowRightEl);
          break;
        case 'bottom':
          moveTooltip(x, bottom, width, height, -width / 2, _offset, null, null);
          switchArrow(_tooltipArrowUpEl);
      }
      return _$tooltipText.html(content);
    };
    link$(_.tooltip, tooltip);
    return link$(_.ready, initialize);
  };

}).call(this);

(function() {
  Steam.TopicListView = function(_, _topics) {
    return {
      template: 'topic-list-view',
      topics: _topics
    };
  };

}).call(this);

(function() {
  var check, checkInvalid, checkValid, s_0, s_all, s_arr, s_bools, s_date, s_empty, s_err, s_false, s_func, s_nan, s_not_arrs, s_not_bools, s_not_dates, s_not_errs, s_not_funcs, s_not_nums, s_not_nums_or_strs, s_not_objs, s_not_regexps, s_not_strs, s_null, s_num, s_nums, s_obj, s_regexp, s_str, s_strs, s_true, s_undef;

  s_undef = void 0;

  s_null = null;

  s_nan = Number.NaN;

  s_0 = 0;

  s_num = 42;

  s_empty = '';

  s_str = 'foo';

  s_true = true;

  s_false = false;

  s_arr = [1, 2, 3];

  s_func = function() {
    return true;
  };

  s_err = new Error('fail');

  s_date = new Date();

  s_regexp = /(.+)/g;

  s_obj = {};

  s_all = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_true, s_false, s_arr, s_func, s_err, s_date, s_regexp, s_obj];

  s_nums = [s_nan, s_0, s_num];

  s_not_nums = [s_undef, s_null, s_empty, s_str, s_true, s_false, s_arr, s_func, s_err, s_date, s_regexp, s_obj];

  s_strs = [s_empty, s_str];

  s_not_strs = [s_undef, s_null, s_nan, s_0, s_num, s_true, s_false, s_arr, s_func, s_err, s_date, s_regexp, s_obj];

  s_not_nums_or_strs = [s_undef, s_null, s_true, s_false, s_arr, s_func, s_err, s_date, s_regexp, s_obj];

  s_bools = [s_true, s_false];

  s_not_bools = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_arr, s_func, s_err, s_date, s_regexp, s_obj];

  s_not_arrs = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_true, s_false, s_func, s_err, s_date, s_regexp, s_obj];

  s_not_funcs = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_true, s_false, s_arr, s_err, s_date, s_regexp, s_obj];

  s_not_errs = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_true, s_false, s_arr, s_func, s_date, s_regexp, s_obj];

  s_not_dates = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_true, s_false, s_arr, s_func, s_err, s_regexp, s_obj];

  s_not_regexps = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_true, s_false, s_arr, s_func, s_err, s_date, s_obj];

  s_not_objs = [s_undef, s_null, s_nan, s_0, s_num, s_empty, s_str, s_true, s_false, s_arr, s_func, s_err, s_date, s_regexp];

  checkValid = function(t, values, type) {
    var value, _i, _len;
    for (_i = 0, _len = values.length; _i < _len; _i++) {
      value = values[_i];
      t.ok(null === T.check(value, type), "" + (JSON.stringify(value)) + " ~ " + (JSON.stringify(type.inspect())));
    }
  };

  checkInvalid = function(t, values, type) {
    var errors, value, _i, _len;
    for (_i = 0, _len = values.length; _i < _len; _i++) {
      value = values[_i];
      errors = T.check(value, type);
      t.ok(null !== errors, "" + (JSON.stringify(value)) + " !~ " + (JSON.stringify(type.inspect())));
    }
  };

  check = function(t, validValues, invalidValues, type) {
    checkValid(t, validValues, type);
    return checkInvalid(t, invalidValues, type);
  };

  test('typedef T.num', function(t) {
    check(t, s_nums, s_not_nums, T({
      Foo: T.num
    }));
    return t.end();
  });

  test('typedef T.str', function(t) {
    check(t, s_strs, s_not_strs, T({
      Foo: T.str
    }));
    return t.end();
  });

  test('typedef T.bool', function(t) {
    check(t, s_bools, s_not_bools, T({
      Foo: T.bool
    }));
    return t.end();
  });

  test('typedef T.func', function(t) {
    check(t, [s_func], s_not_funcs, T({
      Foo: T.func
    }));
    return t.end();
  });

  test('typedef T.err', function(t) {
    check(t, [s_err], s_not_errs, T({
      Foo: T.err
    }));
    return t.end();
  });

  test('typedef T.date', function(t) {
    check(t, [s_date], s_not_dates, T({
      Foo: T.date
    }));
    return t.end();
  });

  test('typedef T.regexp', function(t) {
    check(t, [s_regexp], s_not_regexps, T({
      Foo: T.regexp
    }));
    return t.end();
  });

  test('typedef allows validation functions in simple type definitions', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: T.str(function(value) {
        if ((value != null ? value.length : void 0) === 5) {
          return null;
        } else {
          return 'Invalid length';
        }
      })
    });
    validValues = ['alpha', 'gamma'];
    invalidValues = s_all;
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef allows validation functions with simple type definitions', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: T.str
    }, function(value) {
      if ((value != null ? value.length : void 0) === 5) {
        return null;
      } else {
        return 'Invalid length';
      }
    });
    validValues = ['alpha', 'gamma'];
    invalidValues = s_all;
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef allows validation functions on compound type definitions', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: {
        bar: T.str
      }
    }, function(value) {
      var _ref;
      if ((value != null ? (_ref = value.bar) != null ? _ref.length : void 0 : void 0) === 5) {
        return null;
      } else {
        return 'Invalid length';
      }
    });
    validValues = [
      {
        bar: 'alpha'
      }, {
        bar: 'gamma'
      }
    ];
    invalidValues = s_all;
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef does not allow arbitrary items in type definitions', function(t) {
    t.throws(function() {
      return T({
        foo: 'bar'
      });
    });
    t.throws(function() {
      return T(T.str({
        foo: {
          bar: 'baz'
        }
      }));
    });
    t.throws(function() {
      return T({
        foo: {
          bar: {
            baz: 'quux'
          }
        }
      });
    });
    return t.end();
  });

  test('typedef does not allow arbitrary items in type checks', function(t) {
    t.throws(function() {
      return T.check({
        foo: 'bar'
      }, 'foo');
    });
    t.throws(function() {
      return T.check({
        foo: 'bar'
      }, 42);
    });
    t.throws(function() {
      return T.check({
        foo: 'bar'
      }, {
        foo: 'bar'
      });
    });
    return t.end();
  });

  test('typedef Any is allowed on top level definitions', function(t) {
    check(t, s_all, [], T({
      Foo: T.any
    }));
    return t.end();
  });

  test('typedef Any is allowed on attribute definitions', function(t) {
    var invalidValues, validValues;
    validValues = [
      {
        bar: s_num
      }, {
        bar: s_arr
      }, {
        bar: null
      }, {
        bar: void 0
      }
    ];
    invalidValues = [
      {
        qux: s_num
      }
    ];
    check(t, validValues, invalidValues, T({
      foo: {
        bar: T.any
      }
    }));
    return t.end();
  });

  test('typedef Array allows primitive string typed arrays', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: T.arr(T.str)
    });
    validValues = [[], ['foo', 'bar']];
    invalidValues = s_all;
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Array allows primitive number typed arrays', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: T.arr(T.num)
    });
    validValues = [[], [1, 2, 3, 4, 5]];
    invalidValues = s_not_arrs;
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Array allows compound typed arrays', function(t) {
    var arrayType, fooType;
    fooType = T({
      Foo: {
        foo: T.str,
        bar: T.num
      }
    });
    arrayType = T({
      foos: T.arr(fooType)
    });
    t.ok(null === T.check([
      {
        foo: 'foo',
        bar: 42
      }
    ], arrayType));
    return t.end();
  });

  test('typedef Array does not allow untyped arrays', function(t) {
    t.throws(function() {
      return T({
        foo: T.arr()
      });
    });
    t.throws(function() {
      return T({
        foo: T.arr
      });
    });
    t.throws(function() {
      return T({
        foo: T.arr(identity)
      });
    });
    return t.end();
  });

  test('typedef Array does not allow arbitrary arguments', function(t) {
    t.throws(function() {
      return T({
        foo: T.arr({
          bar: 'baz'
        })
      });
    });
    return t.end();
  });

  test('typedef Array allows validators', function(t) {
    var type;
    type = T({
      foo: T.arr(T.num, function(array) {
        if (array.length > 5) {
          return 'Fail';
        } else {
          return null;
        }
      })
    });
    t.ok(null === T.check([1, 2, 3, 4, 5], type));
    t.ok(null !== T.check([1, 2, 3, 4, 5, 6], type));
    return t.end();
  });

  test('typedef Tuple allows primitive types', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: T.tuple(T.str, T.num, T.date)
    });
    validValues = [['foo', 41, new Date()], ['bar', 42, new Date()], ['baz', 43, new Date()]];
    invalidValues = [
      [new Date(), 'foo', 42], [new Date(), new Date(), new Date()], ['foo', 'bar', 'baz'], [41, 42, 43], ['foo', 42, new Date(), 'baz'], ['foo', 42], [], {
        foo: 'bar'
      }
    ];
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Tuple allows compound types', function(t) {
    var arrayType, fooType;
    fooType = T({
      Foo: {
        foo: T.str,
        bar: T.num
      }
    });
    arrayType = T({
      foos: T.tuple(fooType)
    });
    t.ok(null === T.check([
      {
        foo: 'foo',
        bar: 42
      }
    ], arrayType));
    return t.end();
  });

  test('typedef Tuple does not allow untyped tuples', function(t) {
    t.throws(function() {
      return T({
        foo: T.tuple()
      });
    });
    t.throws(function() {
      return T({
        foo: T.tuple
      });
    });
    t.throws(function() {
      return T({
        foo: T.tuple(identity)
      });
    });
    return t.end();
  });

  test('typedef Tuple does not allow arbitrary arguments', function(t) {
    t.throws(function() {
      return T({
        foo: T.tuple({
          bar: 'baz'
        })
      });
    });
    return t.end();
  });

  test('typedef Tuple allows validators', function(t) {
    var type;
    type = T({
      foo: T.tuple(T.str, T.num, T.date, function(tuple) {
        if (tuple[0].length > 3) {
          return 'Fail';
        } else {
          return null;
        }
      })
    });
    t.ok(null === T.check(['foo', 42, new Date()], type));
    t.ok(null !== T.check(['quux', 42, new Date()], type));
    return t.end();
  });

  test('typedef Union allows single primitive types', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: T.union(T.num)
    });
    validValues = s_nums;
    invalidValues = s_not_nums;
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Union allows multiple primitive types', function(t) {
    var invalidValues, type, validValues;
    type = T({
      foo: T.union(T.str, T.num)
    });
    validValues = [s_str, s_num];
    invalidValues = s_not_nums_or_strs;
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Union allows compound types', function(t) {
    var barType, fooType, invalidValues, validValues, varType;
    fooType = T({
      Foo: {
        foo: T.str,
        bar: T.num
      }
    });
    barType = T({
      Bar: {
        baz: T.str
      }
    });
    varType = T({
      qux: {
        foobar: T.union(fooType, barType)
      }
    });
    validValues = [
      {
        foobar: {
          foo: 'foo',
          bar: 42
        }
      }, {
        foobar: {
          baz: 'quux'
        }
      }
    ];
    invalidValues = [
      {
        foobar: {
          qux: 'quux'
        }
      }
    ];
    check(t, validValues, invalidValues, varType);
    return t.end();
  });

  test('typedef Union can create unions without T.union', function(t) {
    var barType, fooType, invalidValues, validValues, varType;
    fooType = T({
      Foo: {
        foo: T.str,
        bar: T.num
      }
    });
    barType = T({
      Bar: {
        baz: T.str
      }
    });
    varType = T({
      qux: {
        foobar: [fooType, barType]
      }
    });
    validValues = [
      {
        foobar: {
          foo: 'foo',
          bar: 42
        }
      }, {
        foobar: {
          baz: 'quux'
        }
      }
    ];
    invalidValues = [
      {
        foobar: {
          qux: 'quux'
        }
      }
    ];
    check(t, validValues, invalidValues, varType);
    return t.end();
  });

  test('typedef Union does not allow untyped unions', function(t) {
    t.throws(function() {
      return T({
        foo: T.union()
      });
    });
    t.throws(function() {
      return T({
        foo: T.union
      });
    });
    t.throws(function() {
      return T({
        foo: T.union(identity)
      });
    });
    return t.end();
  });

  test('typedef Union does not allow arbitrary arguments', function(t) {
    t.throws(function() {
      return T({
        foo: T.union({
          bar: 'baz'
        })
      });
    });
    t.throws(function() {
      return T({
        foo: T.union({
          bar: 'baz'
        }, {
          qux: 'qux'
        })
      });
    });
    return t.end();
  });

  test('typedef Union allows validators', function(t) {
    var type;
    type = T({
      foo: T.union(T.str, T.num, function(value) {
        if (value === 42 || value === '42') {
          return 'Fail';
        } else {
          return null;
        }
      })
    });
    t.ok(null === T.check(41, type));
    t.ok(null === T.check('41', type));
    t.ok(null !== T.check(42, type));
    t.ok(null !== T.check('42', type));
    return t.end();
  });

  test('typedef Enum does not allow invalid definitions', function(t) {
    t.throws(function() {
      return T({
        foo: T.str([41, 42, 43])
      });
    });
    t.throws(function() {
      return T({
        foo: T.num(['Windows', 'OSX', 'Linux'])
      });
    });
    return t.end();
  });

  test('typedef Enum Number', function(t) {
    var invalidValues, type, validValues;
    validValues = [1, 3, 5, 7, 9];
    invalidValues = [2, 4, 6, 8].concat(s_not_nums);
    type = T({
      foo: T.num(validValues)
    });
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Enum String', function(t) {
    var invalidValues, type, validValues;
    validValues = ['Windows', 'OSX', 'Linux'];
    invalidValues = s_all;
    type = T({
      foo: T.str(validValues)
    });
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Enum Boolean', function(t) {
    var invalidValues, type, validValues;
    validValues = [true, false];
    invalidValues = s_not_bools;
    type = T({
      foo: T.bool(validValues)
    });
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Enum Function', function(t) {
    var f1, f2, invalidValues, type, validValues;
    f1 = function() {};
    f2 = function() {};
    validValues = [f1, f2];
    invalidValues = s_all;
    type = T({
      foo: T.func(validValues)
    });
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Enum Error', function(t) {
    var e1, e2, invalidValues, type, validValues;
    e1 = new Error('foo');
    e2 = new Error('bar');
    validValues = [e1, e2];
    invalidValues = s_all;
    type = T({
      foo: T.err(validValues)
    });
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Enum Date', function(t) {
    var d1, d2, invalidValues, type, validValues;
    d1 = new Date(Date.now() - 1000);
    d2 = new Date(Date.now() - 10000);
    validValues = [d1, d2];
    invalidValues = s_all;
    type = T({
      foo: T.date(validValues)
    });
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef Enum RegExp', function(t) {
    var invalidValues, rx1, rx2, type, validValues;
    rx1 = /\s+/;
    rx2 = /.+/g;
    validValues = [rx1, rx2];
    invalidValues = s_all;
    type = T({
      foo: T.regexp(validValues)
    });
    check(t, validValues, invalidValues, type);
    return t.end();
  });

  test('typedef inspect', function(t) {
    var description, type;
    type = T({
      Foo: {
        a: T.any,
        b: T.num,
        c: T.str,
        d: T.bool,
        e: T.func,
        f: T.err,
        g: T.date,
        h: T.regexp
      }
    });
    description = {
      Foo: {
        a: 'Any',
        b: 'Number',
        c: 'String',
        d: 'Boolean',
        e: 'Function',
        f: 'Error',
        g: 'Date',
        h: 'RegExp'
      }
    };
    t.deepEqual(type.inspect(), description);
    return t.end();
  });

}).call(this);

(function() {
  Steam.Xhr = function(_) {
    var createResponse, handleResponse;
    createResponse = function(status, data, xhr) {
      return {
        status: status,
        data: data,
        xhr: xhr
      };
    };
    handleResponse = function(go, jqxhr) {
      return jqxhr.done(function(data, status, xhr) {
        return go(null, createResponse(status, data, xhr));
      }).fail(function(xhr, status, error) {
        return go(createResponse(status, xhr.responseJSON, xhr));
      });
    };
    link$(_.h2oGet, function(path, go) {
      return handleResponse(go, $.getJSON(path));
    });
    return link$(_.h2oPost, function(path, opts, go) {
      return handleResponse(go, $.post(path, opts));
    });
  };

}).call(this);
}).call(this);