/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.libtorch;

import com.facebook.soloader.nativeloader.SystemDelegate;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.pytorch.IValue;
import org.pytorch.Module;
import org.pytorch.Tensor;
import org.scijava.nativelib.NativeLoader;

public class LibtorchBundle {
    public static void init() {
        com.facebook.soloader.nativeloader.NativeLoader.initIfUninitialized(new MySystemDelegate());
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            throw new RuntimeException("Expected exactly 1 argument");
        }
        File file = new File(args[0]).getAbsoluteFile();
        System.err.println("Model file: " + file);
        Module mod = Module.load(file.getPath());
        Tensor data = Tensor.fromBlob(new int[]{1, 2, 3, 4, 5, 6}, new long[]{2L, 3L});
        IValue result = mod.forward(IValue.from(data), IValue.from(3.0));
        Tensor output = result.toTensor();
        System.out.println("shape: " + Arrays.toString(output.shape()));
        System.out.println("data: " + Arrays.toString(output.getDataAsFloatArray()));
    }

    static {
        LibtorchBundle.init();
    }

    static class MySystemDelegate
    extends SystemDelegate {
        private final Set<String> alreadyLoaded = new HashSet<String>();

        MySystemDelegate() {
        }

        @Override
        public boolean loadLibrary(String shortName, int flags) {
            if (this.alreadyLoaded.contains(shortName)) {
                return false;
            }
            try {
                NativeLoader.loadLibrary(shortName, new String[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            this.alreadyLoaded.add(shortName);
            return true;
        }
    }
}

