/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoRow;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;

public class MojoRowBuilder {
    private final Map<String, Integer> _columnNamesMap;
    private final MojoColumn.Type[] _columnTypes;
    private final Collection<String> _missingValues;
    private Object[] _values;

    MojoRowBuilder(Map<String, Integer> columnNamesMap, MojoColumn.Type[] columnTypes, Collection<String> missingValues) {
        this._columnNamesMap = columnNamesMap;
        this._columnTypes = columnTypes;
        this._missingValues = missingValues;
        this._values = new Object[this._columnTypes.length];
    }

    public void setValue(String name, String value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setValue(idx, value);
        }
    }

    public MojoRowBuilder setValue(int idx, String value) {
        if (idx >= this._values.length) {
            throw new ArrayIndexOutOfBoundsException("Index " + idx + " is out of available scope.");
        }
        this._values[idx] = value != null ? (this._missingValues.contains(value) ? null : this._columnTypes[idx].parse(value)) : null;
        return this;
    }

    public MojoRowBuilder setBool(String name, Boolean value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setBool(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setChar(String name, Character value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setChar(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setByte(String name, Byte value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setByte(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setShort(String name, Short value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setShort(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setInt(String name, Integer value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setInt(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setLong(String name, Long value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setLong(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setFloat(String name, Float value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setFloat(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setDouble(String name, Double value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setDouble(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setString(String name, String value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setString(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setDate(String name, Date value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setDate(idx, value);
        }
        return this;
    }

    public MojoRowBuilder setTimestamp(String name, Timestamp value) {
        Integer idx = this._columnNamesMap.get(name);
        if (idx != null) {
            this.setTimestamp(idx, value);
        }
        return this;
    }

    private MojoRowBuilder setJavaValue(int idx, Object value) {
        if (idx >= this._values.length) {
            throw new ArrayIndexOutOfBoundsException("Index " + idx + " is out of available scope.");
        }
        this._values[idx] = this._columnTypes[idx].fromJavaClass(value);
        return this;
    }

    public MojoRowBuilder setBool(int idx, Boolean value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setByte(int idx, Byte value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setShort(int idx, Short value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setChar(int idx, Character value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setInt(int idx, Integer value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setLong(int idx, Long value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setFloat(int idx, Float value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setDouble(int idx, Double value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setString(int idx, String value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setDate(int idx, Date value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setTimestamp(int idx, Timestamp value) {
        return this.setJavaValue(idx, value);
    }

    public MojoRowBuilder setValues(Object[] values) {
        if (values.length != this._values.length) {
            throw new IllegalArgumentException("Length of values argument does not match size of MojoRowBuilder");
        }
        System.arraycopy(values, 0, this._values, 0, this._values.length);
        return this;
    }

    MojoRow toMojoRow() {
        return new MojoRow(this._values);
    }

    public void clear() {
        this._values = new Object[this._values.length];
    }

    public int size() {
        return this._values.length;
    }
}

