package ai.h2o.mojos.runtime.readers;

import java.io.*;

/**
 * The backend serves MOJO content from a folder.
 */
public class FolderMojoReaderBackend extends MojoReaderBackend {

  public FolderMojoReaderBackend(String folder) {
    this(folder, null);
  }

  public FolderMojoReaderBackend(String folder, String pipelineFile) {
    super(folder, File.separator, pipelineFile);
  }

  @Override
  public InputStream getFile(String filename) throws IOException {
    File f = new File(getBaseDir(), filename);
    return new FileInputStream(f);
  }

  @Override
  public BufferedReader getTextFile(String filename) throws IOException {
    File f = new File(getBaseDir(), filename);
    FileReader fr = new FileReader(f);
    return new BufferedReader(fr);
  }

  @Override
  public byte[] getBinaryFile(String filename) throws IOException {
    File f = new File(getBaseDir(), filename);
    byte[] out = new byte[(int) f.length()];
    DataInputStream dis = new DataInputStream(new FileInputStream(f));
    dis.readFully(out);
    return out;
  }

  @Override
  public boolean exists(String filename) {
    return new File(getBaseDir(), filename).exists();
  }

  @Override public void close() {}
}
