/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import java.util.Arrays;

public class ArrayUtils {
    public static <T> T[] join(T[] a, T[] b, T[] ... others) {
        assert (a != null && b != null);
        int totalLen = a.length + b.length + ArrayUtils.len(others);
        T[] r = Arrays.copyOf(a, totalLen);
        System.arraycopy(b, 0, r, a.length, b.length);
        int idx = a.length + b.length;
        for (T[] t : others) {
            System.arraycopy(t, 0, r, idx, t.length);
            idx += t.length;
        }
        return r;
    }

    public static <T> int len(T[] ... others) {
        int len = 0;
        for (T[] t : others) {
            len += t.length;
        }
        return len;
    }

    public static <I, O> O[] foreach(I[] in, Mapper<I, O> func) {
        O[] result = null;
        for (int i = 0; i < in.length; ++i) {
            result[i] = func.map(in[i]);
        }
        return result;
    }

    public static Mapper<String, String> replace(final String pattern, final String replacement) {
        return new Mapper<String, String>(){

            @Override
            public String map(String in) {
                return in != null ? in.replace(pattern, replacement) : null;
            }
        };
    }

    static interface Mapper<I, O> {
        public O map(I var1);
    }
}

