package ai.h2o.mojos.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

/**
 * Service to obtain instance of {@link MojoPipelineFactory}.
 *
 * The service is using Java SPI to obtain all classes
 * implementing {@link MojoPipelineFactory} interface.
 */
final class MojoPipelineFactoryService {

  private static class InstanceHolder {
    private static MojoPipelineFactoryService INSTANCE = new MojoPipelineFactoryService();
  }

  private final ServiceLoader<MojoPipelineFactory> loader;

  public static MojoPipelineFactoryService getInstance() {
    return InstanceHolder.INSTANCE;
  }

  private MojoPipelineFactoryService() {
    loader = ServiceLoader.load(MojoPipelineFactory.class);
  }

  /**
   * Get all implementors of {@link MojoPipelineFactory} interface.
   *
   * @return array of objects implementing {@link MojoPipelineFactory} interface. Empty array
   * if no implementor is found.
   */
  synchronized public MojoPipelineFactory[] getAll() {
    List<MojoPipelineFactory> l = new ArrayList<>();
    for (MojoPipelineFactory mmf : loader) {
      l.add(mmf);
    }
    return l.toArray(new MojoPipelineFactory[0]);
  }

  public MojoPipelineFactory getMojoPipelineFactory() {
    MojoPipelineFactory[] factories = getInstance().getAll();
    if (factories.length == 0) {
      throw new RuntimeException("Cannot find MOJO implementation backend!");
    }
    if (factories.length > 1) {
      throw new RuntimeException("Found multiple MOJO implementation backends, but expected only one!");
    }
    return factories[0];
  }
}
