/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.util.HashMap;
import java.util.Map;

public class MojoFrameMeta {
    private String[] _columnNames;
    private MojoColumn.Type[] _columnTypes;
    private Map<String, Integer> _columnNameToIndex;

    public MojoFrameMeta(String[] columnNames, MojoColumn.Type[] columnTypes) {
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("columnNames and columnTypes arguments must have the same length");
        }
        this._columnNameToIndex = new HashMap<String, Integer>();
        for (int i = 0; i < columnNames.length; ++i) {
            if (this._columnNameToIndex.containsKey(columnNames[i])) {
                throw new IllegalArgumentException("Columns may not have duplicate names: \"" + columnNames[i] + "\"");
            }
            this._columnNameToIndex.put(columnNames[i], i);
        }
        this._columnNames = new String[columnNames.length];
        this._columnTypes = new MojoColumn.Type[columnTypes.length];
        System.arraycopy(columnNames, 0, this._columnNames, 0, this._columnNames.length);
        System.arraycopy(columnTypes, 0, this._columnTypes, 0, this._columnTypes.length);
    }

    public int getColumnIndex(String columnName) {
        return this._columnNameToIndex.get(columnName);
    }

    public String getColumnName(int index) {
        return this._columnNames[index];
    }

    public MojoColumn.Type getColumnType(int index) {
        return this._columnTypes[index];
    }

    public MojoColumn.Type getColumnType(String columnName) {
        return this._columnTypes[this.getColumnIndex(columnName)];
    }

    public boolean contains(String columnName) {
        return this._columnNameToIndex.containsKey(columnName);
    }

    public int size() {
        return this._columnNames.length;
    }

    protected Map<String, Integer> getColumnNamesMap() {
        return this._columnNameToIndex;
    }

    public String[] getColumnNames() {
        return this._columnNames;
    }

    public MojoColumn.Type[] getColumnTypes() {
        return this._columnTypes;
    }

    public static MojoFrameMeta getEmpty() {
        return new MojoFrameMeta(new String[0], new MojoColumn.Type[0]);
    }
}

