/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.DateParser;
import java.util.Objects;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatterBuilder;

public class MojoDateTime {
    private static DateTime NOW = DateTime.now((DateTimeZone)DateTimeZone.UTC);
    private int _YEAR;
    private int _MONTH;
    private int _WEEK_OF_YEAR;
    private int _DAY;
    private int _DAY_OF_YEAR;
    private int _DAY_OF_WEEK;
    private int _HOUR;
    private int _MINUTE;
    private int _SECOND;
    private long _MILLIS_FROM_UNIX;

    public MojoDateTime(long millisFromUnix) {
        this(new DateTime(millisFromUnix));
    }

    private MojoDateTime(DateTime dt) {
        if (dt.isSupported(DateTimeFieldType.year())) {
            this._YEAR = dt.get(DateTimeFieldType.year());
            if (dt.isSupported(DateTimeFieldType.monthOfYear())) {
                this._MONTH = dt.get(DateTimeFieldType.monthOfYear());
                this._DAY = dt.isSupported(DateTimeFieldType.dayOfMonth()) ? dt.get(DateTimeFieldType.dayOfMonth()) : 1;
            } else {
                this._MONTH = 1;
                this._DAY = 1;
            }
        } else {
            this._YEAR = NOW.getYear();
            this._MONTH = NOW.getMonthOfYear();
            this._DAY = NOW.getDayOfMonth();
        }
        LocalDate tmp = new LocalDate(this._YEAR, this._MONTH, this._DAY);
        if (dt.isSupported(DateTimeFieldType.dayOfYear()) && dt.isSupported(DateTimeFieldType.dayOfWeek())) {
            this._DAY_OF_YEAR = dt.get(DateTimeFieldType.dayOfYear());
            this._DAY_OF_WEEK = dt.get(DateTimeFieldType.dayOfWeek());
        } else {
            this._DAY_OF_YEAR = tmp.getDayOfYear();
            this._DAY_OF_WEEK = tmp.getDayOfWeek();
        }
        if (dt.isSupported(DateTimeFieldType.weekOfWeekyear())) {
            this._WEEK_OF_YEAR = dt.get(DateTimeFieldType.weekOfWeekyear());
        }
        if (dt.isSupported(DateTimeFieldType.hourOfDay())) {
            this._HOUR = dt.get(DateTimeFieldType.hourOfDay());
            if (dt.isSupported(DateTimeFieldType.minuteOfHour())) {
                this._MINUTE = dt.get(DateTimeFieldType.minuteOfHour());
                this._SECOND = dt.isSupported(DateTimeFieldType.secondOfMinute()) ? dt.get(DateTimeFieldType.secondOfMinute()) : 0;
            } else {
                this._MINUTE = 0;
                this._SECOND = 0;
            }
        } else {
            this._HOUR = 0;
            this._MINUTE = 0;
            this._SECOND = 0;
        }
        this._MILLIS_FROM_UNIX = dt.getMillis();
    }

    public static MojoDateTime parse(String s) {
        DateTime out = DateParser.DTF.parseDateTime(s);
        return new MojoDateTime(out);
    }

    public static MojoDateTime parse(String s, DateParser parser) {
        return parser.parse(s);
    }

    public static MojoDateTime create(DateTime s) {
        return new MojoDateTime(s);
    }

    public int getYear() {
        return this._YEAR;
    }

    public int getQuarter() {
        return (this._MONTH - 1) / 3 + 1;
    }

    public int getMonth() {
        return this._MONTH;
    }

    public int getDay() {
        return this._DAY;
    }

    public int getDayOfYear() {
        return this._DAY_OF_YEAR;
    }

    public int getWeekOfYear() {
        return this._WEEK_OF_YEAR;
    }

    public int getDayOfWeek() {
        return this._DAY_OF_WEEK - 1;
    }

    public int getHour() {
        return this._HOUR;
    }

    public int getMinute() {
        return this._MINUTE;
    }

    public int getSecond() {
        return this._SECOND;
    }

    public long getMillis() {
        return this._MILLIS_FROM_UNIX;
    }

    public static final DateTimeFormatterBuilder genFormatterBuilder(DateTimeFormatterBuilder dtfb, String[] formats) {
        for (String f : formats) {
            dtfb.appendOptional(DateTimeFormat.forPattern((String)f).getParser());
        }
        return dtfb;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MojoDateTime that = (MojoDateTime)o;
        return this._YEAR == that._YEAR && this._MONTH == that._MONTH && this._WEEK_OF_YEAR == that._WEEK_OF_YEAR && this._DAY == that._DAY && this._DAY_OF_YEAR == that._DAY_OF_YEAR && this._DAY_OF_WEEK == that._DAY_OF_WEEK && this._HOUR == that._HOUR && this._MINUTE == that._MINUTE && this._SECOND == that._SECOND;
    }

    public int hashCode() {
        return Objects.hash(this._YEAR, this._MONTH, this._WEEK_OF_YEAR, this._DAY, this._DAY_OF_YEAR, this._DAY_OF_WEEK, this._HOUR, this._MINUTE, this._SECOND);
    }

    public String toString() {
        return "MojoDateTime{_YEAR=" + this._YEAR + ", _MONTH=" + this._MONTH + ", _WEEK_OF_YEAR=" + this._WEEK_OF_YEAR + ", _DAY=" + this._DAY + ", _DAY_OF_YEAR=" + this._DAY_OF_YEAR + ", _DAY_OF_WEEK=" + this._DAY_OF_WEEK + ", _HOUR=" + this._HOUR + ", _MINUTE=" + this._MINUTE + ", _SECOND=" + this._SECOND + '}';
    }

    public static enum DatePart {
        YEAR("year"){

            @Override
            public String write(String var) {
                return "(" + var + ".getYear())";
            }
        }
        ,
        QUARTER("quarter"){

            @Override
            public String write(String var) {
                return "(" + var + ".getQuarter())";
            }
        }
        ,
        MONTH("month"){

            @Override
            public String write(String var) {
                return "(" + var + ".getMonth())";
            }
        }
        ,
        WEEK("week"){

            @Override
            public String write(String var) {
                return "(" + var + ".getWeekOfYear())";
            }
        }
        ,
        WEEKDAY("weekday"){

            @Override
            public String write(String var) {
                return "(" + var + ".getDayOfWeek())";
            }
        }
        ,
        DAY("day"){

            @Override
            public String write(String var) {
                return "(" + var + ".getDay())";
            }
        }
        ,
        DAYOFYEAR("dayofyear"){

            @Override
            public String write(String var) {
                return "(" + var + ".getDayOfYear())";
            }
        }
        ,
        HOUR("hour"){

            @Override
            public String write(String var) {
                return "(" + var + ".getHour())";
            }
        }
        ,
        MINUTE("minute"){

            @Override
            public String write(String var) {
                return "(" + var + ".getMinute())";
            }
        }
        ,
        SECOND("second"){

            @Override
            public String write(String var) {
                return "(" + var + ".getSecond())";
            }
        };

        private final String _name;

        private DatePart(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public abstract String write(String var1);
    }
}

