/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.readers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class MojoReaderBackend
implements Closeable {
    private String _pipelineFileName;
    private String _baseDir;
    private String _sep;
    public static String DEFAULT_BASE_DIR = "mojo/";
    public static String DEFAULT_PROTO_PIPELINE_FILENAME = "pipeline.pb";
    public static String DEFAULT_TOML_PIPELINE_FILENAME = "pipeline.toml";
    public static String DEFAULT_PROTO_PIPELINE_FILE_PATH = DEFAULT_BASE_DIR + DEFAULT_PROTO_PIPELINE_FILENAME;
    public static String DEFAULT_TOML_PIPELINE_FILE_PATH = DEFAULT_BASE_DIR + DEFAULT_TOML_PIPELINE_FILENAME;

    public MojoReaderBackend() {
        this(null);
    }

    public MojoReaderBackend(String baseDir) {
        this(baseDir, null);
    }

    public MojoReaderBackend(String baseDir, String separator) {
        this(baseDir, separator, null);
    }

    public MojoReaderBackend(String baseDir, String separator, String pipelineFileName) {
        String string = this._sep = separator == null ? File.separator : separator;
        String string2 = pipelineFileName == null ? (baseDir == null ? DEFAULT_PROTO_PIPELINE_FILE_PATH : DEFAULT_PROTO_PIPELINE_FILENAME) : (this._pipelineFileName = pipelineFileName);
        this._baseDir = baseDir == null ? "" : (baseDir.isEmpty() || baseDir.endsWith(this._sep) ? baseDir : baseDir + this._sep);
    }

    public abstract InputStream getFile(String var1) throws IOException;

    public abstract BufferedReader getTextFile(String var1) throws IOException;

    public abstract byte[] getBinaryFile(String var1) throws IOException;

    public abstract boolean exists(String var1);

    @Deprecated
    public BufferedReader getPipelineFile() throws IOException {
        return this.getTextFile(this._pipelineFileName);
    }

    public String getPipelineFileName() {
        return this._pipelineFileName;
    }

    public String getBaseDir() {
        return this._baseDir;
    }

    public String getSeparator() {
        return this._sep;
    }
}

