package ai.h2o.mojos.runtime.lic;

/**
 * The default configuration properties used by license manager
 * to look for license.
 */
public class LicenseConsts {

  /** The default name of license file. */
  public static final String LICENSE_FILENAME = "license.sig";

  /** Name of environment variable which holds license key. */
  public static final String ENV_PROP_LICENSE_KEY = "DRIVERLESS_AI_LICENSE_KEY";

  /** Name of environment variable which hold location of license file.
   *
   * For example, `export DRIVERLESS_AI_LICENSE_FILE=/opt/dai/license/license.sig`
   */
  public static final String ENV_PROP_LICENSE_FILE = "DRIVERLESS_AI_LICENSE_FILE";

  /**
   * Name of JVM system property which holds license key.
   */
  public static final String SYS_PROP_LICENSE_KEY = "ai.h2o.mojos.runtime.license.key";

  /**
   * Name of JVM system property which holds location of license key.
   *
   * For example, `java -Dai.h2o.mojos.runtime.license.file=/opt/dai/license/license.key -cp...`
   */
  public static final String SYS_PROP_LICENSE_FILE = "ai.h2o.mojos.runtime.license.file";

  /** Name of JVM system property which overrides default license file name ({@link #LICENSE_FILENAME}.
   *
   */
  public static final String SYS_PROP_LICENSE_FILENAME = "ai.h2o.mojos.runtime.license.filename";
}
