package ai.h2o.mojos.runtime.frame;

/**
 * Column factory.
 *
 * Create a {@link MojoColumn} instances based on give column type.
 */
public interface MojoColumnFactory {

  /**
   * Creates an instance of {@link MojoColumn} based on given `type` and `nrows`.
   * @param type  type of column to create.
   * @param nrows  number of rows which column represents.
   * @return
   */
  MojoColumn create(MojoColumn.Type type, int nrows);

}
