package ai.h2o.mojos.runtime.lic;

import ai.h2o.mojos.runtime.readers.MojoReaderBackend;

/**
 * The default configuration properties used by license manager
 * to look for mojo signature.
 */
public class MojoSignatureConsts {
  
  /** Name of JVM system property which overrides default signature
   * file name ({@link #MOJO_SIGNATURE_FILENAME}.
   */
  public static final String SYS_PROP_SIGNATURE_FILENAME = "ai.h2o.mojos.runtime.signature.filename";

  /** Name of JVM system property which overrides default watermark
   * file name ({@link #MOJO_WATERMARK_FILENAME}.
   */
  public static final String SYS_PROP_WATERMARK_FILENAME = "ai.h2o.mojos.runtime.watermark.filename";

  /** The default name of MOJO signature file. */
  public static final String MOJO_WATERMARK_FILENAME = MojoReaderBackend.DEFAULT_BASE_DIR + "pipeline.wm";

  public static final String MOJO_SIGNATURE_FILENAME = MojoReaderBackend.DEFAULT_BASE_DIR + "pipeline.sig";
}
